/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHKeyPairGenerator;
import oracle.security.crypto.core.DHParameterGenerator;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.KeyPairGenerator;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.jce.provider.PhaosKeyPairGeneratorSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public class DHKeyPairGeneratorSpi
extends PhaosKeyPairGeneratorSpi {
    public DHKeyPairGeneratorSpi() throws AlgorithmIdentifierException {
        super(KeyPairGenerator.getInstance((AlgorithmIdentifier)AlgID.dh));
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof DHParameterSpec) {
            this.initialize((DHParameterSpec)params, random);
        } else if (params instanceof DHGenParameterSpec) {
            this.initialize((DHGenParameterSpec)params, random);
        } else {
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameterSpec: " + params);
        }
    }

    private void initialize(DHGenParameterSpec params, SecureRandom random) throws InvalidParameterException {
        DHGenParameterSpec dhParams = params;
        DHParameterGenerator gen = new DHParameterGenerator();
        gen.initialize(dhParams.getPrimeSize(), dhParams.getExponentSize(), this.wrapSecureRandom(random));
        DHParams p = gen.generateParameters();
        ((DHKeyPairGenerator)this.kpg).initialize(p, this.wrapSecureRandom(random));
        this.initialized = true;
    }

    private void initialize(DHParameterSpec params, SecureRandom random) throws InvalidParameterException {
        DHParams p = new DHParams(params.getP(), params.getG(), params.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
        ((DHKeyPairGenerator)this.kpg).initialize(p, this.wrapSecureRandom(random));
        this.initialized = true;
    }

    private RandomBitsSource wrapSecureRandom(SecureRandom random) {
        return random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
    }
}

