/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.jce.cert.AttributeTypeAndValue;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class X500RDN
implements ASN1Object {
    public static final ASN1ObjectID id_at_commonName = new ASN1ObjectID(ASN1Utils.attrTypeID, 3);
    public static final ASN1ObjectID id_at_localityName = new ASN1ObjectID(ASN1Utils.attrTypeID, 7);
    public static final ASN1ObjectID id_at_stateOrProvinceName = new ASN1ObjectID(ASN1Utils.attrTypeID, 8);
    public static final ASN1ObjectID id_at_organizationName = new ASN1ObjectID(ASN1Utils.attrTypeID, 10);
    public static final ASN1ObjectID id_at_organizationalUnitName = new ASN1ObjectID(ASN1Utils.attrTypeID, 11);
    public static final ASN1ObjectID id_at_countryName = new ASN1ObjectID(ASN1Utils.attrTypeID, 6);
    public static final ASN1ObjectID emailAddress = new ASN1ObjectID(ASN1Utils.pkcsID, 9, 1);
    private Hashtable attrSet;
    private ASN1Set contents = null;

    public X500RDN(InputStream is) throws IOException {
        this.input(is);
    }

    public Enumeration types() {
        return this.attrSet.keys();
    }

    public ASN1Object getValue(ASN1ObjectID type) {
        AttributeTypeAndValue tv = (AttributeTypeAndValue)this.attrSet.get(type);
        return tv != null ? tv.getValue() : null;
    }

    public int hashCode() {
        return Utils.hashBytes((Streamable)this.contents);
    }

    private static String fixWhitespace(String s) {
        String t = s.trim();
        if (t.length() == 0) {
            return t;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(t.charAt(0));
        int len = t.length();
        for (int i = 1; i < len; ++i) {
            char c = t.charAt(i);
            if (Character.isWhitespace(c)) {
                if (Character.isWhitespace(t.charAt(i - 1))) continue;
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X500RDN x = (X500RDN)o;
        if (this.attrSet.size() != x.attrSet.size()) {
            return false;
        }
        Enumeration e = this.attrSet.elements();
        Enumeration f = x.attrSet.elements();
        while (e.hasMoreElements() && f.hasMoreElements()) {
            AttributeTypeAndValue a = (AttributeTypeAndValue)e.nextElement();
            AttributeTypeAndValue b = (AttributeTypeAndValue)f.nextElement();
            if (!a.getType().equals((Object)b.getType())) {
                return false;
            }
            if (a.getValue().getClass() != b.getValue().getClass()) {
                return false;
            }
            if (a.getValue() instanceof ASN1String) {
                ASN1String s = (ASN1String)a.getValue();
                ASN1String t = (ASN1String)b.getValue();
                if (!(s.getTag() == 19 && t.getTag() == 19 ? !X500RDN.fixWhitespace(s.getValue()).equalsIgnoreCase(X500RDN.fixWhitespace(t.getValue())) : !s.getValue().equals(t.getValue()))) continue;
                return false;
            }
            if (Utils.areEqual((byte[])Utils.toBytes((Streamable)a.getValue()), (byte[])Utils.toBytes((Streamable)b.getValue()))) continue;
            return false;
        }
        return true;
    }

    private static String getTypeName(ASN1ObjectID oid) {
        if (oid.equals((Object)id_at_commonName)) {
            return "CN";
        }
        if (oid.equals((Object)id_at_localityName)) {
            return "L";
        }
        if (oid.equals((Object)id_at_stateOrProvinceName)) {
            return "ST";
        }
        if (oid.equals((Object)id_at_organizationName)) {
            return "O";
        }
        if (oid.equals((Object)id_at_organizationalUnitName)) {
            return "OU";
        }
        if (oid.equals((Object)id_at_countryName)) {
            return "C";
        }
        if (oid.equals((Object)emailAddress)) {
            return "Email";
        }
        return "";
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean escapeUnicode) {
        StringBuffer s = new StringBuffer();
        Enumeration e = this.attrSet.elements();
        while (e.hasMoreElements()) {
            AttributeTypeAndValue tv = (AttributeTypeAndValue)e.nextElement();
            String name = X500RDN.getTypeName(tv.getType());
            s.append(name != null ? name : tv.getType().toStringCompact());
            s.append('=');
            ASN1Object value = tv.getValue();
            if (value instanceof ASN1String) {
                s.append(X500RDN.escapeValue(((ASN1String)value).getValue(), escapeUnicode));
            } else {
                s.append('#');
                s.append(Utils.toHexString((byte[])Utils.toBytes((Streamable)value)));
            }
            s.append('+');
        }
        if (s.length() > 0) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    static String escapeValue(String s, boolean escapeUnicode) {
        StringBuffer t = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (escapeUnicode && c >= '\u0080') {
                StringBuffer u = new StringBuffer();
                while (true) {
                    u.append(c);
                    if (i == s.length() || s.charAt(i + 1) < '\u0080') break;
                    c = s.charAt(++i);
                }
                String hex = Utils.toHexString((byte[])Utils.toUTF8((String)u.toString()));
                int size = hex.length();
                for (int j = 0; j < size; j += 2) {
                    t.append('\\');
                    t.append(hex.charAt(j));
                    t.append(hex.charAt(j + 1));
                }
                continue;
            }
            if (c < ' ' || c == '\u007f' || i == 0 && c == ' ' || i == s.length() - 1 && c == ' ') {
                String hex = Integer.toString(c, 16);
                t.append('\\');
                if (c < '\u0010') {
                    t.append('0');
                }
                t.append(hex);
                continue;
            }
            if (X500RDN.isSpecial(c) || c == '\\' || c == '\"') {
                t.append('\\');
            }
            t.append(c);
        }
        return t.toString();
    }

    static String unescapeValue(String s) {
        StringBuffer t = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == '\\' && i < s.length() - 1) {
                t.append(s.charAt(++i));
                continue;
            }
            t.append(s.charAt(i));
        }
        return t.toString();
    }

    private static boolean isSpecial(char c) {
        return c == ',' || c == '+' || c == '=' || c == '<' || c == '>' || c == ';' || c == '#';
    }

    public void input(InputStream is) throws IOException {
        this.contents = new ASN1Set(is);
        this.attrSet = new Hashtable();
        ASN1SetInputStream setIS = new ASN1SetInputStream(Utils.toStream((Streamable)this.contents));
        while (setIS.hasMoreData()) {
            AttributeTypeAndValue tv = new AttributeTypeAndValue((InputStream)setIS);
            if (tv == null) continue;
            this.attrSet.put(tv.getType(), tv);
        }
        setIS.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.contents.output(os);
    }

    public int length() {
        return this.contents.length();
    }
}

