/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.jce.cert.X500RDN;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class X500Name
implements Principal,
ASN1Object {
    private static final ASN1ObjectID at_commonName = new ASN1ObjectID(ASN1Utils.attrTypeID, 3);
    private Vector rdnSequence = new Vector();
    private String name;
    private String stringContents;
    private ASN1Sequence contents;
    private int hash = -1;

    public X500Name(InputStream is) throws IOException {
        this.input(is);
    }

    public X500RDN componentAt(int i) {
        return (X500RDN)this.rdnSequence.elementAt(i);
    }

    public void input(InputStream is) throws IOException {
        this.contents = new ASN1Sequence(is);
        int size = this.contents.size();
        for (int i = 0; i < size; ++i) {
            this.rdnSequence.addElement(new X500RDN(Utils.toStream((Streamable)this.contents.elementAt(i))));
        }
    }

    public void output(OutputStream os) throws IOException {
        this.contents.output(os);
    }

    public int length() {
        return this.contents.length();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int size = this.rdnSequence.size();
            for (int i = 0; i < size; ++i) {
                X500RDN rdn = this.componentAt(i);
                Enumeration e = rdn.types();
                while (e.hasMoreElements()) {
                    ASN1ObjectID type = (ASN1ObjectID)e.nextElement();
                    ASN1Object o = rdn.getValue(type);
                    if (!(o instanceof ASN1String)) continue;
                    ASN1String value = (ASN1String)o;
                    if (!type.equals((Object)X500RDN.id_at_commonName)) continue;
                    this.name = value.getValue();
                }
            }
        }
        return this.name;
    }

    @Override
    public String toString() {
        if (this.stringContents == null) {
            StringBuffer s = new StringBuffer();
            for (int i = this.rdnSequence.size() - 1; i >= 0; --i) {
                X500RDN rdn = this.componentAt(i);
                s.append(rdn.toString());
                s.append(',');
            }
            if (s.length() > 0) {
                s.setLength(s.length() - 1);
            }
            this.stringContents = s.toString();
        }
        return this.stringContents;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X500Name x = (X500Name)o;
        return Utils.areEqual((byte[])Utils.toBytes((Streamable)x), (byte[])Utils.toBytes((Streamable)this));
    }

    @Override
    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }
}

