/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.CodeGenerator;
import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import antlr.preprocessor.Option;
import antlr.preprocessor.Rule;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

class Grammar {
    protected String name;
    protected String fileName;
    protected String superGrammar;
    protected String type;
    protected IndexedVector rules;
    protected IndexedVector options;
    protected String tokenSection;
    protected String preambleAction;
    protected String memberAction;
    protected Hierarchy hier;
    protected boolean predefined = false;
    protected boolean alreadyExpanded = false;
    protected boolean specifiedVocabulary = false;
    protected String additionalClass = null;
    protected Grammar additionalGrammar = null;
    protected String superClass = null;
    protected String importVocab = null;
    protected String exportVocab = null;
    protected Tool antlrTool;

    public Grammar(Tool tool, String string, String string2, IndexedVector indexedVector) {
        this.name = string;
        this.superGrammar = string2;
        this.rules = indexedVector;
        this.antlrTool = tool;
    }

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new IndexedVector();
        }
        this.options.appendElement(option.getName(), option);
    }

    public void addRule(Rule rule) {
        this.rules.appendElement(rule.getName(), rule);
    }

    public void expandInPlace() {
        Object object;
        Object object2;
        Object object3;
        IndexedVector indexedVector = new IndexedVector();
        if (this.alreadyExpanded) {
            return;
        }
        Grammar grammar = this.getSuperGrammar();
        if (grammar == null) {
            return;
        }
        if (this.exportVocab == null) {
            this.exportVocab = this.getName();
        }
        if (grammar.isPredefined()) {
            return;
        }
        grammar.expandInPlace();
        this.alreadyExpanded = true;
        GrammarFile grammarFile = this.hier.getFile(this.getFileName());
        grammarFile.setExpanded(true);
        Object object4 = this.getRules().elements();
        while (object4.hasMoreElements()) {
            object3 = (Rule)object4.nextElement();
            indexedVector.appendElement(((Rule)object3).getName(), object3);
        }
        object4 = grammar.getRules();
        object3 = ((IndexedVector)object4).elements();
        while (object3.hasMoreElements()) {
            Rule rule = (Rule)object3.nextElement();
            this.inherit(rule, grammar);
        }
        if (this.additionalGrammar != null) {
            object3 = null;
            object3 = this.getOverridingRules(indexedVector);
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                object2 = (Rule)((Vector)object3).get(i);
                object = (Rule)this.rules.getElement(((Rule)object2).getName());
                if (object != null) {
                    if (!((Rule)object).sameSignature((Rule)object2)) {
                        this.antlrTool.warning("rule " + this.getName() + "." + ((Rule)object).getName() + " has different signature than " + grammar.getName() + "." + ((Rule)object).getName());
                    }
                    this.rules.removeElement(((Rule)object).getName());
                    this.addRule((Rule)object2);
                    continue;
                }
                this.addRule((Rule)object2);
            }
        }
        if ((object3 = grammar.getOptions()) != null) {
            Enumeration enumeration = ((IndexedVector)object3).elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Option)enumeration.nextElement();
                this.inherit((Option)object2, grammar);
            }
        }
        if (this.options != null && this.options.getElement("importVocab") == null || this.options == null) {
            Option option = new Option("importVocab", grammar.exportVocab + ";", this);
            this.addOption(option);
            object2 = grammar.getFileName();
            object = this.antlrTool.pathToFile((String)object2);
            String string = (String)object + grammar.exportVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt;
            String string2 = this.antlrTool.fileMinusPath(string);
            if (!((String)object).equals("." + System.getProperty("file.separator"))) {
                try {
                    this.antlrTool.copyFile(string, string2);
                }
                catch (IOException iOException) {
                    this.antlrTool.toolError("cannot find/copy importVocab file " + string);
                    return;
                }
            }
        }
        this.inherit(grammar.memberAction, grammar);
    }

    private Vector getOverridingRules(IndexedVector indexedVector) {
        Object object;
        Vector<Rule> vector;
        IndexedVector indexedVector2 = new IndexedVector();
        Object object2 = indexedVector.elements();
        while (object2.hasMoreElements()) {
            vector = (Rule)object2.nextElement();
            indexedVector2.appendElement(((Rule)((Object)vector)).getName(), vector);
        }
        object2 = this.additionalGrammar.getRules();
        vector = ((IndexedVector)object2).elements();
        while (vector.hasMoreElements()) {
            object = (Rule)vector.nextElement();
            if (indexedVector2.getElement(((Rule)object).getName()) != null) continue;
            indexedVector2.appendElement(((Rule)object).getName(), object);
        }
        vector = new Vector<Rule>();
        object = indexedVector2.elements();
        while (object.hasMoreElements()) {
            vector.add((Rule)object.nextElement());
        }
        return vector;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public IndexedVector getOptions() {
        return this.options;
    }

    public IndexedVector getRules() {
        return this.rules;
    }

    public Grammar getSuperGrammar() {
        if (this.superGrammar == null) {
            return null;
        }
        Grammar grammar = this.hier.getGrammar(this.superGrammar);
        return grammar;
    }

    public String getSuperGrammarName() {
        return this.superGrammar;
    }

    public String getType() {
        return this.type;
    }

    public void inherit(Option option, Grammar grammar) {
        if (option.getName().equals("importVocab") || option.getName().equals("exportVocab")) {
            return;
        }
        Option option2 = null;
        if (this.options != null) {
            option2 = (Option)this.options.getElement(option.getName());
        }
        if (option2 == null) {
            this.addOption(option);
        }
    }

    public void inherit(Rule rule, Grammar grammar) {
        Rule rule2 = (Rule)this.rules.getElement(rule.getName());
        if (rule2 != null) {
            if (!rule2.sameSignature(rule)) {
                this.antlrTool.warning("rule " + this.getName() + "." + rule2.getName() + " has different signature than " + grammar.getName() + "." + rule2.getName());
            }
        } else {
            this.addRule(rule);
        }
    }

    public void inherit(String string, Grammar grammar) {
        if (this.memberAction != null) {
            return;
        }
        if (string != null) {
            this.memberAction = string;
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hier = hierarchy;
    }

    public void setMemberAction(String string) {
        this.memberAction = string;
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public void setPreambleAction(String string) {
        this.preambleAction = string;
    }

    public void setPredefined(boolean bl) {
        this.predefined = bl;
    }

    public void setTokenSection(String string) {
        this.tokenSection = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10000);
        if (this.preambleAction != null) {
            stringBuffer.append(this.preambleAction);
        }
        if (this.superGrammar == null) {
            return "class " + this.name + ";";
        }
        if (this.superClass != null) {
            stringBuffer.append("class " + this.name + " extends " + this.type + this.superClass + ";//dermot");
        } else {
            stringBuffer.append("class " + this.name + " extends " + this.type + ";");
        }
        stringBuffer.append(System.getProperty("line.separator") + System.getProperty("line.separator"));
        if (this.options != null) {
            stringBuffer.append(Hierarchy.optionsToString(this.options));
        }
        if (this.tokenSection != null) {
            stringBuffer.append(this.tokenSection + "\n");
        }
        if (this.memberAction != null) {
            stringBuffer.append(this.memberAction + System.getProperty("line.separator"));
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = (Rule)this.rules.elementAt(i);
            if (!this.getName().equals(rule.enclosingGrammar.getName())) {
                stringBuffer.append("// inherited from grammar " + rule.enclosingGrammar.getName() + System.getProperty("line.separator"));
            }
            stringBuffer.append(rule + System.getProperty("line.separator") + System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public void setAdditionalClass(String string) {
        this.additionalClass = string;
    }

    public String getAdditionalClass() {
        return this.additionalClass;
    }

    public void setAdditionalGrammar(Grammar grammar) {
        this.additionalGrammar = grammar;
    }

    public Grammar getAdditionalGrammar() {
        return this.additionalGrammar;
    }
}

