/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Identifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.IdentifierImpl;

public class QualifiedIdentifier
implements Comparable<QualifiedIdentifier>,
Identifier {
    protected final String orig;
    protected final IdentifierImpl userName;
    protected final IdentifierImpl objectName;
    protected final IdentifierImpl subObjectName;

    public QualifiedIdentifier(String string, String string2) {
        this(string, string2, null);
    }

    public QualifiedIdentifier(String string, String string2, String string3) {
        this.userName = new IdentifierImpl(string);
        this.objectName = new IdentifierImpl(string2);
        this.subObjectName = new IdentifierImpl(string3);
        this.orig = this.getId();
    }

    public QualifiedIdentifier(String string) {
        this(string, false);
    }

    public QualifiedIdentifier(String string, boolean bl) {
        this.orig = string;
        int n = this.getFullStopIndex(string, bl);
        this.userName = new IdentifierImpl(n != -1 ? this.getPreceedingId(string, n) : null);
        if (n != -1) {
            string = this.getIdRemainder(string, n);
            n = this.getFullStopIndex(string, bl);
        }
        this.objectName = new IdentifierImpl(this.getPreceedingId(string, n));
        string = this.getIdRemainder(string, n);
        n = this.getFullStopIndex(string, bl);
        this.subObjectName = new IdentifierImpl(this.getPreceedingId(string, n));
    }

    protected int getFullStopIndex(String string, boolean bl) {
        if (string != null) {
            int n = string.length();
            boolean bl2 = false;
            int n2 = -2;
            block4: for (int i = 0; i < n; ++i) {
                switch (string.charAt(i)) {
                    case '.': {
                        if (bl2) continue block4;
                        return i;
                    }
                    case '\"': {
                        boolean bl3 = bl2 = !bl2;
                        if (bl2) continue block4;
                        if (bl && n2 == i - 1) {
                            n2 = -2;
                            bl2 = !bl2;
                            continue block4;
                        }
                        n2 = i;
                    }
                }
            }
        }
        return -1;
    }

    protected String getPreceedingId(String string, int n) {
        if (string != null && n >= 0) {
            if (n == 0) {
                return "";
            }
            if (n < string.length()) {
                return string.substring(0, n).trim();
            }
            return null;
        }
        return string != null ? string.trim() : string;
    }

    protected String getIdRemainder(String string, int n) {
        if (string != null && n >= 0) {
            if (n + 1 == string.length()) {
                return "";
            }
            if (n + 1 < string.length()) {
                return string.substring(n + 1, string.length());
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.orig;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        QualifiedIdentifier qualifiedIdentifier = (QualifiedIdentifier)object;
        return QualifiedIdentifier.areEqual(this.userName, qualifiedIdentifier.userName) && QualifiedIdentifier.areEqual(this.objectName, qualifiedIdentifier.objectName);
    }

    @Override
    public int compareTo(QualifiedIdentifier qualifiedIdentifier) {
        int n = 0;
        if (this != qualifiedIdentifier) {
            if (this.userName != qualifiedIdentifier.userName) {
                n = this.userName == null && qualifiedIdentifier.userName != null ? -1 : (this.userName != null && qualifiedIdentifier.userName == null ? 1 : this.userName.compareTo(qualifiedIdentifier.userName));
            }
            if (n == 0 && this.objectName != qualifiedIdentifier.objectName) {
                n = this.objectName == null && qualifiedIdentifier.objectName != null ? -1 : (this.objectName != null && qualifiedIdentifier.objectName == null ? 1 : this.objectName.compareTo(qualifiedIdentifier.objectName));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.userName == null ? 0 : this.userName.hashCode());
        n = n * 31 + (this.objectName == null ? 0 : this.objectName.hashCode());
        return n;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public String getObjectName() {
        return this.objectName.toString();
    }

    public String getSubObjectName() {
        return this.subObjectName.toString();
    }

    public Identifier getUserNameId() {
        return this.userName;
    }

    public Identifier getObjectNameId() {
        return this.objectName;
    }

    public Identifier getSubObjectNameId() {
        return this.subObjectName;
    }

    @Override
    public String getId(Boolean bl) {
        String string = this.userName.getId(bl);
        String string2 = this.objectName.getId(bl);
        String string3 = this.subObjectName.getId(bl);
        return (String)(string != null ? string + "." : "") + (string2 != null ? string2 : "") + (String)(string3 != null ? "." + string3 : "");
    }

    @Override
    public String getId() {
        return this.getId(null);
    }

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }
}

