/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;

public abstract class AbstractClauseModel<E>
implements ClauseModel<E> {
    protected final Class<E> clazz;
    protected final ClauseType clauseType;
    protected final RepeatIntervalModel rim;
    protected final HashMap<Integer, Object> properties;
    protected EventListenerList modelEventListeners = new EventListenerList();
    protected EventListenerList propertyEventListeners = new EventListenerList();

    public AbstractClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel) {
        this.clazz = clazz;
        this.clauseType = clauseType;
        this.rim = repeatIntervalModel;
        this.properties = new HashMap();
        repeatIntervalModel.addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
    }

    @Override
    public abstract int size();

    @Override
    public Class<E> getElementClass() {
        return this.clazz;
    }

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    @Override
    public RepeatIntervalModel getRepeatIntervalModel() {
        return this.rim;
    }

    @Override
    public ClauseType getClauseType() {
        return this.clauseType;
    }

    public Object setProperty(int n, Object object) {
        return this.properties.put(n, object);
    }

    public Object getProperty(int n) {
        return this.properties.get(n);
    }

    void fireRepeatIntervalModelEvent(RepeatIntervalModelEvent repeatIntervalModelEvent) {
        this.fireLocalRepeatIntervalModelEvent(repeatIntervalModelEvent);
        this.rim.fireRepeatIntervalModelEvent(repeatIntervalModelEvent);
    }

    void fireLocalRepeatIntervalModelEvent(RepeatIntervalModelEvent repeatIntervalModelEvent) {
        if (repeatIntervalModelEvent != null) {
            Object[] objectArray = this.modelEventListeners.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != RepeatIntervalModelListener.class) continue;
                ((RepeatIntervalModelListener)objectArray[i + 1]).repeatIntervalChanged(repeatIntervalModelEvent);
            }
        }
    }

    void fireLocalRepeatIntervalPropertyEvent(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null) {
            Object[] objectArray = this.propertyEventListeners.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != RepeatIntervalModelListener.class) continue;
                ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
            }
        }
    }

    public void addRepeatIntervalPropertyListener(RepeatIntervalModelListener repeatIntervalModelListener) {
        this.propertyEventListeners.add(RepeatIntervalModelListener.class, repeatIntervalModelListener);
    }

    public void removeRepeatIntervalPropertyListener(RepeatIntervalModelListener repeatIntervalModelListener) {
        this.propertyEventListeners.remove(RepeatIntervalModelListener.class, repeatIntervalModelListener);
    }

    @Override
    public void addRepeatIntervalModelListener(RepeatIntervalModelListener repeatIntervalModelListener) {
        this.modelEventListeners.add(RepeatIntervalModelListener.class, repeatIntervalModelListener);
    }

    @Override
    public void removeRepeatIntervalModelListener(RepeatIntervalModelListener repeatIntervalModelListener) {
        this.modelEventListeners.remove(RepeatIntervalModelListener.class, repeatIntervalModelListener);
    }

    protected class RepeatIntervalChangeListener
    implements RepeatIntervalModelListener {
        protected RepeatIntervalChangeListener() {
        }

        @Override
        public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
            if (repeatIntervalModelEvent.getSource() != this) {
                AbstractClauseModel.this.fireLocalRepeatIntervalModelEvent(repeatIntervalModelEvent);
            }
        }
    }
}

