/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.FreqClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ClausePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NamedSchedule;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UnaryClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UserDefinedFrequency;

public class ExtendedFreqClause
extends FreqClause {
    public ExtendedFreqClause(RepeatIntervalModel repeatIntervalModel) {
        super(repeatIntervalModel);
    }

    protected ExtendedFreqClause(UnaryClauseModel<Frequency> unaryClauseModel) {
        super(unaryClauseModel);
    }

    protected ExtendedFreqClause(Class<Frequency> clazz, RepeatIntervalModel repeatIntervalModel) {
        super(clazz, repeatIntervalModel);
    }

    public JPanel getUserDefinedPanel(Properties properties) {
        return new UserDefinedPanel(properties);
    }

    public JPanel getUserDefinedPanel() {
        return this.getUserDefinedPanel(null);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class SyntaxHandler
    extends FreqClause.SyntaxHandler {
        protected SyntaxHandler() {
            super(ExtendedFreqClause.this);
        }

        @Override
        protected Frequency parseFrequency(String string) {
            Frequency frequency = null;
            try {
                frequency = super.parseFrequency(string);
            }
            catch (Throwable throwable) {
                frequency = new UserDefinedFrequency(new NamedSchedule(string));
            }
            return frequency;
        }
    }

    protected class UserDefinedPanel
    extends PropertyBasedPanel
    implements ClausePanel<Frequency> {
        protected transient GridBagLayout gridBagLayout1;
        protected transient JComboBox userDefinedFreqComboBox;
        protected transient ComboBoxModel userDefinedFreqModel;

        public UserDefinedPanel(Properties properties) {
            super(properties);
            this.gridBagLayout1 = new GridBagLayout();
            this.userDefinedFreqComboBox = new JComboBox();
            this.userDefinedFreqModel = new DefaultComboBoxModel();
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            ((UnaryClauseModel)ExtendedFreqClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            NamedSchedule[] namedScheduleArray = ExtendedFreqClause.this.getRepeatIntervalModel().getNamedScheduleList();
            this.userDefinedFreqModel = new DefaultComboBoxModel<NamedSchedule>(namedScheduleArray);
            this.userDefinedFreqComboBox.setModel(this.userDefinedFreqModel);
            this.userDefinedFreqComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserDefinedPanel.this.userDefinedFreqComboBox_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.userDefinedFreqComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
            this.userDefinedFreqModel.setSelectedItem(null);
        }

        @Override
        public UserDefinedFrequency getSelectedClauseElement() {
            Object object = this.userDefinedFreqModel.getSelectedItem();
            if (object != null) {
                return new UserDefinedFrequency((NamedSchedule)object);
            }
            return null;
        }

        @Override
        public ClauseModel<Frequency> getClauseModel() {
            return ExtendedFreqClause.this.clauseModel;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.userDefinedFreqComboBox.setEnabled(bl);
        }

        protected void userDefinedFreqComboBox_actionPerformed(ActionEvent actionEvent) {
            UserDefinedFrequency userDefinedFrequency = this.getSelectedClauseElement();
            if (userDefinedFrequency != null) {
                ((UnaryClauseModel)ExtendedFreqClause.this.clauseModel).set(userDefinedFrequency);
            }
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case FREQ: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        if (object instanceof UserDefinedFrequency) {
                            UserDefinedPanel.this.userDefinedFreqModel.setSelectedItem(((UserDefinedFrequency)object).getNamedSchedule());
                            break;
                        }
                        if (object != null && object instanceof UserDefinedFrequency) break;
                        UserDefinedPanel.this.userDefinedFreqModel.setSelectedItem(null);
                    }
                }
            }
        }
    }
}

