/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.xmlmodel;

import java.awt.geom.Point2D;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.navigator.net.DBAURLFormatHelper;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineDefinitions;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeGenerator;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdgeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNodeType;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.xmlmodel.XMLGraphEngineNode;
import oracle.ide.model.Element;

public class XMLGraphEngineUtils {
    public static void removeEdgesFrom(GraphEngineGraph graphEngineGraph, GraphEngineNode graphEngineNode) {
        Collection<GraphEngineEdge> collection = graphEngineGraph.getEdgesInboundTo(graphEngineNode);
        for (GraphEngineEdge graphEngineEdge : collection) {
            graphEngineGraph.remove(graphEngineEdge);
        }
        collection = graphEngineGraph.getEdgesOutboundFrom(graphEngineNode);
        for (GraphEngineEdge graphEngineEdge : collection) {
            graphEngineGraph.remove(graphEngineEdge);
        }
    }

    public static List<GraphEngineObject> generateEdgesFor(GraphEngineDefinitions graphEngineDefinitions, GraphEngineNode graphEngineNode) {
        List<GraphEngineObject> list;
        Vector<GraphEngineObject> vector = new Vector<GraphEngineObject>();
        GraphEngineNodeType graphEngineNodeType = graphEngineNode.getType();
        List<GraphEngineEdgeGenerator> list2 = graphEngineDefinitions.getEdgeGeneratorsInboundTo(graphEngineNodeType.getTypeId());
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : list2) {
            list = graphEngineEdgeGenerator.generateInboundTo(graphEngineNode);
            if (list == null) continue;
            vector.addAll(list);
        }
        list2 = graphEngineDefinitions.getEdgeGeneratorsOutboundFrom(graphEngineNodeType.getTypeId());
        for (GraphEngineEdgeGenerator graphEngineEdgeGenerator : list2) {
            list = graphEngineEdgeGenerator.generateOutboundFrom(graphEngineNode);
            if (list == null) continue;
            vector.addAll(list);
        }
        return vector;
    }

    public static XMLGraphEngineNode createNode(Element element, GraphEngineGraph graphEngineGraph, GraphEngineNode graphEngineNode, String string, String object, String string2, String string3, String string4, String string5, Point2D point2D) {
        XMLGraphEngineNode xMLGraphEngineNode = new XMLGraphEngineNode(graphEngineNode);
        GraphEngineNodeType graphEngineNodeType = null;
        if (object == null) {
            object = string3 != null ? string3 + "." + string4 : string4;
        }
        if (string != null) {
            graphEngineNodeType = graphEngineGraph.getModel().getDefinitions().getNodeDefinition(string);
        }
        Object object2 = string3 != null ? (string2 != null && string2.equals(string3) ? string4 : string3 + "." + string4) : string4;
        xMLGraphEngineNode.setElement(element);
        xMLGraphEngineNode.setOwner(string3);
        xMLGraphEngineNode.setName(string4);
        xMLGraphEngineNode.setId((String)object);
        xMLGraphEngineNode.setConnectionSchema(string2);
        xMLGraphEngineNode.setNodeType(graphEngineNodeType);
        xMLGraphEngineNode.setLabel((String)object2);
        xMLGraphEngineNode.setToolTip(string5);
        xMLGraphEngineNode.setLocation(point2D);
        return xMLGraphEngineNode;
    }

    public static XMLGraphEngineEdge createEdge(GraphEngineGraph graphEngineGraph, GraphEngineNode graphEngineNode, String string, String string2, Boolean bl, String string3, String string4, GraphEngineNode graphEngineNode2, GraphEngineNode graphEngineNode3) {
        XMLGraphEngineEdge xMLGraphEngineEdge = new XMLGraphEngineEdge(graphEngineNode);
        GraphEngineEdgeType graphEngineEdgeType = null;
        if (string != null) {
            graphEngineEdgeType = graphEngineGraph.getModel().getDefinitions().getEdgeDefinition(string);
        }
        xMLGraphEngineEdge.setElement(graphEngineNode2.getElement());
        xMLGraphEngineEdge.setId(string2);
        xMLGraphEngineEdge.setEdgeType(graphEngineEdgeType);
        xMLGraphEngineEdge.setLabel(string3);
        xMLGraphEngineEdge.setToolTip(string4);
        xMLGraphEngineEdge.setDirected(bl);
        xMLGraphEngineEdge.setSource(graphEngineNode2);
        xMLGraphEngineEdge.setTarget(graphEngineNode3);
        return xMLGraphEngineEdge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseNode getDatabaseNode(String string, String string2, String string3, String string4) {
        DatabaseNode databaseNode = null;
        boolean bl = DatabaseNavigatorElementFactory.isReportError();
        try {
            DatabaseNavigatorElementFactory.setReportError((Boolean)false);
            DBUtil dBUtil = DBUtil.getInstance((String)string);
            if (dBUtil != null) {
                dBUtil.setRaiseError(false);
            }
            if (string3 == null) {
                string3 = "SYS";
            }
            if (string != null && string2 != null && string4 != null) {
                URL uRL = DBURLFormatHelper.getURL((URL)DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string, null, (String)string3, (String)string2), (String)string4);
                DatabaseNode databaseNode2 = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                if (databaseNode2 == null && (databaseNode2 = DatabaseNavigatorElementFactory.getObjectNode((URL)(uRL = DBAURLFormatHelper.getURL((URL)DBAURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string, null, (String)string3, (String)string2), (String)string4)))) == null) {
                    uRL = DBAURLFormatHelper.getURL((URL)DBAURLFormatHelper.getURL((String)"sqldev.dbanav", (String)string, null, (String)"SYS", (String)string2), (String)string4);
                    databaseNode2 = DatabaseNavigatorElementFactory.getObjectNode((URL)uRL);
                }
                databaseNode = databaseNode2;
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            DatabaseNavigatorElementFactory.setReportError((Boolean)bl);
        }
        return databaseNode;
    }
}

