/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.dialogs.newjob;

import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DatabaseFeatureRegistry;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.schedule.ScheduleWhenModel;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;

public class NewJobModel {
    public static final String JOBPANEL_ADVANCED_PROPERTIES_NAME = "job_advanced_properties_panel";
    public static final String JOBPANEL_DESTINATION_NAME = "job_destination_panel";
    public static final String JOBPANEL_ARGUMENTS_NAME = "job_arguments_panel";
    public static final String JOBPANEL_EMAIL_NOTIFICATION_NAME = "job_email_notification_panel";
    public static final String SCHEMA_LIST = "schemaList";
    public static final String STORED_PROCEDURE_SCHEMA_LIST = "storedProcedureSchemaList";
    public static final String JOB_CLASS_LIST = "jobClassList";
    public static final String JOB_TYPES = "jobTypes";
    public static final String MAX_RUN_DURATION = "max_run_duration";
    public static final String LOGGING_LEVEL = "logging_level";
    public static final String RESTARTABLE = "restartable";
    public static final String JOB_PRIORITY = "job_priority";
    public static final String JOB_WEIGHT = "job_weight";
    public static final String MAX_FAILURES = "max_failures";
    public static final String MAX_RUNS = "max_runs";
    public static final String STORE_OUTPUT = "store_output";
    public static final String CONNECT_CREDENTIAL_NAME = "connect_credential_name";
    public static final String JOB_CLASS = "job_class";
    public static final String JOB_ACTION = "job_action";
    public static final String JOB_NAME = "job_name";
    public static final String JOB_STYLE = "job_style";
    public static final String AUTO_DROP = "auto_drop";
    public static final String OWNER = "owner";
    public static final String COMMENTS = "comments";
    public static final String ENABLED = "enabled";
    public static final String DETACHED = "detached";
    public static final String DESTINATION_NAME = "destination_name";
    public static final String CREDENTIAL_NAME = "credential_name";
    public static final String RAISE_EVENTS = "raise_events";
    public static final String INSTANCE_ID = "instance_id";
    public static final String PARALLEL_INSTANCES = "parallel_instances";
    public static final String FOLLOW_DEFAULT_TIME_ZONE = "follow_default_time_zone";
    public static final String STOP_ON_WINDOW_CLOSE = "stop_on_window_close";
    public static final String FILE_WATCHER_NAME = "file_watcher_name";
    public static final String RESET_TO_DEFAULTS = "reset_to_defaults";
    public static final String JOB_ARGUMENTS_EXECUTABLE = "job_arguments_executable";
    public static final String JOB_ARGUMENTS_PROGRAM_AND_STOREDPROCEDURE = "job_arguments_program_storedProcedure";
    public static final String JOB_STYLE_REGULAR = "REGULAR";
    public static final String JOB_STYLE_LIGHTWEIGHT = "LIGHTWEIGHT";
    public static final String JOB_LOG_NONE = "";
    public static final String JOB_LOG_LOGGING_OFF = "DBMS_SCHEDULER.LOGGING_OFF";
    public static final String JOB_LOG_LOGGING_FAILED_RUNS = "DBMS_SCHEDULER.LOGGING_FAILED_RUNS";
    public static final String JOB_LOG_LOGGING_RUNS = "DBMS_SCHEDULER.LOGGING_RUNS";
    public static final String JOB_LOG_LOGGING_FULL = "DBMS_SCHEDULER.LOGGING_FULL";
    public static final String SCRIPT_TYPE_SQLPLUS = SchedulerArb.getString("SCRIPT_TYPE_SQLPLUS");
    public static final String SCRIPT_TYPE_BACKUP = SchedulerArb.getString("SCRIPT_TYPE_BACKUP");
    public static final String SCRIPT_TYPE_EXTERNAL = SchedulerArb.getString("SCRIPT_TYPE_EXTERNAL");
    public static final String JOB_TYPE_PLSQL_BLOCK = SchedulerArb.getString("JOB_CREATE_TYPE_PLSQL_BLOCK");
    public static final String JOB_TYPE_CHAIN = SchedulerArb.getString("JOB_CREATE_TYPE_CHAIN_BLOCK");
    public static final String JOB_TYPE_EXECUTABLE = SchedulerArb.getString("JOB_CREATE_TYPE_EXECUTABLE_BLOCK");
    public static final String JOB_TYPE_SCRIPT = SchedulerArb.getString("JOB_CREATE_TYPE_SCRIPT_BLOCK");
    public static final String JOB_TYPE_STORED_PROCEDURE = SchedulerArb.getString("JOB_CREATE_TYPE_STORED_PROCEDURE_BLOCK");
    public static final String JOB_TYPE_REMOTE_STORED_PROCEDURE = SchedulerArb.getString("JOB_CREATE_TYPE_REMOTE_STORED_PROCEDURE_BLOCK");
    public static final String JOB_TYPE_NAMED_PROGRAM = SchedulerArb.getString("JOB_CREATE_TYPE_NAMED_PROGRAM_BLOCK");
    public static final String WHAT_JOB_TYPE_PANEL_NAME = "WHAT_JOB_TYPE_PANEL_NAME";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_PLSQL_BLOCK_CAPTION = "what_job_type_panel_plsql_caption";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_CHAIN_CAPTION = "what_job_type_panel_chain_caption";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_STORED_PROCEDURE_CAPTION = "what_job_type_panel_stored_procedure_caption";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_REMOTE_STORED_PROCEDURE_CAPTION = "what_job_type_panel_remote_stored_procedure_caption";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_NAMED_PROGRAM_CAPTION = "what_job_type_panel_named_program_caption";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_EXECUTABLE_CAPTION = "what_job_type_panel_executable_caption";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_PLSQL_BLOCK = "WHAT_JOB_TYPE_PANEL_PLSQL_BLOCK";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_CHAIN = "WHAT_JOB_TYPE_PANEL_CHAIN";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_STORED_PROCEDURE = "WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_STORED_PROCEDURE_SCHEMA = "WHAT_JOB_TYPE_PANEL_STORED_PROCEDURE_SCHEMA";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_REMOTE_STORED_PROCEDURE = "WHAT_JOB_TYPE_PANEL_REMOTE_STORED_PROCEDURE";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_NAMED_PROGRAM = "WHAT_JOB_TYPE_PANEL_NAMED_PROGRAM";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_EXECUTABLE = "WHAT_JOB_TYPE_PANEL_EXECUTABLE";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_SCRIPT_TYPE = "WHAT_JOB_TYPE_PANEL_SCRIPT_TYPE";
    public static final String WHAT_JOB_TYPE_PANEL_ADD_SCRIPT = "WHAT_JOB_TYPE_PANEL_SCRIPT";
    public static final String SET_NAMED_PROGRAM_EVENT = "setNamedProgramEvent";
    public static final String SET_STORED_PROCEDURE_EVENT = "setStoredProcedureEvent";
    public static final String SET_REMOTE_STORED_PROCEDURE_EVENT = "setRemoteStoredProcedureEvent";
    public static final String SET_PLSQL_BLOCK_EVENT = "setPlsqlBlockEvent";
    public static final String SET_CHAIN_EVENT = "setChainEvent";
    public static final String SET_EXECUTABLE_EVENT = "setExecutableEvent";
    public static final String SET_EXTERNAL_SCRIPT_EVENT = "setExternalScriptEvent";
    public static final String JOB_WHEN_CALENDAR_EXPRESSION_REPEAT = "CALENDAR_EXPRESSION";
    public static final String JOB_WHEN_CALENDAR_EXPRESSION_IMMEDIATE = "IMMEDIATE";
    public static final String JOB_WHEN_CALENDAR_EXPRESSION_ONCE = "ONCE";
    public static final String JOB_WHEN_CALENDAR_EXPRESSION_NONE = "NONE";
    public static final String JOB_WHEN_EVENT = "EVENT";
    public static final String JOB_WHEN_NAMED_SCHEDULE = "NAMED_SCHEDULE";
    public static final String JOB_WHEN_FILE_WATCHER_NAME = "FILE_WATCHER";
    public static final String SET_NAMED_SCHEDULE_EVENT = "setNamedScheduleEvent";
    public static final String WHEN_JOB_TYPE_PANEL_NAME = "WHEN_JOB_TYPE_PANEL_NAME";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_NAMED_SCHEDULE_CAPTION = "when_job_type_panel_add_named_schedule_caption";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_IMMEDIATE_CAPTION = "when_job_type_panel_add_immediate_caption";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_REPEAT_CAPTION = "when_job_type_panel_add_repeat_caption";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_ONCE_CAPTION = "when_job_type_panel_add_once_caption";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_CAPTION = "when_job_type_panel_add_event_caption";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_FILEWATCHER_CAPTION = "when_job_type_panel_add_filewatcher_caption";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_NAMED_SCHEDULE = "when_job_type_panel_add_named_schedule";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_IMMEDIATE = "when_job_type_panel_add_immediate";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_REPEAT = "when_job_type_panel_add_repeat";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_ONCE = "when_job_type_panel_add_once";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT = "when_job_type_panel_add_event";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_FILEWATCHER = "when_job_type_panel_add_filewatcher";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_ONCE_START_DATE = "once_start_date";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_REPEAT_START_DATE = "repeat_start_date";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_REPEAT_END_DATE = "repeat_end_date";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_CALENDAR_EXPRESSION_REPEAT_REPEAT_INTERVAL = "repeat_repeat_interval";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_START_DATE = "event_start_date";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_END_DATE = "event_end_date";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_REPEAT_INTERVAL = "event_repeat_interval";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_AGENT_NAME = "event_agent_name";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_AQ_NAME = "event_aq_name";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_QUEUE_SPEC = "event_queue_spec";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_EVENT_EVENT_CONDITION = "event_event_condition";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_FILEWATCHER_NAME = "file_watcher_name";
    public static final String WHEN_JOB_TYPE_PANEL_ADD_FILEWATCHER_EVENT_CONDITION = "file_watcher_event_condition";
    public static final String JOB_WHERE_LOCAL = SchedulerArb.getString("JOB_CREATE_DESTINATION_LOCAL");
    public static final String JOB_WHERE_REMOTE = SchedulerArb.getString("JOB_CREATE_DESTINATION_REMOTE");
    public static final String JOB_WHERE_MULTIPLE = SchedulerArb.getString("JOB_CREATE_DESTINATION_MULTIPLE");
    public static final String JOB_WHERE_LOCAL_EXECUATBLE = "LOCAL_EXECUTABLE";
    public static final String JOB_WHERE_REMOTE_EXECUTABLE = "REMOTE_EXECUTABLE";
    public static final String JOB_WHERE_MULTIPLE_EXECUTABLE = "MULTIPLE_EXECUTABLE";
    public static final String JOB_WHERE_SELECTION_EVENT = "setWhereSelectionEvent";
    public static final String JOB_WHAT_NAMED_PROGRAMS = "jobWhatNamedPrograms";
    public static final String JOB_WHAT_STORED_PROCEDURES = "jobWhatStoredProcedures";
    public static final String JOB_WHAT_REMOTE_STORED_PROCEDURES = "jobWhatRemoteStoredProcedures";
    public static final String JOB_WHAT_CHAINS = "jobWhatChains";
    public static final String JOB_WHAT_SELECTION_EVENT = "jobWhatSelectionsEvent";
    public static final String JOB_WHEN_NAMED_SCHEDULES = "jobWhenNamedSchedules";
    public static final String JOB_WHEN_EVENT_ADVANCED_QUEUES = "jobWhenEventAdvancedQueues";
    public static final String JOB_WHEN_EVENT_AGENTS = "jobWhenEventAgents";
    public static final String JOB_WHEN_FILE_WATCHER = "jobWhenFileWatcher";
    public static final String JOB_WHEN_SELECTION_EVENT = "jobWhenSelectionsEvent";
    public static final String JOB_WHEN_EVENT_EVENTCONDITION_EVENT = "jobWhenEventConditionEvent";
    public static final String JOB_WHEN_EVENT_ADVANCEDQUEUE_EVENT = "jobWhenEventAdvancedQueueEvent";
    public static final String JOB_WHEN_EVENT_AGENT_EVENT = "jobWhenEventAgentEvent";
    public static final String JOB_WHERES = "jobWheres";
    public static final String JOB_WHERES_LOCAL_CRED = "jobWheresLocalCred";
    public static final String JOB_WHERES_REMOTE_CRED = "jobWheresRemoteCred";
    public static final String JOB_WHERES_REMOTE_DEST = "jobWheresRemoteDest";
    public static final String JOB_WHERES_REMOTE_EXTERNAL_DEST = "jobWheresRemoteExternalDest";
    public static final String JOB_WHERES_MULTIPLE_DEST = "jobWheresMultipleDest";
    public static final String JOB_WHERES_MULTIPLE_EXTERNAL_DEST = "jobWheresMultipleExternalDest";
    public static final String JOB_WHERES_MULTIPLE_CRED = "jobWheresMultipleCred";
    public static final String WHERE_JOB_TYPE_PANEL_NAME = "where_job_type_panel_name";
    public static final String DESTINATION_NONEXEC_CARDPANEL_NAME = "Destination_NonExec_CardPanel_Name";
    public static final String DESTINATION_EXEC_CARDPANEL_NAME = "Destination_Exec_CardPanel_Name";
    public static final String DESTINATION_SCRIPT_CARDPANEL_NAME = "Destination_Script_CardPanel_Name";
    public static final String NUMBER_OF_ARGUMENTS = "number_of_arguments";
    public static final String ARGUMENT_ADDED = "argument_added";
    public static final String ARGUMENT_DELETED = "argument_deleted";
    public static final String ARGUMENT_CLEARED = "argument_cleared";
    public static final String JOB_ARGUMENT_LIST_RETRIVED = "job_argument_list_retrived";
    public static final String JOB_ARGUMENT_LIST_CLEARED = "job_argument_list_cleared";
    public static final String JOB_ARGUMENT_ADDED = "job_argument_added";
    public static final String SET_JOB_ARGUMENT_EXECUTABLE = "set_job_arguments_executable";
    public static final String DEFAULT_VALUE = "default_value";
    private static final String DEFAULT_JOB_CLASS = "DEFAULT_JOB_CLASS";
    private static final String DEFAULT_JOB_TYPE = "NAMED_PROGRAM";
    private static final String DEFAULT_JOB_STYLE = "REGULAR";
    public static final int QUEUE_SPEC_EVENT = 1;
    public static final int QUEUE_SPEC_FILE_WATCHER = 2;
    public static final int JOB_ARG_SELECT_BY_POSITION = 1;
    public static final int JOB_ARG_SELECT_BY_NAME = 2;
    public static final int JOB_ARG_SELECT_BY_NAMED_PROGRAM = 1;
    public static final int JOB_ARG_SELECT_BY_EXECUTABLE = 2;
    public static final int JOB_ARG_SELECT_BY_STORED_PROCEDURE = 3;
    public static final String NOTIFICATION_RECIPIENTS = "Recipients";
    public static final String NOTIFICATION_SENDER = "Sender";
    public static final String NOTIFICATION_SUBJECT = "Subject";
    public static final String NOTIFICATION_BODY = "Body";
    public static final String NOTIFICATION_SELECT_EVENTS = "Selected_events";
    public static final String NOTIFICATION_FILTER_CONDITION = "filter_condition";
    public static final String NOTIFICATION_RESET_TO_DEFAULTS = "reset_to_defaults";
    public static final String JOB_ALL_EVENTS = "job_all_events";
    public static final String JOB_BROKEN = "job_broken";
    public static final String JOB_CHAIN_STALLED = "job_chain_stalled";
    public static final String JOB_COMPLETED = "job_completed";
    public static final String JOB_DISABLED = "job_disabled";
    public static final String JOB_FAILED = "job_failed";
    public static final String JOB_OVER_MAX_DUR = "job_over_max_dur";
    public static final String JOB_RUN_COMPLETED = "job_run_completed";
    public static final String JOB_SCH_LIM_REACHED = "job_sch_lim_reached";
    public static final String JOB_STARTED = "job_started";
    public static final String JOB_STOPPED = "job_stopped";
    public static final String JOB_SUCCEEDED = "job_succeeded";
    public static String[] JOBRAISEEVENT_LIST = new String[]{"job_started", "job_succeeded", "job_failed", "job_broken", "job_completed", "job_stopped", "job_sch_lim_reached", "job_disabled", "job_chain_stalled"};
    public static String[] JOBEVENT_LIST = new String[]{"job_started", "job_broken", "job_chain_stalled", "job_completed", "job_disabled", "job_failed", "job_over_max_dur", "job_run_completed", "job_sch_lim_reached", "job_stopped", "job_succeeded"};
    public static boolean notificationDefaultSender = false;
    public static boolean notificationDefaultFilterCondition = false;
    public static String notificationDefaultSubject = "Oracle Scheduler Job Notification - %job_owner%.%job_name%.%job_subname% %event_type%";
    public static String[] notificationDefaultEvents = new String[]{JOBEVENT_LIST[5], JOBEVENT_LIST[1], JOBEVENT_LIST[8], JOBEVENT_LIST[2], JOBEVENT_LIST[6]};
    public static String notificationDefaultBody = "Job: %job_owner%.%job_name%.%job_subname%\nEvent: %event_type%\nDate: %event_timestamp%\nLog id: %log_id%\nJob class: %job_class_name%\nRun count: %run_count%\nFailure count: %failure_count%\nRetry count: %retry_count%\nError code: %error_code\n%Error message: %error_message%\n";
    public static final String EMAIL_SUBJECT_EVENT = "emailNotificationSubjectChangeEvent";
    public static final String EMAIL_BODY_EVENT = "emailNotificationBodyChangeEvent";
    public static final String EMAIL_EVENTS_EVENT = "emailNotificationEventsChangeEvent";
    public static final String EMAIL_FILTER_CONDITION_EVENT = "emailFilterConditionEvent";
    public static final String EMAIL_SENDER_EVENT = "emailSenderEvent";
    public static final String EMAIL_RECIPIENTS_EVENT = "emailRecipientsEvent";
    public static String[] JOB_STYLE_LIST = new String[]{"REGULAR", "LIGHTWEIGHT"};
    public static String[] LOGGING_LEVEL_LIST = new String[]{"DBMS_SCHEDULER.LOGGING_OFF", "DBMS_SCHEDULER.LOGGING_FAILED_RUNS", "DBMS_SCHEDULER.LOGGING_RUNS", "DBMS_SCHEDULER.LOGGING_FULL"};
    public static String[] LOGGING_LEVEL_LIST_MIN = new String[]{"DBMS_SCHEDULER.LOGGING_OFF", "DBMS_SCHEDULER.LOGGING_RUNS", "DBMS_SCHEDULER.LOGGING_FULL"};
    public static String[] EXTERNAL_SCRIPT_TYPE_LIST = new String[]{SCRIPT_TYPE_SQLPLUS, SCRIPT_TYPE_BACKUP, SCRIPT_TYPE_EXTERNAL};
    private Hashtable<String, String> attributesDefaults = new Hashtable();
    private DBObject dbObject = null;
    private HashMap<String, Object> previousJobDataMap;
    private HashMap<String, String> notificationDataMap;
    private HashMap<Integer, String> jobArgDataMap;
    private HashMap<String, String> previousJobDestinationMap;
    private ScheduleWhenModel whenModel;
    private String[] queryRaiseEvents = new String[]{"job_started", "job_succeeded", "job_failed", "job_broken", "job_completed", "job_stopped", "job_sch_lim_reached", "job_disabled", "job_chain_stalled"};
    private Connection connection = null;
    private Operation operation;
    private String schemaForStoreProcedure = null;

    public NewJobModel(DBObject dBObject, Operation operation) {
        this.previousJobDataMap = new HashMap();
        this.notificationDataMap = new HashMap();
        this.jobArgDataMap = new HashMap();
        this.previousJobDestinationMap = new HashMap();
        this.operation = operation;
        this.whenModel = new ScheduleWhenModel();
        this.setDBObject(dBObject);
    }

    public void setDBObject(DBObject dBObject) {
        this.dbObject = dBObject;
        this.connection = dBObject != null ? dBObject.getConnection() : null;
    }

    public DBObject getDBObject() {
        return this.dbObject;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean getDelayLoadingChoice() {
        return this.getOperation() == Operation.CREATE_NEW;
    }

    public ScheduleWhenModel getWhenModel() {
        return this.whenModel;
    }

    public Object setPreviousJobData(String string, Object object) {
        return this.previousJobDataMap.put(string, object);
    }

    public Object getPreviousJobData(String string) {
        return this.previousJobDataMap.get(string);
    }

    public void setPreviousJobJobArgData(Integer n, String string) {
        this.jobArgDataMap.put(n, string);
    }

    public String[] getPreviousJobJobArgData() {
        String[] stringArray = null;
        Set<Integer> set = this.jobArgDataMap.keySet();
        if (set.size() > 0) {
            stringArray = new String[set.size()];
            Iterator<Integer> iterator = set.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                stringArray[n] = this.jobArgDataMap.get(iterator.next());
                ++n;
            }
        }
        return stringArray;
    }

    public String getLoggingLevelPreviousJobData() {
        String string = (String)this.getPreviousJobData("oldLoggingLevel");
        if (string == null) {
            return JOB_LOG_LOGGING_OFF;
        }
        if (string.equals("OFF")) {
            string = JOB_LOG_LOGGING_OFF;
        } else if (string.equals("RUNS")) {
            string = JOB_LOG_LOGGING_RUNS;
        } else if (string.equals("FAILED RUNS")) {
            string = JOB_LOG_LOGGING_FAILED_RUNS;
        } else if (string.equals("FULL")) {
            string = JOB_LOG_LOGGING_FULL;
        }
        return string;
    }

    private String[] getEventsFromString(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i <= 8; ++i) {
            if (string.indexOf(this.queryRaiseEvents[i].toUpperCase()) < 0) continue;
            hashSet.add(this.queryRaiseEvents[i]);
        }
        String[] stringArray = new String[hashSet.size()];
        return hashSet.toArray(stringArray);
    }

    private int getEventTotalFromString(String string) {
        int n = 0;
        for (int i = 0; i <= 8; ++i) {
            if (string.indexOf(this.queryRaiseEvents[i].toUpperCase()) < 0) continue;
            n += (int)Math.pow(2.0, i);
        }
        return n;
    }

    public String[] getRaisedEventsPreviousJobDataEnums() {
        String string = (String)this.getPreviousJobData("oldRaiseEvent");
        if (string != null) {
            return this.getEventsFromString(string);
        }
        return new String[0];
    }

    public int getRaisedEventsPreviousJobData() {
        String string = (String)this.getPreviousJobData("oldRaiseEvent");
        if (string != null) {
            return this.getEventTotalFromString(string);
        }
        return 0;
    }

    public void setJobNotificationData(String string, String string2, boolean bl) {
        Object object = string2;
        if (bl) {
            String string3 = this.notificationDataMap.get(string);
            if (string3 == null) {
                string3 = JOB_LOG_NONE;
            }
            object = !string3.contains(string2) ? (string3.trim().length() == 0 ? string2 : string3 + " , " + string2) : string3;
        }
        this.notificationDataMap.put(string, (String)object);
    }

    public String getJobNotificationData(String string) {
        return this.notificationDataMap.get(string);
    }

    public Object setPreviousJobDestinationData(String string, String string2) {
        return this.previousJobDestinationMap.put(string, string2);
    }

    public String getPreviousJobDestinationData(String string) {
        return this.previousJobDestinationMap.get(string);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean FeatureMin121() {
        return RaptorVersionTracker.checkVersion((Connection)this.getConnection(), null, (Version)new Version("12.1"));
    }

    public boolean FeatureMin112() {
        return RaptorVersionTracker.checkVersion((Connection)this.getConnection(), null, (Version)new Version("11.2"));
    }

    public boolean FeatureMin111() {
        return RaptorVersionTracker.checkVersion((Connection)this.getConnection(), null, (Version)new Version("11.1"));
    }

    public boolean FeatureisXE() {
        return DatabaseFeatureRegistry.isFeatureEnabled((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)this.getConnection()), (String)"xe");
    }

    public boolean FeatureMin102() {
        return RaptorVersionTracker.checkVersion((Connection)this.getConnection(), null, (Version)new Version("10.2"));
    }

    public boolean supportsExternalDBJobs() {
        return this.FeatureMin112();
    }

    public String getSchema() {
        return this.dbObject != null ? this.dbObject.getSchemaName() : null;
    }

    public String getJobObjectName() {
        return this.dbObject != null ? this.dbObject.getObjectName() : null;
    }

    public String getJobObjectOwner() {
        return this.dbObject != null ? this.dbObject.getSchemaName() : null;
    }

    public String getDBObjectSchemaName() {
        return DBURLFormatHelper.getSchema((URL)this.dbObject.getURL());
    }

    public String getDBObjectChildName() {
        return DBURLFormatHelper.getChildName((URL)this.dbObject.getURL());
    }

    public String getDBObjectName() {
        return DBURLFormatHelper.getName((URL)this.dbObject.getURL());
    }

    public void setSchemaForStoredProcedure(String string) {
        this.schemaForStoreProcedure = string;
    }

    public String getSchemaForStoredProcedure() {
        return this.schemaForStoreProcedure;
    }

    protected String getObjectName() {
        String string = this.getDBObjectChildName();
        if (string == null) {
            string = this.getDBObjectName();
        }
        return string;
    }

    public String getDBVersion() {
        return this.dbObject != null ? this.dbObject.getDBVersion() : null;
    }

    public String getQuery() {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = dBMSSchedulerCodeGenerator.generate(this.getDBVersion(), "JOB_LIST", null);
        return RaptorQueryUtils.promoteToDba((String)string, (Connection)this.getDBObject().getConnection());
    }

    protected String getQuery(Connection connection, String string) {
        return Utils.getQuery(this.getClass(), (Connection)connection, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobInformation() {
        block7: {
            String string = this.getJobObjectName();
            String string2 = this.getJobObjectOwner();
            Connection connection = this.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_NAME", string);
                    hashMap.put("OBJECT_OWNER", string2);
                    String string3 = this.getQuery(connection, "getJobData");
                    resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                    if (resultSet != null) {
                        this.setJobDataFromResultSet(resultSet, connection);
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block7;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobParallelInstanceData() {
        block7: {
            String string = this.getJobObjectName();
            String string2 = this.getJobObjectOwner();
            Connection connection = this.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_OWNER", string2);
                    hashMap.put("OBJECT_NAME", string);
                    String string3 = this.getQuery(connection, "getParallelInstanceData");
                    resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                    if (resultSet != null) {
                        this.setParallelInstancesFromResultSet(resultSet, connection);
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block7;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobJobArgsData() {
        block7: {
            String string = this.getJobObjectName();
            String string2 = this.getJobObjectOwner();
            Connection connection = this.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_OWNER", string2);
                    hashMap.put("OBJECT_NAME", string);
                    String string3 = this.getQuery(connection, "getJobArgsData");
                    resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                    if (resultSet != null) {
                        this.setJobArgsFromResultSet(resultSet, connection);
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    break block7;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public void setNewJobInformation() {
        this.whenModel.initProperty(ScheduleWhenModel.Property.EVENT_TYPE, (Object)ScheduleWhenModel.EventType.IMMEDIATE);
    }

    protected void setJobDataFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.setPreviousJobData("oldOwner", this.getSchema());
                this.setPreviousJobData("oldObjectName", this.getObjectName());
                this.setPreviousJobData("oldJobclass", "\"SYS\".\"" + this.getStringFromRS(resultSet, "JOB_CLASS") + "\"");
                this.setPreviousJobData("oldEnabled", this.getStringFromRS(resultSet, "ENABLED"));
                this.setPreviousJobData("oldComments", this.getStringFromRS(resultSet, "COMMENTS"));
                this.setPreviousJobData("oldJobType", this.getStringFromRS(resultSet, "JOB_TYPE"));
                this.setPreviousJobData("oldJobAction", this.getStringFromRS(resultSet, "JOB_ACTION"));
                this.setPreviousJobData("oldNumArgs", new Integer(this.getIntFromRS(resultSet, "NUMBER_OF_ARGUMENTS")));
                this.setPreviousJobData("oldProgramName", this.getStringFromRS(resultSet, "PROGRAM_NAME"));
                this.setPreviousJobData("oldProgramOwner", this.getStringFromRS(resultSet, "PROGRAM_OWNER"));
                this.setPreviousJobData("oldJobStyle", this.getStringFromRS(resultSet, "JOB_STYLE"));
                this.setPreviousJobData("oldCredentialOwner", this.getStringFromRS(resultSet, "CREDENTIAL_OWNER"));
                this.setPreviousJobData("oldCredentialName", this.getStringFromRS(resultSet, "CREDENTIAL_NAME"));
                this.setPreviousJobData("oldDestinationOwner", this.getStringFromRS(resultSet, "DESTINATION_OWNER"));
                this.setPreviousJobData("oldDestinationName", this.getStringFromRS(resultSet, "DESTINATION"));
                this.setPreviousJobData("oldNumberOfDestination", new Integer(this.getIntFromRS(resultSet, "NUMBER_OF_DESTINATIONS")));
                this.setPreviousJobData("oldSource", this.getStringFromRS(resultSet, "SOURCE"));
                this.setPreviousJobData("oldAutoDrop", this.getStringFromRS(resultSet, "AUTO_DROP"));
                this.setPreviousJobData("oldRestartable", this.getStringFromRS(resultSet, "RESTARTABLE"));
                this.setPreviousJobData("oldStoreOutput", this.getStringFromRS(resultSet, "STORE_OUTPUT"));
                this.setPreviousJobData("oldConnectCredentialName", this.getStringFromRS(resultSet, "CONNECT_CREDENTIAL_NAME"));
                this.setPreviousJobData("oldConnectCredentialOwner", this.getStringFromRS(resultSet, "CONNECT_CREDENTIAL_OWNER"));
                this.setPreviousJobData("oldJobPriority", this.getStringFromRS(resultSet, "JOB_PRIORITY"));
                this.setPreviousJobData("oldMaxRuns", this.getStringFromRS(resultSet, "MAX_RUNS"));
                this.setPreviousJobData("oldMaxFailures", this.getStringFromRS(resultSet, "MAX_FAILURES"));
                this.setPreviousJobData("oldJobWeight", this.getStringFromRS(resultSet, "JOB_WEIGHT"));
                this.setPreviousJobData("oldStopOnWindowClose", this.getStringFromRS(resultSet, "STOP_ON_WINDOW_CLOSE"));
                this.setPreviousJobData("oldFollowDefaultTimeZone", this.getStringFromRS(resultSet, "STOP_ON_WINDOW_CLOSE"));
                this.setPreviousJobData("oldLoggingLevel", this.getStringFromRS(resultSet, "LOGGING_LEVEL"));
                this.setPreviousJobData("oldInstanceId", this.getStringFromRS(resultSet, "INSTANCE_ID"));
                this.setPreviousJobData("oldMaxRunDuration", this.getIntervalFromRS((OracleResultSet)resultSet, "MAX_RUN_DURATION"));
                this.setPreviousJobData("oldScheduleLimit", this.getIntervalFromRS((OracleResultSet)resultSet, "SCHEDULE_LIMIT"));
                this.setPreviousJobData("oldRaiseEvent", this.getStringFromRS(resultSet, "RAISE_EVENTS"));
                this.getWhenModel().initPropertiesFromRS((OracleResultSet)resultSet, this.connection);
            }
        }
    }

    protected void setParallelInstancesFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                this.setPreviousJobData("oldParallelInstances", this.getStringFromRS(resultSet, "PARALLEL_INSTANCES"));
            }
        }
    }

    protected void setJobArgsFromResultSet(ResultSet resultSet, Connection connection) throws SQLException {
        if (resultSet != null) {
            while (resultSet.next()) {
                String string = this.getStringFromRS(resultSet, "JOB_NAME");
                String string2 = this.getStringFromRS(resultSet, "ARGUMENT_NAME");
                int n = this.getIntFromRS(resultSet, "ARGUMENT_POSITION");
                String string3 = this.getStringFromRS(resultSet, "ARGUMENT_TYPE");
                String string4 = this.getStringFromRS(resultSet, "VALUE");
                this.setPreviousJobJobArgData(new Integer(n), string4);
            }
        }
    }

    private OraINTERVALDS getIntervalFromRS(OracleResultSet oracleResultSet, String string) {
        try {
            INTERVALDS iNTERVALDS = oracleResultSet.getINTERVALDS(string);
            String string2 = iNTERVALDS.stringValue();
            OraINTERVALDS oraINTERVALDS = OraINTERVALDS.getInstance((INTERVALDS)iNTERVALDS);
            string2 = oraINTERVALDS.toString();
            return oraINTERVALDS;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private String getStringFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private int getIntFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getInt(string);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private long getLongFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getLong(string);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    private boolean getBooleanFromRS(ResultSet resultSet, String string) {
        try {
            return resultSet.getBoolean(string);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobNotificationInformation() {
        if (!this.FeatureMin112()) {
            return;
        }
        String string = this.getJobObjectName();
        String string2 = this.getJobObjectOwner();
        Connection connection = this.getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSet resultSet = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OBJECT_OWNER", string2);
                hashMap.put("OBJECT_NAME", string);
                String string3 = this.getQuery(connection, "getNotificationData");
                if (string3 != null && (resultSet = dBUtil.executeOracleQuery(string3, hashMap)) != null) {
                    this.setNotificationDataFromResultSet(resultSet);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
            }
        }
    }

    protected void setNotificationDataFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null) {
            if (resultSet.next()) {
                do {
                    this.setJobNotificationData("oldJobNotificationRecipient", this.getStringFromRS(resultSet, "RECIPIENT"), true);
                    this.setJobNotificationData("oldJobNotificationSender", this.getStringFromRS(resultSet, "SENDER"), false);
                    this.setJobNotificationData("oldJobNotificationBody", this.getStringFromRS(resultSet, "BODY"), false);
                    this.setJobNotificationData("oldJobNotificationSubject", this.getStringFromRS(resultSet, "SUBJECT"), false);
                    this.setJobNotificationData("oldJobNotificationFilterCondition", this.getStringFromRS(resultSet, "FILTER_CONDITION"), false);
                    this.setJobNotificationData("oldJobNotificationSelectedEvents", this.getStringFromRS(resultSet, JOB_WHEN_EVENT), true);
                } while (resultSet.next());
            } else {
                this.setJobNotificationData("oldJobNotificationSubject", notificationDefaultSubject, false);
                this.setJobNotificationData("oldJobNotificationBody", notificationDefaultBody, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviousJobDestinationInformation() {
        if (!this.FeatureMin112()) {
            return;
        }
        String string = (String)this.getPreviousJobData("oldDestinationOwner");
        String string2 = (String)this.getPreviousJobData("oldDestinationName");
        if (string2 == null) {
            this.setPreviousJobDestinationData("oldJobDestinationType", JOB_LOG_NONE);
        } else {
            Connection connection = this.getConnection();
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("OBJECT_OWNER", string);
                    hashMap.put("OBJECT_DEST_OR_GROUP_NAME", string2);
                    String string3 = this.getQuery(connection, "getDestinationTypeData");
                    if (string3 != null && (resultSet = dBUtil.executeOracleQuery(string3, hashMap)) != null) {
                        this.setDestinationDataFromResultSet(resultSet);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    protected void setDestinationDataFromResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet != null && resultSet.next()) {
            this.setPreviousJobDestinationData("oldJobDestinationType", this.getStringFromRS(resultSet, "DEST_TYPE"));
        }
    }

    public static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }
}

