/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.utils;

import com.adbs.querybuilder.ConditionType;
import com.adbs.querybuilder.ItemSortType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Localizer {
    private String languageId;
    private final HashMap<String, Document> languageCache = new HashMap();
    public final ArrayList<String> languages = new ArrayList();

    public Localizer() {
        this.languages.add("Auto");
        this.languages.add("Default");
        this.languages.add("ar-sa");
        this.languages.add("de");
        this.languages.add("en");
        this.languages.add("es");
        this.languages.add("fr");
        this.languages.add("it");
        this.languages.add("pl");
        this.languages.add("pt-br");
        this.languages.add("ru");
        this.languages.add("sv");
        this.languageCache.put("Auto", null);
        this.languageCache.put("Default", null);
        this.languageCache.put("ar-sa", null);
        this.languageCache.put("de", null);
        this.languageCache.put("en", null);
        this.languageCache.put("es", null);
        this.languageCache.put("fr", null);
        this.languageCache.put("it", null);
        this.languageCache.put("pl", null);
        this.languageCache.put("pt-br", null);
        this.languageCache.put("ru", null);
        this.languageCache.put("sv", null);
        this.languageId = "Auto";
    }

    public String getLanguage() {
        return this.languageId;
    }

    public void setLanguage(String lang) {
        if (Str.IsNullOrEmpty(lang)) {
            this.languageId = "Auto";
        } else if (lang.equals("Auto") || lang.equals("Default")) {
            this.languageId = lang;
        } else if (this.languageCache.containsKey(lang)) {
            this.languageId = lang;
        }
        Helpers.sortTypeNames[ItemSortType.Asc.ordinal()] = Helpers.localizer.getString("strSortTypeAscending", "Ascending");
        Helpers.sortTypeNames[ItemSortType.Desc.ordinal()] = Helpers.localizer.getString("strSortTypeDescending", "Descending");
        Helpers.conditionTypes[ConditionType.Where.ordinal()] = Helpers.localizer.getString("strConditionTypeWhere", "For values");
        Helpers.conditionTypes[ConditionType.Having.ordinal()] = Helpers.localizer.getString("strConditionTypeHaving", "For groups");
    }

    private String getAutoLanguage() {
        String lng = Locale.getDefault().toString();
        if (this.languageCache.containsKey(lng)) {
            return lng;
        }
        if (lng.length() > 2 && this.languageCache.containsKey(lng = lng.substring(0, 2))) {
            return lng;
        }
        return "Default";
    }

    private Document getLanguageData(String language) {
        Document doc = null;
        if (this.languageCache.containsKey(language) && (doc = this.languageCache.get(language)) == null) {
            this.loadLanguageFromResources(language);
            doc = this.languageCache.get(language);
        }
        return doc;
    }

    public void localizeDialog(JDialog dialog) {
        Document doc;
        String lang = this.languageId;
        if (lang.equals("Auto")) {
            lang = this.getAutoLanguage();
        }
        if ((doc = this.getLanguageData(lang)) != null) {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            try {
                Element form = (Element)xPath.evaluate("//form[@id='" + dialog.getName() + "']", doc, XPathConstants.NODE);
                if (form != null) {
                    dialog.setTitle(form.getAttribute("title"));
                    NodeList controls = form.getChildNodes();
                    for (int i = 0; i < controls.getLength(); ++i) {
                        if (!(controls.item(i) instanceof Element)) continue;
                        Element control = (Element)controls.item(i);
                        String controlName = control.getAttribute("id");
                        String controlText = control.getTextContent();
                        if (controlName == null || controlText == null) continue;
                        this.findAndLocalizeControl(dialog.getContentPane().getComponents(), controlName, controlText);
                    }
                }
            }
            catch (XPathExpressionException ex) {
                Logger.getLogger(Localizer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void localizePanel(JPanel panel) {
        Document doc;
        String lang = this.languageId;
        if (lang.equals("Auto")) {
            lang = this.getAutoLanguage();
        }
        if ((doc = this.getLanguageData(lang)) != null) {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            try {
                Element form = (Element)xPath.evaluate("//form[@id='" + panel.getName() + "']", doc, XPathConstants.NODE);
                if (form != null) {
                    NodeList controls = form.getChildNodes();
                    for (int i = 0; i < controls.getLength(); ++i) {
                        if (!(controls.item(i) instanceof Element)) continue;
                        Element control = (Element)controls.item(i);
                        String controlName = control.getAttribute("id");
                        String controlText = control.getTextContent();
                        if (controlName == null || controlText == null) continue;
                        this.findAndLocalizeControl(panel.getComponents(), controlName, controlText);
                    }
                }
            }
            catch (XPathExpressionException ex) {
                Logger.getLogger(Localizer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void findAndLocalizeControl(Component[] components, String controlName, String controlText) {
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c.getName() != null && c.getName().equals(controlName)) {
                Border b;
                if (c instanceof JTextComponent) {
                    ((JTextComponent)c).setText(controlText);
                    break;
                }
                if (c instanceof JLabel) {
                    if (!controlText.toLowerCase().contains("<html>")) {
                        controlText = "<html>" + controlText + "</html>";
                    }
                    ((JLabel)c).setText(controlText);
                    break;
                }
                if (c instanceof AbstractButton) {
                    ((AbstractButton)c).setText(controlText);
                    break;
                }
                if (!(c instanceof Container)) break;
                if (c.getParent() instanceof JTabbedPane) {
                    JTabbedPane tp = (JTabbedPane)c.getParent();
                    tp.setTitleAt(tp.indexOfComponent(c), controlText);
                    break;
                }
                if (!(c instanceof JPanel) || (b = ((JPanel)c).getBorder()) == null || !(b instanceof TitledBorder)) break;
                ((TitledBorder)b).setTitle(controlText);
                break;
            }
            if (!(c instanceof Container) || ((Container)c).getComponentCount() <= 0) continue;
            this.findAndLocalizeControl(((Container)c).getComponents(), controlName, controlText);
        }
    }

    public String getString(String id, String defaultText) {
        return this.getString(id, this.languageId, defaultText);
    }

    public String getString(String id, String langId, String defaultText) {
        Document doc;
        String lang = langId;
        String text = defaultText;
        if (lang.equals("Auto")) {
            lang = this.getAutoLanguage();
        }
        if ((doc = this.getLanguageData(lang)) != null) {
            NodeList stringNodes = doc.getDocumentElement().getElementsByTagName("string");
            for (int i = 0; i < stringNodes.getLength(); ++i) {
                Node stringNode = stringNodes.item(i);
                Node idAttr = stringNode.getAttributes().getNamedItem("id");
                if (idAttr == null || idAttr.getNodeValue() == null || !idAttr.getNodeValue().equals(id)) continue;
                text = stringNode.getTextContent().trim();
                break;
            }
        }
        return text;
    }

    private boolean loadLanguageFromResources(String languageId) {
        InputStream stream = null;
        try {
            Class<QueryBuilder> resourceClass = QueryBuilder.class;
            stream = resourceClass.getResourceAsStream("lang/" + languageId + ".xml");
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        if (stream == null) {
            return false;
        }
        return this.loadLanguageFromStream(stream);
    }

    public boolean loadLanguageFromFile(String languageFile) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(languageFile);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return this.loadLanguageFromStream(stream);
    }

    public boolean loadLanguageFromStream(InputStream languageStream) {
        if (languageStream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(languageStream, "UTF-8"));
                StringBuilder sb = new StringBuilder();
                String line = null;
                char firstChar = (char)br.read();
                if (firstChar != '\ufeff') {
                    sb.append(firstChar);
                }
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                return this.loadLanguageFromString(sb.toString());
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    public boolean loadLanguageFromString(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            StringReader sr = new StringReader(xmlString);
            Document doc = parser.parse(new InputSource(sr));
            if (doc.getDocumentElement().hasAttribute("id")) {
                String lng = doc.getDocumentElement().getAttribute("id");
                this.languageCache.put(lng, doc);
                if (!this.languages.contains(lng)) {
                    this.languages.add(lng);
                }
                return true;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }
}

