/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.AstTokenString;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.TeradataIdentifierExtender;
import com.adbs.syntax.TeradataParser;
import com.adbs.syntax.TeradataQueryPropertiesDialog;
import com.adbs.syntax.TeradataScanner;
import com.adbs.syntax.TeradataStringLiteralExtender;
import com.adbs.syntax.TeradataSubQuerySelectExpressionExtender;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeradataSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;

    public TeradataSyntaxProvider() {
        try {
            this.registerExtender(AstTokenString.class, TeradataStringLiteralExtender.class);
            this.registerExtender(AstTokenIdentifier.class, TeradataIdentifierExtender.class);
            this.registerExtender(SQLSubQuerySelectExpression.class, TeradataSubQuerySelectExpressionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(TeradataSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.Insensitive;
    }

    @Override
    public void setIdentCaseSens(IdentCaseSensitivity value) {
    }

    @Override
    protected Class getParserClass() {
        return TeradataParser.class;
    }

    @Override
    protected Class getScannerClass() {
        return TeradataScanner.class;
    }

    @Override
    public String getDescription() {
        return "Teradata";
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (!LoadMetadataHelpers.getDefaultSchemaNamesTeradata(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Grouping", false);
        names.addIdentifier("AggGeomUnion", false);
        names.addIdentifier("AggGeomIntersection", false);
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Ave", false);
        names.addIdentifier("Average", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Kurtosis", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Skew", false);
        names.addIdentifier("StdDev_Pop", false);
        names.addIdentifier("StdDev_Samp", false);
        names.addIdentifier("Var_Pop", false);
        names.addIdentifier("Var_Samp", false);
    }

    @Override
    public void getComparisonOperators(List<String> list) {
        list.clear();
        list.add("=");
        list.add("!=");
        list.add("<>");
        list.add("^=");
        list.add("NOT=");
        list.add("<");
        list.add("<=");
        list.add(">");
        list.add(">=");
        list.add("EQ");
        list.add("NE");
        list.add("GE");
        list.add("GT");
        list.add("LE");
        list.add("LT");
    }

    @Override
    public boolean isSupportProcedures() {
        return true;
    }

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    @Override
    public boolean isSupportCTE() {
        return true;
    }

    @Override
    public boolean isCteColumnNamesMandatory() {
        return true;
    }

    @Override
    public void getUnionOperatorList(List<String> sl) {
        super.getUnionOperatorList(sl);
        sl.add("Except");
        sl.add("Except All");
        sl.add("Intersect");
        sl.add("Intersect All");
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return TeradataQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Rank");
        names.addBuiltin("Dense_Rank");
        names.addBuiltin("NTile");
        names.addBuiltin("Row_Number");
        names.addBuiltin("DateAdd");
        names.addBuiltin("DateDiff");
        names.addBuiltin("DateName");
        names.addBuiltin("DatePart");
        names.addBuiltin("Day");
        names.addBuiltin("GetDate");
        names.addBuiltin("GetUTCDate");
        names.addBuiltin("Month");
        names.addBuiltin("Year");
        names.addBuiltin("Abs");
        names.addBuiltin("Degrees");
        names.addBuiltin("Rand");
        names.addBuiltin("ACos");
        names.addBuiltin("Exp");
        names.addBuiltin("Round");
        names.addBuiltin("ASin");
        names.addBuiltin("Floor");
        names.addBuiltin("Sign");
        names.addBuiltin("ATan");
        names.addBuiltin("Log");
        names.addBuiltin("Sin");
        names.addBuiltin("ATn2");
        names.addBuiltin("Log10");
        names.addBuiltin("SqRt");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Pi");
        names.addBuiltin("Square");
        names.addBuiltin("Cos");
        names.addBuiltin("Power");
        names.addBuiltin("Tan");
        names.addBuiltin("Cot");
        names.addBuiltin("Radians");
        names.addBuiltin("Col_Length");
        names.addBuiltin("FullTextCatalogProperty");
        names.addBuiltin("Col_Name");
        names.addBuiltin("FullTextServiceProperty");
        names.addBuiltin("ColumnProperty");
        names.addBuiltin("Index_Col");
        names.addBuiltin("DatabaseProperty");
        names.addBuiltin("IndexKey_Property");
        names.addBuiltin("DatabasePropertyEx");
        names.addBuiltin("IndexProperty");
        names.addBuiltin("Db_Id");
        names.addBuiltin("Object_Id");
        names.addBuiltin("Db_Name");
        names.addBuiltin("Object_Name");
        names.addBuiltin("File_Id");
        names.addBuiltin("ObjectProperty");
        names.addBuiltin("File_IdEx");
        names.addBuiltin("ObjectPropertyEx");
        names.addBuiltin("File_Name");
        names.addBuiltin("SQL_Variant_Property");
        names.addBuiltin("FileGroup_Id");
        names.addBuiltin("Type_Id");
        names.addBuiltin("FileGroup_Name");
        names.addBuiltin("Type_Name");
        names.addBuiltin("FileGroupProperty");
        names.addBuiltin("TypeProperty");
        names.addBuiltin("FileProperty");
        names.addBuiltin("Has_Perms_By_Name");
        names.addBuiltin("Is_Member");
        names.addBuiltin("Is_SrvRoleMember");
        names.addBuiltin("Permissions");
        names.addBuiltin("Schema_Id");
        names.addBuiltin("Schema_Name");
        names.addBuiltin("SUser_Id");
        names.addBuiltin("SUser_SId");
        names.addBuiltin("SUser_SName");
        names.addBuiltin("SUser_Name");
        names.addBuiltin("User_Id");
        names.addBuiltin("User_Name");
        names.addBuiltin("ASCII");
        names.addBuiltin("NChar");
        names.addBuiltin("SoundEx");
        names.addBuiltin("Char");
        names.addBuiltin("PatIndex");
        names.addBuiltin("Space");
        names.addBuiltin("CharIndex");
        names.addBuiltin("QuoteName");
        names.addBuiltin("Str");
        names.addBuiltin("Difference");
        names.addBuiltin("Replace");
        names.addBuiltin("Stuff");
        names.addBuiltin("Left");
        names.addBuiltin("Replicate");
        names.addBuiltin("SubString");
        names.addBuiltin("Len");
        names.addBuiltin("Reverse");
        names.addBuiltin("Unicode");
        names.addBuiltin("Lower");
        names.addBuiltin("Right");
        names.addBuiltin("Upper");
        names.addBuiltin("LTrim");
        names.addBuiltin("RTrim");
        names.addBuiltin("App_Name");
        names.addBuiltin("Cast");
        names.addBuiltin("Convert");
        names.addBuiltin("Coalesce");
        names.addBuiltin("CollationProperty");
        names.addBuiltin("Columns_Updated");
        names.addBuiltin("DataLength");
        names.addBuiltin("Error_Line");
        names.addBuiltin("Error_Message");
        names.addBuiltin("Error_Number");
        names.addBuiltin("Error_Procedure");
        names.addBuiltin("Error_Severity");
        names.addBuiltin("Error_State");
        names.addBuiltin("FormatMessage");
        names.addBuiltin("GetANSINull");
        names.addBuiltin("Host_Id");
        names.addBuiltin("Host_Name");
        names.addBuiltin("Ident_Current");
        names.addBuiltin("IdntT_Incr");
        names.addBuiltin("Ident_Seed");
        names.addBuiltin("Identity");
        names.addBuiltin("IsDate");
        names.addBuiltin("IsNull");
        names.addBuiltin("IsNumeric");
        names.addBuiltin("NewId");
        names.addBuiltin("NullIf");
        names.addBuiltin("ParseName");
        names.addBuiltin("RowCount_Big");
        names.addBuiltin("Scope_Identity");
        names.addBuiltin("ServerProperty");
        names.addBuiltin("sessionProperty");
        names.addBuiltin("Stats_Date");
        names.addBuiltin("Update");
        names.addBuiltin("User_Name");
        names.addBuiltin("XAct_State");
        names.addBuiltin("Patindex");
        names.addBuiltin("TextValid");
        names.addBuiltin("TextPtr");
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select top 1 " + fieldExpression + " from " + objectExpression + " a";
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsTeradata(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsTeradata(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
        mff.setQuery("select c.*,   case c.ColumnType     when 'CF' then 'Char'     when 'CV' then 'VarChar'     when 'D'  then 'Decimal'     when 'TS' then 'Timestamp'     when 'I'  then 'Integer'     when 'I2' then 'SmallInt'     when 'DA' then 'Date'   end as ColumnType2 from dbc.ColumnsX c where (c.DatabaseName='" + objectSchema + "')and(c.TableName='" + objectName + "')");
        mff.setTrimSpaces(true);
        mff.setNameFieldName("ColumnName");
        mff.setServerTypeFieldName("ColumnType2");
        mff.setSizeFieldName("ColumnLength");
        mff.setPrecisionFieldName("DecimalTotalDigits");
        mff.setScaleFieldName("DecimalFractionalDigits");
        mff.setDefaultValueFieldName("DefaultValue");
        mff.setNullableFieldName("Nullable");
        mff.setNullableValue("Y");
        mff.setShortDescriptionFieldName("CommentString");
        mff.loadFields(metadataObject.getFields());
        mff = new MetadataFieldsFetcherFromQuery(sqlContext);
        mff.setQuery("select * from dbc.Indices where (IndexType in ('P','Q','K'))and(UniqueFlag='Y')and(TableName='" + objectName + "')and(DatabaseName='" + objectSchema + "')");
        mff.setTrimSpaces(true);
        mff.setNameFieldName("ColumnName");
        mff.setPrimaryFieldName("ColumnName");
        mff.setNonPrimaryValue(null);
        mff.loadFields(metadataObject.getFields());
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsTeradata(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("varying") != 0 && type.compareToIgnoreCase("binary") != 0 && type.compareToIgnoreCase("varbinary") != 0;
    }

    @Override
    public boolean isInnerKeywordInLinksMandatory() {
        return false;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListTeradata(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }
}

