/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.SQLOrderByItem;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.metadata.MetadataRelationsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.SQLOrderByItemExtender;
import com.adbs.syntax.SQLiteParser;
import com.adbs.syntax.SQLiteQueryPropertiesDialog;
import com.adbs.syntax.SQLiteScanner;
import com.adbs.syntax.SQLiteSubSelectStatementExtender;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLiteSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;

    public SQLiteSyntaxProvider() {
        try {
            this.registerExtender(SQLSubSelectStatement.class, SQLiteSubSelectStatementExtender.class);
            this.registerExtender(SQLOrderByItem.class, SQLOrderByItemExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(SQLiteSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected Class getScannerClass() {
        return SQLiteScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return SQLiteParser.class;
    }

    @Override
    public String getDescription() {
        return "SQLite";
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.Insensitive;
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Group_Concat", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Total", false);
    }

    public void getComparisonOperators(List sl) {
        sl.clear();
        sl.add("=");
        sl.add("==");
        sl.add("<>");
        sl.add("!=");
        sl.add(">");
        sl.add(">=");
        sl.add("<");
        sl.add("<=");
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Date");
        names.addBuiltin("Time");
        names.addBuiltin("DateTime");
        names.addBuiltin("JulianDay");
        names.addBuiltin("StrfTime");
        names.addBuiltin("Abs");
        names.addBuiltin("Changes");
        names.addBuiltin("Coalesce");
        names.addBuiltin("Glob");
        names.addBuiltin("IfNull");
        names.addBuiltin("Hex");
        names.addBuiltin("Last_Insert_Rowid");
        names.addBuiltin("Length");
        names.addBuiltin("Like");
        names.addBuiltin("Load_Eextension");
        names.addBuiltin("Lower");
        names.addBuiltin("LTrim");
        names.addBuiltin("Max");
        names.addBuiltin("Min");
        names.addBuiltin("NullIf");
        names.addBuiltin("Quote");
        names.addBuiltin("Random");
        names.addBuiltin("RandomBlob");
        names.addBuiltin("Replace");
        names.addBuiltin("Round");
        names.addBuiltin("RTrim");
        names.addBuiltin("SoundEx");
        names.addBuiltin("SQLite_CompileOption_Get");
        names.addBuiltin("SQLite_CompileOption_Used");
        names.addBuiltin("SQLite_Source_Id");
        names.addBuiltin("SQLite_Version");
        names.addBuiltin("SubStr");
        names.addBuiltin("Total_Changes");
        names.addBuiltin("Trim");
        names.addBuiltin("TypeOf");
        names.addBuiltin("Upper");
        names.addBuiltin("ZeroBlob");
    }

    @Override
    public boolean isUniversalExpressions() {
        return false;
    }

    @Override
    public boolean isSupportBracketsInUnions() {
        return false;
    }

    @Override
    public boolean isSupportSubQueryBracketsInUnions() {
        return false;
    }

    @Override
    public boolean isSupportSchemas() {
        return false;
    }

    @Override
    public boolean isSupportDatabases() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return true;
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsSQLite(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!LoadMetadataHelpers.loadMetadataObjectsSQLite(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
        String objectDatabase = metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
        if (!Str.IsNullOrEmpty(objectDatabase)) {
            objectDatabase = objectDatabase + ".";
        }
        MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
        mff.setQuery("pragma " + objectDatabase + "table_info(" + objectName + ");");
        mff.setNameFieldName("name");
        mff.setServerTypeFieldName("type");
        mff.setNullableFieldName("notnull");
        mff.setNonNullableValue(1);
        mff.setPrimaryFieldName("pk");
        mff.setPrimaryValue(1);
        mff.loadFields(metadataObject.getFields());
    }

    @Override
    public void loadMetadataForTable(BaseSQLContext sqlContext, MetadataTable metadataTable) {
        super.loadMetadataForTable(sqlContext, metadataTable);
        if (sqlContext.getMetadataProvider().canExecSQL()) {
            String objectName = metadataTable.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
            String objectDatabase = metadataTable.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer());
            if (!Str.IsNullOrEmpty(objectDatabase)) {
                objectDatabase = objectDatabase + ".";
            }
            MetadataRelationsFetcherFromQuery mrf = new MetadataRelationsFetcherFromQuery(sqlContext);
            mrf.setQuery("pragma " + objectDatabase + "foreign_key_list(" + objectName + ");");
            mrf.setPkNameFieldName("table");
            mrf.setPkFieldName("to");
            mrf.setDefaultChildObjectName(objectName);
            mrf.setFkFieldName("from");
            mrf.setForeignKeyIdFieldName("id");
            mrf.setOrdinalFieldName("seq");
            if (!mrf.validateQuery()) {
                return;
            }
            mrf.loadMetadata(metadataTable.getMetadataContainer(), null, metadataTable.getDatabase());
        }
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return SQLiteQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) {
        if (!LoadMetadataHelpers.getDatabaseListSQLite(sqlContext, databaseList)) {
            super.getDatabaseList(sqlContext, databaseList);
        }
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) {
        SQLQualifiedName result = LoadMetadataHelpers.getDefaultDatabaseNameSQLite(sqlContext);
        if (result == null) {
            result = super.getDefaultDatabaseName(sqlContext);
        }
        return result;
    }
}

