/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.ServerDescriptor;
import com.adbs.syntax.UniversalSyntaxServerType;
import com.adbs.utils.Str;

class MSSQLDescriptor
extends ServerDescriptor {
    MSSQLDescriptor() {
    }

    @Override
    public UniversalSyntaxServerType getServerType() {
        return UniversalSyntaxServerType.MSSQL;
    }

    @Override
    public String getQuoteBegin() {
        return "[";
    }

    @Override
    public String getQuoteEnd() {
        return "]";
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select top 0 " + fieldExpression + " from " + objectExpression + " where 0<>0";
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConnectedServer(BaseMetadataProvider metadataProvider) {
        return LoadMetadataHelpers.isConnectedServerIsMSSQL(metadataProvider);
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) {
        return LoadMetadataHelpers.getDefaultDatabaseNameMSSQL(sqlContext);
    }

    @Override
    public boolean getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) {
        return LoadMetadataHelpers.getDefaultSchemaNamesMSSQL(sqlContext, defaultSchemaNames);
    }

    @Override
    public boolean getDatabasesList(BaseSQLContext sqlContext, SQLQualifiedNameList databasesList) throws QueryBuilderException {
        return LoadMetadataHelpers.getDatabaseListMSSQL(sqlContext, databasesList);
    }

    @Override
    public boolean loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        return LoadMetadataHelpers.loadMetadataObjectsMSSQL(sqlContext, metadataContainer, metadataFilter, database);
    }

    @Override
    public boolean loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        return LoadMetadataHelpers.loadMetadataRelationsMSSQL(sqlContext, metadataContainer, metadataFilter, database);
    }
}

