/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.InformixParser;
import com.adbs.syntax.InformixSQLSelectStatementExtender;
import com.adbs.syntax.InformixSQLSubQuerySelectExpressionExtender;
import com.adbs.syntax.InformixScanner;
import com.adbs.syntax.InformixVersion;
import com.adbs.syntax.MetadataFieldsFetcherFromQueryInformix;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InformixSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private InformixVersion serverVersion = InformixVersion.DS11;

    public InformixSyntaxProvider() {
        try {
            this.registerExtender(SQLSubQuerySelectExpression.class, InformixSQLSubQuerySelectExpressionExtender.class);
            this.registerExtender(SQLSelectStatement.class, InformixSQLSelectStatementExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(InformixSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public InformixVersion getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(InformixVersion serverVersion) {
        if (this.serverVersion != serverVersion) {
            this.serverVersion = serverVersion;
            this.sendNotifications();
        }
    }

    @Override
    public BaseSyntaxProvider clone() {
        InformixSyntaxProvider result = (InformixSyntaxProvider)super.clone();
        result.serverVersion = this.serverVersion;
        return result;
    }

    @Override
    protected Class getScannerClass() {
        return InformixScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return InformixParser.class;
    }

    @Override
    public String getDescription() {
        return "IBM Informix";
    }

    @Override
    protected void setParserParams(BaseParser parser) {
        super.setParserParams(parser);
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.SensitiveLowerCase;
    }

    @Override
    public void setIdentCaseSens(IdentCaseSensitivity value) {
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Count", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
        names.addIdentifier("Range", false);
        names.addIdentifier("StdEv", false);
        names.addIdentifier("Variance", false);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("Abs");
        names.addBuiltin("Ceil");
        names.addBuiltin("Floor");
        names.addBuiltin("Mod");
        names.addBuiltin("Pow");
        names.addBuiltin("Power");
        names.addBuiltin("Root");
        names.addBuiltin("Round");
        names.addBuiltin("Trunc");
        names.addBuiltin("SqRt");
        names.addBuiltin("Exp");
        names.addBuiltin("LogN");
        names.addBuiltin("Log10");
        names.addBuiltin("Cos");
        names.addBuiltin("Sin");
        names.addBuiltin("Tan");
        names.addBuiltin("ASin");
        names.addBuiltin("ACos");
        names.addBuiltin("ATan");
        names.addBuiltin("ATan2");
        names.addBuiltin("Cardinality");
        names.addBuiltin("DBInfo");
        names.addBuiltin("Encrypt_AES");
        names.addBuiltin("Encrypt_TDES");
        names.addBuiltin("Decrypt_Char");
        names.addBuiltin("Decrypt_Binary");
        names.addBuiltin("GetHint");
        names.addBuiltin("Hex");
        names.addBuiltin("Length");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Character_Length");
        names.addBuiltin("Octet_Length");
        names.addBuiltin("SecLabel_To_Char");
        names.addBuiltin("SecLabel_By_Comp");
        names.addBuiltin("SecLabel_By_Name");
        names.addBuiltin("FileToBlob");
        names.addBuiltin("FileToClob");
        names.addBuiltin("LoToFile");
        names.addBuiltin("LoCopy");
        names.addBuiltin("Date");
        names.addBuiltin("Day");
        names.addBuiltin("Month");
        names.addBuiltin("WeekDay");
        names.addBuiltin("Year");
        names.addBuiltin("Last_Day");
        names.addBuiltin("Extend");
        names.addBuiltin("MDY");
        names.addBuiltin("Add_Months");
        names.addBuiltin("Months_Between");
        names.addBuiltin("Next_Day");
        names.addBuiltin("To_Char");
        names.addBuiltin("To_Date");
        names.addBuiltin("To_Number");
        names.addBuiltin("ASCII");
        names.addBuiltin("Trim");
        names.addBuiltin("LTrim");
        names.addBuiltin("RTrim");
        names.addBuiltin("SubString");
        names.addBuiltin("SubStr");
        names.addBuiltin("Replace");
        names.addBuiltin("LPad");
        names.addBuiltin("RPad");
        names.addBuiltin("Upper");
        names.addBuiltin("Lower");
        names.addBuiltin("InitCap");
        names.addBuiltin("Format_Units");
        names.addBuiltin("Ifx_Allow_NewLine");
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public boolean isSupportDerivedTables() {
        return false;
    }

    @Override
    public boolean isSupportSubQueryDerivedTables() {
        return false;
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsInformix(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsInformix(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsInformix(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (sqlContext.isTableExists("SYSCOLUMNS") && sqlContext.isTableExists("SYSTABLES")) {
            String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
            MetadataFieldsFetcherFromQueryInformix mff = new MetadataFieldsFetcherFromQueryInformix(sqlContext);
            mff.setQuery("Select \tc.COLNAME, \tc.COLTYPE, \tc.COLLENGTH From \tSYSCOLUMNS c Inner Join \tSYSTABLES t On t.TABID = c.TABID Where \tt.OWNER = '" + objectSchema + "' And \tt.TABNAME = '" + objectName + "' Order By \tt.TABID, c.COLNO");
            mff.setNameFieldName("COLNAME");
            mff.setServerTypeFieldName("COLTYPE");
            mff.setNullableFieldName("COLTYPE");
            mff.setNonNullableValue(true);
            mff.loadFields(metadataObject.getFields());
        }
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("character") != 0 && type.compareToIgnoreCase("nchar") != 0 && type.compareToIgnoreCase("national char") != 0 && type.compareToIgnoreCase("national chararacter") != 0 && type.compareToIgnoreCase("nvarchar") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("char varying") != 0 && type.compareToIgnoreCase("character varying") != 0;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        return null;
    }

    @Override
    public void getSchemaList(BaseSQLContext sqlContext, SQLIdentifiersCollection schemaList, SQLQualifiedName fromDatabase) {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListInformix(sqlContext, schemaList, fromDatabase)) {
            super.getSchemaList(sqlContext, schemaList, fromDatabase);
        }
    }

    @Override
    public boolean isDetectServerVersion() {
        return super.isDetectServerVersion();
    }

    @Override
    public void setDetectServerVersion(boolean detectServerVersion) {
        super.setDetectServerVersion(detectServerVersion);
    }

    @Override
    public void doDetectServerVersion(BaseMetadataProvider metadataProvider) {
        super.doDetectServerVersion(metadataProvider);
        int version = LoadMetadataHelpers.calcServerVersionInformix(metadataProvider);
        switch (version) {
            case 8: {
                this.setServerVersion(InformixVersion.DS8);
                break;
            }
            case 9: {
                this.setServerVersion(InformixVersion.DS9);
                break;
            }
            case 10: {
                this.setServerVersion(InformixVersion.DS10);
                break;
            }
            case 11: {
                this.setServerVersion(InformixVersion.DS11);
                break;
            }
            default: {
                this.setServerVersion(InformixVersion.DS11);
            }
        }
    }
}

