/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.AdvantageParser;
import com.adbs.syntax.AdvantageQueryPropertiesDialog;
import com.adbs.syntax.AdvantageScanner;
import com.adbs.syntax.AdvantageSubQuerySelectExpressionExtender;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.SybaseSyntaxProvider;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdvantageSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private SQLQualifiedName defaultDatabaseName = null;

    public AdvantageSyntaxProvider() {
        try {
            this.registerExtender(SQLSubQuerySelectExpression.class, AdvantageSubQuerySelectExpressionExtender.class);
        }
        catch (Exception ex) {
            Logger.getLogger(SybaseSyntaxProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    protected Class getScannerClass() {
        return AdvantageScanner.class;
    }

    @Override
    protected Class getParserClass() {
        return AdvantageParser.class;
    }

    @Override
    public String getDescription() {
        return "Advantage Database Server";
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return IdentCaseSensitivity.Insensitive;
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Avg", false);
        names.addIdentifier("Max", false);
        names.addIdentifier("Min", false);
        names.addIdentifier("Sum", false);
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        names.addBuiltin("CurDate");
        names.addBuiltin("Current_Date");
        names.addBuiltin("Current_Time");
        names.addBuiltin("Current_Timestamp");
        names.addBuiltin("CurTime");
        names.addBuiltin("DayName");
        names.addBuiltin("DayOfMonth");
        names.addBuiltin("DayOfWeek");
        names.addBuiltin("DayOfYear");
        names.addBuiltin("Extract");
        names.addBuiltin("Hour");
        names.addBuiltin("Minute");
        names.addBuiltin("Month");
        names.addBuiltin("MonthName");
        names.addBuiltin("Now");
        names.addBuiltin("Quarter");
        names.addBuiltin("Second");
        names.addBuiltin("TimestampAdd");
        names.addBuiltin("TimestampDiff");
        names.addBuiltin("Week");
        names.addBuiltin("Year");
        names.addBuiltin("Abs");
        names.addBuiltin("ACos");
        names.addBuiltin("ASin");
        names.addBuiltin("ATan");
        names.addBuiltin("ATan2");
        names.addBuiltin("Ceiling");
        names.addBuiltin("Cos");
        names.addBuiltin("Cot");
        names.addBuiltin("Degrees");
        names.addBuiltin("Exp");
        names.addBuiltin("Floor");
        names.addBuiltin("Log");
        names.addBuiltin("Log10");
        names.addBuiltin("Mod");
        names.addBuiltin("Pi");
        names.addBuiltin("Power");
        names.addBuiltin("Radians");
        names.addBuiltin("Rand");
        names.addBuiltin("Round");
        names.addBuiltin("Sign");
        names.addBuiltin("Sin");
        names.addBuiltin("Sqrt");
        names.addBuiltin("Tan");
        names.addBuiltin("Truncate");
        names.addBuiltin("Ascii");
        names.addBuiltin("Bit_Length");
        names.addBuiltin("Char");
        names.addBuiltin("Character_Length");
        names.addBuiltin("Char_Length");
        names.addBuiltin("Collate");
        names.addBuiltin("Concat");
        names.addBuiltin("Insert");
        names.addBuiltin("LCase");
        names.addBuiltin("Left");
        names.addBuiltin("Length");
        names.addBuiltin("Locate");
        names.addBuiltin("Lower");
        names.addBuiltin("LTrim");
        names.addBuiltin("Octet_Length");
        names.addBuiltin("Position");
        names.addBuiltin("Repeat");
        names.addBuiltin("Replace");
        names.addBuiltin("Right");
        names.addBuiltin("RTrim");
        names.addBuiltin("Space");
        names.addBuiltin("SubString");
        names.addBuiltin("Trim");
        names.addBuiltin("UCase");
        names.addBuiltin("Upper");
        names.addBuiltin("ApplicationId");
        names.addBuiltin("Cast");
        names.addBuiltin("Coalesce");
        names.addBuiltin("Contains");
        names.addBuiltin("Convert");
        names.addBuiltin("Database");
        names.addBuiltin("Difference");
        names.addBuiltin("IfNull");
        names.addBuiltin("IIf");
        names.addBuiltin("IsNull");
        names.addBuiltin("LastAutoInc");
        names.addBuiltin("NewIdString");
        names.addBuiltin("Score");
        names.addBuiltin("ScoreDistinct");
        names.addBuiltin("SoundEx");
        names.addBuiltin("User");
    }

    @Override
    public void getComparisonOperators(List<String> sl) {
        super.getComparisonOperators(sl);
        sl.clear();
        sl.add("=");
        sl.add("<");
        sl.add("<=");
        sl.add(">");
        sl.add(">=");
        sl.add("<>");
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList names) {
        names.clear();
        names.addIdentifier("Count", false);
    }

    @Override
    public boolean isFixedSizeType(String type) {
        return type.compareToIgnoreCase("char") != 0 && type.compareToIgnoreCase("varchar") != 0 && type.compareToIgnoreCase("binary") != 0 && type.compareToIgnoreCase("varbinary") != 0;
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        if (!LoadMetadataHelpers.getDatabaseListAdvantage(sqlContext, databaseList)) {
            super.getDatabaseList(sqlContext, databaseList);
        }
    }

    @Override
    public void resetCachedDefaultDatabaseName() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
        }
        this.defaultDatabaseName = null;
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName;
        }
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        this.defaultDatabaseName = LoadMetadataHelpers.getDefaultDatabaseNameAdvantage(sqlContext);
        if (this.defaultDatabaseName == null) {
            this.defaultDatabaseName = super.getDefaultDatabaseName(sqlContext);
        }
        return this.defaultDatabaseName;
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (forObj instanceof UnionSubQuery) {
            return AdvantageQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    @Override
    public String getQuoteBegin() {
        return "\"";
    }

    @Override
    public String getQuoteEnd() {
        return "\"";
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider metadataProvider) {
        assert (metadataProvider != null);
        SyntaxSupportsConectedServer result = LoadMetadataHelpers.isConnectedServerIsAdvantage(metadataProvider);
        if (result == SyntaxSupportsConectedServer.Unknown) {
            result = super.isSupportConectedServer(metadataProvider);
        }
        return result;
    }

    @Override
    public boolean isSupportDatabases() {
        return true;
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext sqlContext, MetadataObject metadataObject) throws QueryBuilderException {
        assert (sqlContext != null);
        assert (sqlContext.getMetadataProvider() != null);
        assert (sqlContext.getMetadataProvider().canExecSQL());
        assert (metadataObject != null);
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        String objectName = metadataObject.getName().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String objectSchema = metadataObject.getSchema().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServerWithoutQuotes());
        String db = Helpers.isQualifiedNameEmpty(metadataObject.getDatabase()) ? "Database()" : "'" + metadataObject.getDatabase().getSimpleSQL(sqlContext.getSQLBuilderExpressionForServer()) + "'";
        MetadataFieldsFetcherFromQuery mff = new MetadataFieldsFetcherFromQuery(sqlContext);
        mff.setQuery("execute procedure sp_GetColumns(" + db + ", null, '" + objectName + "', null)");
        mff.setNameFieldName("COLUMN_NAME");
        mff.setServerTypeFieldName("TYPE_NAME");
        mff.setSizeFieldName("COLUMN_SIZE");
        mff.setPrecisionFieldName("NUM_PREC_RADIX");
        mff.setScaleFieldName("DECIMAL_DIGITS");
        mff.setNullableFieldName("NULLABLE");
        mff.setNullableValue("1");
        mff.loadFields(metadataObject.getFields());
        mff.dispose();
        mff = new MetadataFieldsFetcherFromQuery(sqlContext);
        mff.setQuery("execute procedure sp_GetPrimaryKeys(" + db + ", null, '" + objectName + "')");
        mff.setNameFieldName("COLUMN_NAME");
        mff.setPrimaryFieldName("COLUMN_NAME");
        mff.setNonPrimaryValue(null);
        mff.loadFields(metadataObject.getFields());
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsAdvantage(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.isDetectServerVersion()) {
            this.doDetectServerVersion(sqlContext.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsAdvantage(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public String getQueryToLoadFieldsForObject(String fieldName, String objectExpression) {
        String fieldExpression = Str.IsNullOrEmpty(fieldName) ? "*" : fieldName;
        return "select top 0 " + fieldExpression + " from " + objectExpression + " a";
    }
}

