/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.QueryTabSheet;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Wrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

class UnionNavBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private QueryTabSheet queryTabSheet;
    private ButtonGroup buttonGroup = new ButtonGroup();

    public UnionNavBar(QueryTabSheet queryTabSheet) {
        this.queryTabSheet = queryTabSheet;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setFocusable(false);
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof JToggleButton) {
                    UnionNavBar.this.buttonGroup.add((AbstractButton)c);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof JToggleButton) {
                    UnionNavBar.this.buttonGroup.remove((AbstractButton)c);
                }
            }
        });
    }

    public QueryTabSheet getQueryTabSheet() {
        return this.queryTabSheet;
    }

    void buildList(List l, UnionGroup q) {
        for (int i = 0; i < q.getCount(); ++i) {
            QueryBase item = q.get(i);
            if (item instanceof UnionSubQuery) {
                l.add(item);
            }
            if (!(item instanceof UnionGroup)) continue;
            l.add(item);
            this.buildList(l, (UnionGroup)item);
            l.add(item);
        }
    }

    protected void buildControlList(List l, UnionGroup q) {
        for (int i = 0; i < q.getCount(); ++i) {
            QueryBase item = q.get(i);
            l.add(item.getUnionOperatorControl());
            if (item instanceof UnionSubQuery) {
                l.add(((UnionSubQuery)item).getUnionButton());
                continue;
            }
            if (!(item instanceof UnionGroup)) continue;
            l.add(((UnionGroup)item).getLeftBracket());
            this.buildControlList(l, (UnionGroup)item);
            l.add(((UnionGroup)item).getRightBracket());
        }
    }

    void findQueryBounds(List l, UnionGroup q, Wrapper<Integer> i1, Wrapper<Integer> i2) {
        i1.value = l.indexOf(q);
        l.set((Integer)i1.value, null);
        i2.value = l.indexOf(q);
        l.set((Integer)i1.value, q);
    }

    @Override
    public void doLayout() {
        this.realignButtons();
        super.doLayout();
    }

    private void realignButtons() {
        int i;
        ArrayList l = new ArrayList();
        this.buildList(l, this.getQueryTabSheet().getQuery());
        for (i = 0; i < l.size(); ++i) {
            ((QueryBase)l.get(i)).updateUnionOperator();
        }
        l.clear();
        this.buildControlList(l, this.getQueryTabSheet().getQuery());
        for (i = l.size() - 1; i >= 0; --i) {
            Component c = (Component)l.get(i);
            if (c == null || !c.isVisible()) continue;
            this.setComponentZOrder(c, 0);
        }
    }

    int calcWidth() {
        ArrayList l = new ArrayList();
        this.buildList(l, this.getQueryTabSheet().getQuery());
        for (int i = 0; i < l.size(); ++i) {
            ((QueryBase)l.get(i)).updateUnionOperator();
        }
        return this.getLayout().preferredLayoutSize((Container)this).width;
    }

    public void reAlign() {
        this.revalidate();
    }
}

