/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.SQLBuilderConditionFormatNL;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.BaseSQLBuilder;
import com.adbs.querybuilder.SqlBuilderOptionsPages;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SqlBuilderPage
extends BasePropertyPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private SqlBuilderOptionsPages page = SqlBuilderOptionsPages.MainQuery;
    private BaseSQLBuilder builder = null;
    private SQLBuilderSelectFormat format;
    private JCheckBox cbNewLineAfterDatasource;
    private JCheckBox cbNewLineAfterGroupItem;
    private JCheckBox cbNewLineAfterJoin;
    private JCheckBox cbNewLineAfterKeywords;
    private JCheckBox cbNewLineAfterSelectItem;
    private JCheckBox cbNewLineHavingRest;
    private JCheckBox cbNewLineHavingTop;
    private JCheckBox cbNewLineWhereRest;
    private JCheckBox cbNewLineWhereTop;
    private JCheckBox cbPartsOnNewLines;
    private JPanel groupLabel1;
    private JPanel groupLabel2;
    private JPanel groupLabel3;
    private JPanel groupLabel4;
    private JPanel groupLabel5;
    private JPanel groupLabel6;
    private JLabel label13;
    private JLabel label14;
    private JLabel label15;
    private JLabel label16;
    private JSpinner updownGlobalIndent;
    private JSpinner updownHavingIndent;
    private JSpinner updownPartIndent;
    private JSpinner updownWhereIndent;

    public SqlBuilderPage(SqlBuilderOptionsPages page, BaseSQLBuilder builder) {
        this.page = page;
        this.builder = builder;
        this.format = new SQLBuilderSelectFormat(null);
        if (page == SqlBuilderOptionsPages.MainQuery) {
            this.format.assign(builder.getMainQueryFormat());
        } else if (page == SqlBuilderOptionsPages.DerievedQueries) {
            this.format.assign(builder.getDerievedQueryFormat());
        } else if (page == SqlBuilderOptionsPages.ExpressionSubqueries) {
            this.format.assign(builder.getExpressionSubqueryFormat());
        }
        this.initComponents();
        Helpers.localizer.localizePanel(this);
        this.cbPartsOnNewLines.setSelected(this.format.getMainPartsFromNewLine());
        this.cbNewLineAfterKeywords.setSelected(this.format.getNewLineAfterPartKeywords());
        this.updownGlobalIndent.setValue(this.format.getIndentGlobal());
        this.updownPartIndent.setValue(this.format.getIndentInPart());
        this.cbNewLineAfterSelectItem.setSelected(this.format.getSelectListFormat().getNewLineAfterItem());
        this.cbNewLineAfterDatasource.setSelected(this.format.getFromClauseFormat().getNewLineAfterDatasource());
        this.cbNewLineAfterJoin.setSelected(this.format.getFromClauseFormat().getNewLineAfterJoin());
        this.cbNewLineWhereTop.setSelected(this.format.getWhereFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.AllLogical || this.format.getWhereFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.TopmostOr || this.format.getWhereFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.TopmostLogical);
        this.actionPerformed(new ActionEvent(this.cbNewLineWhereTop, 0, ""));
        this.cbNewLineWhereRest.setSelected(this.format.getWhereFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.AllLogical);
        this.actionPerformed(new ActionEvent(this.cbNewLineWhereRest, 0, ""));
        this.updownWhereIndent.setValue(this.format.getWhereFormat().getIndentNestedConditions());
        this.cbNewLineAfterGroupItem.setSelected(this.format.getGroupByFormat().getNewLineAfterItem());
        this.cbNewLineHavingTop.setSelected(this.format.getHavingFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.AllLogical || this.format.getHavingFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.TopmostOr || this.format.getHavingFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.TopmostLogical);
        this.actionPerformed(new ActionEvent(this.cbNewLineHavingTop, 0, ""));
        this.cbNewLineHavingRest.setSelected(this.format.getHavingFormat().getNewLineAfter() == SQLBuilderConditionFormatNL.AllLogical);
        this.actionPerformed(new ActionEvent(this.cbNewLineHavingRest, 0, ""));
        this.updownHavingIndent.setValue(this.format.getHavingFormat().getIndentNestedConditions());
        this.updownHavingIndent.addChangeListener(this);
        this.cbNewLineHavingRest.addActionListener(this);
        this.cbNewLineHavingTop.addActionListener(this);
        this.cbNewLineAfterGroupItem.addActionListener(this);
        this.updownWhereIndent.addChangeListener(this);
        this.cbNewLineWhereRest.addActionListener(this);
        this.cbNewLineWhereTop.addActionListener(this);
        this.cbNewLineAfterJoin.addActionListener(this);
        this.cbNewLineAfterDatasource.addActionListener(this);
        this.cbNewLineAfterSelectItem.addActionListener(this);
        this.updownPartIndent.addChangeListener(this);
        this.updownGlobalIndent.addChangeListener(this);
        this.cbNewLineAfterKeywords.addActionListener(this);
        this.cbPartsOnNewLines.addActionListener(this);
    }

    @Override
    public void applyChanges() {
        if (this.isModified()) {
            this.format.setMainPartsFromNewLine(this.cbPartsOnNewLines.isSelected());
            this.format.setNewLineAfterPartKeywords(this.cbNewLineAfterKeywords.isSelected());
            this.format.setIndentInPart((Integer)this.updownPartIndent.getValue());
            this.format.setIndentGlobal((Integer)this.updownGlobalIndent.getValue());
            this.format.getSelectListFormat().setNewLineAfterItem(this.cbNewLineAfterSelectItem.isSelected());
            this.format.getFromClauseFormat().setNewLineAfterDatasource(this.cbNewLineAfterDatasource.isSelected());
            this.format.getFromClauseFormat().setNewLineAfterJoin(this.cbNewLineAfterJoin.isSelected());
            if (this.cbNewLineWhereRest.isSelected()) {
                this.format.getWhereFormat().setNewLineAfter(SQLBuilderConditionFormatNL.AllLogical);
            } else if (this.cbNewLineWhereTop.isSelected()) {
                this.format.getWhereFormat().setNewLineAfter(SQLBuilderConditionFormatNL.TopmostLogical);
            } else {
                this.format.getWhereFormat().setNewLineAfter(SQLBuilderConditionFormatNL.None);
            }
            this.format.getWhereFormat().setIndentNestedConditions((Integer)this.updownWhereIndent.getValue());
            this.format.getGroupByFormat().setNewLineAfterItem(this.cbNewLineAfterGroupItem.isSelected());
            if (this.cbNewLineHavingRest.isSelected()) {
                this.format.getHavingFormat().setNewLineAfter(SQLBuilderConditionFormatNL.AllLogical);
            } else if (this.cbNewLineHavingTop.isSelected()) {
                this.format.getHavingFormat().setNewLineAfter(SQLBuilderConditionFormatNL.TopmostLogical);
            } else {
                this.format.getHavingFormat().setNewLineAfter(SQLBuilderConditionFormatNL.None);
            }
            this.format.getHavingFormat().setIndentNestedConditions((Integer)this.updownHavingIndent.getValue());
            if (this.page == SqlBuilderOptionsPages.MainQuery) {
                this.builder.getMainQueryFormat().assign(this.format);
            } else if (this.page == SqlBuilderOptionsPages.DerievedQueries) {
                this.builder.getDerievedQueryFormat().assign(this.format);
            } else if (this.page == SqlBuilderOptionsPages.ExpressionSubqueries) {
                this.builder.getExpressionSubqueryFormat().assign(this.format);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cbNewLineWhereTop) {
            this.cbNewLineWhereRest.setEnabled(this.cbNewLineWhereTop.isSelected());
            if (!this.cbNewLineWhereTop.isSelected()) {
                this.cbNewLineWhereRest.setSelected(false);
                this.actionPerformed(new ActionEvent(this.cbNewLineWhereRest, 0, ""));
            }
        } else if (source == this.cbNewLineWhereRest) {
            this.updownWhereIndent.setEnabled(this.cbNewLineWhereRest.isSelected());
        } else if (source == this.cbNewLineHavingTop) {
            this.cbNewLineHavingRest.setEnabled(this.cbNewLineHavingTop.isSelected());
            if (!this.cbNewLineHavingTop.isSelected()) {
                this.cbNewLineHavingRest.setSelected(false);
                this.actionPerformed(new ActionEvent(this.cbNewLineHavingRest, 0, ""));
            }
        } else if (source == this.cbNewLineHavingRest) {
            this.updownHavingIndent.setEnabled(this.cbNewLineHavingRest.isSelected());
        }
        if (e.getID() != 0) {
            this.setModified(true);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setModified(true);
    }

    private void initComponents() {
        this.groupLabel3 = new JPanel();
        this.cbPartsOnNewLines = new JCheckBox();
        this.cbNewLineAfterKeywords = new JCheckBox();
        this.updownGlobalIndent = new JSpinner();
        this.updownPartIndent = new JSpinner();
        this.label13 = new JLabel();
        this.label14 = new JLabel();
        this.groupLabel1 = new JPanel();
        this.cbNewLineAfterSelectItem = new JCheckBox();
        this.groupLabel2 = new JPanel();
        this.cbNewLineAfterDatasource = new JCheckBox();
        this.cbNewLineAfterJoin = new JCheckBox();
        this.groupLabel4 = new JPanel();
        this.cbNewLineWhereTop = new JCheckBox();
        this.cbNewLineWhereRest = new JCheckBox();
        this.updownWhereIndent = new JSpinner();
        this.label15 = new JLabel();
        this.groupLabel5 = new JPanel();
        this.cbNewLineAfterGroupItem = new JCheckBox();
        this.groupLabel6 = new JPanel();
        this.cbNewLineHavingTop = new JCheckBox();
        this.cbNewLineHavingRest = new JCheckBox();
        this.updownHavingIndent = new JSpinner();
        this.label16 = new JLabel();
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Dialog", 0, 11));
        this.setName("SqlBuilderPage");
        this.groupLabel3.setBorder(BorderFactory.createTitledBorder(null, "WHERE", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel3.setName("groupLabel3");
        this.groupLabel3.setOpaque(false);
        this.cbPartsOnNewLines.setFont(this.cbPartsOnNewLines.getFont());
        this.cbPartsOnNewLines.setText("Start parts on new lines");
        this.cbPartsOnNewLines.setName("cbPartsOnNewLines");
        this.cbPartsOnNewLines.setOpaque(false);
        this.cbNewLineAfterKeywords.setFont(this.cbNewLineAfterKeywords.getFont());
        this.cbNewLineAfterKeywords.setText("Insert new line after part keyword");
        this.cbNewLineAfterKeywords.setName("cbNewLineAfterKeywords");
        this.cbNewLineAfterKeywords.setOpaque(false);
        this.updownGlobalIndent.setFont(this.updownGlobalIndent.getFont());
        this.updownGlobalIndent.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.updownPartIndent.setFont(this.updownPartIndent.getFont());
        this.updownPartIndent.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.label13.setFont(this.label13.getFont());
        this.label13.setText("Global indent");
        this.label13.setName("label13");
        this.label14.setFont(this.label14.getFont());
        this.label14.setText("Part indent");
        this.label14.setName("label14");
        GroupLayout groupLabel3Layout = new GroupLayout(this.groupLabel3);
        this.groupLabel3.setLayout(groupLabel3Layout);
        groupLabel3Layout.setHorizontalGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel3Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbPartsOnNewLines).addComponent(this.cbNewLineAfterKeywords).addGroup(groupLabel3Layout.createSequentialGroup().addComponent(this.updownGlobalIndent, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.label13)).addGroup(groupLabel3Layout.createSequentialGroup().addComponent(this.updownPartIndent, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.label14))).addContainerGap(167, Short.MAX_VALUE)));
        groupLabel3Layout.setVerticalGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel3Layout.createSequentialGroup().addComponent(this.cbPartsOnNewLines).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNewLineAfterKeywords).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updownGlobalIndent, -2, -1, -2).addComponent(this.label13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updownPartIndent, -2, -1, -2).addComponent(this.label14)).addContainerGap(-1, Short.MAX_VALUE)));
        this.groupLabel1.setBorder(BorderFactory.createTitledBorder(null, "WHERE", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel1.setOpaque(false);
        this.cbNewLineAfterSelectItem.setFont(this.cbNewLineAfterSelectItem.getFont());
        this.cbNewLineAfterSelectItem.setText("Insert new line after each select list item");
        this.cbNewLineAfterSelectItem.setName("cbNewLineAfterSelectItem");
        this.cbNewLineAfterSelectItem.setOpaque(false);
        GroupLayout groupLabel1Layout = new GroupLayout(this.groupLabel1);
        this.groupLabel1.setLayout(groupLabel1Layout);
        groupLabel1Layout.setHorizontalGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel1Layout.createSequentialGroup().addContainerGap().addComponent(this.cbNewLineAfterSelectItem).addContainerGap(143, Short.MAX_VALUE)));
        groupLabel1Layout.setVerticalGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNewLineAfterSelectItem));
        this.groupLabel2.setBorder(BorderFactory.createTitledBorder(null, "WHERE", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel2.setOpaque(false);
        this.cbNewLineAfterDatasource.setFont(this.cbNewLineAfterDatasource.getFont());
        this.cbNewLineAfterDatasource.setText("Insert new line after each datat source item");
        this.cbNewLineAfterDatasource.setName("cbNewLineAfterDatasource");
        this.cbNewLineAfterDatasource.setOpaque(false);
        this.cbNewLineAfterJoin.setFont(this.cbNewLineAfterJoin.getFont());
        this.cbNewLineAfterJoin.setText("Insert new line after each JOIN keyword");
        this.cbNewLineAfterJoin.setName("cbNewLineAfterJoin");
        this.cbNewLineAfterJoin.setOpaque(false);
        GroupLayout groupLabel2Layout = new GroupLayout(this.groupLabel2);
        this.groupLabel2.setLayout(groupLabel2Layout);
        groupLabel2Layout.setHorizontalGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel2Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNewLineAfterDatasource).addComponent(this.cbNewLineAfterJoin)).addContainerGap(125, Short.MAX_VALUE)));
        groupLabel2Layout.setVerticalGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel2Layout.createSequentialGroup().addComponent(this.cbNewLineAfterDatasource).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNewLineAfterJoin)));
        this.groupLabel4.setBorder(BorderFactory.createTitledBorder(null, "WHERE", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel4.setOpaque(false);
        this.cbNewLineWhereTop.setFont(this.cbNewLineWhereTop.getFont());
        this.cbNewLineWhereTop.setText("Insert new line after topmost logical operators");
        this.cbNewLineWhereTop.setName("cbNewLineWhereTop");
        this.cbNewLineWhereTop.setOpaque(false);
        this.cbNewLineWhereRest.setFont(this.cbNewLineWhereRest.getFont());
        this.cbNewLineWhereRest.setText("Insert new line after the rest of logical operators");
        this.cbNewLineWhereRest.setName("cbNewLineWhereRest");
        this.cbNewLineWhereRest.setOpaque(false);
        this.updownWhereIndent.setFont(this.updownWhereIndent.getFont());
        this.updownWhereIndent.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.label15.setFont(this.label15.getFont());
        this.label15.setText("Nested conditions indent");
        this.label15.setName("label15");
        GroupLayout groupLabel4Layout = new GroupLayout(this.groupLabel4);
        this.groupLabel4.setLayout(groupLabel4Layout);
        groupLabel4Layout.setHorizontalGroup(groupLabel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel4Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNewLineWhereTop).addComponent(this.cbNewLineWhereRest).addGroup(groupLabel4Layout.createSequentialGroup().addComponent(this.updownWhereIndent, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.label15))).addContainerGap(99, Short.MAX_VALUE)));
        groupLabel4Layout.setVerticalGroup(groupLabel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel4Layout.createSequentialGroup().addComponent(this.cbNewLineWhereTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNewLineWhereRest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLabel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updownWhereIndent, -2, -1, -2).addComponent(this.label15)).addContainerGap(-1, Short.MAX_VALUE)));
        this.groupLabel5.setBorder(BorderFactory.createTitledBorder(null, "WHERE", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel5.setOpaque(false);
        this.cbNewLineAfterGroupItem.setFont(this.cbNewLineAfterGroupItem.getFont());
        this.cbNewLineAfterGroupItem.setText("Insert new line after each group list item");
        this.cbNewLineAfterGroupItem.setName("cbNewLineAfterGroupItem");
        this.cbNewLineAfterGroupItem.setOpaque(false);
        GroupLayout groupLabel5Layout = new GroupLayout(this.groupLabel5);
        this.groupLabel5.setLayout(groupLabel5Layout);
        groupLabel5Layout.setHorizontalGroup(groupLabel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel5Layout.createSequentialGroup().addContainerGap().addComponent(this.cbNewLineAfterGroupItem).addContainerGap(143, Short.MAX_VALUE)));
        groupLabel5Layout.setVerticalGroup(groupLabel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNewLineAfterGroupItem));
        this.groupLabel6.setBorder(BorderFactory.createTitledBorder(null, "WHERE", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel6.setOpaque(false);
        this.cbNewLineHavingTop.setFont(this.cbNewLineHavingTop.getFont());
        this.cbNewLineHavingTop.setText("Insert new line after topmost logical operators");
        this.cbNewLineHavingTop.setName("cbNewLineHavingTop");
        this.cbNewLineHavingTop.setOpaque(false);
        this.cbNewLineHavingRest.setFont(this.cbNewLineHavingRest.getFont());
        this.cbNewLineHavingRest.setText("Insert new line after the rest of logical operators");
        this.cbNewLineHavingRest.setName("cbNewLineHavingRest");
        this.cbNewLineHavingRest.setOpaque(false);
        this.updownHavingIndent.setFont(this.updownHavingIndent.getFont());
        this.updownHavingIndent.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.label16.setFont(this.label16.getFont());
        this.label16.setText("Nested conditions indent");
        this.label16.setName("label16");
        GroupLayout groupLabel6Layout = new GroupLayout(this.groupLabel6);
        this.groupLabel6.setLayout(groupLabel6Layout);
        groupLabel6Layout.setHorizontalGroup(groupLabel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel6Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNewLineHavingTop).addComponent(this.cbNewLineHavingRest).addGroup(groupLabel6Layout.createSequentialGroup().addComponent(this.updownHavingIndent, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.label16))).addContainerGap(99, Short.MAX_VALUE)));
        groupLabel6Layout.setVerticalGroup(groupLabel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel6Layout.createSequentialGroup().addComponent(this.cbNewLineHavingTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNewLineHavingRest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLabel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.updownHavingIndent, -2, -1, -2).addComponent(this.label16)).addContainerGap(11, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.groupLabel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.groupLabel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel4, -2, 101, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel6, -2, -1, -2)));
    }
}

