/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstNodeVisitor;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLAliasExpression;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLExpressionAnd;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLogicalCollection;
import com.adbs.ast.SQLExpressionNot;
import com.adbs.ast.SQLExpressionOr;
import com.adbs.ast.SQLExpressionParameter;
import com.adbs.ast.SQLFromClause;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromGroup;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLGroupByList;
import com.adbs.ast.SQLJoinKind;
import com.adbs.ast.SQLJoinKindCross;
import com.adbs.ast.SQLJoinKindFull;
import com.adbs.ast.SQLJoinKindInner;
import com.adbs.ast.SQLJoinKindLeft;
import com.adbs.ast.SQLJoinKindRight;
import com.adbs.ast.SQLOrderByClause;
import com.adbs.ast.SQLOrderByItem;
import com.adbs.ast.SQLOrderByOrders;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemAllTableColumns;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.ast.SQLSubQueryExpressions;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SQLWithClause;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.ast.StatsColumn;
import com.adbs.ast.StatsObject;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryXMLCreatorParam;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class QueryXMLCreator
extends AstNodeVisitor {
    private Document document;
    private SQLBuilder sqlBuilder;

    public QueryXMLCreator(Document document, SQLBuilder sqlBuilder) {
        this.document = document;
        this.sqlBuilder = sqlBuilder;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document value) {
        this.document = value;
    }

    public SQLBuilder getSQLBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected List getNodeChildren(AstNodeBase node, Object nodeParam, AstNodeBase parent, Object parentParam) {
        List result = super.getNodeChildren(node, nodeParam, parent, parentParam);
        if (node instanceof SQLSubSelectStatement && ((SQLSubSelectStatement)node).orderBy != null) {
            result.remove(((SQLSubSelectStatement)node).orderBy);
            result.add(((SQLSubSelectStatement)node).orderBy);
        }
        return result;
    }

    private void addMetadataObjectNodes(Element parent, MetadataObject metadataObject) {
        if (!Helpers.isQualifiedNameEmpty(metadataObject.getDatabase())) {
            Helpers.createNodeWithValueParent(this.document, parent, "database", metadataObject.getDatabase().getSimpleSQL(this.sqlBuilder));
        }
        if (!metadataObject.getSchema().isEmpty()) {
            Helpers.createNodeWithValueParent(this.document, parent, "schema", metadataObject.getSchema().getSimpleSQL(this.sqlBuilder));
        }
        if (!metadataObject.getName().isEmpty()) {
            Helpers.createNodeWithValueParent(this.document, parent, "name", metadataObject.getName().getSimpleSQL(this.sqlBuilder));
        }
        if (!metadataObject.getAltName().isEmpty()) {
            Helpers.createNodeWithValueParent(this.document, parent, "alt_name", metadataObject.getAltName());
        }
    }

    private void addUsedDatabaseObject(StatsObject statsObject, Element parentINode) {
        Element inode = Helpers.createNodeParent(this.document, parentINode, "used_object");
        if (statsObject.getMetadataObject() != null) {
            inode.setAttribute("object_name", statsObject.getMetadataObject().getFullName().getSimpleSQL(this.sqlBuilder));
            this.addMetadataObjectNodes(inode, statsObject.getMetadataObject());
        } else {
            inode.setAttribute("object_name", statsObject.getName().getSimpleSQL(this.sqlBuilder));
        }
    }

    private void addUsedDatabaseObjects(AstNodeBase node, Element parentINode) {
        Element usedObjectsNode = Helpers.createNodeParent(this.document, parentINode, "used_objects");
        for (int i = 0; i < node.getUsedDatabaseObjects().getCount(); ++i) {
            StatsObject so = node.getUsedDatabaseObjects().get(i);
            this.addUsedDatabaseObject(so, usedObjectsNode);
        }
    }

    private void addUsedDatabaseObjectColumn(StatsColumn statsColumn, Element parentINode) {
        Element inode = Helpers.createNodeParent(this.document, parentINode, "used_column");
        if (statsColumn.getMetadataObject() != null) {
            inode.setAttribute("object_name", statsColumn.getMetadataObject().getFullName().getSimpleSQL(this.sqlBuilder));
            this.addMetadataObjectNodes(inode, statsColumn.getMetadataObject());
        } else {
            inode.setAttribute("object_name", statsColumn.getObjectName().getSimpleSQL(this.sqlBuilder));
        }
        if (statsColumn.getMetadataField() != null) {
            inode.setAttribute("column_name", statsColumn.getMetadataField().getName().getSimpleSQL(this.sqlBuilder));
            if (!statsColumn.getMetadataObject().getName().isEmpty()) {
                Helpers.createNodeWithValueParent(this.document, inode, "column", statsColumn.getMetadataField().getName().getSimpleSQL(this.sqlBuilder));
            }
        } else {
            inode.setAttribute("column_name", statsColumn.getName().getSimpleSQL(this.sqlBuilder));
        }
    }

    private void addUsedDatabaseObjectColumns(AstNodeBase node, Element parentINode) {
        Element usedObjectColumnsNode = Helpers.createNodeParent(this.document, parentINode, "used_columns");
        for (int i = 0; i < node.getUsedDatabaseObjectColumns().getCount(); ++i) {
            StatsColumn sc = node.getUsedDatabaseObjectColumns().get(i);
            this.addUsedDatabaseObjectColumn(sc, usedObjectColumnsNode);
        }
    }

    private String calcNodeName(AstNodeBase node, Object parentParam, String nodeName) {
        String result = parentParam != null ? ((QueryXMLCreatorParam)parentParam).getNodeName(node) : "";
        if (Str.IsNullOrEmpty(result)) {
            result = nodeName;
        }
        return result;
    }

    private QueryXMLCreatorParam createNewParamObj(AstNodeBase node, Object parentParam, String nodeName, boolean stats, boolean sql) {
        Element inode;
        String name = this.calcNodeName(node, parentParam, nodeName);
        if (!Str.IsNullOrEmpty(name)) {
            inode = this.document.createElement(name);
            if (parentParam != null) {
                ((QueryXMLCreatorParam)parentParam).node.appendChild(inode);
            } else {
                this.document.appendChild(inode);
                inode.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                inode.setAttribute("xsi:noNamespaceSchemaLocation", "http://www.activequerybuilder.com/schemas/query.xsd");
            }
            if (stats) {
                this.addUsedDatabaseObjects(node, inode);
                this.addUsedDatabaseObjectColumns(node, inode);
            }
            if (sql) {
                inode.setAttribute("sql", ((AstNode)node).getSimpleSQL(this.sqlBuilder));
            }
        } else {
            inode = ((QueryXMLCreatorParam)parentParam).node;
        }
        QueryXMLCreatorParam result = new QueryXMLCreatorParam();
        result.node = inode;
        return result;
    }

    private Element createNewNodeWithValue(AstNodeBase node, Object parentParam, String nodeName, Object nodeValue, boolean sql) {
        Element result;
        String name = this.calcNodeName(node, parentParam, nodeName);
        if (!Str.IsNullOrEmpty(name)) {
            result = this.document.createElement(name);
            assert (parentParam != null);
            ((QueryXMLCreatorParam)parentParam).node.appendChild(result);
            if (sql) {
                result.setAttribute("sql", ((AstNode)node).getSimpleSQL(this.sqlBuilder));
            }
            result.setTextContent(Helpers.transformNodeValue(nodeValue).toString());
        } else {
            result = null;
        }
        return result;
    }

    private String joinKindToString(SQLJoinKind joinKind) throws QueryBuilderException {
        String result;
        if (joinKind instanceof SQLJoinKindCross) {
            result = "cross";
        } else if (joinKind instanceof SQLJoinKindInner) {
            result = "inner";
        } else if (joinKind instanceof SQLJoinKindLeft) {
            result = "left";
        } else if (joinKind instanceof SQLJoinKindRight) {
            result = "right";
        } else if (joinKind instanceof SQLJoinKindFull) {
            result = "full";
        } else {
            throw new QueryBuilderException("Don't know how to write the join class: " + joinKind.getClass().getName());
        }
        return result;
    }

    @Override
    protected Object enterIntoNode(AstNodeBase node, AstNodeBase parent, Object parentParam) {
        QueryXMLCreatorParam newParam;
        if (node instanceof SQLSubSelectStatement) {
            newParam = node instanceof SQLSelectStatement ? this.createNewParamObj(node, parentParam, "statement", true, true) : this.createNewParamObj(node, parentParam, "subquery", true, true);
            if (((SQLSubSelectStatement)node).orderBy != null) {
                newParam.addNodeName(((SQLSubSelectStatement)node).orderBy, "order_by_clause");
            }
        } else if (node instanceof SQLSubQueryExpressions) {
            newParam = this.createNewParamObj(node, parentParam, "union_group", true, false);
            Element inode = newParam.node;
            if (!Str.IsNullOrEmpty(((SQLSubQueryExpressions)node).getUnionOperator())) {
                inode.setAttribute("union_operator", ((SQLSubQueryExpressions)node).getUnionOperator());
            }
        } else if (node instanceof SQLSubQuerySelectExpression) {
            newParam = this.createNewParamObj(node, parentParam, "union_subquery", true, true);
            Element inode = newParam.node;
            if (!Str.IsNullOrEmpty(((SQLSubQueryExpression)node).getUnionOperator())) {
                inode.setAttribute("union_operator", ((SQLSubQueryExpression)node).getUnionOperator());
            }
            if (((SQLSubQuerySelectExpression)node).selectItems != null) {
                newParam.addNodeName(((SQLSubQuerySelectExpression)node).selectItems, "select_clause");
            }
            if (((SQLSubQuerySelectExpression)node).from != null) {
                newParam.addNodeName(((SQLSubQuerySelectExpression)node).from, "from_clause");
            }
            if (((SQLSubQuerySelectExpression)node).where != null) {
                newParam.addNodeName(((SQLSubQuerySelectExpression)node).where, "where_clause");
            }
            if (((SQLSubQuerySelectExpression)node).groupBy != null) {
                newParam.addNodeName(((SQLSubQuerySelectExpression)node).groupBy, "group_by_clause");
            }
            if (((SQLSubQuerySelectExpression)node).having != null) {
                newParam.addNodeName(((SQLSubQuerySelectExpression)node).having, "having_clause");
            }
            if (((SQLSubQuerySelectExpression)node).orderBy != null) {
                newParam.addNodeName(((SQLSubQuerySelectExpression)node).orderBy, "order_by_clause");
            }
        } else if (node instanceof SQLSelectItems) {
            newParam = this.createNewParamObj(node, parentParam, "", true, false);
        } else if (node instanceof SQLSelectItem) {
            newParam = this.createNewParamObj(node, parentParam, "select_item", true, true);
            Element inode = newParam.node;
            if (node instanceof SQLSelectItemExpression) {
                inode.setAttribute("type", "expression");
                newParam.addNodeName(((SQLSelectItemExpression)node).expression, "expression");
                newParam.addNodeName(((SQLSelectItemExpression)node).alias, "expression_alias");
            } else if (node instanceof SQLSelectItemAllTableColumns) {
                inode.setAttribute("type", "all_object_columns");
            } else {
                inode.setAttribute("type", "all_columns");
            }
        } else if (node instanceof SQLExpressionItem) {
            newParam = this.createNewParamObj(node, parentParam, "", true, true);
            if (node instanceof SQLExpressionLogicalCollection) {
                String name = node instanceof SQLExpressionOr ? "or" : (node instanceof SQLExpressionAnd ? "and" : "");
                if (!name.equals("")) {
                    for (int i = 0; i < ((SQLExpressionLogicalCollection)node).getCount(); ++i) {
                        newParam.addNodeName(((SQLExpressionLogicalCollection)node).get(i), name);
                    }
                }
            } else if (node instanceof SQLExpressionNot) {
                if (((SQLExpressionNot)node).lExpression != null) {
                    newParam.addNodeName(((SQLExpressionNot)node).lExpression, "not");
                }
            } else if (node instanceof SQLExpressionParameter) {
                if (((SQLExpressionParameter)node).symbol != null) {
                    newParam.addNodeName(((SQLExpressionParameter)node).symbol, "param_symbol");
                }
                if (((SQLExpressionParameter)node).name != null) {
                    newParam.addNodeName(((SQLExpressionParameter)node).name, "param_name");
                }
            }
        } else if (node instanceof SQLAliasExpression) {
            this.createNewNodeWithValue(node, parentParam, "", ((SQLAliasExpression)node).alias.getToken(), false);
            newParam = null;
        } else if (node instanceof SQLAliasObjectAlias) {
            this.createNewNodeWithValue(node, parentParam, "", ((SQLAliasObjectAlias)node).alias.getToken(), false);
            newParam = null;
        } else if (node instanceof SQLFromClause) {
            newParam = this.createNewParamObj(node, parentParam, "", false, false);
        } else if (node instanceof SQLFromGroup) {
            newParam = this.createNewParamObj(node, parentParam, "from_group", false, false);
            if (((SQLFromGroup)node).joinKind != null) {
                newParam.addNodeName(((SQLFromGroup)node).joinKind, "join_kind");
            }
            if (((SQLFromGroup)node).joinOn != null) {
                newParam.addNodeName(((SQLFromGroup)node).joinOn, "join_expression");
            }
        } else if (node instanceof SQLJoinKind) {
            try {
                this.createNewNodeWithValue(node, parentParam, "", this.joinKindToString((SQLJoinKind)node), false);
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(QueryXMLCreator.class.getName()).log(Level.SEVERE, null, ex);
            }
            newParam = null;
        } else if (node instanceof SQLFromSource) {
            newParam = this.createNewParamObj(node, parentParam, "from_item", true, true);
            Element inode = newParam.node;
            if (((SQLFromSource)node).joinKind != null) {
                newParam.addNodeName(((SQLFromSource)node).joinKind, "join_kind");
            }
            if (((SQLFromSource)node).joinOn != null) {
                newParam.addNodeName(((SQLFromSource)node).joinOn, "join_expression");
            }
            if (((SQLFromSource)node).alias != null) {
                newParam.addNodeName(((SQLFromSource)node).alias, "object_alias");
            }
            if (node instanceof SQLFromObject) {
                inode.setAttribute("type", "object");
                if (((SQLFromObject)node).getMetadataObject() != null) {
                    this.addMetadataObjectNodes(inode, ((SQLFromObject)node).getMetadataObject());
                }
            } else if (node instanceof SQLFromQuery) {
                inode.setAttribute("type", "derived_table");
                newParam.addNodeName(((SQLFromQuery)node).subQuery, "derived_table");
            } else if (node instanceof SQLFromFunction) {
                inode.setAttribute("type", "function");
            }
        } else if (node instanceof SQLGroupByList) {
            newParam = this.createNewParamObj(node, parentParam, "", true, true);
            for (int i = 0; i < ((SQLGroupByList)node).getCount(); ++i) {
                newParam.addNodeName(((SQLGroupByList)node).get(i), "group_by_item");
            }
        } else if (node instanceof SQLOrderByClause) {
            newParam = this.createNewParamObj(node, parentParam, "", true, true);
            for (int i = 0; i < ((SQLOrderByClause)node).getCount(); ++i) {
                newParam.addNodeName(((SQLOrderByClause)node).get(i), "order_by_item");
            }
        } else if (node instanceof SQLOrderByItem) {
            newParam = this.createNewParamObj(node, parentParam, "", true, true);
            if (((SQLOrderByItem)node).expression != null) {
                newParam.addNodeName(((SQLOrderByItem)node).expression, "expression");
            }
            if (((SQLOrderByItem)node).sort == SQLOrderByOrders.Desc) {
                newParam.node.setAttribute("sort_type", "desc");
            }
        } else if (node instanceof SQLWithClause) {
            newParam = this.createNewParamObj(node, parentParam, "with_clause", false, false);
        } else if (node instanceof SQLWithClauseItem) {
            newParam = this.createNewParamObj(node, parentParam, "with_item", true, true);
            newParam.addNodeName(((SQLWithClauseItem)node).name, "with_name");
            newParam.addNodeName(((SQLWithClauseItem)node).subQuery, "with_subquery");
        } else if (node instanceof AstTokenIdentifier) {
            this.createNewNodeWithValue(node, parentParam, "", ((AstTokenIdentifier)node).getToken(), false);
            newParam = null;
        } else if (node instanceof AstToken) {
            this.createNewNodeWithValue(node, parentParam, "", ((AstToken)node).getToken(), false);
            newParam = null;
        } else {
            newParam = new QueryXMLCreatorParam();
            newParam.node = ((QueryXMLCreatorParam)parentParam).node;
        }
        return newParam;
    }

    public static void createQueryXML(SQLSelectStatement statement, SQLBuilder sqlBuilder, Document document) throws QueryBuilderException {
        QueryXMLCreator creator = new QueryXMLCreator(document, sqlBuilder);
        creator.visit(statement, null);
    }
}

