/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.MetadataContainer;
import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.BaseSQLBuilder;
import com.adbs.querybuilder.GeneralPage;
import com.adbs.querybuilder.MetadataTreePage;
import com.adbs.querybuilder.MiscellaneousPage;
import com.adbs.querybuilder.OfflineModePage;
import com.adbs.querybuilder.PanesVisibilityPage;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderProperties;
import com.adbs.querybuilder.QueryStructureTreePage;
import com.adbs.querybuilder.SqlBuilderOptionsPages;
import com.adbs.querybuilder.SqlBuilderPage;
import com.adbs.querybuilder.SqlSyntaxPage;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.UniversalSyntaxProvider;
import com.adbs.utils.Helpers;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

class QueryBuilderPropertiesDialog
extends JDialog
implements BasePropertyPanel.ModifiedEventListener {
    private static final long serialVersionUID = 1L;
    private boolean dialogResult = false;
    private QueryBuilder queryBuilder;
    private MetadataContainer metadataContainer;
    private BaseSyntaxProvider syntaxProvider;
    private SqlSyntaxPage sqlSyntaxPage;
    private OfflineModePage offlineModePage;
    private PanesVisibilityPage panesVisibilityPage;
    private QueryStructureTreePage queryStructureTreePage;
    private MetadataTreePage metadataTreePage;
    private MiscellaneousPage miscellaneousPage;
    private GeneralPage generalPage;
    private SqlBuilderPage mainQueryPage;
    private SqlBuilderPage derievedQueriesPage;
    private SqlBuilderPage expressionSubqueriesPage;
    private JButton bApply;
    private JButton bCancel;
    private JButton bOk;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JLabel lNonVisualOptions;
    private JLabel lSqlBuilderOptions;
    private JLabel lVisualOptions;
    private JPanel pagesPanel;
    private JRadioButton rbDerivedQueries;
    private JRadioButton rbExpressionSubqeries;
    private JRadioButton rbGeneral;
    private JRadioButton rbMainQuery;
    private JRadioButton rbMetadataTree;
    private JRadioButton rbMiscellaneous;
    private JRadioButton rbOfflineMode;
    private JRadioButton rbPanesVisibility;
    private JRadioButton rbQueryStructureTree;
    private JRadioButton rbSqlSyntax;

    public QueryBuilderPropertiesDialog(Window parent, QueryBuilder queryBuilder, String title, EnumSet<QueryBuilderProperties> flags, BaseSQLBuilder builder) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        assert (queryBuilder != null);
        this.queryBuilder = queryBuilder;
        this.initComponents();
        Helpers.localizer.localizeDialog(this);
        this.setTitle(title);
        this.setLocationRelativeTo(parent);
        if (flags.contains((Object)QueryBuilderProperties.NonVisual)) {
            this.metadataContainer = new MetadataContainer(null, queryBuilder.getSQLContext());
            this.metadataContainer.assign(queryBuilder.getMetadataContainer());
            this.syntaxProvider = queryBuilder.getSyntaxProvider() != null ? queryBuilder.getSyntaxProvider().clone() : new UniversalSyntaxProvider();
            this.sqlSyntaxPage = new SqlSyntaxPage(queryBuilder, this.metadataContainer, this.syntaxProvider);
            this.sqlSyntaxPage.addModifiedEventListener(this);
            this.offlineModePage = new OfflineModePage(queryBuilder, this.metadataContainer, this.syntaxProvider);
            this.offlineModePage.addModifiedEventListener(this);
            this.rbSqlSyntaxActionPerformed(null);
        } else {
            this.lNonVisualOptions.setVisible(false);
            this.rbSqlSyntax.setVisible(false);
            this.rbOfflineMode.setVisible(false);
        }
        if (flags.contains((Object)QueryBuilderProperties.Visual)) {
            this.panesVisibilityPage = new PanesVisibilityPage(queryBuilder);
            this.panesVisibilityPage.addModifiedEventListener(this);
            this.queryStructureTreePage = new QueryStructureTreePage(queryBuilder);
            this.queryStructureTreePage.addModifiedEventListener(this);
            this.metadataTreePage = new MetadataTreePage(queryBuilder);
            this.metadataTreePage.addModifiedEventListener(this);
            this.miscellaneousPage = new MiscellaneousPage(queryBuilder);
            this.miscellaneousPage.addModifiedEventListener(this);
            if (!flags.contains((Object)QueryBuilderProperties.NonVisual)) {
                this.rbPanesVisibilityActionPerformed(null);
            }
        } else {
            this.lVisualOptions.setVisible(false);
            this.rbPanesVisibility.setVisible(false);
            this.rbQueryStructureTree.setVisible(false);
            this.rbMetadataTree.setVisible(false);
            this.rbMiscellaneous.setVisible(false);
        }
        if (flags.contains((Object)QueryBuilderProperties.SqlBuilder) && builder != null) {
            this.generalPage = new GeneralPage(builder);
            this.generalPage.addModifiedEventListener(this);
            this.mainQueryPage = new SqlBuilderPage(SqlBuilderOptionsPages.MainQuery, builder);
            this.mainQueryPage.addModifiedEventListener(this);
            this.derievedQueriesPage = new SqlBuilderPage(SqlBuilderOptionsPages.DerievedQueries, builder);
            this.derievedQueriesPage.addModifiedEventListener(this);
            this.expressionSubqueriesPage = new SqlBuilderPage(SqlBuilderOptionsPages.ExpressionSubqueries, builder);
            this.expressionSubqueriesPage.addModifiedEventListener(this);
            if (!flags.contains((Object)QueryBuilderProperties.NonVisual) && !flags.contains((Object)QueryBuilderProperties.Visual)) {
                this.rbGeneralActionPerformed(null);
            }
        } else {
            this.lSqlBuilderOptions.setVisible(false);
            this.rbGeneral.setVisible(false);
            this.rbMainQuery.setVisible(false);
            this.rbDerivedQueries.setVisible(false);
            this.rbExpressionSubqeries.setVisible(false);
            if (builder == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, "Invalid SQLBuilder object!");
            }
        }
        this.getRootPane().setDefaultButton(this.bOk);
        AbstractAction escape = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryBuilderPropertiesDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "ESCAPE");
        this.rootPane.getActionMap().put("ESCAPE", escape);
    }

    private void switchPage(JPanel page) {
        this.pagesPanel.removeAll();
        this.pagesPanel.add(page);
        this.pagesPanel.repaint();
        page.revalidate();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.dialogResult;
    }

    public boolean isModified() {
        return this.sqlSyntaxPage != null && this.sqlSyntaxPage.isModified() || this.offlineModePage != null && this.offlineModePage.isModified() || this.panesVisibilityPage != null && this.panesVisibilityPage.isModified() || this.queryStructureTreePage != null && this.queryStructureTreePage.isModified() || this.metadataTreePage != null && this.metadataTreePage.isModified() || this.miscellaneousPage != null && this.miscellaneousPage.isModified() || this.generalPage != null && this.generalPage.isModified() || this.mainQueryPage != null && this.mainQueryPage.isModified() || this.derievedQueriesPage != null && this.derievedQueriesPage.isModified() || this.expressionSubqueriesPage != null && this.expressionSubqueriesPage.isModified();
    }

    public void setModified(boolean value) {
        if (this.sqlSyntaxPage != null) {
            this.sqlSyntaxPage.setModified(value);
        }
        if (this.offlineModePage != null) {
            this.offlineModePage.setModified(value);
        }
        if (this.panesVisibilityPage != null) {
            this.panesVisibilityPage.setModified(value);
        }
        if (this.queryStructureTreePage != null) {
            this.queryStructureTreePage.setModified(value);
        }
        if (this.metadataTreePage != null) {
            this.metadataTreePage.setModified(value);
        }
        if (this.miscellaneousPage != null) {
            this.miscellaneousPage.setModified(value);
        }
        if (this.generalPage != null) {
            this.generalPage.setModified(value);
        }
        if (this.mainQueryPage != null) {
            this.mainQueryPage.setModified(value);
        }
        if (this.derievedQueriesPage != null) {
            this.derievedQueriesPage.setModified(value);
        }
        if (this.expressionSubqueriesPage != null) {
            this.expressionSubqueriesPage.setModified(value);
        }
    }

    public void applyChanges() {
        if (this.sqlSyntaxPage != null) {
            this.sqlSyntaxPage.applyChanges();
        }
        if (this.offlineModePage != null) {
            this.offlineModePage.applyChanges();
        }
        if (this.panesVisibilityPage != null) {
            this.panesVisibilityPage.applyChanges();
        }
        if (this.queryStructureTreePage != null) {
            this.queryStructureTreePage.applyChanges();
        }
        if (this.metadataTreePage != null) {
            this.metadataTreePage.applyChanges();
        }
        if (this.miscellaneousPage != null) {
            this.miscellaneousPage.applyChanges();
        }
        if (this.generalPage != null) {
            this.generalPage.applyChanges();
        }
        if (this.mainQueryPage != null) {
            this.mainQueryPage.applyChanges();
        }
        if (this.derievedQueriesPage != null) {
            this.derievedQueriesPage.applyChanges();
        }
        if (this.expressionSubqueriesPage != null) {
            this.expressionSubqueriesPage.applyChanges();
        }
        this.setModified(false);
    }

    @Override
    public void modifiedEventOccurred(BasePropertyPanel.ModifiedEvent event) {
        this.bApply.setEnabled(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.bOk = new JButton();
        this.bCancel = new JButton();
        this.bApply = new JButton();
        this.jPanel1 = new JPanel();
        this.lNonVisualOptions = new JLabel();
        this.rbSqlSyntax = new JRadioButton();
        this.rbOfflineMode = new JRadioButton();
        this.lVisualOptions = new JLabel();
        this.rbPanesVisibility = new JRadioButton();
        this.rbQueryStructureTree = new JRadioButton();
        this.rbMetadataTree = new JRadioButton();
        this.rbMiscellaneous = new JRadioButton();
        this.lSqlBuilderOptions = new JLabel();
        this.rbGeneral = new JRadioButton();
        this.rbMainQuery = new JRadioButton();
        this.rbDerivedQueries = new JRadioButton();
        this.rbExpressionSubqeries = new JRadioButton();
        this.jScrollPane2 = new JScrollPane();
        this.pagesPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Active Query Builder Properties");
        this.setFont(new Font("Dialog", 0, 11));
        this.setModal(true);
        this.setName("QueryBuilderPropertiesDialog");
        this.bOk.setFont(this.bOk.getFont());
        this.bOk.setText("OK");
        this.bOk.setName("bOk");
        this.bOk.setPreferredSize(new Dimension(73, 23));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.bOkActionPerformed(evt);
            }
        });
        this.bCancel.setFont(this.bCancel.getFont());
        this.bCancel.setText("Cancel");
        this.bCancel.setName("bCancel");
        this.bCancel.setPreferredSize(new Dimension(73, 23));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.bCancelActionPerformed(evt);
            }
        });
        this.bApply.setFont(this.bApply.getFont());
        this.bApply.setText("Apply");
        this.bApply.setEnabled(false);
        this.bApply.setName("bApply");
        this.bApply.setPreferredSize(new Dimension(73, 23));
        this.bApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.bApplyActionPerformed(evt);
            }
        });
        this.jPanel1.setFont(this.jPanel1.getFont());
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 3));
        this.lNonVisualOptions.setFont(this.lNonVisualOptions.getFont().deriveFont(this.lNonVisualOptions.getFont().getStyle() | 1));
        this.lNonVisualOptions.setText("Non-visual Options");
        this.lNonVisualOptions.setName("lNonVisual");
        this.jPanel1.add(this.lNonVisualOptions);
        this.buttonGroup1.add(this.rbSqlSyntax);
        this.rbSqlSyntax.setFont(this.rbSqlSyntax.getFont());
        this.rbSqlSyntax.setSelected(true);
        this.rbSqlSyntax.setText("SQL Syntax");
        this.rbSqlSyntax.setMargin(new Insets(4, 10, 2, 2));
        this.rbSqlSyntax.setName("lSqlSyntax");
        this.rbSqlSyntax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbSqlSyntaxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbSqlSyntax);
        this.buttonGroup1.add(this.rbOfflineMode);
        this.rbOfflineMode.setFont(this.rbOfflineMode.getFont());
        this.rbOfflineMode.setText("Offline Mode");
        this.rbOfflineMode.setMargin(new Insets(2, 10, 6, 2));
        this.rbOfflineMode.setName("lOfflineMode");
        this.rbOfflineMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbOfflineModeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbOfflineMode);
        this.lVisualOptions.setFont(this.lVisualOptions.getFont().deriveFont(this.lVisualOptions.getFont().getStyle() | 1));
        this.lVisualOptions.setText("Visual Options");
        this.lVisualOptions.setName("lVisual");
        this.jPanel1.add(this.lVisualOptions);
        this.buttonGroup1.add(this.rbPanesVisibility);
        this.rbPanesVisibility.setFont(this.rbPanesVisibility.getFont());
        this.rbPanesVisibility.setText("Panes Visibility");
        this.rbPanesVisibility.setMargin(new Insets(4, 10, 2, 2));
        this.rbPanesVisibility.setName("lPanesVisibility");
        this.rbPanesVisibility.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbPanesVisibilityActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbPanesVisibility);
        this.buttonGroup1.add(this.rbQueryStructureTree);
        this.rbQueryStructureTree.setFont(this.rbQueryStructureTree.getFont());
        this.rbQueryStructureTree.setText("Query Structure Tree");
        this.rbQueryStructureTree.setMargin(new Insets(2, 10, 2, 2));
        this.rbQueryStructureTree.setName("lQueryStructureTree");
        this.rbQueryStructureTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbQueryStructureTreeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbQueryStructureTree);
        this.buttonGroup1.add(this.rbMetadataTree);
        this.rbMetadataTree.setFont(this.rbMetadataTree.getFont());
        this.rbMetadataTree.setText("Metadata Tree");
        this.rbMetadataTree.setMargin(new Insets(2, 10, 2, 2));
        this.rbMetadataTree.setName("lMetadataTree");
        this.rbMetadataTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbMetadataTreeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbMetadataTree);
        this.buttonGroup1.add(this.rbMiscellaneous);
        this.rbMiscellaneous.setFont(this.rbMiscellaneous.getFont());
        this.rbMiscellaneous.setText("Miscellaneous");
        this.rbMiscellaneous.setMargin(new Insets(2, 10, 6, 2));
        this.rbMiscellaneous.setName("lMiscellaneous");
        this.rbMiscellaneous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbMiscellaneousActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbMiscellaneous);
        this.lSqlBuilderOptions.setFont(this.lSqlBuilderOptions.getFont().deriveFont(this.lSqlBuilderOptions.getFont().getStyle() | 1));
        this.lSqlBuilderOptions.setText("SQL Builder Options");
        this.lSqlBuilderOptions.setName("lSqlBuilder");
        this.jPanel1.add(this.lSqlBuilderOptions);
        this.buttonGroup1.add(this.rbGeneral);
        this.rbGeneral.setFont(this.rbGeneral.getFont());
        this.rbGeneral.setText("General");
        this.rbGeneral.setMargin(new Insets(4, 10, 2, 2));
        this.rbGeneral.setName("lGeneral");
        this.rbGeneral.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbGeneralActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbGeneral);
        this.buttonGroup1.add(this.rbMainQuery);
        this.rbMainQuery.setFont(this.rbMainQuery.getFont());
        this.rbMainQuery.setText("Main Query");
        this.rbMainQuery.setMargin(new Insets(2, 10, 2, 2));
        this.rbMainQuery.setName("lMainQuery");
        this.rbMainQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbMainQueryActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbMainQuery);
        this.buttonGroup1.add(this.rbDerivedQueries);
        this.rbDerivedQueries.setFont(this.rbDerivedQueries.getFont());
        this.rbDerivedQueries.setText("Derived Queries");
        this.rbDerivedQueries.setMargin(new Insets(2, 10, 2, 2));
        this.rbDerivedQueries.setName("lDerivedQueries");
        this.rbDerivedQueries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbDerivedQueriesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbDerivedQueries);
        this.buttonGroup1.add(this.rbExpressionSubqeries);
        this.rbExpressionSubqeries.setFont(this.rbExpressionSubqeries.getFont());
        this.rbExpressionSubqeries.setText("Expression Subqeries");
        this.rbExpressionSubqeries.setMargin(new Insets(2, 10, 4, 2));
        this.rbExpressionSubqeries.setName("lExpressionSubqueries");
        this.rbExpressionSubqeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryBuilderPropertiesDialog.this.rbExpressionSubqeriesActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbExpressionSubqeries);
        this.jScrollPane2.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane2.setFont(this.jScrollPane2.getFont());
        this.pagesPanel.setFont(this.pagesPanel.getFont());
        this.pagesPanel.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView(this.pagesPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.bOk, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bCancel, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bApply, -2, 90, -2)).addComponent(this.jScrollPane2, -1, 457, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, 370, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 370, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bApply, -2, -1, -2).addComponent(this.bCancel, -2, -1, -2).addComponent(this.bOk, -2, -1, -2)).addContainerGap()));
        this.pack();
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.dialogResult = true;
        this.setVisible(false);
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.dialogResult = false;
        this.setVisible(false);
    }

    private void bApplyActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.bApply.setEnabled(false);
    }

    private void rbSqlSyntaxActionPerformed(ActionEvent evt) {
        this.switchPage(this.sqlSyntaxPage);
    }

    private void rbOfflineModeActionPerformed(ActionEvent evt) {
        this.switchPage(this.offlineModePage);
    }

    private void rbPanesVisibilityActionPerformed(ActionEvent evt) {
        this.switchPage(this.panesVisibilityPage);
    }

    private void rbQueryStructureTreeActionPerformed(ActionEvent evt) {
        this.switchPage(this.queryStructureTreePage);
    }

    private void rbMetadataTreeActionPerformed(ActionEvent evt) {
        this.switchPage(this.metadataTreePage);
    }

    private void rbMiscellaneousActionPerformed(ActionEvent evt) {
        this.switchPage(this.miscellaneousPage);
    }

    private void rbGeneralActionPerformed(ActionEvent evt) {
        this.switchPage(this.generalPage);
    }

    private void rbMainQueryActionPerformed(ActionEvent evt) {
        this.switchPage(this.mainQueryPage);
    }

    private void rbDerivedQueriesActionPerformed(ActionEvent evt) {
        this.switchPage(this.derievedQueriesPage);
    }

    private void rbExpressionSubqeriesActionPerformed(ActionEvent evt) {
        this.switchPage(this.expressionSubqueriesPage);
    }
}

