/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionOperator;
import com.adbs.utils.Helpers;
import java.util.List;
import javax.swing.JMenuItem;

public abstract class QueryBase
extends ControlOwner {
    private UnionGroup parentQuery;
    private SubQuery rootQuery = this.calcRootQuery();
    protected SQLSubQueryExpression astQueryBase;

    public QueryBase(ControlOwner owner, QueryBuilder queryBuilder) {
        super(owner, owner, queryBuilder);
    }

    public UnionGroup getParentQuery() {
        return this.parentQuery;
    }

    public void setParentQuery(UnionGroup value) {
        if (this.parentQuery != value) {
            if (this.parentQuery != null) {
                if (this.parentQuery.items != null) {
                    this.parentQuery.items.remove(this);
                }
                if (!this.parentQuery.isDisposing()) {
                    this.parentQuery.notifySQLUpdated();
                }
            }
            this.parentQuery = value;
            this.setUpdateParent(value);
            if (this.parentQuery != null) {
                this.parentQuery.items.add(this);
                this.parentQuery.notifySQLUpdated();
                if (this.rootQuery.getQueryPage() != null) {
                    this.rootQuery.getQueryPage().getUnionNavBar().reAlign();
                }
            }
            this.rootQuery.updateUnionSubQueriesOrder();
        }
    }

    public SubQuery getRootQuery() {
        return this.rootQuery;
    }

    abstract UnionOperator getUnionOperatorControl();

    @Override
    public void dispose() {
        this.setParentQuery(null);
        if (this.astQueryBase != null && this.astQueryBase.isAlive()) {
            this.astQueryBase.dispose();
        }
        super.dispose();
    }

    protected int insertBefore(QueryBase q) throws QueryBuilderException {
        int myindex;
        q.setParentQuery(this.parentQuery);
        int qindex = this.parentQuery.items.indexOf(q);
        int result = myindex = this.parentQuery.items.indexOf(this);
        Helpers.listMove(this.parentQuery.items, qindex, result);
        this.notifySQLUpdated();
        if (this.rootQuery.getQueryPage() != null) {
            this.rootQuery.getQueryPage().getUnionNavBar().reAlign();
        }
        return result;
    }

    protected int insertAfter(QueryBase q) throws QueryBuilderException {
        int fromSameList;
        if (q.getParentQuery() == this.parentQuery) {
            fromSameList = 0;
        } else {
            fromSameList = 1;
            q.setParentQuery(this.parentQuery);
        }
        int myindex = this.parentQuery.items.indexOf(this);
        int qindex = this.parentQuery.items.indexOf(q);
        int result = myindex + fromSameList;
        Helpers.listMove(this.parentQuery.items, qindex, result);
        this.notifySQLUpdated();
        if (this.rootQuery.getQueryPage() != null) {
            this.rootQuery.getQueryPage().getUnionNavBar().reAlign();
        }
        return result;
    }

    protected void updateUnionOperator() {
        UnionOperator uo = this.getUnionOperatorControl();
        if (uo == null) {
            return;
        }
        uo.setVisible(this.astQueryBase != null && this.parentQuery != null && this.parentQuery.items.indexOf(this) > 0);
        if (uo.isVisible()) {
            uo.setUnionOperator(this.astQueryBase.getUnionOperator());
            uo.setAll(this.astQueryBase.isAll());
        }
    }

    @Override
    protected void getASTChildren(List l) {
        super.getASTChildren(l);
        if (this.astQueryBase != null) {
            l.add(this.astQueryBase);
        }
    }

    protected void setUnionOperatorByMenuItem(Object source) {
        this.setUnionOperatorFull(((JMenuItem)source).getText());
    }

    private SubQuery calcRootQuery() {
        if (this instanceof SubQuery) {
            return (SubQuery)this;
        }
        if (this.getOwner() instanceof QueryBase) {
            return ((QueryBase)this.getOwner()).getRootQuery();
        }
        return null;
    }

    public void loadFromAST(SQLSubQueryExpression astQuery) {
        if (this.astQueryBase != null) {
            this.astQueryBase.dispose();
        }
        this.astQueryBase = astQuery;
        if (this.isControlsCreated()) {
            this.updateUnionOperator();
        }
    }

    public String getUnionOperator() {
        return this.astQueryBase.getUnionOperator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnionOperator(String value) {
        if (value.compareToIgnoreCase(this.getUnionOperator()) != 0) {
            boolean all;
            String cAll = " ALL";
            String newUnionOperator = value;
            boolean bl = all = newUnionOperator.toUpperCase().indexOf(cAll.toUpperCase()) != -1;
            if (all) {
                newUnionOperator = newUnionOperator.substring(0, newUnionOperator.length() - cAll.length());
            }
            this.beginUpdate();
            try {
                this.astQueryBase.setUnionOperator(newUnionOperator);
                this.notifySQLUpdated();
                if (this.isControlsCreated()) {
                    this.getUnionOperatorControl().setUnionOperator(this.astQueryBase.getUnionOperator());
                    this.getUnionOperatorControl().setAll(this.astQueryBase.isAll());
                }
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public boolean isUnionAllFlag() {
        return this.astQueryBase.isAll();
    }

    public void setUnionAllFlag(boolean value) {
        this.beginUpdate();
        try {
            this.astQueryBase.setAll(value);
            this.notifySQLUpdated();
            if (this.isControlsCreated()) {
                this.getUnionOperatorControl().setAll(this.astQueryBase.isAll());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public String getUnionOperatorFull() {
        return this.astQueryBase.getSimpleUnionOperator(this.sqlContext.getSQLBuilderExpression());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnionOperatorFull(String value) {
        String cAll = " ALL";
        if (this.getUnionOperatorFull().compareToIgnoreCase(value) != 0) {
            boolean newUnionAllFlag;
            String newUnionOperator = value;
            boolean bl = newUnionAllFlag = newUnionOperator.toUpperCase().indexOf(cAll.toUpperCase()) != -1;
            if (newUnionAllFlag) {
                newUnionOperator = newUnionOperator.substring(0, newUnionOperator.length() - cAll.length());
            }
            this.beginUpdate();
            try {
                this.setUnionOperator(newUnionOperator);
                this.setUnionAllFlag(newUnionAllFlag);
            }
            finally {
                this.endUpdate();
            }
        }
    }
}

