/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.MetadataTreeOptions;
import com.adbs.querybuilder.ObjectsGroupingType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

class MetadataTreePage
extends BasePropertyPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private QueryBuilder queryBuilder = null;
    private JCheckBox cbShowSystemProcs;
    private JCheckBox cbShowSystemSynonyms;
    private JCheckBox cbShowSystemTables;
    private JCheckBox cbShowSystemViews;
    private JCheckBox cbShowUserProcs;
    private JCheckBox cbShowUserSynonyms;
    private JCheckBox cbShowUserTables;
    private JCheckBox cbShowUserViews;
    private JComboBox comboGroupObjectBy;
    private JPanel groupLabel2;
    private JPanel groupLabel3;
    private JPanel grpUserObjects;
    private JLabel label11;

    public MetadataTreePage(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.initComponents();
        Helpers.localizer.localizePanel(this);
        MetadataTreeOptions o = queryBuilder.getMetadataTreeOptions();
        this.cbShowUserTables.setSelected(o.isShowUserTables());
        this.cbShowUserViews.setSelected(o.isShowUserViews());
        this.cbShowUserProcs.setSelected(o.isShowUserProcedures());
        this.cbShowUserSynonyms.setSelected(o.isShowUserSynonyms());
        this.cbShowSystemTables.setSelected(o.isShowSystemTables());
        this.cbShowSystemViews.setSelected(o.isShowSystemViews());
        this.cbShowSystemProcs.setSelected(o.isShowSystemProcedures());
        this.cbShowSystemSynonyms.setSelected(o.isShowSystemSynonyms());
        this.comboGroupObjectBy.setSelectedIndex(o.getGroupingType().ordinal());
        this.cbShowSystemTables.addActionListener(this);
        this.cbShowSystemViews.addActionListener(this);
        this.cbShowSystemProcs.addActionListener(this);
        this.cbShowSystemSynonyms.addActionListener(this);
        this.cbShowUserTables.addActionListener(this);
        this.cbShowUserViews.addActionListener(this);
        this.cbShowUserProcs.addActionListener(this);
        this.cbShowUserSynonyms.addActionListener(this);
        this.comboGroupObjectBy.addActionListener(this);
    }

    @Override
    public void applyChanges() {
        if (this.isModified()) {
            this.queryBuilder.beginUpdate();
            try {
                MetadataTreeOptions o = this.queryBuilder.getMetadataTreeOptions();
                o.setShowUserTables(this.cbShowUserTables.isSelected());
                o.setShowUserViews(this.cbShowUserViews.isSelected());
                o.setShowUserProcedures(this.cbShowUserProcs.isSelected());
                o.setShowUserSynonyms(this.cbShowUserSynonyms.isSelected());
                o.setShowSystemTables(this.cbShowSystemTables.isSelected());
                o.setShowSystemViews(this.cbShowSystemViews.isSelected());
                o.setShowSystemProcedures(this.cbShowSystemProcs.isSelected());
                o.setShowSystemSynonyms(this.cbShowSystemSynonyms.isSelected());
                o.setGroupingType(ObjectsGroupingType.values()[this.comboGroupObjectBy.getSelectedIndex()]);
            }
            finally {
                this.queryBuilder.endUpdate();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setModified(true);
    }

    private void initComponents() {
        this.grpUserObjects = new JPanel();
        this.cbShowUserViews = new JCheckBox();
        this.cbShowUserProcs = new JCheckBox();
        this.cbShowUserTables = new JCheckBox();
        this.cbShowUserSynonyms = new JCheckBox();
        this.groupLabel2 = new JPanel();
        this.cbShowSystemViews = new JCheckBox();
        this.cbShowSystemSynonyms = new JCheckBox();
        this.cbShowSystemTables = new JCheckBox();
        this.cbShowSystemProcs = new JCheckBox();
        this.groupLabel3 = new JPanel();
        this.label11 = new JLabel();
        this.comboGroupObjectBy = new JComboBox();
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Dialog", 0, 11));
        this.setName("MetadataTreePage");
        this.grpUserObjects.setBorder(BorderFactory.createTitledBorder(null, "User Objects", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.grpUserObjects.setFont(this.grpUserObjects.getFont());
        this.grpUserObjects.setName("grpUserObjects");
        this.grpUserObjects.setOpaque(false);
        this.cbShowUserViews.setFont(this.cbShowUserViews.getFont());
        this.cbShowUserViews.setText("Show user views");
        this.cbShowUserViews.setName("cbShowUserViews");
        this.cbShowUserViews.setOpaque(false);
        this.cbShowUserProcs.setFont(this.cbShowUserProcs.getFont());
        this.cbShowUserProcs.setText("Show user procedures");
        this.cbShowUserProcs.setName("cbShowUserProcs");
        this.cbShowUserProcs.setOpaque(false);
        this.cbShowUserTables.setFont(this.cbShowUserTables.getFont());
        this.cbShowUserTables.setText("Show user tables");
        this.cbShowUserTables.setName("cbShowUserTables");
        this.cbShowUserTables.setOpaque(false);
        this.cbShowUserSynonyms.setFont(this.cbShowUserSynonyms.getFont());
        this.cbShowUserSynonyms.setText("Show user synonyms");
        this.cbShowUserSynonyms.setName("cbShowUserSynonyms");
        this.cbShowUserSynonyms.setOpaque(false);
        GroupLayout grpUserObjectsLayout = new GroupLayout(this.grpUserObjects);
        this.grpUserObjects.setLayout(grpUserObjectsLayout);
        grpUserObjectsLayout.setHorizontalGroup(grpUserObjectsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpUserObjectsLayout.createSequentialGroup().addContainerGap().addGroup(grpUserObjectsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowUserTables).addComponent(this.cbShowUserViews).addComponent(this.cbShowUserProcs).addComponent(this.cbShowUserSynonyms)).addContainerGap(229, Short.MAX_VALUE)));
        grpUserObjectsLayout.setVerticalGroup(grpUserObjectsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(grpUserObjectsLayout.createSequentialGroup().addComponent(this.cbShowUserTables).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowUserViews).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowUserProcs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowUserSynonyms)));
        this.groupLabel2.setBorder(BorderFactory.createTitledBorder(null, "System Objects", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel2.setFont(this.groupLabel2.getFont());
        this.groupLabel2.setName("grpSystemObjects");
        this.groupLabel2.setOpaque(false);
        this.cbShowSystemViews.setFont(this.cbShowSystemViews.getFont());
        this.cbShowSystemViews.setText("Show system views");
        this.cbShowSystemViews.setName("cbShowSystemViews");
        this.cbShowSystemViews.setOpaque(false);
        this.cbShowSystemSynonyms.setFont(this.cbShowSystemSynonyms.getFont());
        this.cbShowSystemSynonyms.setText("Show system synonyms");
        this.cbShowSystemSynonyms.setName("cbShowSystemSynonyms");
        this.cbShowSystemSynonyms.setOpaque(false);
        this.cbShowSystemTables.setFont(this.cbShowSystemTables.getFont());
        this.cbShowSystemTables.setText("Show system tables");
        this.cbShowSystemTables.setName("cbShowSystemTables");
        this.cbShowSystemTables.setOpaque(false);
        this.cbShowSystemProcs.setFont(this.cbShowSystemProcs.getFont());
        this.cbShowSystemProcs.setText("Show system procedures");
        this.cbShowSystemProcs.setName("cbShowSystemProcs");
        this.cbShowSystemProcs.setOpaque(false);
        GroupLayout groupLabel2Layout = new GroupLayout(this.groupLabel2);
        this.groupLabel2.setLayout(groupLabel2Layout);
        groupLabel2Layout.setHorizontalGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel2Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowSystemSynonyms).addComponent(this.cbShowSystemProcs).addComponent(this.cbShowSystemViews).addComponent(this.cbShowSystemTables)).addContainerGap(217, Short.MAX_VALUE)));
        groupLabel2Layout.setVerticalGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel2Layout.createSequentialGroup().addComponent(this.cbShowSystemTables).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowSystemViews).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowSystemProcs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowSystemSynonyms)));
        this.groupLabel3.setBorder(BorderFactory.createTitledBorder(null, "Grouping", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel3.setFont(this.groupLabel3.getFont());
        this.groupLabel3.setName("grpGrouping");
        this.groupLabel3.setOpaque(false);
        this.label11.setFont(this.label11.getFont());
        this.label11.setText("Group objects by");
        this.label11.setName("label11");
        this.comboGroupObjectBy.setFont(this.comboGroupObjectBy.getFont());
        this.comboGroupObjectBy.setModel(new DefaultComboBoxModel<String>(new String[]{"No grouping", "Group by Database", "Group by Object Type", "Group by Database, Schema", "Group by Database, Object Type", "Group by Object Type, Database", "Group by Database, Schema, Object Type", "Group by Database, Object Type, Schema", "Group by Object Type, Database, Schema"}));
        GroupLayout groupLabel3Layout = new GroupLayout(this.groupLabel3);
        this.groupLabel3.setLayout(groupLabel3Layout);
        groupLabel3Layout.setHorizontalGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel3Layout.createSequentialGroup().addContainerGap().addComponent(this.label11).addGap(18, 18, 18).addComponent(this.comboGroupObjectBy, -2, 230, -2).addContainerGap(28, Short.MAX_VALUE)));
        groupLabel3Layout.setVerticalGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel3Layout.createSequentialGroup().addGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label11).addComponent(this.comboGroupObjectBy, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupLabel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.grpUserObjects, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.grpUserObjects, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

