/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class MetadataPathSolver {
    MetadataPathSolver() {
    }

    private static GraphEdges loadEdges(MetadataContainer metadataContainer) {
        GraphEdges result = new GraphEdges();
        for (int i1 = 0; i1 < metadataContainer.getCount(); ++i1) {
            MetadataObject mo1 = metadataContainer.get(i1);
            for (int j = 0; j < mo1.getRelations().getCount(); ++j) {
                MetadataRelation r = mo1.getRelations().get(j);
                MetadataObject mo2 = metadataContainer.findObjectByName(r.getChildName(), r.getChildSchema(), r.getChildDatabase());
                if (mo2 == null) continue;
                int i2 = metadataContainer.indexOf(mo2);
                result.setEdgeExists(i1, i2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List findShortestPath(MetadataContainer metadataContainer, List sources, MetadataObject destination) {
        int infinity = Integer.MAX_VALUE;
        int undefined = -1;
        ArrayList<MetadataObject> result = null;
        assert (metadataContainer != null);
        int srcIndex = metadataContainer.indexOf(destination);
        assert (srcIndex != -1);
        int[] distance = new int[metadataContainer.getCount()];
        int[] previous = new int[metadataContainer.getCount()];
        for (int i = 0; i < metadataContainer.getCount(); ++i) {
            distance[i] = Integer.MAX_VALUE;
            previous[i] = -1;
        }
        distance[srcIndex] = 0;
        GraphEdges ge = MetadataPathSolver.loadEdges(metadataContainer);
        try {
            int i;
            int index;
            int minIndex;
            List<Integer> nodesToProcess = ge.getNodesWithNeigbors();
            while (nodesToProcess.size() > 0) {
                minIndex = nodesToProcess.get(0);
                for (int i2 = 1; i2 < nodesToProcess.size(); ++i2) {
                    index = nodesToProcess.get(i2);
                    if (distance[minIndex] <= distance[index]) continue;
                    minIndex = index;
                }
                if (distance[minIndex] == Integer.MAX_VALUE) break;
                nodesToProcess.remove(minIndex);
                List<Integer> neighbors = ge.GetNeighbors(minIndex);
                for (i = 0; i < neighbors.size(); ++i) {
                    int alt;
                    int neighborIndex = neighbors.get(i);
                    if (!nodesToProcess.contains(neighborIndex) || (alt = distance[minIndex] + 1) >= distance[neighborIndex]) continue;
                    distance[neighborIndex] = alt;
                    previous[neighborIndex] = minIndex;
                }
            }
            int minDist = Integer.MAX_VALUE;
            minIndex = -1;
            for (i = 0; i < sources.size(); ++i) {
                int index2 = metadataContainer.indexOf((MetadataObject)sources.get(i));
                if (minDist <= distance[index2]) continue;
                minDist = distance[index2];
                minIndex = index2;
            }
            if (minIndex != -1) {
                result = new ArrayList<MetadataObject>();
                index = minIndex;
                while (index != -1) {
                    result.add(metadataContainer.get(index));
                    index = previous[index];
                }
            } else {
                result = null;
            }
        }
        finally {
            ge.dispose();
        }
        return result;
    }

    static class GraphEdges
    implements Disposable {
        private HashMap<Integer, List<Integer>> _map = new HashMap();

        public HashMap<Integer, List<Integer>> getMap() {
            return this._map;
        }

        public List<Integer> getNodesWithNeigbors() {
            return new ArrayList<Integer>(this._map.keySet());
        }

        @Override
        public void dispose() {
            this._map.clear();
            this._map = null;
        }

        private void setEdgeExistsInternal(int left, int right) {
            List<Integer> l = this._map.get(left);
            if (l == null) {
                l = new ArrayList<Integer>();
                this._map.put(left, l);
            }
            l.add(right);
        }

        public void setEdgeExists(int left, int right) {
            this.setEdgeExistsInternal(left, right);
            this.setEdgeExistsInternal(right, left);
        }

        public boolean isEdgeExists(int left, int right) {
            List<Integer> l = this._map.get(left);
            if (l != null) {
                return l.contains(right);
            }
            return false;
        }

        public List<Integer> GetNeighbors(int node) {
            return this._map.get(node);
        }
    }
}

