/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkConnectToSide;
import com.adbs.querybuilder.LinkPainter;
import com.adbs.querybuilder.LinkPainterFriendlyName;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

@LinkPainterFriendlyName(value="Simple")
public class LinkPainterSimple
extends LinkPainter {
    private Color linkLinesColor = Color.BLACK;
    private Color linkShapesColor = Color.WHITE;

    public LinkPainterSimple(QueryBuilder queryBuilder) {
        super(queryBuilder);
    }

    public Color getLinkColor() {
        return this.linkLinesColor;
    }

    public void setLinkColor(Color value) {
        if (this.linkLinesColor != value) {
            this.linkLinesColor = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    public Color getShapesColor() {
        return this.linkShapesColor;
    }

    public void setLinkShapesColor(Color value) {
        if (this.linkShapesColor != value) {
            this.linkShapesColor = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    protected void paintEndMark(Graphics g, int startX, int startY, int endX, int endY, LinkConnectToSide side, LinkSideType linkType) {
        int factor = side == LinkConnectToSide.Left ? -1 : 1;
        if (linkType == LinkSideType.Inner) {
            if (factor == -1) {
                startX -= 6;
            }
            g.setColor(this.linkShapesColor);
            g.fillOval(startX, startY - 3, 6, 6);
            g.setColor(this.linkLinesColor);
            g.drawOval(startX, startY - 3, 6, 6);
        } else {
            int[] xx = new int[3];
            int[] yy = new int[3];
            xx[0] = startX;
            yy[0] = startY;
            xx[1] = startX + 4 * factor;
            yy[1] = startY - 5;
            xx[2] = xx[1];
            yy[2] = yy[1] + 9;
            g.setColor(this.linkShapesColor);
            g.fillPolygon(xx, yy, 3);
            g.setColor(this.linkLinesColor);
            g.drawPolygon(xx, yy, 3);
        }
    }

    @Override
    public void paintLink(Graphics g, int[] xPoints, int[] yPoints, boolean focused, LinkConnectToSide firstSide, LinkConnectToSide secondSide, Link link) {
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        if (!focused) {
            this.drawLine(g, xPoints, yPoints, this.linkLinesColor, 0, 1);
        } else {
            this.drawLine(g, xPoints, yPoints, this.linkLinesColor, 0, 2);
        }
        this.paintEndMark(g, xPoints[0], yPoints[0], xPoints[1], yPoints[1], firstSide, link.getLeftType());
        this.paintEndMark(g, xPoints[3], yPoints[3], xPoints[2], yPoints[2], secondSide, link.getRightType());
        ((Graphics2D)g).setStroke(oldStroke);
    }
}

