/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.Disposable;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DiagramPane;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkChangedEvent;
import com.adbs.querybuilder.LinkChangingEvent;
import com.adbs.querybuilder.LinkConnectToSide;
import com.adbs.querybuilder.LinkManipulations;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.utils.Helpers;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class LinkControl
extends JComponent
implements Disposable,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DiagramPane diagramPane;
    private Link link;
    private LinkConnectToSide firstSide;
    private LinkConnectToSide secondSide;
    private Point[] line = new Point[]{new Point(), new Point(), new Point(), new Point()};
    private static int LINK_NUM = 0;

    @Override
    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public LinkControl(Link link) {
        this.link = link;
        this.setMaximumSize(new Dimension(0, 0));
        this.setLocation(0, 0);
        this.setSize(0, 0);
        this.setFocusable(true);
        this.setNamesForQA();
        this.setVisible(true);
    }

    private void setNamesForQA() {
        String name = null;
        name = null == this.link.getLeftField() || null == this.link.getRightField() ? "Link" + LINK_NUM++ : this.link.getLeftField().getQualifiedName() + "-" + this.link.getRightField().getQualifiedName();
        this.setName(name);
        this.setSize(1, 1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            private void showPopup(MouseEvent e) {
                LinkControl.this.getPopupMenu().show(LinkControl.this, e.getX(), e.getY());
            }
        });
    }

    private void setPositionForQA() {
        this.setLocation(this.line[1].x, this.line[1].y);
    }

    DiagramPane getDiagramPane() {
        return this.diagramPane;
    }

    void setDiagramPane(DiagramPane value) {
        this.diagramPane = value;
    }

    public LinkConnectToSide getFirstSide() {
        return this.firstSide;
    }

    public LinkConnectToSide getSecondSide() {
        return this.secondSide;
    }

    public Link getLink() {
        return this.link;
    }

    protected Rectangle calcEnterLine(Rectangle r, LinkConnectToSide side, LinkSideType linkType) {
        Rectangle result = new Rectangle();
        result.y = (r.y + r.y + r.height) / 2;
        result.height = 0;
        if (side == LinkConnectToSide.Left) {
            result.x = r.x;
            result.width = -16;
        } else {
            result.x = r.x + r.width;
            result.width = 16;
        }
        return result;
    }

    protected void calcLinkPoints(Rectangle firstRect, Rectangle secondRect) {
        Graphics g = this.getDiagramPane().getGraphics();
        Rectangle p1 = this.calcEnterLine(firstRect, this.firstSide, this.link.getLeftType());
        Rectangle p2 = this.calcEnterLine(secondRect, this.secondSide, this.link.getRightType());
        this.line[0].x = p1.x;
        this.line[0].y = p1.y;
        this.line[1].x = p1.x + p1.width;
        this.line[1].y = p1.y + p1.height;
        this.line[2].x = p2.x + p2.width;
        this.line[2].y = p2.y + p2.height;
        this.line[3].x = p2.x;
        this.line[3].y = p2.y;
        this.setPositionForQA();
        g.dispose();
    }

    JPopupMenu getPopupMenu() {
        QueryBuilder qb = this.link.getQueryBuilder();
        if (qb.getLinkOptions().getLinkManipulations() != LinkManipulations.Deny) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem item = new JMenuItem(Helpers.localizer.getString("strRemove", "Remove"));
            item.setActionCommand("remove");
            item.addActionListener(this.link);
            menu.add(item);
            menu.addSeparator();
            if (this.link.getQueryBuilder().getLinkOptions().getLinkManipulations() != LinkManipulations.Deny && (this.link.getPlace() == LinkPlace.From || this.link.getPlace() == LinkPlace.Where && (this.link.getSQLContext().getSyntaxProvider().isSupportOracleJoins() || this.link.getSQLContext().getSyntaxProvider().isSupportTransactSQLJoins()))) {
                String tmpl = Helpers.localizer.getString("strSelectAllRowsFrom", "Select all rows from %1$s");
                item = new JCheckBoxMenuItem(String.format(tmpl, this.link.getLeftDatasource().getCaption()));
                item.setActionCommand("select all rows from left");
                item.setSelected(this.link.getLeftType() == LinkSideType.Outer);
                item.addActionListener(this);
                menu.add(item);
                item = new JCheckBoxMenuItem(String.format(tmpl, this.link.getRightDatasource().getCaption()));
                item.setActionCommand("select all rows from right");
                item.setSelected(this.link.getRightType() == LinkSideType.Outer);
                item.addActionListener(this);
                menu.add(item);
                menu.addSeparator();
            }
            item = new JMenuItem(Helpers.localizer.getString("strEdit", "Properties"));
            item.setActionCommand("edit");
            item.addActionListener(this.link);
            item.setFont(item.getFont().deriveFont(1));
            menu.add(item);
            return menu;
        }
        return null;
    }

    void alignLink() {
        int newHeight;
        int newWidth;
        int newTop;
        int newLeft;
        LinkControl l = this;
        Link linkObject = l.getLink();
        DataSource second = linkObject.getRightDatasource();
        if (second == null || !second.isControlsCreated()) {
            return;
        }
        DataSource first = linkObject.getLeftDatasource();
        if (first == null || !first.isControlsCreated()) {
            return;
        }
        Rectangle fr = first.calcFieldRect(linkObject.getLeftField());
        Rectangle r1 = SwingUtilities.convertRectangle(null, SwingUtilities.convertRectangle(first.getDSControl(), fr, null), this.diagramPane);
        Rectangle sr = second.calcFieldRect(linkObject.getRightField());
        Rectangle r2 = SwingUtilities.convertRectangle(null, SwingUtilities.convertRectangle(second.getDSControl(), sr, null), this.diagramPane);
        if (r1.x + r1.width < r2.x) {
            newLeft = r1.x + r1.width;
            newTop = Math.min(r1.y, r2.y);
            newWidth = r2.x - newLeft;
            newHeight = Math.max(r1.y + r1.height, r2.y + r2.height) - newTop;
            this.firstSide = LinkConnectToSide.Right;
            this.secondSide = LinkConnectToSide.Left;
        } else if (r2.x + r2.width < r1.x) {
            newLeft = r2.x + r2.width;
            newTop = Math.min(r1.y, r2.y);
            newWidth = r1.x - newLeft;
            newHeight = Math.max(r1.y + r1.height, r2.y + r2.height) - newTop;
            this.firstSide = LinkConnectToSide.Left;
            this.secondSide = LinkConnectToSide.Right;
        } else if (Math.abs(r1.x - r2.x) <= Math.abs(r1.x + r1.width - (r2.x + r2.width))) {
            newLeft = Math.min(r1.x, r2.x) - 16;
            newTop = Math.min(r1.y, r2.y);
            newWidth = Math.max(r1.x, r2.x) - newLeft;
            newHeight = Math.max(r1.y + r1.height, r2.y + r2.height) - newTop;
            this.firstSide = LinkConnectToSide.Left;
            this.secondSide = LinkConnectToSide.Left;
        } else {
            newLeft = Math.min(r1.x + r1.width, r2.x + r2.width) - 16;
            newTop = Math.min(r1.y, r2.y);
            newWidth = Math.max(r1.x + r1.width, r2.x + r2.width) - newLeft;
            newHeight = Math.max(r1.y + r1.height, r2.y + r2.height) - newTop;
            this.firstSide = LinkConnectToSide.Right;
            this.secondSide = LinkConnectToSide.Right;
        }
        if (newWidth < 16) {
            int newNewLeft = newLeft + newWidth - 16;
            int newNewRight = newLeft + 16;
            newLeft = newNewLeft;
            newWidth = newNewRight - newNewLeft;
        }
        int relEndsHeight = 20;
        newTop -= relEndsHeight;
        newLeft -= 2;
        newHeight += relEndsHeight * 2 + 1;
        newWidth += 4;
        l.calcLinkPoints(fr, sr);
    }

    public void reAlign() {
        this.invalidate();
    }

    public boolean hitTest(Point p) {
        Path2D.Float path = new Path2D.Float();
        ((Path2D)path).moveTo(this.line[0].x, this.line[0].y);
        ((Path2D)path).lineTo(this.line[1].x, this.line[1].y);
        ((Path2D)path).lineTo(this.line[2].x, this.line[2].y);
        ((Path2D)path).lineTo(this.line[3].x, this.line[3].y);
        return new BasicStroke(10.0f).createStrokedShape(path).contains(p);
    }

    public void paintLink(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DataSource rightDatasource = this.link.getRightDatasource();
        if (rightDatasource == null || !rightDatasource.isControlsCreated() || rightDatasource.getDSControl() == null || rightDatasource.getDSControl().isDisposing()) {
            return;
        }
        DataSource leftDatasource = this.link.getLeftDatasource();
        if (leftDatasource == null || !leftDatasource.isControlsCreated() || leftDatasource.getDSControl() == null || leftDatasource.getDSControl().isDisposing()) {
            return;
        }
        Rectangle r1 = leftDatasource.calcFieldRect(this.link.getLeftField());
        r1 = SwingUtilities.convertRectangle(null, SwingUtilities.convertRectangle(leftDatasource.getDSControl(), r1, null), this.diagramPane);
        Rectangle r2 = rightDatasource.calcFieldRect(this.link.getRightField());
        r2 = SwingUtilities.convertRectangle(null, SwingUtilities.convertRectangle(rightDatasource.getDSControl(), r2, null), this.diagramPane);
        this.calcLinkPoints(r1, r2);
        int[] xPoints = Helpers.getXPoints(this.line);
        int[] yPoints = Helpers.getYPoints(this.line);
        if (this.link.getQueryBuilder().getLinkStyle() != null) {
            this.link.getQueryBuilder().getLinkStyle().paintLink(g, xPoints, yPoints, this.diagramPane.getFocusedControl() == this, this.firstSide, this.secondSide, this.link);
        } else {
            Helpers.defaultLinkPainter.paintLink(g, xPoints, yPoints, this.diagramPane.getFocusedControl() == this, this.firstSide, this.secondSide, this.link);
        }
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("select all rows from left")) {
            LinkChangingEvent linkChangingEvent = new LinkChangingEvent(this.link.getQueryBuilder(), this.link);
            this.link.getQueryBuilder().fireLinkChangingEvent(linkChangingEvent);
            if (linkChangingEvent.abort) {
                return;
            }
            switch (this.link.getLeftType()) {
                case Outer: {
                    this.link.setLeftType(LinkSideType.Inner);
                    break;
                }
                case Inner: {
                    if (this.link.getPlace() == LinkPlace.Where || !this.link.getSQLContext().getSyntaxProvider().isSupportFullANSIJoin()) {
                        this.link.setRightType(LinkSideType.Inner);
                    }
                    this.link.setLeftType(LinkSideType.Outer);
                }
            }
            if (this.link.getDatasourceOwner() != null) {
                this.link.getDatasourceOwner().notifySQLUpdated();
            }
            LinkChangedEvent linkChangedEvent = new LinkChangedEvent(this.link.getQueryBuilder(), this.link);
            this.link.getQueryBuilder().fireLinkChangedEvent(linkChangedEvent);
        } else if (action.equals("select all rows from right")) {
            LinkChangingEvent linkChangingEvent = new LinkChangingEvent(this.link.getQueryBuilder(), this.link);
            this.link.getQueryBuilder().fireLinkChangingEvent(linkChangingEvent);
            if (linkChangingEvent.abort) {
                return;
            }
            switch (this.link.getRightType()) {
                case Outer: {
                    this.link.setRightType(LinkSideType.Inner);
                    break;
                }
                case Inner: {
                    if (this.link.getPlace() == LinkPlace.Where || !this.link.getSQLContext().getSyntaxProvider().isSupportFullANSIJoin()) {
                        this.link.setLeftType(LinkSideType.Inner);
                    }
                    this.link.setRightType(LinkSideType.Outer);
                }
            }
            if (this.link.getDatasourceOwner() != null) {
                this.link.getDatasourceOwner().notifySQLUpdated();
            }
            LinkChangedEvent linkChangedEvent = new LinkChangedEvent(this.link.getQueryBuilder(), this.link);
            this.link.getQueryBuilder().fireLinkChangedEvent(linkChangedEvent);
        }
    }
}

