/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.UpdatablePersistent;
import com.adbs.querybuilder.FieldListBaseColumnOptions;
import com.adbs.querybuilder.FieldListDescriptionColumnOptions;
import com.adbs.querybuilder.FieldListMarkColumnOptions;
import com.adbs.querybuilder.FieldListNameColumnOptions;
import com.adbs.querybuilder.FieldListSortType;
import com.adbs.querybuilder.FieldListTypeColumnOptions;
import com.adbs.querybuilder.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FieldListOptions
extends UpdatablePersistent {
    private QueryBuilder queryBuilder;
    private ArrayList<FieldListBaseColumnOptions> orderedColumnList = new ArrayList();
    private FieldListMarkColumnOptions markColumnOptions;
    private FieldListNameColumnOptions nameColumnOptions;
    private FieldListTypeColumnOptions typeColumnOptions;
    private FieldListDescriptionColumnOptions descriptionColumnOptions;
    private boolean hideAsteriskItem = false;
    private int defaultFieldListWidth = 140;
    private FieldListSortType sortType = FieldListSortType.None;
    private boolean keyFieldsFirst = true;

    public FieldListOptions(QueryBuilder queryBuilder) {
        super(null);
        this.queryBuilder = queryBuilder;
        this.beginUpdate();
        try {
            this.markColumnOptions = new FieldListMarkColumnOptions(this);
            this.nameColumnOptions = new FieldListNameColumnOptions(this);
            this.typeColumnOptions = new FieldListTypeColumnOptions(this);
            this.descriptionColumnOptions = new FieldListDescriptionColumnOptions(this);
        }
        finally {
            this.endUpdate();
        }
        this.updateOrderedColumnsList();
    }

    @Override
    public void dispose() {
        this.orderedColumnList.clear();
        this.markColumnOptions.dispose();
        this.nameColumnOptions.dispose();
        this.typeColumnOptions.dispose();
        this.descriptionColumnOptions.dispose();
        super.dispose();
    }

    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof FieldListOptions) {
                this.setMarkColumnOptions(((FieldListOptions)source).getMarkColumnOptions());
                this.setNameColumnOptions(((FieldListOptions)source).getNameColumnOptions());
                this.setTypeColumnOptions(((FieldListOptions)source).getTypeColumnOptions());
                this.setDescriptionColumnOptions(((FieldListOptions)source).getDescriptionColumnOptions());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public FieldListMarkColumnOptions getMarkColumnOptions() {
        return this.markColumnOptions;
    }

    public void setMarkColumnOptions(FieldListMarkColumnOptions options) {
        if (this.markColumnOptions != options) {
            this.markColumnOptions.assign(options);
        }
    }

    public FieldListNameColumnOptions getNameColumnOptions() {
        return this.nameColumnOptions;
    }

    public void setNameColumnOptions(FieldListNameColumnOptions options) {
        if (this.nameColumnOptions != options) {
            this.nameColumnOptions.assign(options);
        }
    }

    public FieldListTypeColumnOptions getTypeColumnOptions() {
        return this.typeColumnOptions;
    }

    public void setTypeColumnOptions(FieldListTypeColumnOptions options) {
        if (this.typeColumnOptions != options) {
            this.typeColumnOptions.assign(options);
        }
    }

    public FieldListDescriptionColumnOptions getDescriptionColumnOptions() {
        return this.descriptionColumnOptions;
    }

    public void setDescriptionColumnOptions(FieldListDescriptionColumnOptions options) {
        if (this.descriptionColumnOptions != options) {
            this.descriptionColumnOptions.assign(options);
        }
    }

    ArrayList<FieldListBaseColumnOptions> getOrderedColumnList() {
        return this.orderedColumnList;
    }

    public boolean isHideAsteriskItem() {
        return this.hideAsteriskItem;
    }

    public void setHideAsteriskItem(boolean value) {
        if (this.hideAsteriskItem != value) {
            this.hideAsteriskItem = value;
            this.notifyUpdated();
        }
    }

    public int getDefaultFieldListWidth() {
        return this.defaultFieldListWidth;
    }

    public void setDefaultFieldListWidth(int value) {
        this.defaultFieldListWidth = value;
    }

    @Override
    protected void doUpdated() {
        this.updateOrderedColumnsList();
        super.doUpdated();
    }

    private void updateOrderedColumnsList() {
        this.orderedColumnList.clear();
        this.orderedColumnList.add(this.markColumnOptions);
        this.orderedColumnList.add(this.nameColumnOptions);
        this.orderedColumnList.add(this.typeColumnOptions);
        this.orderedColumnList.add(this.descriptionColumnOptions);
        Collections.sort(this.orderedColumnList, new OrderedColumnsListComparator());
    }

    public FieldListSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(FieldListSortType sortType) {
        if (this.sortType != sortType) {
            this.sortType = sortType;
            this.notifyUpdated();
        }
    }

    public boolean isKeyFieldsFirst() {
        return this.keyFieldsFirst;
    }

    public void setKeyFieldsFirst(boolean keyFieldsFirst) {
        if (this.keyFieldsFirst != keyFieldsFirst) {
            this.keyFieldsFirst = keyFieldsFirst;
            this.notifyUpdated();
        }
    }

    private class OrderedColumnsListComparator
    implements Comparator<FieldListBaseColumnOptions> {
        private OrderedColumnsListComparator() {
        }

        @Override
        public int compare(FieldListBaseColumnOptions c1, FieldListBaseColumnOptions c2) {
            if (c1.getDrawOrder() < c2.getDrawOrder()) {
                return -1;
            }
            if (c1.getDrawOrder() > c2.getDrawOrder()) {
                return 1;
            }
            return 0;
        }
    }
}

