/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLExpressionAnd;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLogicalCollection;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLJoinKind;
import com.adbs.ast.SyntaxProviderChangedEvent;
import com.adbs.ast.SyntaxProviderChangedEventListener;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DataSourceBase
extends ControlOwner
implements SyntaxProviderChangedEventListener {
    private DatasourceGroup group;
    protected UnionSubQuery query;
    private SQLExpressionItem tmpJoin;
    protected SQLFromSource astFromSource;

    public DataSourceBase(ControlOwner owner, ControlOwner updateParent, QueryBuilder queryBuilder) {
        super(owner, updateParent, queryBuilder);
        assert (owner instanceof UnionSubQuery && owner == updateParent || owner instanceof DatasourceGroup && updateParent instanceof DatasourceGroup);
        if (owner instanceof UnionSubQuery) {
            assert (updateParent instanceof UnionSubQuery);
            this.query = (UnionSubQuery)owner;
            this.group = null;
        } else {
            try {
                this.setGroup((DatasourceGroup)updateParent);
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(DataSourceBase.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.query = this.group.getQuery();
        }
        this.getSQLContext().addSyntaxProviderChangedEventListener(this);
    }

    @Override
    public void dispose() {
        this.getSQLContext().removeSyntaxProviderChangedEventListener(this);
        this.group = null;
        if (this.astFromSource != null) {
            this.astFromSource.dispose();
        }
        this.astFromSource = null;
        super.dispose();
    }

    public DatasourceGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasourceGroup value) throws QueryBuilderException {
        if (this.group != value) {
            if (this.group != null) {
                this.group.unregisterDatasourceBase(this);
            }
            this.group = value;
            if (this.group != null) {
                this.group.registerDatasourceBase(this);
            }
            this.setUpdateParent(value);
        }
    }

    public UnionSubQuery getQuery() {
        return this.query;
    }

    protected String getDataSourceName() {
        return this.getResultSQL(this.getSQLContext().getSQLBuilderExpression());
    }

    public SQLJoinKind getJoinKind() {
        return this.astFromSource.joinKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJoinKind(SQLJoinKind value) {
        this.beginUpdate();
        try {
            this.setFromSourceJoinKind(value);
            if (this.group != null) {
                LinkSideType rt;
                LinkSideType lt;
                if (this.getJoinKind() != null) {
                    lt = this.getJoinKind().isLeftOuter() ? LinkSideType.Outer : LinkSideType.Inner;
                    rt = this.getJoinKind().isRightOuter() ? LinkSideType.Outer : LinkSideType.Inner;
                } else {
                    lt = LinkSideType.Inner;
                    rt = LinkSideType.Inner;
                }
                for (int i = 0; i < this.group.links.size(); ++i) {
                    Link l = this.group.links.get(i);
                    if ((l.getDatasourceOwner() != this || l.getPlace() != LinkPlace.From) && (l.getPlace() != LinkPlace.Where || !this.getSQLContext().getSyntaxProvider().isSupportOracleJoins() && !this.getSQLContext().getSyntaxProvider().isSupportTransactSQLJoins())) continue;
                    if (!l.isSimple() || l.datasourceOwner.containsDatasource(l.rightDatasource, true)) {
                        l.leftType = lt;
                        l.rightType = rt;
                        continue;
                    }
                    l.leftType = rt;
                    l.rightType = lt;
                }
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    void setFromSourceJoinKind(SQLJoinKind value) {
        if (this.astFromSource.joinKind != null) {
            this.astFromSource.joinKind.dispose();
        }
        this.astFromSource.joinKind = value;
    }

    public Class getJoinKindClass() {
        if (this.astFromSource.joinKind != null) {
            return this.astFromSource.joinKind.getClass();
        }
        return null;
    }

    public void setJoinKindClass(Class value) {
        if (this.getJoinKindClass() == null || this.getJoinKindClass() != value) {
            AstNodeBase newJoin = null;
            try {
                Constructor c = value.getConstructor(BaseSQLContext.class);
                newJoin = (SQLJoinKind)c.newInstance(this.getSQLContext());
            }
            catch (Exception ex) {
                Logger.getLogger(DataSourceBase.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (this.getJoinKind() != null) {
                newJoin.assign(this.getJoinKind());
            }
            this.setJoinKind((SQLJoinKind)newJoin);
        }
    }

    public SQLFromSource getFromSource() {
        return this.astFromSource;
    }

    @Override
    protected void getASTChildren(List l) {
        super.getASTChildren(l);
        if (this.astFromSource != null) {
            l.add(this.astFromSource);
        }
    }

    @Override
    protected AstNode createResultAST() {
        SQLFromSource result;
        if (this.astFromSource != null) {
            result = this.astFromSource.clone(this.getSQLContext());
            result.data = this;
            if (this.group != null && this.group.getLinkCount() > 0) {
                ArrayList<SQLExpressionItem> ll = new ArrayList<SQLExpressionItem>();
                for (int i = 0; i < this.group.getLinkCount(); ++i) {
                    Link l = this.group.links.get(i);
                    if (l.getPlace() != LinkPlace.From || l.getDatasourceOwner() != this || l.getLinkExpression() == null) continue;
                    ll.add(l.getLinkExpression());
                }
                if (ll.size() == 0) {
                    result.joinOn = null;
                } else if (ll.size() == 1) {
                    result.joinOn = ((SQLExpressionItem)ll.get(0)).clone(this.getSQLContext());
                } else {
                    SQLExpressionAnd joinOn = new SQLExpressionAnd(this.getSQLContext());
                    for (int i = 0; i < ll.size(); ++i) {
                        joinOn.add(((SQLExpressionItem)ll.get(i)).clone(this.getSQLContext()));
                    }
                    result.joinOn = Helpers.simplifyLogicalExpression(joinOn);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public void saveLayout(Document document, Element unionSubQuery, SQLBuilder sqlBuilder) {
    }

    public void loadLayout(Element unionSubQuery, SQLBuilder sqlBuilder) {
    }

    public boolean loadFromAST(SQLFromSource fs) {
        if (this.astFromSource != null) {
            this.astFromSource.dispose();
        }
        this.astFromSource = fs;
        this.astFromSource.data = this;
        this.tmpJoin = fs.joinOn;
        fs.joinOn = null;
        this.notifySQLUpdated();
        return this.astFromSource.joinKind != null;
    }

    private boolean loadExpressionItem(SQLExpressionItem e, List<Link> addedLinks) {
        boolean result = Link.canLoadExpressionAsSimpleLink(this, e);
        if (result) {
            Link l = new Link(this.getGroup(), this.getQueryBuilder());
            l.setLinkParamsInternal(this, e, LinkPlace.From, false);
            if (this.isControlsCreated() && l.canCreateControls()) {
                l.createControls();
            }
            addedLinks.add(l);
        }
        return result;
    }

    private SQLExpressionItem loadJoin(SQLExpressionItem e, List<Link> addedLinks) {
        SQLExpressionItem result = e;
        if ((e = Helpers.expressionRemoveBrackets(e)) instanceof SQLExpressionAnd) {
            int i = 0;
            while (i < ((SQLExpressionAnd)e).getCount()) {
                SQLExpressionItem ei = ((SQLExpressionAnd)e).get(i);
                if ((ei = Helpers.expressionRemoveBrackets(ei)) instanceof SQLExpressionAnd) {
                    ei = this.loadJoin(((SQLExpressionAnd)e).get(i), addedLinks);
                    if (ei == null) {
                        ((SQLExpressionAnd)e).extract(i);
                        continue;
                    }
                    ++i;
                    continue;
                }
                if (this.loadExpressionItem(((SQLExpressionAnd)e).get(i), addedLinks)) {
                    ((SQLExpressionAnd)e).extract(i);
                    continue;
                }
                ++i;
            }
            if (((SQLExpressionAnd)e).getCount() == 0) {
                result.dispose();
                result = null;
            }
        } else if (!(e instanceof SQLExpressionLogicalCollection) && this.loadExpressionItem(result, addedLinks)) {
            result = null;
        }
        return result;
    }

    public void loadJoins() {
        if (this.tmpJoin != null) {
            this.addLinksFromExpression(this.tmpJoin);
            this.tmpJoin = null;
        }
    }

    public void updateChecks() {
    }

    public void getDatasources(List list) {
    }

    public void getDatasourceByClass(Class datasourceClass, List list) {
        if (this.getClass() == datasourceClass || datasourceClass.isAssignableFrom(this.getClass())) {
            list.add(this);
        }
    }

    public boolean containsDatasource(DataSourceBase ds, boolean recursive) {
        return this == ds;
    }

    private void realignLinksFromGroup(DatasourceGroup grp) {
        int i;
        for (i = 0; i < grp.getLinkCount(); ++i) {
            Link l = grp.links.get(i);
            if (l.getLinkControl() == null || l.getLeftDatasource() != this && l.getRightDatasource() != this) continue;
            l.getLinkControl().reAlign();
            l.getLinkControl().invalidate();
        }
        for (i = 0; i < grp.getCount(); ++i) {
            DataSourceBase ds = grp.get(i);
            if (!(ds instanceof DatasourceGroup)) continue;
            this.realignLinksFromGroup((DatasourceGroup)ds);
        }
    }

    public void realignLinks() {
        this.realignLinksFromGroup(this.query.getFromClause());
    }

    public void invalidateLinks() {
        if (this.group != null) {
            for (int i = 0; i < this.group.getLinkCount(); ++i) {
                Link l = this.group.links.get(i);
                if (l.getLinkControl() == null || l.getLeftDatasource() != this && l.getRightDatasource() != this) continue;
                l.getLinkControl().invalidate();
            }
        }
    }

    @Override
    public void syntaxProviderChangedEventOccurred(SyntaxProviderChangedEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List addLinksFromExpression(SQLExpressionItem expression) {
        assert (expression != null);
        if (this.group.indexOf(this) == 0) {
            throw new QueryBuilderException("Links cannot be added to the first datasource of the group.");
        }
        ArrayList<Link> result = new ArrayList<Link>();
        this.group.beginUpdate();
        try {
            SQLExpressionItem expr = this.loadJoin(expression, result);
            if (expr != null) {
                Link l = new Link(this.group, this.queryBuilder);
                l.setLinkParamsInternal(this, expr, LinkPlace.From, false);
                if (this.isControlsCreated() && l.canCreateControls()) {
                    l.createControls();
                }
                result.add(l);
            }
        }
        finally {
            this.group.endUpdate();
        }
        return result;
    }
}

