/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryTabSheet;
import com.adbs.utils.Helpers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class CustomTabbedPane
extends JTabbedPane
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private QueryBuilder queryBuilder;
    private boolean tabsVisible = true;
    boolean suspendSelectionResponse = false;

    public CustomTabbedPane() {
        this.addChangeListener(this);
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.suspendSelectionResponse && this.queryBuilder != null && this.getSelectedIndex() != -1) {
            this.queryBuilder.setActiveSubquery(((QueryTabSheet)this.getSelectedComponent()).getQuery());
        }
    }

    public boolean isTabsVisible() {
        return this.tabsVisible;
    }

    public void setTabsVisible(boolean tabsVisible) {
        this.tabsVisible = tabsVisible;
        if (!tabsVisible) {
            this.setUI(new BasicTabbedPaneUI(){

                @Override
                public void installUI(JComponent c) {
                    super.installUI(c);
                    this.uninstallListeners();
                }

                @Override
                protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
                    return 0;
                }

                @Override
                protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                }
            });
        } else {
            this.setUI(UIManager.getUI(this));
        }
        this.invalidate();
    }

    void setPageIndex(Component page, int index) {
        int x = this.indexOfComponent(page);
        if (x != index) {
            this.suspendSelectionResponse = true;
            String caption = ((QueryTabSheet)page).getQuery().getCaption();
            this.insertTab(caption, null, page, "", index);
            this.suspendSelectionResponse = false;
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        Component tabComponent = this.getTabComponentAt(index);
        if (tabComponent != null) {
            TitlePanel titlePanel = (TitlePanel)tabComponent;
            titlePanel.titleLabel.setText(title);
            titlePanel.titleButton.setName(title + ".Close");
        }
    }

    void makeTabWithButtonAt(int index, ActionListener buttonActionListener) {
        TitlePanel titlePanel = new TitlePanel(buttonActionListener);
        this.setTabComponentAt(index, titlePanel);
    }

    private class TitlePanel
    extends JPanel {
        JLabel titleLabel;
        JButton titleButton;

        public TitlePanel(ActionListener buttonActionListener) {
            this.setOpaque(false);
            BorderLayout layout = new BorderLayout();
            layout.setHgap(5);
            this.setLayout(layout);
            this.titleLabel = new JLabel();
            this.add(this.titleLabel);
            this.titleButton = new JButton();
            this.titleButton.setBorder(BorderFactory.createEmptyBorder());
            this.titleButton.setContentAreaFilled(false);
            this.titleButton.setFocusable(false);
            this.titleButton.setIcon(Helpers.createImageIcon("images/close.png"));
            this.titleButton.setPressedIcon(Helpers.createImageIcon("images/close_pressed.png"));
            this.titleButton.setRolloverIcon(Helpers.createImageIcon("images/close_rollover.png"));
            this.titleButton.setPreferredSize(new Dimension(17, 17));
            this.titleButton.addActionListener(buttonActionListener);
            this.add((Component)this.titleButton, "East");
        }
    }
}

