/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstIdentifierList;
import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataQualifiedNameList;
import com.adbs.ast.SQLAggregateParamPrefix;
import com.adbs.ast.SQLAliasExpression;
import com.adbs.ast.SQLAliasExpressionAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLExpressionAggregate;
import com.adbs.ast.SQLExpressionAnd;
import com.adbs.ast.SQLExpressionBrackets;
import com.adbs.ast.SQLExpressionColumn;
import com.adbs.ast.SQLExpressionConstant;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLikeTemplate;
import com.adbs.ast.SQLExpressionList;
import com.adbs.ast.SQLExpressionLogicalCollection;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLExpressionSelect;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLOrderByItem;
import com.adbs.ast.SQLOrderByNullOrdering;
import com.adbs.ast.SQLOrderByOrders;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemAllColumns;
import com.adbs.ast.SQLSelectItemAllTableColumns;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.querybuilder.ConditionType;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.CriteriaListControl;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.ItemSortType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.SubSelectStatementProxy;
import com.adbs.querybuilder.UserMessageId;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import com.adbs.utils.Wrapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class CriteriaItem
extends ControlOwner
implements ActionListener {
    private static final long serialVersionUID = 1L;
    CriteriaList criteriaList;
    private SQLFromSource expressionDatasourceAST;
    private SQLObjectColumn expressionColumnAST;
    private boolean selected;
    AstNode astExpression;
    SQLExpressionAggregate astAggregate;
    SQLAliasExpression astAlias;
    private ItemSortType sortType = ItemSortType.None;
    private SQLOrderByNullOrdering sortNullOrdering = SQLOrderByNullOrdering.Default;
    private SQLOrderByItem astOrderByItem;
    private boolean grouping;
    ConditionType conditionType;
    ArrayList astConditions = new ArrayList();

    public CriteriaItem(CriteriaList owner, QueryBuilder queryBuilder) {
        super(owner, owner, queryBuilder);
        this.criteriaList = owner;
        this.grouping = false;
        this.conditionType = ConditionType.Where;
    }

    @Override
    public void dispose() {
        if (!this.getQueryBuilder().isDisposing()) {
            if (!this.criteriaList.isDisposing()) {
                this.criteriaList.beginUpdate();
                try {
                    this.criteriaList.items.remove(this);
                    this.criteriaList.orderByItems.remove(this);
                    this.criteriaList.notifySQLUpdated();
                }
                finally {
                    this.criteriaList.endUpdate();
                }
            }
            this.clear();
            if (this.astExpression != null) {
                this.astExpression.dispose();
                this.astExpression = null;
            }
            if (this.astAggregate != null) {
                this.astAggregate.dispose();
                this.astAggregate = null;
            }
            if (this.astAlias != null) {
                this.astAlias.dispose();
                this.astAlias = null;
            }
            if (this.astOrderByItem != null) {
                this.astOrderByItem.dispose();
                this.astOrderByItem = null;
            }
        }
        super.dispose();
    }

    public CriteriaList getCriteriaList() {
        return this.criteriaList;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) throws QueryBuilderException {
        if (value != this.selected) {
            this.beginUpdate();
            try {
                if (value && !this.isCanSelect()) {
                    throw new QueryBuilderException(Helpers.localizer.getString("strCantSelectExpression", "Cannot select this expression"));
                }
                this.selected = value;
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public boolean isSelectedUI() {
        return this.selected;
    }

    public void setSelectedUI(boolean value) {
        if (this.selected != value) {
            this.beginUpdate();
            try {
                this.selected = value;
                if (this.isQueryWithGrouping() && this.selected && this.isAggregatedExpression()) {
                    this.setGrouping(this.selected);
                }
                if (this.getCriteriaList().getUnionSubQuery().getRootQuery().isSubQuery() && this.isSelected() && this.getExpressionField() != null && this.getExpressionField().isVirtualCalculatedField() && Str.IsNullOrEmpty(this.getAliasString())) {
                    this.createAliasFromFieldName();
                }
                if (this.isSelected() && this.isColumnNamesConflict() && this.astAlias == null) {
                    if (this.isSupportsAlias()) {
                        this.createUniqueAlias();
                    } else if (!this.queryBuilder.isResolveColumnNamingConflictsAutomatically()) {
                        this.queryBuilder.fireUserMessageEvent(UserMessageId.SelectingExpressionCausesConflict);
                    } else {
                        this.criteriaList.assignAliasesToDuplicateColumnNames();
                        if (this.isColumnNamesConflict()) {
                            this.queryBuilder.fireUserMessageEvent(UserMessageId.SelectingExpressionCausesConflict);
                        }
                    }
                }
                if (this.isSelected() && this.getExpression() != null && this.queryBuilder.getCriteriaListOptions().isCreateColumnAliasesForUnnamedColumns() && this.isSupportsAlias() && this.isUnnamedColumn()) {
                    this.createUniqueAlias();
                }
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public AstNode getASTExpression() {
        return this.astExpression;
    }

    public String getExpressionString() {
        if (this.astExpression != null) {
            return this.astExpression.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpressionString(String expressionString) throws QueryBuilderException {
        String tmpExpressionString = "";
        Wrapper<SQLAliasExpression> newAlias = new Wrapper<SQLAliasExpression>();
        if (this.criteriaList.isListLoading()) {
            return;
        }
        if (!Str.IsNullOrEmpty(expressionString)) {
            tmpExpressionString = expressionString.trim();
        }
        if (!tmpExpressionString.equals(this.getExpressionString())) {
            if (this.getQueryBuilder() != null) {
                this.beginUpdate();
                if (this.astExpression != null) {
                    this.astExpression.dispose();
                    this.astExpression = null;
                }
                try {
                    Wrapper<AstNode> expr = new Wrapper<AstNode>(this.astExpression);
                    if (this.parseNewExpression(tmpExpressionString, expr, newAlias)) {
                        this.astExpression = (AstNode)expr.value;
                        if (this.astExpression == null) {
                            this.clear();
                        } else if (newAlias.value != null) {
                            this.setAliasString(((SQLAliasExpression)newAlias.value).alias.getToken());
                            newAlias.value = null;
                        }
                        this.fixupExpression(this.astExpression);
                    } else {
                        this.astExpression = new SQLExpressionConstant(this.getSQLContext());
                        ((SQLExpressionConstant)this.astExpression).addString("\"" + tmpExpressionString + "\"");
                    }
                    if (this.getAggregate() != null) {
                        SQLQualifiedNameList lStar = new SQLQualifiedNameList(this.getSQLContext());
                        SQLQualifiedNameList l1Param = new SQLQualifiedNameList(this.getSQLContext());
                        SQLQualifiedNameList lPref1Param = new SQLQualifiedNameList(this.getSQLContext());
                        this.getAggregateNameList(lStar, l1Param, lPref1Param);
                        int iStar = lStar.findByName(this.getAggregateName());
                        int i1Param = l1Param.findByName(this.getAggregateName());
                        int iPref1Param = lPref1Param.findByName(this.getAggregateName());
                        if (iStar == -1 && i1Param == -1 && iPref1Param == -1) {
                            this.setAggregate(null);
                        } else if (iPref1Param == -1 && (iStar != -1 || i1Param != -1)) {
                            this.setAggregatePrefix(SQLAggregateParamPrefix.All);
                        }
                    }
                    this.calcColumnAndDatasource();
                    this.loadSubQueries(this.astExpression);
                    this.notifySQLUpdated();
                }
                finally {
                    this.endUpdate();
                }
            } else {
                throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
            }
        }
    }

    public SQLExpressionAggregate getAggregate() {
        return this.astAggregate;
    }

    public void setAggregate(SQLExpressionAggregate aggregate) {
        if (aggregate != this.astAggregate) {
            this.beginUpdate();
            try {
                if (aggregate == null) {
                    this.astAggregate = null;
                } else {
                    if (this.astAggregate != null && aggregate.getClass() != this.astAggregate.getClass()) {
                        this.astAggregate = null;
                    }
                    if (this.astAggregate == null) {
                        this.astAggregate = (SQLExpressionAggregate)aggregate.clone(this.getSQLContext());
                    } else {
                        this.astAggregate.assign(aggregate);
                    }
                }
                if (this.astAggregate != null) {
                    this.grouping = false;
                    this.conditionType = ConditionType.Having;
                } else {
                    this.conditionType = ConditionType.Where;
                }
                this.calcColumnAndDatasource();
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public SQLQualifiedName getAggregateName() {
        if (this.astAggregate != null) {
            return this.astAggregate.name;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggregateName(SQLQualifiedName aggregateName) {
        BaseSQLContext context = this.getSQLContext();
        if (aggregateName != this.getAggregateName() && !context.isQualifiedNamesEqual(aggregateName, this.getAggregateName())) {
            SQLQualifiedNameList lStar = new SQLQualifiedNameList(context);
            SQLQualifiedNameList l1Param = new SQLQualifiedNameList(context);
            SQLQualifiedNameList lPref1Param = new SQLQualifiedNameList(context);
            this.getAggregateNameList(lStar, l1Param, lPref1Param);
            this.beginUpdate();
            try {
                int i;
                for (i = 0; i < lPref1Param.getCount(); ++i) {
                    if (!context.isQualifiedNamesEqual(aggregateName, lPref1Param.get(i))) continue;
                    if (this.astAggregate != null) {
                        assert (this.astAggregate.name != null);
                        this.astAggregate.name.assign(aggregateName);
                        this.notifySQLUpdated();
                    } else {
                        SQLExpressionAggregate agg = new SQLExpressionAggregate(context);
                        agg.name = aggregateName.clone(context);
                        this.setAggregate(agg);
                    }
                    return;
                }
                for (i = 0; i < l1Param.getCount(); ++i) {
                    if (!context.isQualifiedNamesEqual(aggregateName, l1Param.get(i))) continue;
                    if (this.astAggregate != null) {
                        assert (this.astAggregate.name != null);
                        this.astAggregate.name.assign(aggregateName);
                        this.setAggregatePrefix(SQLAggregateParamPrefix.All);
                        this.notifySQLUpdated();
                    } else {
                        SQLExpressionAggregate agg = new SQLExpressionAggregate(context);
                        agg.name = aggregateName.clone(context);
                        this.setAggregate(agg);
                    }
                    return;
                }
                for (i = 0; i < lStar.getCount(); ++i) {
                    if (!context.isQualifiedNamesEqual(aggregateName, lStar.get(i))) continue;
                    if (this.astAggregate != null) {
                        assert (this.astAggregate.name != null);
                        this.astAggregate.name.assign(aggregateName);
                        this.setAggregatePrefix(SQLAggregateParamPrefix.All);
                        this.notifySQLUpdated();
                    } else {
                        SQLExpressionAggregate agg = new SQLExpressionAggregate(context);
                        agg.name = aggregateName.clone(context);
                        this.setAggregate(agg);
                    }
                    return;
                }
            }
            finally {
                this.endUpdate();
            }
        } else {
            this.setAggregate(null);
        }
    }

    public SQLAggregateParamPrefix getAggregatePrefix() {
        if (this.astAggregate != null) {
            return this.astAggregate.prefix;
        }
        return SQLAggregateParamPrefix.All;
    }

    public void setAggregatePrefix(SQLAggregateParamPrefix prefix) {
        if (this.astAggregate != null && prefix != this.getAggregatePrefix()) {
            this.beginUpdate();
            try {
                this.astAggregate.prefix = prefix;
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public String getAggregateString() {
        if (this.getAggregateName() != null) {
            String result = this.getAggregateNameStrInternal(this.sqlContext.getSQLBuilderExpressionNonQuoted(), this.getAggregateName());
            switch (this.getAggregatePrefix()) {
                case All: {
                    break;
                }
                case Distinct: {
                    result = result + " Distinct";
                    break;
                }
                case Unique: {
                    result = result + " Unique";
                }
            }
            return result;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAggregateString(String aggregateString) {
        Wrapper<String> fn = new Wrapper<String>("");
        BaseSQLContext context = this.getSQLContext();
        if (!Str.IsNullOrEmpty(aggregateString)) {
            fn.value = aggregateString.trim().toUpperCase();
        }
        if (!Str.IsNullOrEmpty((String)fn.value)) {
            SQLAggregateParamPrefix tmpPrefix = this.calcAggregatePrefixFromAggregateString(fn);
            SQLQualifiedNameList lStar = new SQLQualifiedNameList(context);
            SQLQualifiedNameList l1Param = new SQLQualifiedNameList(context);
            SQLQualifiedNameList lPref1Param = new SQLQualifiedNameList(context);
            this.getAggregateNameList(lStar, l1Param, lPref1Param);
            this.beginUpdate();
            try {
                String fn2;
                int i;
                for (i = 0; i < lPref1Param.getCount(); ++i) {
                    fn2 = this.getAggregateNameStrInternal(this.sqlContext.getSQLBuilderExpressionNonQuoted(), lPref1Param.get(i));
                    if (((String)fn.value).compareToIgnoreCase(fn2) != 0) continue;
                    SQLExpressionAggregate agg = new SQLExpressionAggregate(context);
                    agg.name = lPref1Param.get(i).clone(context);
                    agg.prefix = tmpPrefix;
                    this.setAggregate(agg);
                    return;
                }
                if (tmpPrefix != SQLAggregateParamPrefix.All) return;
                for (i = 0; i < l1Param.getCount(); ++i) {
                    fn2 = this.getAggregateNameStrInternal(this.sqlContext.getSQLBuilderExpressionNonQuoted(), l1Param.get(i));
                    if (((String)fn.value).compareToIgnoreCase(fn2) != 0) continue;
                    SQLExpressionAggregate agg = new SQLExpressionAggregate(context);
                    agg.name = l1Param.get(i).clone(context);
                    this.setAggregate(agg);
                    return;
                }
                for (i = 0; i < lStar.getCount(); ++i) {
                    fn2 = this.getAggregateNameStrInternal(this.sqlContext.getSQLBuilderExpressionNonQuoted(), lStar.get(i));
                    if (((String)fn.value).compareToIgnoreCase(fn2) != 0) continue;
                    SQLExpressionAggregate agg = new SQLExpressionAggregate(context);
                    agg.name = lStar.get(i).clone(context);
                    this.setAggregate(agg);
                    return;
                }
                return;
            }
            finally {
                this.endUpdate();
            }
        } else {
            this.setAggregate(null);
        }
    }

    public String getAggregateStringUI() {
        return this.getAggregateString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAggregateStringUI(String aggregateString) {
        this.criteriaList.beginUpdate();
        try {
            this.setAggregateString(aggregateString);
            if (this.isAggregatedExpression() && !this.isQueryWithGrouping()) {
                for (int i = 0; i < this.criteriaList.getCount(); ++i) {
                    CriteriaItem ci;
                    ci.setGrouping((ci = this.criteriaList.get(i)).isSelected() && !ci.isAggregatedExpression());
                }
            } else if (!this.isAggregatedExpression() && this.isQueryWithGrouping() && this.isSelected()) {
                this.setGrouping(true);
            }
            if (this.isSelected() && this.getExpression() != null && this.queryBuilder.getCriteriaListOptions().isCreateColumnAliasesForUnnamedColumns() && this.isSupportsAlias() && this.isUnnamedColumn()) {
                this.createUniqueAlias();
            }
        }
        finally {
            this.criteriaList.endUpdate();
        }
    }

    public SQLAliasExpression getAlias() {
        return this.astAlias;
    }

    public String getAliasString() {
        if (this.astAlias != null && this.astAlias.alias != null) {
            return this.astAlias.alias.getToken();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAliasString(String aliasString) {
        String tmpAliasString = null;
        if (this.criteriaList.isListLoading()) {
            return;
        }
        if (!Str.IsNullOrEmpty(aliasString)) {
            tmpAliasString = aliasString.trim();
        }
        if (tmpAliasString == null || !tmpAliasString.equals(this.getAliasString())) {
            if (this.isSupportsAlias() && !Str.IsNullOrEmpty(tmpAliasString)) {
                this.beginUpdate();
                try {
                    if (this.astAlias == null) {
                        this.astAlias = new SQLAliasExpressionAlias(this.sqlContext);
                        ((SQLAliasExpressionAlias)this.astAlias).asKeyword = true;
                    }
                    if (this.astAlias.alias != null) {
                        this.astAlias.alias.dispose();
                    }
                    this.astAlias.alias = new AstTokenIdentifier(this.sqlContext, tmpAliasString, true);
                    this.notifySQLUpdated();
                }
                finally {
                    this.endUpdate();
                }
            }
            if (this.astAlias != null) {
                this.beginUpdate();
                try {
                    this.astAlias = null;
                    this.notifySQLUpdated();
                }
                finally {
                    this.endUpdate();
                }
            }
        }
        if (this.getExpression() != null && this.getExpression() instanceof SQLExpressionSelect) {
            ((SubSelectStatementProxy)((SQLExpressionSelect)this.getExpression()).subQuery).subQuery.updateCaption();
        }
    }

    public ItemSortType getSortType() {
        return this.sortType;
    }

    public void setSortType(ItemSortType value) {
        if (this.sortType != value) {
            this.beginUpdate();
            try {
                this.sortType = value;
                if (this.sortType != ItemSortType.None) {
                    if (this.criteriaList.orderByItems.indexOf(this) == -1) {
                        this.criteriaList.orderByItems.add(this);
                    }
                    if (this.astOrderByItem != null) {
                        this.astOrderByItem.dispose();
                    }
                    this.astOrderByItem = new SQLOrderByItem(this.sqlContext);
                } else {
                    this.criteriaList.orderByItems.remove(this);
                    this.astOrderByItem.dispose();
                    this.astOrderByItem = null;
                }
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public String getSortTypeString() {
        String result = this.sortTypeToString(this.sortType);
        if (!Str.IsNullOrEmpty(result) && this.sortNullOrdering != SQLOrderByNullOrdering.Default) {
            result = this.sortNullOrdering == SQLOrderByNullOrdering.NullsFirst ? result + " Nulls First" : result + " Nulls Last";
        }
        return result;
    }

    public void setSortTypeString(String value) {
        String s = "";
        if (this.criteriaList.isListLoading()) {
            return;
        }
        if (!Str.IsNullOrEmpty(value)) {
            s = value.trim();
        }
        if (Str.IsNullOrEmpty(s)) {
            this.setSortType(ItemSortType.None);
            this.sortNullOrdering = SQLOrderByNullOrdering.Default;
        } else {
            s = s.toUpperCase();
            for (ItemSortType st : ItemSortType.values()) {
                String sts = this.sortTypeToString(st).toUpperCase();
                if (sts.length() <= 0 || s.compareTo(sts.substring(0, Math.min(s.length(), sts.length()))) != 0 && sts.compareTo(s.substring(0, Math.min(s.length(), sts.length()))) != 0) continue;
                this.setSortType(st);
                break;
            }
            if (this.sqlContext.getSyntaxProvider() != null && this.sqlContext.getSyntaxProvider().isSupportNullOrdering()) {
                if (s.indexOf("FIRST") != -1) {
                    this.setSortNullOrdering(SQLOrderByNullOrdering.NullsFirst);
                } else if (s.indexOf("LAST") != -1) {
                    this.setSortNullOrdering(SQLOrderByNullOrdering.NullsLast);
                } else {
                    this.setSortNullOrdering(SQLOrderByNullOrdering.Default);
                }
            }
        }
    }

    public int getSortOrder() {
        return this.criteriaList.orderByItems.indexOf(this);
    }

    public void setSortOrder(int value) {
        int i;
        if (this.sortType != ItemSortType.None && (i = this.criteriaList.orderByItems.indexOf(this)) != -1) {
            Helpers.listMove(this.criteriaList.orderByItems, i, value);
        }
    }

    public String getSortOrderString() {
        if (this.sortType != ItemSortType.None) {
            return String.valueOf(this.getSortOrder() + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortOrderString(String value) {
        Wrapper<Integer> i = new Wrapper<Integer>(0);
        if (this.criteriaList.isListLoading()) {
            return;
        }
        this.beginUpdate();
        try {
            if (!Str.IsNullOrEmpty(value)) {
                value = value.trim();
            }
            if (Str.IsNullOrEmpty(value)) {
                this.setSortType(ItemSortType.None);
            } else {
                int ci;
                if (this.sortType == ItemSortType.None) {
                    this.setSortType(ItemSortType.Asc);
                }
                if (!String.valueOf((ci = this.getSortOrder()) + 1).equals(value) && Helpers.tryStrToInt(value, i)) {
                    if ((Integer)i.value > this.criteriaList.orderByItems.size()) {
                        i.value = this.criteriaList.orderByItems.size();
                    }
                    Wrapper<Integer> wrapper = i;
                    Integer n = (Integer)wrapper.value;
                    wrapper.value = (Integer)wrapper.value - 1;
                    Integer n2 = wrapper.value;
                    if ((Integer)i.value < 0) {
                        i.value = 0;
                    }
                    if ((Integer)i.value != ci) {
                        Helpers.listMove(this.criteriaList.orderByItems, ci, (Integer)i.value);
                        this.notifySQLUpdated();
                    }
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public void setGrouping(boolean grouping) {
        if (this.grouping != grouping) {
            this.beginUpdate();
            try {
                this.grouping = grouping;
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public boolean isGroupingUI() {
        return this.grouping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroupingUI(boolean grouping) {
        if (this.grouping != grouping) {
            this.beginUpdate();
            try {
                if (this.isQueryWithGrouping()) {
                    this.grouping = grouping;
                    if (grouping) {
                        this.setAggregate(null);
                        this.setConditionType(ConditionType.Where);
                    } else if (this.astAggregate == null) {
                        this.setConditionType(ConditionType.Where);
                        try {
                            this.setSelected(false);
                        }
                        catch (QueryBuilderException ex) {
                            Logger.getLogger(CriteriaItem.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        this.setConditionType(ConditionType.Having);
                    }
                } else {
                    this.grouping = grouping;
                    if (grouping) {
                        this.setAggregate(null);
                        this.setConditionType(ConditionType.Where);
                        for (int i = 0; i < this.criteriaList.getCount(); ++i) {
                            CriteriaItem ci = this.criteriaList.get(i);
                            if (!ci.selected || ci.isAggregatedExpression()) continue;
                            ci.setGrouping(true);
                            ci.setConditionType(ConditionType.Where);
                        }
                    } else if (!this.isAggregatedExpression()) {
                        this.setConditionType(ConditionType.Where);
                    } else {
                        this.setConditionType(ConditionType.Having);
                    }
                }
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public ConditionType getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionType conditionType) {
        if (this.conditionType != conditionType) {
            this.beginUpdate();
            try {
                this.conditionType = conditionType;
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public ConditionType getConditionTypeUI() {
        return this.conditionType;
    }

    public void setConditionTypeUI(ConditionType conditionType) {
        if (this.conditionType != conditionType) {
            this.beginUpdate();
            try {
                this.conditionType = conditionType;
                if (conditionType == ConditionType.Where) {
                    this.setAggregate(null);
                } else if (!this.isAggregatedExpression()) {
                    this.setGrouping(true);
                }
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public String getGroupingTypeString() {
        if (this.astExpression != null) {
            if (this.astAggregate == null && !this.grouping && this.conditionType == ConditionType.Where) {
                return "Where";
            }
            if (this.astAggregate == null && this.grouping && this.conditionType == ConditionType.Having) {
                return "Group By";
            }
            if (this.astAggregate == null && !this.grouping && this.conditionType == ConditionType.Having) {
                return "Having";
            }
            if (this.astAggregate != null && !this.grouping && this.conditionType == ConditionType.Having) {
                return this.getAggregateString();
            }
            return "";
        }
        return "";
    }

    public void setGroupingTypeString(String groupingTypeString) {
        String tmpString = "";
        if (!Str.IsNullOrEmpty(groupingTypeString)) {
            tmpString = groupingTypeString.trim();
        }
        if (!Str.IsNullOrEmpty(tmpString)) {
            this.beginUpdate();
            try {
                if (tmpString.compareToIgnoreCase("WHERE") == 0) {
                    this.setConditionTypeUI(ConditionType.Where);
                    this.setAggregate(null);
                    this.setGroupingUI(false);
                } else if (tmpString.compareToIgnoreCase("GROUP BY") == 0) {
                    this.setGroupingUI(true);
                    this.setAggregate(null);
                    this.setConditionTypeUI(ConditionType.Having);
                } else if (tmpString.compareToIgnoreCase("HAVING") == 0) {
                    this.setAggregate(null);
                    this.setGroupingUI(false);
                    this.setConditionTypeUI(ConditionType.Having);
                } else {
                    this.setGrouping(false);
                    this.setConditionType(ConditionType.Having);
                    this.setAggregateString(tmpString);
                }
            }
            finally {
                this.endUpdate();
            }
        }
    }

    public int getConditionCount() {
        return this.astConditions.size();
    }

    public SQLFromSource getExpressionDatasourceAST() {
        return this.expressionDatasourceAST;
    }

    public DataSource getExpressionDatasource() {
        if (this.expressionDatasourceAST != null) {
            assert (this.expressionDatasourceAST.data instanceof DataSource);
            return (DataSource)this.expressionDatasourceAST.data;
        }
        return null;
    }

    public SQLObjectColumn getExpressionColumnAST() {
        return this.expressionColumnAST;
    }

    public boolean expressionOnly() {
        return this.getConditionCount() == 0;
    }

    boolean isSupportsAlias() {
        return this.astExpression != null && (this.astExpression instanceof SQLExpressionItem && (this.getSQLContext().getSyntaxProvider().isUniversalExpressions() || !((SQLExpressionItem)this.astExpression).isLogical()) || this.astExpression instanceof SQLSelectItem && this.astAggregate != null);
    }

    protected boolean isExpressionOnly() {
        this.shrinkConditionList();
        return this.astConditions.isEmpty();
    }

    public boolean isCanSelect() {
        return this.astExpression != null && (this.astExpression instanceof SQLExpressionItem && (this.getSQLContext().getSyntaxProvider().isUniversalExpressions() || !((SQLExpressionItem)this.astExpression).isLogical()) || this.astExpression instanceof SQLSelectItem);
    }

    boolean isCanSort() {
        return this.astExpression != null && (this.astExpression instanceof SQLExpressionItem && (this.getSQLContext().getSyntaxProvider().isUniversalExpressions() || !((SQLExpressionItem)this.astExpression).isLogical()) || this.astExpression instanceof SQLSelectItem && this.astAggregate != null);
    }

    protected void calcColumnAndDatasource() {
        if (this.astExpression != null && this.astAggregate == null) {
            if (this.astExpression instanceof SQLExpressionItem) {
                SQLExpressionItem ei = (SQLExpressionItem)this.astExpression;
                if ((ei = Helpers.expressionRemoveBrackets(ei)) instanceof SQLExpressionColumn) {
                    this.expressionDatasourceAST = ((SQLExpressionColumn)ei).column.datasource;
                    this.expressionColumnAST = ((SQLExpressionColumn)ei).column;
                } else {
                    this.expressionColumnAST = null;
                    this.expressionDatasourceAST = null;
                }
            } else if (this.astExpression instanceof SQLSelectItemAllTableColumns) {
                this.expressionDatasourceAST = ((SQLSelectItemAllTableColumns)this.astExpression).databaseObject.datasource;
                this.expressionColumnAST = null;
            } else {
                this.expressionColumnAST = null;
                this.expressionDatasourceAST = null;
            }
        } else {
            this.expressionColumnAST = null;
            this.expressionDatasourceAST = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqualExpression(SQLExpressionItem ast) {
        if (this.astExpression == null || ast == null) {
            return false;
        }
        if (this.astExpression instanceof SQLExpressionItem) {
            if (this.astExpression.getClass() != ast.getClass()) {
                return false;
            }
            SQLExpressionItem ei = this.getExpression();
            try {
                boolean bl = ei.getSimpleSQL(this.getSQLContext().getSQLBuilderExpressionForServer()).equals(ast.getSimpleSQL(this.getSQLContext().getSQLBuilderExpressionForServer()));
                return bl;
            }
            finally {
                ei.dispose();
            }
        }
        return false;
    }

    public void addCondition(int index, SQLExpressionItem expression) {
        if (this.astExpression instanceof SQLExpressionItem) {
            expression.removeLExpression((SQLExpressionItem)this.astExpression);
        }
        if (this.astConditions.size() <= index) {
            Helpers.listSetSize(this.astConditions, index + 1, false);
        }
        if (this.astConditions.get(index) == null) {
            this.astConditions.set(index, expression);
        } else if (this.astConditions.get(index) instanceof SQLExpressionAnd) {
            SQLExpressionAnd sc = (SQLExpressionAnd)this.astConditions.get(index);
            if (expression instanceof SQLExpressionAnd) {
                int i;
                SQLExpressionAnd expressionAnd = (SQLExpressionAnd)expression;
                for (i = 0; i < expressionAnd.getCount(); ++i) {
                    SQLExpressionItem innerExpression = expressionAnd.get(i);
                    sc.add(innerExpression);
                    this.loadSubQueries(innerExpression);
                }
                for (i = expressionAnd.getCount() - 1; i >= 0; --i) {
                    expressionAnd.extract(i);
                }
                expression.dispose();
                expression = null;
            } else if (expression instanceof SQLExpressionLogicalCollection) {
                sc.add(new SQLExpressionBrackets(this.sqlContext, expression));
            } else {
                sc.add(expression);
            }
        } else {
            SQLExpressionItem sci2 = (SQLExpressionItem)this.astConditions.get(index);
            this.astConditions.remove(index);
            SQLExpressionAnd sc = new SQLExpressionAnd(this.getSQLContext());
            this.astConditions.add(index, sc);
            if (sci2 instanceof SQLExpressionLogicalCollection) {
                sc.add(new SQLExpressionBrackets(this.sqlContext, sci2));
            } else {
                sc.add(sci2);
            }
            if (expression instanceof SQLExpressionLogicalCollection) {
                sc.add(new SQLExpressionBrackets(this.sqlContext, expression));
            } else {
                sc.add(expression);
            }
        }
        if (expression != null) {
            this.loadSubQueries(expression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean notifyDatasourceDestroyingInternal(DataSource datasource) {
        boolean result;
        boolean bl = result = this.expressionDatasourceAST == datasource.astFromSource;
        if (result) {
            return true;
        }
        ArrayList l = new ArrayList();
        if (this.astExpression != null) {
            this.astExpression.getReferencedDatasourcesRecursive(l);
            boolean bl2 = result = l.indexOf(datasource.astFromSource) != -1;
            if (result) {
                return true;
            }
        }
        this.beginUpdate();
        try {
            for (int i = this.getConditionCount() - 1; i >= 0; --i) {
                SQLExpressionItem n = this.getASTCondition(i);
                if (n == null) continue;
                l.clear();
                n.getReferencedDatasourcesRecursive(l);
                if (l.indexOf(datasource.getFromSource()) == -1) continue;
                this.setASTCondition(i, null);
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
        return false;
    }

    @Override
    protected void notifyDatasourceReplacedInternal(DataSource datasourceFrom, DataSource datasourceTo) {
        if (this.astExpression != null) {
            if (this.expressionDatasourceAST == datasourceFrom.getFromSource()) {
                this.expressionDatasourceAST = datasourceTo.getFromSource();
            }
            this.astExpression.replaceReferencesToDatasourceRecursive(datasourceFrom.getFromSource(), datasourceTo.getFromSource());
            for (int i = this.getConditionCount() - 1; i >= 0; --i) {
                SQLExpressionItem n = this.getASTCondition(i);
                if (n == null) continue;
                n.replaceReferencesToDatasourceRecursive(datasourceFrom.getFromSource(), datasourceTo.getFromSource());
            }
        }
    }

    public void shrinkConditionList() {
        for (int i = this.astConditions.size() - 1; i >= 0 && this.astConditions.get(i) == null; --i) {
            this.astConditions.remove(i);
        }
    }

    @Override
    protected void getASTChildren(List l) {
        if (this.astExpression != null) {
            l.add(this.astExpression);
        }
        if (this.astAlias != null) {
            l.add(this.astAlias);
        }
        for (int i = 0; i < this.astConditions.size(); ++i) {
            if (this.astConditions.get(i) == null) continue;
            l.add(this.astConditions.get(i));
        }
    }

    public SQLExpressionItem getASTCondition(int index) {
        if (index >= this.astConditions.size()) {
            return null;
        }
        return (SQLExpressionItem)this.astConditions.get(index);
    }

    @Override
    protected AstNode createResultAST() {
        return this.getSelectItem();
    }

    public void clear() {
        this.beginUpdate();
        try {
            if (this.astExpression != null) {
                this.astExpression.dispose();
                this.astExpression = null;
            }
            if (this.astAlias != null) {
                this.astAlias.dispose();
                this.astAlias = null;
            }
            for (Object condition : this.astConditions) {
                if (condition == null) continue;
                ((SQLExpressionItem)condition).dispose();
            }
            this.astConditions.clear();
            if (this.astOrderByItem != null) {
                this.astOrderByItem.dispose();
                this.astOrderByItem = null;
            }
            this.expressionColumnAST = null;
            this.expressionDatasourceAST = null;
            this.conditionType = ConditionType.Where;
            this.sortType = ItemSortType.None;
            this.grouping = false;
            this.criteriaList.orderByItems.remove(this);
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public void loadFromAST(AstNode a, boolean doFixup) {
        if (a instanceof SQLSelectItem) {
            SQLSelectItem si = (SQLSelectItem)a;
            if (si instanceof SQLSelectItemExpression) {
                this.astExpression = ((SQLSelectItemExpression)si).expression;
                ((SQLSelectItemExpression)si).expression = null;
                this.astAlias = ((SQLSelectItemExpression)si).alias;
                ((SQLSelectItemExpression)si).alias = null;
            } else {
                this.astExpression = si.clone(this.getSQLContext());
            }
        } else if (a instanceof SQLExpressionItem) {
            this.astExpression = a.clone(this.getSQLContext());
            this.astExpression.restoreColumnPrefixRecursive(true);
            if (doFixup) {
                this.fixupExpression(this.astExpression);
            }
        }
        this.calcColumnAndDatasource();
        this.loadSubQueries(this.astExpression);
        this.notifySQLUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLOrderByItem getOrderByItem() {
        SQLOrderByItem result = this.astOrderByItem != null ? (SQLOrderByItem)this.astOrderByItem.clone(this.sqlContext) : new SQLOrderByItem(this.sqlContext);
        if (this.isSelected() && this.criteriaList.getUnionSubQuery().getRootQuery().isQueryWithUnions()) {
            AstIdentifierList occupiedNames = this.getOccupiedColumnNames();
            try {
                if (occupiedNames.getCount() == 1) {
                    SQLExpressionColumn ec = new SQLExpressionColumn(this.sqlContext);
                    ec.column = new SQLObjectColumn(this.sqlContext);
                    ec.column.add(occupiedNames.get(0).clone(this.sqlContext));
                    result.expression = ec;
                }
                result.expression = this.getExpression();
            }
            finally {
                occupiedNames.dispose();
            }
        } else if (this.sqlContext.getSyntaxProvider().isSupportOrderByAlias() && this.selected && this.astAlias != null && this.astAlias.alias != null) {
            SQLExpressionColumn ec = new SQLExpressionColumn(this.sqlContext);
            ec.column = new SQLObjectColumn(this.sqlContext);
            ec.column.add(this.astAlias.alias.clone(this.sqlContext));
            result.expression = ec;
        } else {
            result.expression = this.getExpression();
        }
        if (this.sortType == ItemSortType.Desc) {
            result.sort = SQLOrderByOrders.Desc;
        }
        result.nullOrdering = this.getSortNullOrdering();
        return result;
    }

    public SQLExpressionItem getGroupByItem() {
        return this.getExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFieldExpression(DataSource ds, SQLQualifiedName fieldName) {
        BaseSQLContext context = this.getSQLContext();
        this.beginUpdate();
        try {
            if (fieldName == null) {
                SQLSelectItemAllTableColumns si2 = new SQLSelectItemAllTableColumns(context);
                si2.databaseObject = new SQLDatabaseObject(context);
                si2.databaseObject.datasource = ds.astFromSource;
                this.loadFromAST(si2, true);
            } else {
                SQLSelectItemExpression si = new SQLSelectItemExpression(context);
                si.expression = new SQLExpressionColumn(context);
                ((SQLExpressionColumn)si.expression).column = new SQLObjectColumn(context);
                ((SQLExpressionColumn)si.expression).column.assign(fieldName);
                ((SQLExpressionColumn)si.expression).column.datasource = ds.astFromSource;
                int i = context.getSyntaxProvider().findFieldInFieldList(((SQLExpressionColumn)si.expression).column, ds.astFromSource.getFieldList());
                if (i != -1) {
                    MetadataField mf = ((SQLExpressionColumn)si.expression).column.datasource.getFieldList().get(i);
                    ((SQLExpressionColumn)si.expression).column.assign(mf.getName());
                    ((SQLExpressionColumn)si.expression).column.setMetadataField(mf);
                    if (this.getQueryBuilder().getCriteriaListOptions().isCreateColumnAliasesFromAltNames() && !Str.IsNullOrEmpty(mf.getAltName())) {
                        si.alias = new SQLAliasExpressionAlias(context);
                        ((SQLAliasExpressionAlias)si.alias).asKeyword = true;
                        si.alias.alias = this.criteriaList.createUniqueAlias(mf.getAltName());
                    }
                }
                this.loadFromAST(si, true);
                for (i = 0; i < this.criteriaList.getCount(); ++i) {
                    if (!this.criteriaList.get(i).isGrouping() && this.criteriaList.get(i).getConditionType() != ConditionType.Having) continue;
                    this.grouping = true;
                    this.conditionType = ConditionType.Where;
                    break;
                }
            }
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    private String sortTypeToString(ItemSortType sortType) {
        return Helpers.sortTypeNames[sortType.ordinal()];
    }

    private boolean parseNewExpression(String expression, Wrapper<AstNode> newExpression, Wrapper<SQLAliasExpression> newAlias) {
        SQLSelectItem si = null;
        newAlias.value = null;
        newExpression.value = null;
        if (Str.IsNullOrEmpty(expression)) {
            return true;
        }
        if (this.getSQLContext().isValidIdent(expression)) {
            ArrayList l = new ArrayList();
            DatasourceGroup g = this.criteriaList.getUnionSubQuery().getFromClause();
            if (g != null) {
                g.getDatasources(l);
            }
            for (int i = l.size() - 1; i >= 0; --i) {
                DataSource ds = (DataSource)l.get(i);
                if (ds.astFromSource.getFieldList().findFieldByName(expression) == -1) continue;
                SQLExpressionColumn expressionColumn = new SQLExpressionColumn(this.getSQLContext());
                expressionColumn.column = new SQLObjectColumn(this.getSQLContext());
                expressionColumn.column.datasource = ds.astFromSource;
                expressionColumn.column.addName(expression);
                newExpression.value = expressionColumn;
                return true;
            }
        }
        try {
            si = this.getSQLContext().parseSelectItem(expression);
        }
        catch (Exception ex) {
            Logger.getLogger(CriteriaItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (si != null) {
            if (si instanceof SQLSelectItemExpression) {
                if (((SQLSelectItemExpression)si).alias != null) {
                    newAlias.value = ((SQLSelectItemExpression)si).alias;
                    ((SQLSelectItemExpression)si).alias = null;
                }
                newExpression.value = ((SQLSelectItemExpression)si).expression;
                ((SQLSelectItemExpression)si).expression = null;
                return true;
            }
            newExpression.value = si;
            return true;
        }
        try {
            newExpression.value = this.getSQLContext().parseLogicalExpression(expression, true);
        }
        catch (Exception ex) {
            Logger.getLogger(CriteriaItem.class.getName()).log(Level.SEVERE, null, ex);
        }
        return newExpression.value != null;
    }

    private void fixupExpression(AstNode expression) {
        if (expression == null) {
            return;
        }
        expression.simplifyTreeRecursive();
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        this.gatherPrepareAndFixupContext(lCTE, lFromObj, true);
        SubQuery subQuery = this.criteriaList.getUnionSubQuery().getRootQuery();
        for (int i = lFromObj.size() - 1; i >= 0; --i) {
            SQLFromSource fromSource = (SQLFromSource)lFromObj.get(i);
            if (!(fromSource instanceof SQLFromQuery)) continue;
            SQLFromQuery fromQuery = (SQLFromQuery)fromSource;
            if (!(fromQuery.subQuery instanceof SubSelectStatementProxy)) continue;
            SubSelectStatementProxy proxy = (SubSelectStatementProxy)fromQuery.subQuery;
            if (proxy.subQuery != subQuery) continue;
            lFromObj.remove(i);
        }
        expression.prepareAndFixupRecursive(lCTE, lFromObj);
    }

    public boolean isCanGrouping() {
        return this.astExpression != null && this.astExpression instanceof SQLExpressionItem;
    }

    public boolean isSupportConditions() {
        return this.astExpression != null && (this.astExpression instanceof SQLExpressionItem || this.astExpression instanceof SQLSelectItem && this.astAggregate != null);
    }

    protected void setASTCondition(int index, SQLExpressionItem expression) {
        this.beginUpdate();
        try {
            if (expression != null && index >= this.astConditions.size()) {
                Helpers.listSetSize(this.astConditions, index + 1, false);
            }
            if (index < this.astConditions.size()) {
                if (this.astConditions.get(index) != null) {
                    ((SQLExpressionItem)this.astConditions.get(index)).dispose();
                }
                this.astConditions.set(index, expression);
            }
            if (expression == null) {
                this.shrinkConditionList();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void doSQLUpdated() {
        if (this.isDisposing()) {
            return;
        }
        super.doSQLUpdated();
        if (!this.isCanSelect()) {
            this.selected = false;
        }
        if (!this.isSupportsAlias()) {
            this.setAliasString("");
        }
        if (!this.isCanSort()) {
            this.criteriaList.orderByItems.remove(this);
            this.sortType = ItemSortType.None;
        }
        if (!this.isCanGrouping()) {
            this.grouping = false;
        }
        if (!this.isSupportConditions()) {
            for (int i = this.astConditions.size() - 1; i >= 0; --i) {
                if (this.astConditions.get(i) == null) continue;
                ((SQLExpressionItem)this.astConditions.get(i)).dispose();
            }
            this.astConditions.clear();
        }
    }

    public SQLExpressionItem getExpression() {
        SQLExpressionItem result;
        if (this.astExpression != null) {
            if (this.astAggregate != null) {
                SQLExpressionAggregate ag;
                result = ag = (SQLExpressionAggregate)this.astAggregate.clone(this.getSQLContext());
                if (this.astExpression instanceof SQLExpressionItem) {
                    ag.params = new SQLExpressionList(this.sqlContext);
                    ag.params.add(((SQLExpressionItem)this.astExpression).clone(this.sqlContext));
                }
            } else {
                result = this.astExpression instanceof SQLExpressionItem ? ((SQLExpressionItem)this.astExpression).clone(this.getSQLContext()) : null;
            }
        } else {
            result = null;
        }
        return result;
    }

    public SQLSelectItem getSelectItem() {
        SQLSelectItem result;
        if (this.astExpression != null) {
            SQLExpressionItem expr = this.getExpression();
            if (expr != null) {
                SQLSelectItemExpression si;
                result = si = new SQLSelectItemExpression(this.getSQLContext());
                si.expression = expr;
                if (this.astAlias != null) {
                    si.alias = (SQLAliasExpression)this.astAlias.clone(this.getSQLContext());
                }
            } else {
                result = this.astExpression instanceof SQLSelectItem ? (SQLSelectItem)this.astExpression.clone(this.getSQLContext()) : null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private SQLAggregateParamPrefix calcAggregatePrefixFromAggregateString(Wrapper<String> aggregateString) {
        SQLAggregateParamPrefix result;
        int aggLength = ((String)aggregateString.value).length();
        if (aggLength >= 10 && ((String)aggregateString.value).substring(aggLength - 9, aggLength).equals(" DISTINCT")) {
            result = SQLAggregateParamPrefix.Distinct;
            aggregateString.value = ((String)aggregateString.value).substring(0, aggLength - 9);
        } else if (aggLength >= 5 && ((String)aggregateString.value).substring(aggLength - 4, aggLength).equals(" ALL")) {
            result = SQLAggregateParamPrefix.All;
            aggregateString.value = ((String)aggregateString.value).substring(0, aggLength - 4);
        } else if (aggLength >= 8 && ((String)aggregateString.value).substring(aggLength - 7, aggLength).equals(" UNIQUE")) {
            result = SQLAggregateParamPrefix.Unique;
            aggregateString.value = ((String)aggregateString.value).substring(0, aggLength - 7);
        } else {
            result = SQLAggregateParamPrefix.All;
        }
        return result;
    }

    public void getAggregateNameList(SQLQualifiedNameList starAggregates, SQLQualifiedNameList oneParamAggregates, SQLQualifiedNameList prefixed1ParamAggregates) {
        if (starAggregates != null) {
            starAggregates.clear();
        }
        if (oneParamAggregates != null) {
            oneParamAggregates.clear();
        }
        if (prefixed1ParamAggregates != null) {
            prefixed1ParamAggregates.clear();
        }
        if (this.astExpression != null) {
            if (this.astExpression instanceof SQLExpressionItem) {
                if (!((SQLExpressionItem)this.astExpression).isLogical() || this.getSQLContext().getSyntaxProvider().isUniversalExpressions()) {
                    if (oneParamAggregates != null) {
                        this.getSQLContext().getSyntaxProvider().get1ParamAggregateNames(oneParamAggregates);
                    }
                    if (prefixed1ParamAggregates != null) {
                        this.sqlContext.getSyntaxProvider().getPrefixed1ParamAggregateNames(prefixed1ParamAggregates);
                        MetadataQualifiedNameList caf = this.queryBuilder.getMetadataContainer().getCustomAggregateFunctions();
                        for (int i = 0; i < caf.getCount(); ++i) {
                            prefixed1ParamAggregates.add(caf.get(i).clone(this.sqlContext));
                        }
                    }
                }
            } else if (this.astExpression instanceof SQLSelectItem && starAggregates != null) {
                this.getSQLContext().getSyntaxProvider().getStarAggregateNames(starAggregates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAggregateStringList(List<String> list) {
        BaseSQLContext context = this.getSQLContext();
        SQLQualifiedNameList lStar = new SQLQualifiedNameList(context);
        try {
            SQLQualifiedNameList l1Param = new SQLQualifiedNameList(context);
            try {
                SQLQualifiedNameList lPref1Param = new SQLQualifiedNameList(context);
                try {
                    int i;
                    this.getAggregateNameList(lStar, l1Param, lPref1Param);
                    SQLQualifiedNameList lResult = new SQLQualifiedNameList(context);
                    try {
                        for (i = lStar.getCount() - 1; i >= 0; --i) {
                            lResult.add(lStar.get(i));
                        }
                        for (i = l1Param.getCount() - 1; i >= 0; --i) {
                            lResult.add(l1Param.get(i));
                        }
                        for (i = lPref1Param.getCount() - 1; i >= 0; --i) {
                            lResult.add(lPref1Param.get(i));
                        }
                        lResult.sortByNames();
                        list.clear();
                        list.add("");
                        for (i = 0; i < lResult.getCount(); ++i) {
                            String fn = this.getAggregateNameStrInternal(context.getSQLBuilderExpressionNonQuoted(), lResult.get(i));
                            list.add(fn);
                            if (lPref1Param.indexOf(lResult.get(i)) == -1) continue;
                            list.add(fn + " Distinct");
                        }
                    }
                    finally {
                        for (i = lResult.getCount() - 1; i >= 0; --i) {
                            lResult.extract(lResult.get(i));
                        }
                        lResult.dispose();
                    }
                }
                finally {
                    lPref1Param.dispose();
                }
            }
            finally {
                l1Param.dispose();
            }
        }
        finally {
            lStar.dispose();
        }
    }

    public void getGroupingTypeStringList(List<String> list) {
        this.getAggregateStringList(list);
        if (list.size() > 0 && Str.IsNullOrEmpty(list.get(0))) {
            list.remove(0);
        }
        int i = 0;
        if (this.isSupportConditions()) {
            list.add(i, "Where");
            ++i;
        }
        list.add(i, "Group By");
        ++i;
        if (this.isSupportConditions()) {
            list.add(i, "Having");
        }
    }

    public String getConditionString(int index) {
        SQLExpressionItem sc = this.getASTCondition(index);
        if (sc != null) {
            return sc.getSimpleSQL(this.getSQLContext().getSQLBuilderExpression());
        }
        return "";
    }

    private boolean isNumber(String value) {
        Wrapper<Double> k = new Wrapper<Double>(0.0);
        return Helpers.tryStrToDouble(value, k);
    }

    private SQLExpressionItem treatAsStringLiteral(String value) {
        if (value.indexOf("%") != -1) {
            SQLExpressionLikeTemplate like = new SQLExpressionLikeTemplate(this.sqlContext);
            SQLExpressionConstant e = new SQLExpressionConstant(this.sqlContext);
            if (value.length() > 1 && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
                e.addString(Helpers.sqlQuoteString(Helpers.sqlUnquoteString(value)));
            } else {
                e.addString(Helpers.sqlQuoteString(value));
            }
            like.likeOperator = "Like";
            like.like = e;
            return like;
        }
        SQLExpressionOperatorBinary comp = new SQLExpressionOperatorBinary(this.sqlContext, "=");
        SQLExpressionConstant e = new SQLExpressionConstant(this.sqlContext);
        if (!Str.IsNullOrEmpty(value) && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            e.addString(value);
        } else {
            e.addString(Helpers.sqlQuoteString(value));
        }
        comp.rExpression = e;
        return comp;
    }

    private SQLExpressionOperatorBinary treatAsDatasourceColumn(DataSource datasource, String value) {
        SQLExpressionColumn e = new SQLExpressionColumn(this.sqlContext);
        SQLExpressionOperatorBinary result = new SQLExpressionOperatorBinary(this.sqlContext, "=");
        e.column = new SQLObjectColumn(this.sqlContext);
        e.column.datasource = datasource.astFromSource;
        e.column.addName(value);
        result.rExpression = e;
        return result;
    }

    private SQLExpressionOperatorBinary treatAsNumber(String value) {
        SQLExpressionOperatorBinary result = new SQLExpressionOperatorBinary(this.sqlContext, "=");
        SQLExpressionConstant e = new SQLExpressionConstant(this.sqlContext);
        e.addNumber(value);
        result.rExpression = e;
        return result;
    }

    private SQLExpressionOperatorBinary treatAsStringLiteralWithComparisonOperator(String oper, String value) {
        SQLExpressionOperatorBinary result = new SQLExpressionOperatorBinary(this.sqlContext, oper);
        SQLExpressionConstant e = new SQLExpressionConstant(this.sqlContext);
        String s = value.substring(oper.length()).trim();
        if (s.length() > 1 && s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = Helpers.sqlUnquoteString(s);
        }
        e.addString(Helpers.sqlQuoteString(s));
        result.rExpression = e;
        return result;
    }

    private SQLExpressionLikeTemplate TreatAsStringLiteralWithLikeOperator(String value) {
        SQLExpressionConstant e = new SQLExpressionConstant(this.sqlContext);
        SQLExpressionLikeTemplate result = new SQLExpressionLikeTemplate(this.sqlContext);
        String cLike = "Like";
        result.likeOperator = "Like";
        String s = value.substring("Like".length()).trim();
        if (s.length() > 1 && s.startsWith("'") && s.endsWith("'")) {
            s = Helpers.sqlUnquoteString(s);
        }
        e.addString(Helpers.sqlQuoteString(s));
        result.like = e;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConditionString(int index, String value) {
        int[] stringFieldTypes = new int[]{2004, 1, 2005, -16, -1, -15, 2011, -9, 12};
        BaseSQLContext context = this.getSQLContext();
        String cLike = "Like";
        if (this.criteriaList.isListLoading()) {
            return;
        }
        if (!Str.IsNullOrEmpty(value)) {
            value = value.trim();
        }
        if (Str.IsNullOrEmpty(value)) {
            this.setASTCondition(index, null);
        } else {
            MetadataField f = this.getExpressionField();
            if (this.isNumber(value) && (f == null || !Helpers.arrayContains(stringFieldTypes, f.getFieldType()))) {
                this.setASTCondition(index, this.treatAsNumber(value));
            } else if (this.isNumber(value) && (f == null || Helpers.arrayContains(stringFieldTypes, f.getFieldType()))) {
                this.setASTCondition(index, this.treatAsStringLiteral(value));
            } else {
                SQLExpressionItem sc = null;
                if (context.isValidIdent(value)) {
                    ArrayList l = new ArrayList();
                    DatasourceGroup g = this.criteriaList.getUnionSubQuery().getFromClause();
                    if (g != null) {
                        g.getDatasources(l);
                    }
                    for (int j = l.size() - 1; j >= 0; --j) {
                        DataSource ds = (DataSource)l.get(j);
                        if (ds.astFromSource.getFieldList().findFieldByName(value) == -1) continue;
                        sc = this.treatAsDatasourceColumn(ds, value);
                        break;
                    }
                    if (sc == null) {
                        sc = this.treatAsStringLiteral(value);
                    }
                }
                if (sc == null) {
                    if (value.compareToIgnoreCase("Null") == 0 || value.compareToIgnoreCase("=Null") == 0 || value.compareToIgnoreCase("= Null") == 0) {
                        value = "Is Null";
                    } else if (value.compareToIgnoreCase("Not Null") == 0 || value.compareToIgnoreCase("<>Null") == 0 || value.compareToIgnoreCase("<> Null") == 0 || value.compareToIgnoreCase("!=Null") == 0 || value.compareToIgnoreCase("!= Null") == 0) {
                        value = "Is Not Null";
                    }
                    SQLExpressionItem expression = this.getExpression();
                    boolean allowBool = expression != null && expression instanceof SQLExpressionItem ? expression.isLogical() : false;
                    sc = context.parseLogicalExpression(value, false, allowBool);
                    if (sc != null) {
                        SQLExpressionItem e = Helpers.expressionExtractFromBrackets(sc = Helpers.simplifyLogicalExpression(sc));
                        if (e != sc) {
                            sc.dispose();
                            sc = e;
                        }
                        if (!sc.isLogical() || sc instanceof SQLExpressionOperatorBinary && ((SQLExpressionOperatorBinary)sc).lExpression != null) {
                            e = new SQLExpressionOperatorBinary(this.sqlContext, "=");
                            ((SQLExpressionOperatorBinary)e).rExpression = sc;
                            sc = e;
                        }
                    } else if (value.length() > "Like".length() && value.toLowerCase().startsWith("Like".toLowerCase()) && value.charAt("Like".length()) == ' ') {
                        sc = this.TreatAsStringLiteralWithLikeOperator(value);
                    } else {
                        ArrayList<String> compOpers = new ArrayList<String>();
                        context.getSyntaxProvider().getComparisonOperators(compOpers);
                        for (int j = compOpers.size() - 1; j >= 0; --j) {
                            if (!value.startsWith(compOpers.get(j))) continue;
                            sc = this.treatAsStringLiteralWithComparisonOperator(compOpers.get(j), value);
                            break;
                        }
                        if (sc == null && !this.sqlContext.getSyntaxProvider().isUniversalExpressions()) {
                            boolean treatAsFunctionCall = false;
                            SQLQualifiedNameList functions = new SQLQualifiedNameList(this.sqlContext);
                            try {
                                this.sqlContext.getSyntaxProvider().getBuiltinFunctionNames(functions);
                                for (int j = 0; j < functions.getCount(); ++j) {
                                    String funcName = functions.get(j).getSimpleSQL(this.sqlContext.getSQLBuilderExpressionNonQuoted()) + "(";
                                    if (!value.toLowerCase().startsWith(funcName.toLowerCase())) continue;
                                    treatAsFunctionCall = true;
                                    break;
                                }
                            }
                            finally {
                                functions.dispose();
                            }
                            if (treatAsFunctionCall && (sc = this.sqlContext.parseExpression(value)) != null) {
                                SQLExpressionOperatorBinary e = new SQLExpressionOperatorBinary(this.sqlContext, "=");
                                e.rExpression = sc;
                                sc = e;
                            }
                        }
                        if (sc == null) {
                            sc = this.treatAsStringLiteral(value);
                        }
                    }
                }
                this.fixupExpression(sc);
                if (this.astExpression instanceof SQLExpressionItem) {
                    sc.removeLExpression((SQLExpressionItem)this.astExpression);
                }
                this.beginUpdate();
                try {
                    this.setASTCondition(index, sc);
                    this.loadSubQueries(sc);
                }
                finally {
                    this.endUpdate();
                }
            }
        }
        this.shrinkConditionList();
        this.notifySQLUpdated();
    }

    public void setASTExpression(SQLSelectItem expression) throws QueryBuilderException {
        this.beginUpdate();
        try {
            this.loadFromAST(expression, true);
            this.notifySQLUpdated();
        }
        finally {
            this.endUpdate();
        }
    }

    public void finalizeLoading() {
        if (this.astExpression != null && this.astExpression instanceof SQLExpressionAggregate && !this.grouping && (this.astConditions.isEmpty() && this.conditionType == ConditionType.None || this.conditionType == ConditionType.Having) && (((SQLExpressionAggregate)this.astExpression).params == null || ((SQLExpressionAggregate)this.astExpression).params.getCount() == 1)) {
            this.astAggregate = (SQLExpressionAggregate)this.astExpression;
            if (this.astAggregate.params == null) {
                this.astExpression = new SQLSelectItemAllColumns(this.sqlContext);
            } else {
                this.astExpression = this.astAggregate.params.extract(0);
                this.astAggregate.params.dispose();
                this.astAggregate.params = null;
            }
        }
        if (this.conditionType == ConditionType.None) {
            this.conditionType = this.getAggregate() != null || this.astExpression instanceof SQLExpressionAggregate ? ConditionType.Having : ConditionType.Where;
        }
    }

    public void startConditionsLoading() {
        this.conditionType = ConditionType.None;
    }

    private boolean isQueryWithGrouping() {
        for (int i = 0; i < this.criteriaList.getCount(); ++i) {
            if (!this.criteriaList.get(i).isGrouping()) continue;
            return true;
        }
        return false;
    }

    public MetadataField getExpressionField() {
        DataSource ds = this.getExpressionDatasource();
        if (ds == null) {
            return null;
        }
        SQLObjectColumn col = this.getExpressionColumnAST();
        if (col == null) {
            return null;
        }
        int i = ds.getFields().findFieldByName(col);
        if (i != -1) {
            return ds.getFields().get(i);
        }
        return null;
    }

    public void loadOrderByItemFromAST(SQLOrderByItem orderByItem) {
        this.sortType = orderByItem.sort == SQLOrderByOrders.Asc ? ItemSortType.Asc : ItemSortType.Desc;
        this.sortNullOrdering = orderByItem.nullOrdering;
        if (this.astOrderByItem != null) {
            this.astOrderByItem.dispose();
        }
        this.astOrderByItem = orderByItem;
        if (this.astOrderByItem.expression != null) {
            this.astOrderByItem.expression.dispose();
            this.astOrderByItem.expression = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillQueriesMenuItems(JPopupMenu menu, List subQueries) {
        for (int i = 0; i < subQueries.size(); ++i) {
            SQLSubSelectStatement a = ((SubSelectStatementProxy)subQueries.get(i)).generateASTTree(this.getSQLContext());
            try {
                CustomMenuItem item = new CustomMenuItem(Helpers.shortenQuery(a.getSimpleSQL(this.sqlContext.getSQLBuilderExpression())));
                item.setActionCommand("edit subquery");
                item.addActionListener(this);
                item.tag = subQueries.get(i);
                menu.add(item);
                continue;
            }
            finally {
                a.dispose();
            }
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(Helpers.localizer.getString("strMoveUp", "Move up"));
        item.setEnabled(this.criteriaList.indexOf(this) > 0);
        item.setActionCommand("move up");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strMoveDown", "Move down"));
        item.setEnabled(this.criteriaList.indexOf(this) < this.criteriaList.getCount() - 2);
        item.setActionCommand("move down");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(Helpers.localizer.getString("strRemoveItem", "Delete item"));
        item.setEnabled(this.criteriaList.indexOf(this) < this.criteriaList.getCount() - 1);
        item.setActionCommand("remove");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem(Helpers.localizer.getString("strInsertEmtyItem", "Insert empty item"));
        item.setEnabled(this.criteriaList.indexOf(this) < this.criteriaList.getCount() - 1);
        item.setActionCommand("insert");
        item.addActionListener(this);
        menu.add(item);
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        CriteriaListControl clc = this.criteriaList.getCriteriaListControl();
        int row = clc.getSelectedRow();
        int column = clc.getSelectedColumn();
        if (action.equals("move up")) {
            int i = this.criteriaList.indexOf(this);
            if (i > 0) {
                this.criteriaList.moveRow(i, i - 1);
                if (row == i) {
                    clc.setRowSelectionInterval(i - 1, i - 1);
                    clc.setColumnSelectionInterval(column, column);
                }
            }
        } else if (action.equals("move down")) {
            int i = this.criteriaList.indexOf(this);
            if (i < this.criteriaList.getCount() - 1) {
                this.criteriaList.moveRow(i, i + 1);
                if (row == i) {
                    clc.setRowSelectionInterval(i + 1, i + 1);
                    clc.setColumnSelectionInterval(column, column);
                }
            }
        } else if (action.equals("remove")) {
            this.dispose();
            if (row >= 0 && row < clc.getRowCount()) {
                clc.setRowSelectionInterval(row, row);
                clc.setColumnSelectionInterval(column, column);
            }
        } else if (action.equals("insert")) {
            this.criteriaList.insertEmptyRow(this.criteriaList.indexOf(this));
            clc.setRowSelectionInterval(row, row);
            clc.setColumnSelectionInterval(column, column);
        } else if (action.equals("edit subquery")) {
            this.queryBuilder.setActiveSubquery(((SubSelectStatementProxy)((CustomMenuItem)e.getSource()).tag).subQuery);
        }
    }

    public SQLOrderByNullOrdering getSortNullOrdering() {
        return this.sortNullOrdering;
    }

    public void setSortNullOrdering(SQLOrderByNullOrdering value) {
        if (value != this.sortNullOrdering) {
            this.beginUpdate();
            try {
                this.sortNullOrdering = value;
                this.notifySQLUpdated();
            }
            finally {
                this.endUpdate();
            }
        }
    }

    private boolean containsAggregateFunctions(AstNodeBase node) {
        ArrayList chldrn = new ArrayList();
        node.getMyChildren(chldrn);
        for (AstNodeBase child : chldrn) {
            boolean result = false;
            if (child instanceof SQLExpressionAggregate) {
                result = true;
            } else if (!(child instanceof SQLSubSelectStatement)) {
                result = this.containsAggregateFunctions(child);
            }
            if (!result) continue;
            return true;
        }
        return false;
    }

    public boolean isAggregatedExpression() {
        if (this.astExpression == null) {
            return false;
        }
        if (this.astAggregate != null) {
            return true;
        }
        if (this.astExpression instanceof SQLExpressionAggregate) {
            return true;
        }
        return this.containsAggregateFunctions(this.astExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAggregateNameStrInternal(SQLBuilder builder, SQLQualifiedName name) {
        String result;
        SQLExpressionAggregate exprAgg = new SQLExpressionAggregate(this.sqlContext);
        try {
            exprAgg.name = name;
            try {
                builder.beginBuild();
                try {
                    exprAgg.buildFunctionName(builder, builder.getMainQueryFormat());
                }
                finally {
                    builder.endBuild();
                }
                result = builder.getResult();
            }
            finally {
                exprAgg.name = null;
            }
        }
        finally {
            exprAgg.dispose();
        }
        return result;
    }

    private void createAliasFromFieldName() {
        if (this.getExpressionField() != null) {
            AstTokenIdentifier newAlias = this.getCriteriaList().createUniqueAlias(this.getExpressionField().getName().getQualifiedNameWithoutQuotes());
            try {
                this.setAliasString(newAlias.getToken());
            }
            finally {
                newAlias.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpressionStringUI(String value) {
        this.beginUpdate();
        try {
            boolean selectFlag = this.getExpression() == null;
            this.setExpressionString(value);
            if (selectFlag && this.isCanSelect()) {
                this.setSelected(true);
            }
            if (this.isSelected() && this.isQueryWithGrouping() && !this.isAggregatedExpression()) {
                this.setGrouping(true);
            }
            SQLExpressionItem expression = this.getExpression();
            if (!this.isSelected() && expression != null && expression instanceof SQLExpressionItem && expression.isLogical()) {
                int i;
                boolean[] affectedConditionColumns = new boolean[this.getCriteriaList().getMaxConditionCount()];
                for (i = 0; i < this.criteriaList.getCount(); ++i) {
                    CriteriaItem ci = this.criteriaList.get(i);
                    if (this.conditionType != ci.getConditionType()) continue;
                    for (int j = 0; j < ci.getConditionCount(); ++j) {
                        if (ci.getASTCondition(j) == null) continue;
                        affectedConditionColumns[j] = true;
                    }
                }
                for (i = 0; i < affectedConditionColumns.length; ++i) {
                    if (!affectedConditionColumns[i]) continue;
                    this.setConditionString(i, "=TRUE");
                }
            }
            if (this.isSelected() && this.getExpression() != null && this.astAlias == null && this.isColumnNamesConflict()) {
                if (this.isSupportsAlias()) {
                    this.createUniqueAlias();
                } else if (!this.queryBuilder.isResolveColumnNamingConflictsAutomatically()) {
                    this.queryBuilder.fireUserMessageEvent(UserMessageId.SelectingExpressionCausesConflict);
                } else {
                    this.criteriaList.assignAliasesToDuplicateColumnNames();
                    if (this.isColumnNamesConflict()) {
                        this.queryBuilder.fireUserMessageEvent(UserMessageId.SelectingExpressionCausesConflict);
                    }
                }
            }
            if (this.isSelected() && this.getExpression() != null && this.queryBuilder.getCriteriaListOptions().isCreateColumnAliasesForUnnamedColumns() && this.isSupportsAlias() && this.isUnnamedColumn()) {
                this.createUniqueAlias();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setAliasStringUI(String value) {
        this.beginUpdate();
        try {
            this.setAliasString(value);
            if (this.isSupportsAlias() && this.isColumnNamesConflict()) {
                if (this.astAlias == null) {
                    this.queryBuilder.fireUserMessageEvent(UserMessageId.DeletingAliasCausesConflict);
                } else {
                    this.queryBuilder.fireUserMessageEvent(UserMessageId.ColumnNameAlreadyUsed);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    private void collectOccupiedColumnNamesFromField(MetadataField field, AstIdentifierList to) {
        SQLQualifiedName fieldName = field.getName();
        if (fieldName.getCount() == 1) {
            if (fieldName.get(0) instanceof AstTokenIdentifier) {
                to.add(((AstTokenIdentifier)fieldName.get(0)).clone(this.sqlContext));
            } else {
                to.add(new AstTokenIdentifier(this.sqlContext, fieldName.get(0).getToken()));
            }
        }
    }

    private void collectOccupiedColumnNamesFromFields(MetadataFieldList fields, AstIdentifierList to) {
        for (int i = 0; i < fields.getCount(); ++i) {
            this.collectOccupiedColumnNamesFromField(fields.get(i), to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnNamesConflict() {
        if (this.astExpression != null) {
            AstIdentifierList columnNames = this.getOccupiedColumnNames();
            try {
                for (int i = 0; i < columnNames.getCount(); ++i) {
                    if (this.getCriteriaList().isUniqueColumnName(columnNames.get(i), this)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                columnNames.dispose();
            }
        }
        return false;
    }

    public AstIdentifierList getOccupiedColumnNames() {
        AstIdentifierList result = new AstIdentifierList(this.sqlContext);
        if (this.astExpression != null) {
            if (this.astAlias != null && this.astAlias.alias != null && this.astAlias.alias instanceof AstTokenIdentifier) {
                result.add(((AstTokenIdentifier)this.astAlias.alias).clone(this.sqlContext));
            } else if (this.getExpressionField() != null) {
                this.collectOccupiedColumnNamesFromField(this.getExpressionField(), result);
            } else if (this.astExpression instanceof SQLSelectItemAllTableColumns && this.getExpressionDatasource() != null) {
                this.collectOccupiedColumnNamesFromFields(this.getExpressionDatasource().getFields(), result);
            } else if (this.astExpression instanceof SQLSelectItemAllColumns) {
                ArrayList dsl = new ArrayList();
                this.getCriteriaList().getUnionSubQuery().getFromClause().getDatasources(dsl);
                for (int i = 0; i < dsl.size(); ++i) {
                    this.collectOccupiedColumnNamesFromFields(((DataSource)dsl.get(i)).getFields(), result);
                }
            }
        }
        return result;
    }

    public String getAliasBaseName() {
        assert (this.isSupportsAlias());
        if (this.astExpression == null) {
            return "";
        }
        MetadataField expressionField = this.getExpressionField();
        if (expressionField != null && expressionField.getName().getCount() > 0) {
            return expressionField.getName().get(0).getToken();
        }
        ArrayList cl = new ArrayList();
        this.astExpression.getReferencedColumnsRecursive(cl);
        String result = cl.size() == 1 && ((SQLObjectColumn)cl.get(0)).getCount() > 0 ? ((SQLObjectColumn)cl.get(0)).get(0).getToken() : "Column";
        if (this.getAggregate() != null) {
            result = this.getAggregateName().getQualifiedNameWithoutQuotes() + "_" + result;
        }
        return result;
    }

    public boolean isUnnamedColumn() {
        AstIdentifierList occupiedColumnNames = this.getOccupiedColumnNames();
        try {
            boolean bl = occupiedColumnNames.getCount() == 0;
            return bl;
        }
        finally {
            occupiedColumnNames.dispose();
        }
    }

    public int getAliasStartIndex() {
        assert (this.isSupportsAlias());
        if (this.getExpression() == null) {
            return 0;
        }
        if (this.getExpressionField() != null && this.getExpressionField().getNameStr().length() > 0) {
            return 0;
        }
        ArrayList list = new ArrayList();
        this.getExpression().getReferencedColumnsRecursive(list);
        if (list.size() == 1 && ((SQLObjectColumn)list.get(0)).getCount() > 0) {
            return 0;
        }
        return 1;
    }

    public void createUniqueAlias() {
        AstTokenIdentifier newAlias = this.criteriaList.createUniqueAlias(this.getAliasBaseName(), this.getAliasStartIndex());
        try {
            this.setAliasString(newAlias.getToken());
        }
        finally {
            newAlias.dispose();
        }
    }

    private class CustomMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        public Object tag;

        private CustomMenuItem(String s) {
            super(s);
        }
    }
}

