/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.BasePropertiesDialog;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.querybuilder.AfterPropertiesDialogEvent;
import com.adbs.querybuilder.AfterUpdatedEventListener;
import com.adbs.querybuilder.BeforePropertiesDialogEvent;
import com.adbs.querybuilder.ComponentCreatedEvent;
import com.adbs.querybuilder.ComponentDestroyingEvent;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DestroyingEventListener;
import com.adbs.querybuilder.InternalSubqueriesLoader;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.SubSelectStatementProxy;
import com.adbs.utils.Helpers;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ControlOwner
implements Disposable {
    private static final long serialVersionUID = 1L;
    protected final BaseSQLContext sqlContext;
    private ControlOwner acOwner;
    protected final List<ControlOwner> children = new ArrayList<ControlOwner>();
    protected final QueryBuilder queryBuilder;
    private ArrayList<SubSelectStatementProxy> subQueryProxies = new ArrayList();
    private AstNode resultAST = null;
    private boolean controlsCreated = false;
    protected final ArrayList<Component> controls = new ArrayList();
    private ControlOwner updateParent = null;
    private int userSQLUpdating;
    private ArrayList<ControlOwner> updateChildren = new ArrayList();
    private int parentSQLUpdating;
    private int childUpdating;
    private int sqlUpdating;
    private boolean sqlUpdated;
    private boolean isDisposing = false;
    private ArrayList<EventListener> destroyingEventListenerList = new ArrayList();
    private ArrayList<EventListener> afterUpdatedEventListenerList = new ArrayList();

    public ControlOwner(ControlOwner owner, ControlOwner updateParent, QueryBuilder queryBuilder) {
        this.acOwner = owner;
        if (this.acOwner != null) {
            this.acOwner.registerChild(this);
        }
        this.queryBuilder = queryBuilder;
        this.sqlContext = queryBuilder.getSQLContext();
        this.setUpdateParent(updateParent);
    }

    @Override
    public void dispose() {
        this.isDisposing = true;
        try {
            this.fireDestroyingEvent(new EventObject(this));
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
        }
        if (this.controlsCreated) {
            this.destroyControls();
        }
        for (ControlOwner child : new ArrayList<ControlOwner>(this.children)) {
            child.dispose();
        }
        this.children.clear();
        this.setUpdateParent(null);
        assert (this.updateChildren.isEmpty());
        this.destroyCachedResultASTs();
        if (this.acOwner != null) {
            this.acOwner.unregisterChild(this);
        }
        this.acOwner = null;
        this.subQueryProxies.clear();
    }

    public ControlOwner getOwner() {
        return this.acOwner;
    }

    public void setOwner(ControlOwner owner) {
        this.acOwner = owner;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public boolean isControlsCreated() {
        return this.controlsCreated;
    }

    public int getControlsCount() {
        return 0;
    }

    public ControlOwner getUpdateParent() {
        return this.updateParent;
    }

    public void setUpdateParent(ControlOwner value) {
        if (this.updateParent != value) {
            int i;
            assert (value == null || this.isUpdateParentUnderOwnerControl(value));
            if (this.updateParent != null) {
                this.updateParent.unregisterUpdateChild(this);
            }
            ControlOwner oldUpdateParent = this.updateParent;
            ControlOwner newUpdateParent = value;
            for (i = 0; i < this.parentSQLUpdating; ++i) {
                if (newUpdateParent != null) {
                    newUpdateParent.beginUpdateParent();
                }
                if (oldUpdateParent == null) continue;
                oldUpdateParent.endUpdateParent();
            }
            if (newUpdateParent != null) {
                for (i = this.sqlUpdating; i < newUpdateParent.childUpdating; ++i) {
                    this.beginUpdateInternal();
                }
            }
            if (oldUpdateParent != null) {
                for (i = this.sqlUpdating; i > oldUpdateParent.childUpdating; --i) {
                    this.endUpdateInternal();
                }
            }
            this.updateParent = value;
            if (this.updateParent != null) {
                this.updateParent.registerUpdateChild(this);
            }
            assert (this.updateParent == null || this.updateParent.sqlUpdating >= this.sqlUpdating);
        }
    }

    public boolean isUpdating() {
        return this.sqlUpdating > 0;
    }

    protected AstNode getResultASTInternal() {
        return this.getOrGenerateResultAST();
    }

    public AstNode getResultAST() {
        AstNode result = this.getResultASTInternal();
        if (result != null) {
            result = result.clone(this.sqlContext);
        }
        return result;
    }

    protected boolean isDisposing() {
        return this.isDisposing;
    }

    protected void setDisposing(boolean value) {
        this.isDisposing = value;
    }

    private boolean registerChild(ControlOwner child) {
        this.children.add(child);
        return this.isUpdating();
    }

    private void unregisterChild(ControlOwner child) {
        this.children.remove(child);
    }

    public Component getControl(int index) {
        if (this.controls.size() > index) {
            return this.controls.get(index);
        }
        return null;
    }

    private AstNode getOrGenerateResultAST() {
        if (this.resultAST == null) {
            this.resultAST = this.createResultAST();
        }
        return this.resultAST;
    }

    public String getResultSQL() {
        return this.getResultSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public String getResultSQL(SQLBuilder builder) {
        AstNode ast = this.getOrGenerateResultAST();
        String result = ast != null ? ast.getSimpleSQL(builder) : "";
        return result;
    }

    private void beginUpdateParent() {
        ++this.parentSQLUpdating;
        assert (this.parentSQLUpdating > 0);
        if (this.updateParent != null) {
            this.updateParent.beginUpdateParent();
        } else {
            this.beginUpdateInternal();
        }
    }

    private void endUpdateParent() {
        --this.parentSQLUpdating;
        assert (this.parentSQLUpdating >= 0);
        if (this.updateParent != null) {
            this.updateParent.endUpdateParent();
        } else {
            this.endUpdateInternal();
        }
    }

    private void beginUpdateInternal() {
        assert (this.sqlUpdating >= 0);
        ++this.sqlUpdating;
        ++this.childUpdating;
        for (int i = 0; i < this.updateChildren.size(); ++i) {
            this.updateChildren.get(i).beginUpdateInternal();
        }
        assert (this.updateParent == null || this.updateParent.sqlUpdating >= this.sqlUpdating);
    }

    private void endUpdateInternal() {
        block10: {
            try {
                for (int i = this.updateChildren.size() - 1; i >= 0; --i) {
                    this.updateChildren.get(i).endUpdateInternal();
                }
                --this.childUpdating;
                if (this.sqlUpdating != 1 || !this.sqlUpdated) break block10;
                do {
                    try {
                        this.doSQLUpdated();
                    }
                    finally {
                        this.sqlUpdated = false;
                    }
                    this.destroyCachedResultASTs();
                    this.doAfterUpdated();
                    this.fireAfterUpdatedEvent(new EventObject(this));
                } while (this.sqlUpdated);
            }
            finally {
                --this.sqlUpdating;
            }
        }
        assert (this.sqlUpdating >= 0);
        assert (this.updateParent == null || this.updateParent.sqlUpdating >= this.sqlUpdating);
    }

    protected Component calcAcOwnerFromOwner(Component owner) {
        return owner;
    }

    protected void destroyCachedResultASTs() {
        if (this.resultAST != null) {
            this.resultAST.dispose();
        }
        this.resultAST = null;
    }

    protected AstNode createResultAST() {
        return null;
    }

    public boolean canCreateControls() {
        return this.acOwner != null && this.acOwner.isControlsCreated();
    }

    protected Component createControlInternal(int i) {
        return null;
    }

    protected void saveControlParams(int i) {
    }

    protected void restoreControlParams(int i) {
    }

    protected void updateContolParams(int i) {
    }

    protected boolean makeVisible(int i) {
        return true;
    }

    protected void doCreateControls() {
        Helpers.listSetSize(this.controls, this.getControlsCount(), false);
        for (int i = 0; i < this.getControlsCount(); ++i) {
            this.controls.set(i, this.createControlInternal(i));
            this.restoreControlParams(i);
            this.queryBuilder.fireComponentCreatedEvent(new ComponentCreatedEvent(this, this.controls.get(i)));
            if (!this.makeVisible(i)) continue;
            this.controls.get(i).setVisible(true);
        }
        this.controlsCreated = true;
        for (ControlOwner child : this.children) {
            child.createControls();
        }
    }

    protected void doDestroyControls() {
        int i;
        try {
            for (i = this.children.size() - 1; i >= 0; --i) {
                this.children.get(i).destroyControls();
            }
        }
        finally {
            this.controlsCreated = false;
        }
        if (this.getControlsCount() > 0) {
            for (i = this.getControlsCount() - 1; i >= 0; --i) {
                Component c = this.controls.get(i);
                if (c == null) continue;
                this.queryBuilder.fireComponentDestroyingEvent(new ComponentDestroyingEvent(this, this.controls.get(i)));
                this.saveControlParams(i);
                c.setVisible(false);
                if (c.getParent() != null) {
                    c.getParent().remove(c);
                }
                this.controls.set(i, null);
            }
        }
        this.controls.clear();
    }

    public void doUpdateContolParams() {
        if (!this.isDisposing() && this.isControlsCreated()) {
            if (this.getControlsCount() > 0) {
                for (int i = 0; i < this.getControlsCount(); ++i) {
                    if (this.controls.get(i) == null) continue;
                    this.updateContolParams(i);
                }
            }
            for (ControlOwner child : this.children) {
                child.doUpdateContolParams();
            }
        }
    }

    protected void registerUpdateChild(ControlOwner child) {
        if (this.updateChildren.indexOf(child) == -1) {
            this.updateChildren.add(child);
        }
    }

    protected void unregisterUpdateChild(ControlOwner child) {
        this.updateChildren.remove(child);
    }

    protected void doSQLUpdated() {
    }

    protected void doAfterUpdated() {
        if (!this.isDisposing && this.acOwner != null) {
            this.acOwner.notifySQLUpdated();
        }
    }

    protected void loadSubQueries(AstNode ast) {
        if (ast != null) {
            InternalSubqueriesLoader il = new InternalSubqueriesLoader();
            il.Loader = this;
            il.RootNode = ast;
            il.QueryBuilder = this.getQueryBuilder();
            ast.moveSubQueryInProxyRecursive(il, SubSelectStatementProxy.class);
        }
    }

    protected void collectSubqueryProxiesByRootNode(List list, AstNode rootNode) {
        for (SubSelectStatementProxy proxy : this.subQueryProxies) {
            if (proxy.rootNode != rootNode) continue;
            list.add(proxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSubqueryCountByRootNode(AstNode rootNode) {
        ArrayList subQueries = new ArrayList();
        try {
            this.collectSubqueryProxiesByRootNode(subQueries, rootNode);
            int n = subQueries.size();
            return n;
        }
        finally {
            subQueries.clear();
        }
    }

    protected void showSubQueriesPopup(Point pos, List subQueries) {
        JPopupMenu menu = new JPopupMenu();
        for (Object o : subQueries) {
            SQLSubSelectStatement a = ((SubSelectStatementProxy)o).generateASTTree(this.sqlContext);
            JMenuItem item = new JMenuItem(Helpers.shortenQuery(a.getSimpleSQL(this.sqlContext.getSQLBuilderExpression())));
            item.setActionCommand("edit subquery");
            item.addActionListener((SubSelectStatementProxy)o);
            menu.add(item);
        }
        this.queryBuilder.popupMenuPopup(menu, this.queryBuilder, this, pos);
    }

    protected void getASTChildren(List l) {
    }

    protected void getASTChildrenForSubtree(List l) {
        this.getASTChildren(l);
        for (ControlOwner child : this.children) {
            child.getASTChildrenForSubtree(l);
        }
    }

    protected boolean notifyDatasourceDestroyingInternal(DataSource datasource) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyDatasourceDestroying(DataSource datasource) {
        boolean result;
        this.beginUpdate();
        try {
            result = this.notifyDatasourceDestroyingInternal(datasource);
            if (!result) {
                for (int i = this.children.size() - 1; i >= 0; --i) {
                    if (!this.children.get(i).notifyDatasourceDestroying(datasource)) continue;
                    this.children.get(i).dispose();
                    this.notifySQLUpdated();
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return result;
    }

    protected void notifyDatasourceReplacedInternal(DataSource datasourceFrom, DataSource datasourceTo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDatasourceReplaced(DataSource datasourceFrom, DataSource datasourceTo) {
        this.beginUpdate();
        try {
            this.notifyDatasourceReplacedInternal(datasourceFrom, datasourceTo);
            for (int i = this.getChildrenCount() - 1; i >= 0; --i) {
                if (this.children.get(i) == datasourceFrom) continue;
                this.children.get(i).notifyDatasourceReplaced(datasourceFrom, datasourceTo);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void createControls() {
        if (!this.isControlsCreated()) {
            this.doCreateControls();
        }
    }

    public void destroyControls() {
        if (this.isControlsCreated()) {
            this.doDestroyControls();
        }
    }

    public void beginUpdate() {
        assert (this.userSQLUpdating >= 0);
        ++this.userSQLUpdating;
        assert (this.userSQLUpdating > 0);
        if (this.userSQLUpdating == 1) {
            this.beginUpdateParent();
        }
    }

    public void endUpdate() {
        --this.userSQLUpdating;
        assert (this.userSQLUpdating >= 0);
        if (this.userSQLUpdating == 0) {
            this.endUpdateParent();
        }
    }

    public void notifySQLUpdated() {
        boolean startUpdating;
        boolean bl = startUpdating = !this.isUpdating();
        if (startUpdating) {
            this.beginUpdate();
        }
        try {
            this.sqlUpdated = true;
            if (this.updateParent != null) {
                this.updateParent.notifySQLUpdated();
            }
        }
        finally {
            if (startUpdating) {
                this.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editProps(Window parent) {
        if (this.sqlContext.getSyntaxProvider() != null) {
            Class c;
            BeforePropertiesDialogEvent beforePropertiesDialogEvent = new BeforePropertiesDialogEvent(this.queryBuilder, this);
            this.queryBuilder.fireBeforePropertiesDialogEvent(beforePropertiesDialogEvent);
            if (!beforePropertiesDialogEvent.abort && (c = this.sqlContext.getSyntaxProvider().getEditPropsFormClass(this)) != null) {
                try {
                    Constructor constructor = c.getConstructor(Window.class);
                    BasePropertiesDialog d = (BasePropertiesDialog)constructor.newInstance(parent);
                    this.beginUpdate();
                    try {
                        if (d.edit(this, this.sqlContext)) {
                            this.notifySQLUpdated();
                        }
                        this.queryBuilder.fireAfterPropertiesDialogEvent(new AfterPropertiesDialogEvent(this.queryBuilder, this));
                    }
                    finally {
                        this.endUpdate();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(ControlOwner.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        return null;
    }

    private boolean isUpdateParentUnderOwnerControl(ControlOwner updateParent) {
        ControlOwner o;
        for (o = updateParent; o != this.acOwner; o = o.getOwner()) {
        }
        return o == this.acOwner;
    }

    public void notifySQLUpdatedRecursive() {
        boolean startUpdating;
        boolean bl = startUpdating = !this.isUpdating();
        if (startUpdating) {
            this.beginUpdate();
        }
        try {
            this.sqlUpdated = true;
            for (int i = 0; i < this.updateChildren.size(); ++i) {
                this.updateChildren.get(i).notifySQLUpdatedRecursive();
            }
            if (this.updateParent != null) {
                this.updateParent.notifySQLUpdated();
            }
        }
        finally {
            if (startUpdating) {
                this.endUpdate();
            }
        }
    }

    public void gatherPrepareAndFixupContext(List cteList, List fromSourceList, boolean inclParentQueryFromSources) {
        if (this.acOwner != null) {
            this.acOwner.gatherPrepareAndFixupContext(cteList, fromSourceList, inclParentQueryFromSources);
        }
    }

    void languageChanged() {
        for (ControlOwner child : this.children) {
            child.languageChanged();
        }
    }

    public void addDestroyingEventListener(EventListener listener) {
        this.destroyingEventListenerList.add(listener);
    }

    public void removeDestroyingEventListener(EventListener listener) {
        this.destroyingEventListenerList.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDestroyingEvent(EventObject evt) {
        List<EventListener> list;
        List<EventListener> list2 = list = Collections.synchronizedList(new ArrayList<EventListener>(this.destroyingEventListenerList));
        synchronized (list2) {
            ListIterator<EventListener> listeners = list.listIterator();
            while (listeners.hasNext()) {
                ((DestroyingEventListener)listeners.next()).destroyingEventOccurred(evt);
            }
        }
    }

    public void addAfterUpdatedEventListener(EventListener listener) {
        this.afterUpdatedEventListenerList.add(listener);
    }

    public void removeAfterUpdatedEventListener(EventListener listener) {
        this.afterUpdatedEventListenerList.remove(listener);
    }

    protected void fireAfterUpdatedEvent(EventObject evt) {
        Iterator<EventListener> listeners = this.afterUpdatedEventListenerList.iterator();
        while (listeners.hasNext()) {
            ((AfterUpdatedEventListener)listeners.next()).afterUpdatedEventOccurred(evt);
        }
    }

    void registerSubQueryProxy(SubSelectStatementProxy subQueryProxy) {
        this.subQueryProxies.add(subQueryProxy);
    }

    void unregisterSubQueryProxy(SubSelectStatementProxy subQueryProxy) {
        this.subQueryProxies.remove(subQueryProxy);
    }

    void collectVisibleDataSources(List<DataSource> dataSourceList) {
        if (this.acOwner != null) {
            if (this.acOwner instanceof DataSource) {
                this.acOwner.collectVisibleDataSources(dataSourceList);
                dataSourceList.remove((DataSource)this.acOwner);
            } else {
                this.acOwner.collectVisibleDataSources(dataSourceList);
            }
        }
    }

    void collectVisibleCTE(List<SQLWithClauseItem> cteList) {
        if (this.acOwner != null) {
            this.acOwner.collectVisibleCTE(cteList);
        }
    }

    public List<DataSource> getVisibleDataSources() {
        ArrayList<DataSource> dataSourceList = new ArrayList<DataSource>();
        this.collectVisibleDataSources(dataSourceList);
        return dataSourceList;
    }

    List<SQLWithClauseItem> getVisibleCTE() {
        ArrayList<SQLWithClauseItem> cteList = new ArrayList<SQLWithClauseItem>();
        this.collectVisibleCTE(cteList);
        return cteList;
    }

    void setIsDisposing() {
        this.isDisposing = true;
        for (ControlOwner child : this.children) {
            child.setIsDisposing();
        }
    }
}

