/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.metadata.MetadataDatabasesFetcherFromResultSet;
import com.adbs.metadata.MetadataObjectFetcherFromResultSet;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public class JdbcMetadataProvider
extends BaseMetadataProvider {
    private static final long serialVersionUID = 1L;
    private Connection connection;
    private SQLQualifiedName defaultDatabaseName = null;

    @Override
    public void dispose() {
        if (this.defaultDatabaseName != null) {
            this.defaultDatabaseName.dispose();
            this.defaultDatabaseName = null;
        }
        super.dispose();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection connection) {
        if (this.connection != connection) {
            this.connection = connection;
        }
    }

    @Override
    public boolean isConnected() {
        if (this.connection != null) {
            try {
                return !this.connection.isClosed();
            }
            catch (SQLException ex) {
                Logger.getLogger(JdbcMetadataProvider.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return false;
    }

    @Override
    protected void doDisconnect() {
        super.doDisconnect();
        try {
            this.checkConnectionSet();
            this.connection.close();
        }
        catch (Exception ex) {
            Logger.getLogger(JdbcMetadataProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void checkConnectionSet() throws QueryBuilderException {
        if (this.connection == null) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strNoConnectionObject", "No connection object (property %1$s not assigned)."), "Connection"));
        }
    }

    @Override
    protected ResultSet prepareSQLDatasetInternal(String sql, boolean schemaOnly) throws QueryBuilderException {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean prepareStatementUnsupported = false;
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            try {
                try {
                    this.connection.setHoldability(2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                statement = this.connection.prepareStatement(sql, 1003, 1007);
                statement.execute();
                resultSet = statement.getResultSet();
            }
            catch (UnsupportedOperationException unsupported) {
                prepareStatementUnsupported = true;
            }
            if (prepareStatementUnsupported || resultSet == null) {
                Statement stmt = this.connection.createStatement();
                resultSet = stmt.executeQuery(sql);
            }
        }
        catch (Throwable ex) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorExecQuery", "%2$s\n\nQuery:\n%1$s"), sql, ex.getMessage()), ex);
        }
        return resultSet;
    }

    @Override
    protected void execSQLInternal(String sql) throws QueryBuilderException {
        Statement statement = null;
        try {
            if (!this.isConnected()) {
                this.connect();
            }
            statement = this.connection.prepareStatement(sql, 1003, 1007, 2);
            statement.execute();
        }
        catch (Exception ex) {
            throw new QueryBuilderException(String.format(Helpers.localizer.getString("strErrorExecQuery", "%2$s\n\nQuery:\n%1$s"), sql, ex.getMessage()), ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) {
        if (this.defaultDatabaseName != null) {
            return this.defaultDatabaseName;
        }
        this.defaultDatabaseName = new SQLQualifiedName(sqlContext);
        try {
            String s;
            if (!this.isConnected()) {
                this.connect();
            }
            if (!Str.IsNullOrEmpty(s = this.connection.getCatalog())) {
                this.defaultDatabaseName.addName(s, false);
            }
        }
        catch (Exception ex) {
            this.defaultDatabaseName = null;
        }
        return this.defaultDatabaseName;
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        DatabaseMetaData metadata = null;
        MetadataDatabasesFetcherFromResultSet mdf = null;
        ResultSet resultSet = null;
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            mdf = new MetadataDatabasesFetcherFromResultSet(sqlContext);
            metadata = this.connection.getMetaData();
            resultSet = metadata.getCatalogs();
            mdf.setNameFieldName("TABLE_CAT");
            mdf.setResultSet(resultSet);
            mdf.loadDatabases(databaseList);
        }
        catch (Exception ex) {
            throw new QueryBuilderException("JdbcMetadataProvider: Failed to load database list.\n" + ex.getMessage(), ex);
        }
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        DatabaseMetaData metadata = null;
        MetadataObjectFetcherFromResultSet mof = null;
        ResultSet resultSet = null;
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            mof = new MetadataObjectFetcherFromResultSet(sqlContext);
            metadata = this.connection.getMetaData();
            resultSet = metadata.getTables(null, null, null, null);
            if (sqlContext.getSyntaxProvider().isSupportSchemas()) {
                mof.setSchemaFieldName("TABLE_SCHEM");
            }
            mof.setNameFieldName("TABLE_NAME");
            mof.setTypeFieldName("TABLE_TYPE");
            mof.setTableType(new String[]{"TABLE"});
            mof.setSystemTableType(new String[]{"SYSTEM TABLE"});
            mof.setViewType(new String[]{"VIEW"});
            mof.setSynonymType(new String[]{"SYNONYM", "ALIAS"});
            mof.setResultSet(resultSet);
            mof.loadMetadata(metadataContainer, metadataFilter, database);
        }
        catch (Exception ex) {
            throw new QueryBuilderException("JdbcMetadataProvider: Failed to load metadata objects.\n" + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        DatabaseMetaData metadata = null;
        Object mrf = null;
        ResultSet resultSet = null;
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            metadata = this.connection.getMetaData();
            for (int i = 0; i < metadataContainer.getCount(); ++i) {
                MetadataObject mo = metadataContainer.get(i);
                if (!(mo instanceof MetadataTable)) continue;
                try {
                    resultSet = metadata.getExportedKeys(mo.getDatabaseStr(), mo.getSchemaStr(), mo.getNameStr());
                }
                catch (SQLException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "This JDBC driver does not support DatabaseMetaData.getExportedKeys() method.");
                    if (resultSet != null) {
                        try {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            resultSet = null;
                        }
                    }
                    return;
                }
                if (resultSet == null) continue;
                while (resultSet.next()) {
                    MetadataRelation r = mo.getRelations().add();
                    r.getKeyFields().add(resultSet.getString(4));
                    r.setChildDatabaseStr(resultSet.getString(5));
                    r.setChildSchemaStr(resultSet.getString(6));
                    r.setChildNameStr(resultSet.getString(7));
                    r.getChildFields().add(resultSet.getString(8));
                }
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                    continue;
                }
                catch (Exception exception) {
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                        continue;
                    }
                    catch (Exception exception2) {
                        continue;
                    }
                    finally {
                        resultSet = null;
                    }
                }
                finally {
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        resultSet = null;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new QueryBuilderException("JdbcMetadataProvider: Failed to load metadata relations.\n" + ex.getMessage(), ex);
        }
    }

    @Override
    public String getDescription() {
        return "JDBC Metadata Provider";
    }

    @Override
    public boolean canCreateInternalConnection() {
        return true;
    }

    @Override
    public JPanel createConnectionEditFrame(Component owner) {
        return null;
    }

    static {
        Helpers.metadataProviderList.registerMetadataProvider(JdbcMetadataProvider.class);
    }
}

