/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;

public class StatsColumn
implements Disposable {
    private BaseSQLContext sqlContext;
    private MetadataField metadataField;
    private MetadataObject metadataObject;
    private SQLQualifiedName objectName;
    private SQLQualifiedName name;

    public StatsColumn(BaseSQLContext sqlContext, MetadataObject metadataObject, SQLQualifiedName objectName, MetadataField metadataField, SQLQualifiedName name) {
        assert (objectName != null);
        assert (name != null);
        this.sqlContext = sqlContext;
        this.metadataObject = metadataObject;
        this.objectName = objectName.clone(sqlContext);
        this.metadataField = metadataField;
        this.name = name.clone(sqlContext);
    }

    @Override
    public void dispose() {
        this.objectName.dispose();
        this.name.dispose();
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public MetadataObject getMetadataObject() {
        return this.metadataObject;
    }

    public SQLQualifiedName getObjectName() {
        return this.objectName;
    }

    public MetadataField getMetadataField() {
        return this.metadataField;
    }

    public SQLQualifiedName getName() {
        return this.name;
    }

    public void assign(Object source) {
        if (source instanceof StatsColumn) {
            this.metadataObject = ((StatsColumn)source).getMetadataObject();
            this.objectName.assign(((StatsColumn)source).getObjectName());
            this.metadataField = ((StatsColumn)source).getMetadataField();
            this.name.assign(((StatsColumn)source).getName());
        }
    }
}

