/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionList;
import com.adbs.ast.SQLGroupByType;

public class SQLGroupByList
extends SQLExpressionList {
    public SQLGroupByType groupByType = SQLGroupByType.None;
    public boolean groupByStar;

    public SQLGroupByList(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLGroupByList) {
            this.groupByStar = ((SQLGroupByList)source).groupByStar;
            this.groupByType = ((SQLGroupByList)source).groupByType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.groupByType != SQLGroupByType.None) {
            switch (this.groupByType) {
                case Cube: {
                    builder.writeKeyword("Cube");
                    break;
                }
                case Rollup: {
                    builder.writeKeyword("Rollup");
                }
            }
            builder.writeSymbol("(");
        }
        if (!this.groupByStar) {
            AstNodeWithList separator = new AstNodeWithList(this.sqlContext);
            try {
                if (format.getGroupByFormat().getNewLineBeforeComma()) {
                    separator.addNewLine();
                }
                separator.addSymbol(",");
                if (format.getGroupByFormat().getNewLineAfterItem()) {
                    separator.addNewLine();
                } else {
                    separator.addSpace();
                }
                this.buildList(builder, format, separator);
            }
            finally {
                separator.dispose();
            }
        } else {
            builder.writeSymbol("*");
        }
        if (this.groupByType != SQLGroupByType.None) {
            builder.writeSymbol(")");
        }
    }

    public void buildGroupByKeywords(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Group");
        builder.space();
        builder.writeKeyword("By");
    }
}

