/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLExpressionList;
import com.adbs.ast.SQLFromSource;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLFromFunction
extends SQLFromSource {
    public SQLDatabaseObject name;
    public SQLExpressionList params;

    public SQLFromFunction(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLFromFunction.class.getField("name"));
            l.add(SQLFromFunction.class.getField("params"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLFromFunction.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void buildFunctionNameExpression(SQLBuilder builder, SQLBuilderSelectFormat format) {
        assert (this.name != null);
        MetadataObject metadataObject = this.getMetadataObject();
        if (metadataObject != null && builder.isUseAltNames() && !Str.IsNullOrEmpty(metadataObject.getAltName())) {
            metadataObject.getAltNameId().buildSQL(builder, format);
        } else {
            this.name.buildQualifiedNameNamesFull(builder, format);
            this.name.buildQualifiedNameDBLink(builder, format);
        }
    }

    public void buildParamsExpression(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.params != null && this.params.getCount() > 0 || this.sqlContext.getSyntaxProvider().isSupportEmptyBracketsInStoredProcs()) {
            builder.writeSymbol("(");
            if (this.params != null) {
                AstNodeWithList separator = new AstNodeWithList(this.sqlContext);
                separator.addSymbol(",");
                separator.addSpace();
                this.params.buildList(builder, format, separator);
                separator.dispose();
            }
            builder.writeSymbol(")");
        }
    }

    @Override
    public void buildExpression(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildFunctionNameExpression(builder, format);
        this.buildParamsExpression(builder, format);
    }

    @Override
    public void calcFieldList(List cteList, List fromSourceList, boolean calcFieldUsageStats) throws QueryBuilderException {
        int i;
        MetadataObject mo = this.getMetadataObject();
        if (mo != null && !mo.getFields().isLoaded()) {
            this.getMetadataObject().loadFieldsOnDemand();
        }
        if (mo != null && mo.getFields().isLoaded()) {
            this.getFieldList().assign(mo.getFields());
        } else {
            this.getFieldList().clear();
            if (!this.sqlContext.getMetadataContainer().isOfflineMode()) {
                String parameters = "";
                if (this.params != null) {
                    for (i = 0; i < this.params.getCount(); ++i) {
                        if (!Str.IsNullOrEmpty(parameters)) {
                            parameters = parameters + ",";
                        }
                        parameters = parameters + "null";
                    }
                }
                this.sqlContext.loadFieldsForQuery(this.sqlContext.getSyntaxProvider().getQueryToLoadFieldsForProcedure("", this.getFunctionNameExpression(this.sqlContext.getSQLBuilderExpressionForServer()), parameters), this.getFieldList());
                if (mo != null && this.getFieldList().isLoaded()) {
                    mo.getFields().assign(this.getFieldList());
                    if (mo instanceof MetadataProcedure && this.params != null) {
                        for (i = 0; i < this.params.getCount(); ++i) {
                            ((MetadataProcedure)mo).getParameters().add();
                        }
                        ((MetadataProcedure)mo).getParameters().setLoaded(true);
                    }
                }
            }
        }
        if (mo != null && mo.getFields().isLoaded()) {
            this.getFieldList().assign(mo.getFields());
            if (calcFieldUsageStats) {
                for (i = 0; i < this.getFieldList().getCount(); ++i) {
                    MetadataField f1 = this.getFieldList().get(i);
                    MetadataField f2 = mo.getFields().get(i);
                    f1.prepareStatsCollections();
                    f1.getUsedDatabaseObjects().addObject(mo, mo.getFullName());
                    f1.getUsedDatabaseObjectColumns().addColumn(mo, mo.getFullName(), f2, f2.getName());
                }
            }
            return;
        }
        if (calcFieldUsageStats) {
            for (i = 0; i < this.getFieldList().getCount(); ++i) {
                MetadataField f1 = this.getFieldList().get(i);
                f1.prepareStatsCollections();
                f1.getUsedDatabaseObjects().addObject(null, this.name);
                f1.getUsedDatabaseObjectColumns().addColumn(null, this.name, null, f1.getName());
            }
        }
    }

    public String getFunctionNameExpression(SQLBuilder builder) {
        builder.beginBuild();
        try {
            this.buildFunctionNameExpression(builder, builder.getMainQueryFormat());
        }
        finally {
            builder.endBuild();
        }
        return builder.getResult();
    }

    @Override
    public void restoreColumnPrefixRecursive(boolean restore) {
        ArrayList ml = new ArrayList();
        if (restore) {
            this.restoreColumnPrefix();
        }
        this.getMyChildren(ml);
        for (int i = 0; i < ml.size(); ++i) {
            ((AstNodeBase)ml.get(i)).restoreColumnPrefixRecursive(ml.get(i) != this.name);
        }
    }

    @Override
    public boolean buildColumnPrefix(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.alias != null) {
            this.alias.buildAliasName(builder, format);
            return true;
        }
        return false;
    }
}

