/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.Pos;
import com.adbs.ast.Token;
import com.adbs.utils.Helpers;

public class ParsingException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public Pos errorPos;
    public String errorTokenValue;

    public ParsingException(String message) {
        super(message);
    }

    public ParsingException(String message, Token token) {
        super(String.format(message + "\n" + Helpers.localizer.getString("strUnexpectedTokenAt", "Unexpected token \"%1$s\" at line %2$s, pos %3$s"), token.val, token.pos.line, token.pos.col));
        this.errorPos = token.pos;
        this.errorTokenValue = token.val;
    }

    public ParsingException(String message, String token) {
        super(String.format(message + "\n" + Helpers.localizer.getString("strUnknownObjectName", "Unknown object name: \"%1$s\""), token));
        if (token != null) {
            this.errorTokenValue = token;
            this.errorPos.pos = -1;
            this.errorPos.col = -1;
        }
    }

    public ParsingException(String message, String token, Pos position) {
        super(String.format(message + "\n" + Helpers.localizer.getString("strUnknownObjectName", "Unknown object name: \"%1$s\""), token));
        this.errorPos = position;
        this.errorTokenValue = token;
    }
}

