/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataFilterApplyFor;
import com.adbs.ast.MetadataFilterItem;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.EnumSet;

public class MetadataFilter {
    ArrayList<MetadataFilterItem> items = new ArrayList();

    public MetadataFilterItem add() {
        MetadataFilterItem item = new MetadataFilterItem();
        this.items.add(item);
        return item;
    }

    public MetadataFilterItem insert(int index) {
        MetadataFilterItem item = new MetadataFilterItem();
        this.items.add(index, item);
        return item;
    }

    private MetadataFilterItem get(int index) {
        return this.items.get(index);
    }

    private int getCount() {
        return this.items.size();
    }

    private String replaceWildCards(String stringWildCard, String charWildCard, String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '%') {
                sb.append(stringWildCard);
                continue;
            }
            if (str.charAt(i) == '_') {
                sb.append(charWildCard);
                continue;
            }
            if (str.charAt(i) == '[') {
                ++i;
                while (i <= str.length() && str.charAt(i) != ']') {
                    sb.append(str.charAt(i));
                    ++i;
                }
                continue;
            }
            if (str.charAt(i) == '\"') {
                ++i;
                while (i <= str.length() && str.charAt(i) != '\"') {
                    sb.append(str.charAt(i));
                    ++i;
                }
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public String createPrefilterCondition(BaseSQLContext sqlContext, String schemaFieldName, String objectFieldName, EnumSet<MetadataFilterApplyFor> forObjects, String stringWildCard, String charWildCard) {
        String fir;
        String fir2;
        String fir1;
        MetadataFilterItem fi;
        int i;
        String incl = "";
        String excl = "";
        String upper = sqlContext.getSyntaxProvider().getUpperCaseFunctionName();
        for (i = 0; i < this.getCount(); ++i) {
            fi = this.get(i);
            if (!fi.getApplyFor().containsAll(forObjects) || fi.getExclude()) continue;
            fir1 = "";
            if (!Str.IsNullOrEmpty(fi.getSchemaMask()) && !fi.getSchemaMask().equals(String.valueOf('%'))) {
                fir1 = fi.isSchemaMaskCaseSensitive() ? "(" + schemaFieldName + " like '" + this.replaceWildCards(stringWildCard, charWildCard, fi.getSchemaMask()) + "')" : "(" + upper + "(" + schemaFieldName + ") like " + upper + "('" + this.replaceWildCards(stringWildCard, charWildCard, fi.getSchemaMask()) + "'))";
            }
            fir2 = "";
            if (!Str.IsNullOrEmpty(fi.getObjectMask()) && !fi.getObjectMask().equals(String.valueOf('%'))) {
                fir2 = fi.isObjectMaskCaseSensitive() ? "(" + objectFieldName + " like '" + this.replaceWildCards(stringWildCard, charWildCard, fi.getObjectMask()) + "')" : "(" + upper + "(" + objectFieldName + ") like " + upper + "('" + this.replaceWildCards(stringWildCard, charWildCard, fi.getObjectMask()) + "'))";
            }
            if (Str.IsNullOrEmpty(fir = !Str.IsNullOrEmpty(fir1) && !Str.IsNullOrEmpty(fir2) ? "(" + fir1 + ") and (" + fir2 + ")" : (!Str.IsNullOrEmpty(fir1) ? fir1 : (!Str.IsNullOrEmpty(fir2) ? fir2 : "")))) continue;
            if (!Str.IsNullOrEmpty(incl)) {
                incl = incl + "or";
            }
            incl = incl + fir;
        }
        for (i = 0; i < this.getCount(); ++i) {
            fi = this.get(i);
            if (!fi.getApplyFor().containsAll(forObjects) || !fi.getExclude()) continue;
            fir1 = "";
            if (!Str.IsNullOrEmpty(fi.getSchemaMask()) && !fi.getSchemaMask().equals(String.valueOf('%'))) {
                fir1 = fi.isSchemaMaskCaseSensitive() ? "(" + schemaFieldName + " not like '" + this.replaceWildCards(stringWildCard, charWildCard, fi.getSchemaMask()) + "')" : "(" + upper + "(" + schemaFieldName + ") not like " + upper + "('" + this.replaceWildCards(stringWildCard, charWildCard, fi.getSchemaMask()) + "'))";
            }
            fir2 = "";
            if (!Str.IsNullOrEmpty(fi.getObjectMask()) && !fi.getObjectMask().equals(String.valueOf('%'))) {
                fir2 = fi.isObjectMaskCaseSensitive() ? "(" + objectFieldName + " not like '" + this.replaceWildCards(stringWildCard, charWildCard, fi.getObjectMask()) + "')" : "(" + upper + "(" + objectFieldName + ") not like " + upper + "('" + this.replaceWildCards(stringWildCard, charWildCard, fi.getObjectMask()) + "'))";
            }
            if (Str.IsNullOrEmpty(fir = !Str.IsNullOrEmpty(fir1) && !Str.IsNullOrEmpty(fir2) ? "(" + fir1 + ") and (" + fir2 + ")" : (!Str.IsNullOrEmpty(fir1) ? fir1 : (!Str.IsNullOrEmpty(fir2) ? fir2 : "")))) continue;
            if (!Str.IsNullOrEmpty(excl)) {
                excl = excl + "and";
            }
            excl = excl + fir;
        }
        String result = !Str.IsNullOrEmpty(incl) && !Str.IsNullOrEmpty(excl) ? "(" + incl + ") and (" + excl + ")" : (!Str.IsNullOrEmpty(incl) ? incl : (!Str.IsNullOrEmpty(excl) ? excl : ""));
        return result;
    }

    public boolean filterMetadataObject(MetadataObject obj) {
        boolean result = true;
        if (this.getCount() > 0) {
            String mask;
            MetadataFilterItem fi;
            int i;
            EnumSet<MetadataFilterApplyFor> ot;
            if (obj instanceof MetadataTable) {
                ot = EnumSet.of(MetadataFilterApplyFor.Tables);
            } else if (obj instanceof MetadataView) {
                ot = EnumSet.of(MetadataFilterApplyFor.Views);
            } else if (obj instanceof MetadataProcedure) {
                ot = EnumSet.of(MetadataFilterApplyFor.Procedures);
            } else if (obj instanceof MetadataSynonym) {
                ot = EnumSet.of(MetadataFilterApplyFor.Synonyms);
            } else {
                return result;
            }
            boolean incl = false;
            boolean flag = false;
            for (i = 0; i < this.getCount(); ++i) {
                fi = this.get(i);
                if (fi.getExclude() || !fi.getApplyFor().containsAll(ot)) continue;
                flag = true;
                mask = fi.getSchemaMask();
                boolean bl = incl = Str.IsNullOrEmpty(mask) || mask.equals(String.valueOf('%'));
                if (!incl) {
                    incl = Helpers.matchesMask(mask, obj.getSchema().getToken(), fi.isSchemaMaskCaseSensitive());
                }
                if (incl) {
                    mask = fi.getObjectMask();
                    boolean bl2 = incl = Str.IsNullOrEmpty(mask) || mask.equals(String.valueOf('%'));
                    if (!incl) {
                        incl = Helpers.matchesMask(mask, obj.getName().getToken(), fi.isObjectMaskCaseSensitive());
                    }
                }
                if (incl) break;
            }
            if (flag && !incl) {
                return false;
            }
            boolean excl = false;
            flag = false;
            for (i = 0; i < this.getCount(); ++i) {
                fi = this.get(i);
                if (!fi.getExclude() || !fi.getApplyFor().containsAll(ot)) continue;
                flag = true;
                mask = fi.getSchemaMask();
                boolean bl = excl = Str.IsNullOrEmpty(mask) || mask.equals(String.valueOf('%'));
                if (!excl) {
                    excl = Helpers.matchesMask(mask, obj.getSchema().getToken(), fi.isSchemaMaskCaseSensitive());
                }
                if (excl) {
                    mask = fi.getObjectMask();
                    boolean bl3 = excl = Str.IsNullOrEmpty(mask) || mask.equals(String.valueOf('%'));
                    if (!excl) {
                        excl = Helpers.matchesMask(mask, obj.getName().getToken(), fi.isObjectMaskCaseSensitive());
                    }
                }
                if (excl) break;
            }
            result = !flag || !excl;
        }
        return result;
    }
}

