/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.utils.Helpers;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AstNodeWithCollection
extends AstNode {
    private Class itemClass;
    private ArrayList<AstNode> items = new ArrayList();

    public AstNodeWithCollection(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public AstNodeWithCollection(BaseSQLContext sqlContext, Class itemClass) {
        super(sqlContext);
        assert (itemClass != null);
        this.itemClass = itemClass;
    }

    public Class getItemClass() {
        return this.itemClass;
    }

    public void setItemClass(Class value) {
        if (this.itemClass != value) {
            this.itemClass = value;
            for (int i = 0; i < this.getCount(); ++i) {
                try {
                    Constructor c = this.itemClass.getConstructor(BaseSQLContext.class);
                    AstNode o = (AstNode)c.newInstance(this.sqlContext);
                    o.assign(this.get(i));
                    this.set(i, o);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(AstNodeWithCollection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public void setCount(int value) {
        Helpers.listSetSize(this.items, value, true);
    }

    public AstNode get(int index) {
        return this.items.get(index);
    }

    private void set(int index, AstNode value) {
        this.items.set(index, value);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof AstNodeWithCollection) {
            this.clear();
            for (int i = 0; i < ((AstNodeWithCollection)source).getCount(); ++i) {
                this.add().assign(((AstNodeWithCollection)source).get(i));
            }
        }
    }

    @Override
    public void getMyChildren(List list) {
        super.getMyChildren(list);
        int index = this.findFirstChildIndexForClass(AstNodeWithCollection.class);
        for (int i = this.getCount() - 1; i >= 0; --i) {
            list.add(index, this.get(i));
        }
    }

    @Override
    public void moveSubQueryInProxy(Object parameter, Class cls) {
        assert (cls != null);
        super.moveSubQueryInProxy(parameter, cls);
        if (this.itemClass == SQLSubSelectStatement.class || SQLSubSelectStatement.class.isAssignableFrom(this.itemClass)) {
            for (int i = 0; i < this.getCount(); ++i) {
                AstNodeBase o = this.items.get(i);
                if (o == null) continue;
                this.items.remove(i);
                try {
                    Constructor c = cls.getConstructor(BaseSQLContext.class, Object.class, AstNodeBase.class, AstNodeBase.class);
                    this.items.add(i, (AstNode)c.newInstance(this.sqlContext, parameter, this, o));
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(AstNodeWithCollection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public AstNode add() {
        AstNode result = null;
        try {
            Constructor c = this.itemClass.getConstructor(BaseSQLContext.class);
            result = (AstNode)c.newInstance(this.sqlContext);
            this.items.add(result);
            return result;
        }
        catch (Exception ex) {
            Logger.getLogger(AstNodeWithCollection.class.getName()).log(Level.SEVERE, null, ex);
            return result;
        }
    }

    public void delete(int index) {
        AstNode i = this.get(index);
        if (i != null) {
            i.dispose();
        }
        this.items.remove(index);
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.items.clear();
    }

    public AstNode insert(int index) {
        AstNode result = null;
        try {
            Constructor c = this.itemClass.getConstructor(BaseSQLContext.class);
            result = (AstNode)c.newInstance(this.sqlContext);
            this.items.add(index, result);
        }
        catch (Exception ex) {
            Logger.getLogger(AstNodeWithCollection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        super.buildSQLDirect(builder, format);
    }
}

