/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNode;
import com.adbs.ast.AstTraversable;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.PrepareAndFixupVisitor;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLSubSelectStatement;
import com.adbs.ast.StatsColumns;
import com.adbs.ast.StatsObjects;
import com.adbs.utils.Helpers;
import com.adbs.utils.Wrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AstNodeBase
implements Disposable {
    private StackTraceElement[] stackTrace;
    private AstFieldList astFieldList = new AstFieldList();
    protected BaseSQLContext sqlContext;
    protected StatsObjects usedDatabaseObjects;
    protected StatsColumns usedDatabaseObjectColumns;
    public Object data;

    public AstNodeBase(BaseSQLContext sqlContext) {
        assert (sqlContext != null);
        if (Helpers.collectDebugInfo) {
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
        this.sqlContext = sqlContext;
        this.getASTFields(this.astFieldList);
    }

    @Override
    public void dispose() {
        this.assertIsAlive();
        if (this.usedDatabaseObjectColumns != null) {
            this.usedDatabaseObjectColumns.dispose();
        }
        if (this.usedDatabaseObjects != null) {
            this.usedDatabaseObjects.dispose();
        }
        if (this.isAlive()) {
            ArrayList children = new ArrayList();
            this.getMyChildren(children);
            for (int i = 0; i < children.size(); ++i) {
                ((AstNodeBase)children.get(i)).dispose();
            }
        }
        this.astFieldList = null;
    }

    protected AstFieldList getAstFieldList() {
        return this.astFieldList;
    }

    public BaseSQLContext getSQLContext() {
        return this.sqlContext;
    }

    public StatsObjects getUsedDatabaseObjects() {
        return this.usedDatabaseObjects;
    }

    public StatsColumns getUsedDatabaseObjectColumns() {
        return this.usedDatabaseObjectColumns;
    }

    public boolean isAlive() {
        return this.astFieldList != null;
    }

    public void assertIsAlive() {
        boolean alive = this.isAlive();
        if (!alive) {
            if (Helpers.collectDebugInfo) {
                System.err.println("Object is disposed twice. [" + this.getClass().getName() + "] created at:");
                for (StackTraceElement elem : this.stackTrace) {
                    System.err.println(elem);
                }
                System.err.println("");
            } else assert (false) : "Object is disposed twice. [" + this.getClass().getName() + "]";
        }
    }

    protected void getASTFields(AstFieldList l) {
        this.assertIsAlive();
    }

    protected AstNodeBase cloneInternal(BaseSQLContext sqlContext) {
        this.assertIsAlive();
        AstNodeBase result = null;
        try {
            Constructor<?> c = this.getClass().getConstructor(BaseSQLContext.class);
            result = (AstNodeBase)c.newInstance(sqlContext);
            result.assign(this);
        }
        catch (Exception ex) {
            Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    protected void buildASTField(AstNode field, SQLBuilder builder, SQLBuilderSelectFormat format, boolean writeSpaceAfter) {
        this.assertIsAlive();
        if (field != null) {
            field.buildSQL(builder, format);
            if (writeSpaceAfter) {
                builder.space();
            }
        }
    }

    protected void buildASTField(AstNode field, SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.assertIsAlive();
        this.buildASTField(field, builder, format, false);
    }

    public void getMyChildren(List list) {
        this.assertIsAlive();
        for (int i = 0; i < this.astFieldList.getCount(); ++i) {
            AstNodeBase o = null;
            try {
                o = (AstNodeBase)this.astFieldList.fields.get(i).get(this);
            }
            catch (Exception ex) {
                Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (o == null) continue;
            list.add(o);
        }
    }

    public void prepareCalcStatistics() {
        this.assertIsAlive();
        if (this.usedDatabaseObjects == null) {
            this.usedDatabaseObjects = new StatsObjects(this.sqlContext);
        }
        if (this.usedDatabaseObjectColumns == null) {
            this.usedDatabaseObjectColumns = new StatsColumns(this.sqlContext);
        }
        this.usedDatabaseObjects.clear();
        this.usedDatabaseObjectColumns.clear();
    }

    protected int calcStatistics() {
        this.assertIsAlive();
        int result = 0;
        ArrayList ml = new ArrayList();
        this.getMyChildren(ml);
        for (int i = 0; i < ml.size(); ++i) {
            AstNodeBase node = (AstNodeBase)ml.get(i);
            result += this.usedDatabaseObjects.addObjects(node.getUsedDatabaseObjects());
            result += this.usedDatabaseObjectColumns.addColumns(node.getUsedDatabaseObjectColumns());
        }
        return result;
    }

    public void simplifyTree() {
        this.assertIsAlive();
    }

    public void moveSubQueryInProxy(Object parameter, Class cls) {
        this.assertIsAlive();
        AstFieldList fl = new AstFieldList();
        this.getASTFields(fl);
        for (int i = 0; i < fl.getCount(); ++i) {
            try {
                AstNodeBase o = (AstNodeBase)fl.fields.get(i).get(this);
                if (o == null || !(o instanceof SQLSubSelectStatement)) continue;
                Constructor c = cls.getConstructor(BaseSQLContext.class, Object.class, AstNodeBase.class, SQLSubSelectStatement.class);
                fl.fields.get(i).set(this, c.newInstance(this.sqlContext, parameter, this, o));
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    protected void removeReferencesToDatasourceInternal(SQLFromSource fs) {
        for (int i = 0; i < this.astFieldList.getCount(); ++i) {
            try {
                Field fieldInfo = this.astFieldList.fields.get(i);
                AstNodeBase o = (AstNodeBase)fieldInfo.get(this);
                if (o == null) continue;
                ArrayList dsl = new ArrayList();
                o.getReferencedDatasourcesRecursive(dsl);
                if (dsl.indexOf(fs) == -1) continue;
                o.dispose();
                this.astFieldList.fields.get(i).set(this, null);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void getReferencedDatasources(List l) {
        this.assertIsAlive();
    }

    public void getReferencedColumns(List l) {
        this.assertIsAlive();
    }

    public void assign(Object source) {
        this.assertIsAlive();
        assert (source != null) : "AstNodeBase.assign(): source is null";
        if (source instanceof AstNodeBase) {
            assert (((AstNodeBase)source).isAlive()) : "AstNodeBase.assign(): source is disposed";
            this.data = ((AstNodeBase)source).data;
            if (((AstNodeBase)source).getUsedDatabaseObjects() != null || ((AstNodeBase)source).getUsedDatabaseObjectColumns() != null) {
                this.prepareCalcStatistics();
                if (((AstNodeBase)source).getUsedDatabaseObjectColumns() != null) {
                    this.usedDatabaseObjectColumns.assign(((AstNodeBase)source).getUsedDatabaseObjectColumns());
                }
                if (((AstNodeBase)source).getUsedDatabaseObjects() != null) {
                    this.usedDatabaseObjects.assign(((AstNodeBase)source).getUsedDatabaseObjects());
                }
            }
            AstFieldList dl = this.astFieldList;
            AstFieldList sl = ((AstNodeBase)source).getAstFieldList();
            for (int i = 0; i < dl.getCount(); ++i) {
                try {
                    Object oldValue = dl.fields.get(i).get(this);
                    if (oldValue != null) {
                        ((AstNodeBase)oldValue).dispose();
                    }
                    if (i < sl.getCount() && sl.fields.get(i).getDeclaringClass() == dl.fields.get(i).getDeclaringClass()) {
                        Object value = sl.fields.get(i).get(source);
                        if (value != null) {
                            dl.fields.get(i).set(this, ((AstNodeBase)value).clone(this.sqlContext));
                            continue;
                        }
                        dl.fields.get(i).set(this, null);
                        continue;
                    }
                    dl.fields.get(i).set(this, null);
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public Object clone(BaseSQLContext sqlContext) {
        this.assertIsAlive();
        return this.cloneInternal(sqlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseASTTreeDepthFirst(AstTraversable traversable) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        try {
            this.getMyChildren(ml);
            for (int i = 0; i < ml.size(); ++i) {
                AstNodeBase nb = (AstNodeBase)ml.get(i);
                traversable.addNodeToListIfParameter(nb);
                nb.traverseASTTreeDepthFirst(traversable);
            }
        }
        finally {
            ml.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseASTTreeSiblingFirst(AstTraversable traversable) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        try {
            int i;
            this.getMyChildren(ml);
            for (i = 0; i < ml.size(); ++i) {
                traversable.addNodeToListIfParameter((AstNodeBase)ml.get(i));
            }
            for (i = 0; i < ml.size(); ++i) {
                ((AstNodeBase)ml.get(i)).traverseASTTreeDepthFirst(traversable);
            }
        }
        finally {
            ml.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMyChildrenRecursive(Wrapper<List> list) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        try {
            int i;
            this.getMyChildren(ml);
            for (i = 0; i < ml.size(); ++i) {
                ((List)list.value).add(ml.get(i));
            }
            for (i = 0; i < ml.size(); ++i) {
                ((AstNodeBase)ml.get(i)).getMyChildrenRecursive(list);
            }
        }
        finally {
            ml.clear();
        }
    }

    public void prepareAndFixupRecursive(List cteList, List fromSourcesList) {
        this.assertIsAlive();
        PrepareAndFixupVisitor fixuper = new PrepareAndFixupVisitor(false);
        fixuper.fixupInContext(this, cteList, fromSourcesList);
    }

    public void prepareAndFixupRecursive(List cteList, List fromSourcesList, boolean calcFieldUsageStats) {
        this.assertIsAlive();
        PrepareAndFixupVisitor fixuper = new PrepareAndFixupVisitor(calcFieldUsageStats);
        fixuper.fixupInContext(this, cteList, fromSourcesList);
    }

    public void simplifyTreeRecursive() {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        try {
            this.getMyChildren(ml);
            for (int i = 0; i < ml.size(); ++i) {
                ((AstNodeBase)ml.get(i)).simplifyTree();
            }
        }
        finally {
            ml.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSubQueryInProxyRecursive(Object parameter, Class cls) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        this.moveSubQueryInProxy(parameter, cls);
        try {
            this.getMyChildren(ml);
            for (int i = 0; i < ml.size(); ++i) {
                ((AstNodeBase)ml.get(i)).moveSubQueryInProxyRecursive(parameter, cls);
            }
        }
        finally {
            ml.clear();
        }
    }

    public boolean removeReferencesToDatasource(SQLFromSource fs) {
        ArrayList ml = new ArrayList();
        this.getMyChildren(ml);
        for (AstNodeBase node : ml) {
            node.removeReferencesToDatasource(fs);
        }
        this.removeReferencesToDatasourceInternal(fs);
        ArrayList dsl = new ArrayList();
        this.getReferencedDatasourcesRecursive(dsl);
        return dsl.indexOf(fs) == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getReferencedColumnsRecursive(List l) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        this.getReferencedColumns(l);
        try {
            this.getMyChildren(ml);
            for (int i = 0; i < ml.size(); ++i) {
                ((AstNodeBase)ml.get(i)).getReferencedColumnsRecursive(l);
            }
        }
        finally {
            ml.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getReferencedDatasourcesRecursive(List l) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        this.getReferencedDatasources(l);
        try {
            this.getMyChildren(ml);
            for (int i = 0; i < ml.size(); ++i) {
                ((AstNodeBase)ml.get(i)).getReferencedDatasourcesRecursive(l);
            }
        }
        finally {
            ml.clear();
        }
    }

    public void prepareCalcStatisticsRecursive() {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        this.prepareCalcStatistics();
        this.getMyChildren(ml);
        for (int i = 0; i < ml.size(); ++i) {
            ((AstNodeBase)ml.get(i)).prepareCalcStatisticsRecursive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calcStatisticsRecursive() {
        this.assertIsAlive();
        int result = 0;
        ArrayList ml = new ArrayList();
        try {
            this.getMyChildren(ml);
            for (Object n : ml) {
                result += ((AstNodeBase)n).calcStatisticsRecursive();
            }
        }
        finally {
            ml.clear();
        }
        return result += this.calcStatistics();
    }

    protected void restoreColumnPrefix() {
        this.assertIsAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreColumnPrefixRecursive(boolean restore) {
        this.assertIsAlive();
        ArrayList ml = new ArrayList();
        if (restore) {
            this.restoreColumnPrefix();
        }
        try {
            this.getMyChildren(ml);
            for (Object n : ml) {
                ((AstNodeBase)n).restoreColumnPrefixRecursive(true);
            }
        }
        finally {
            ml.clear();
        }
    }

    protected boolean replaceReferencesToDatasource(SQLFromSource fsFrom, SQLFromSource fsTo) {
        return false;
    }

    public boolean replaceReferencesToDatasourceRecursive(SQLFromSource fsFrom, SQLFromSource fsTo) {
        boolean result = this.replaceReferencesToDatasource(fsFrom, fsTo);
        ArrayList ml = new ArrayList();
        this.getMyChildren(ml);
        for (int i = 0; i < ml.size(); ++i) {
            if (ml.get(i) == fsFrom) continue;
            result = ((AstNodeBase)ml.get(i)).replaceReferencesToDatasourceRecursive(fsFrom, fsTo) || result;
        }
        return result;
    }

    protected int findFirstChildIndexForClass(Class type) {
        Class<?> t;
        int result = 0;
        Class<?> currentType = this.getClass();
        for (int i = 0; i < this.astFieldList.getCount() && (t = this.astFieldList.fields.get(i).getDeclaringClass()) != currentType && !t.isAssignableFrom(currentType); ++i) {
            AstNodeBase o = null;
            try {
                o = (AstNodeBase)this.astFieldList.fields.get(i).get(this);
            }
            catch (Exception ex) {
                Logger.getLogger(AstNodeBase.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (o == null) continue;
            ++result;
        }
        return result;
    }
}

