/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.model.java.source.tree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ide.model.java.source.tree.ExpressionT;

public interface LiteralExpressionT
extends ExpressionT {
    public LiteralKind getLiteralKind();

    public static final class LiteralKind {
        private static final Map values = new LinkedHashMap();
        private static final int VALUE_INT = 0;
        private static final int VALUE_LONG = 1;
        private static final int VALUE_FLOAT = 2;
        private static final int VALUE_DOUBLE = 3;
        private static final int VALUE_BOOLEAN = 4;
        private static final int VALUE_CHAR = 5;
        private static final int VALUE_STRING = 6;
        private static final int VALUE_NULL = 7;
        public static final LiteralKind INT = new LiteralKind(0, "INT");
        public static final LiteralKind LONG = new LiteralKind(1, "LONG");
        public static final LiteralKind FLOAT = new LiteralKind(2, "FLOAT");
        public static final LiteralKind DOUBLE = new LiteralKind(3, "DOUBLE");
        public static final LiteralKind BOOLEAN = new LiteralKind(4, "BOOLEAN");
        public static final LiteralKind CHAR = new LiteralKind(5, "CHAR");
        public static final LiteralKind STRING = new LiteralKind(6, "STRING");
        public static final LiteralKind NULL = new LiteralKind(7, "NULL");
        private final int ordinal;
        private final String name;

        private LiteralKind(int ordinal, String name) {
            this.ordinal = ordinal;
            this.name = name;
            values.put(name, this);
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name();
        }

        public int ordinal() {
            return this.ordinal;
        }

        public int hashCode() {
            return this.ordinal();
        }

        public int compareTo(LiteralKind other) {
            return this.ordinal() - other.ordinal();
        }

        public boolean equals(Object other) {
            if (other instanceof LiteralKind) {
                LiteralKind tk = (LiteralKind)other;
                return this.ordinal() == tk.ordinal();
            }
            return false;
        }

        public Class getDeclaringClass() {
            return LiteralKind.class;
        }

        public static LiteralKind valueOf(int ordinal) {
            return LiteralKind.values()[ordinal];
        }

        public static LiteralKind valueOf(Class ignored, String name) {
            return (LiteralKind)values.get(name);
        }

        public static LiteralKind[] values() {
            Collection entries = values.values();
            return entries.toArray(new LiteralKind[entries.size()]);
        }
    }
}

