/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.OnDemandElementVisitor;
import javax.ide.menu.spi.MenuModel;
import javax.ide.menu.spi.SectionVisitor;
import javax.ide.menu.spi.Toolbar;
import javax.ide.menu.spi.ToolbarVisitorListener;

final class ToolbarsVisitor
extends OnDemandElementVisitor {
    private static final ElementName TOOLBAR = ToolbarsVisitor.element("toolbar");
    private ToolbarVisitorListener _listener;
    private final ElementVisitor _toolbarHandler = new ToolbarHandler();

    ToolbarsVisitor() {
    }

    private static final ElementName element(String name) {
        return new ElementName("http://jcp.org/jsr/198/extension-manifest", name);
    }

    @Override
    protected void startImpl(ElementStartContext context) {
        context.registerChildVisitor(TOOLBAR, this._toolbarHandler);
    }

    public void addToolbarVistorListener(ToolbarVisitorListener listener) {
        super.addRegListener(listener);
        this._listener = listener;
    }

    public void removeToolbarVistorListener(ToolbarVisitorListener listener) {
        super.removeRegListener(listener);
        this._listener = null;
    }

    private class ToolbarHandler
    extends ElementVisitor {
        private final ElementVisitor _sectionHandler = new SectionVisitor();

        private ToolbarHandler() {
        }

        @Override
        public void start(ElementStartContext context) {
            String id = context.getAttributeValue("id");
            if (id == null || (id = id.trim()).length() == 0) {
                this.log(context, Level.SEVERE, "Missing required attribute 'id'.");
                return;
            }
            if (ToolbarsVisitor.this._listener != null) {
                ToolbarsVisitor.this._listener.addedToToolbar(id);
            }
            MenuModel model = (MenuModel)context.getScopeData().get("menuModel");
            Toolbar toolbar = model.findOrCreateToolbar(id);
            context.getScopeData().put("sectionContainer", toolbar);
            context.registerChildVisitor(SectionVisitor.SECTION, this._sectionHandler);
        }
    }
}

