/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

public final class SimpleGlobMatcher {
    private final String _pattern;
    private final boolean _caseSensitive;

    public SimpleGlobMatcher(String pattern) {
        this(pattern, false);
    }

    public SimpleGlobMatcher(String pattern, boolean caseSensitive) {
        if (pattern == null) {
            throw new NullPointerException("pattern is null");
        }
        this._pattern = caseSensitive ? pattern : pattern.toLowerCase();
        this._caseSensitive = caseSensitive;
    }

    public boolean matches(String target) {
        if (target == null) {
            throw new NullPointerException("target is null");
        }
        return this.matchImpl(target, this._pattern);
    }

    private boolean matchImpl(String target, String pattern) {
        if (!this._caseSensitive) {
            target = target.toLowerCase();
        }
        int ppos = 0;
        int tpos = 0;
        int tlen = target.length();
        int plen = pattern.length();
        while (tpos != tlen) {
            char pchar = pattern.charAt(ppos);
            char pnext = this.nextChar(pattern, ppos, plen);
            char tchar = target.charAt(tpos);
            char tnext = this.nextChar(target, tpos, tlen);
            if (pchar == '*') {
                ++tpos;
                if (pnext == '\u0000' || tnext == '\u0000' || pnext != tnext) continue;
                ++ppos;
                continue;
            }
            if (pchar != tchar) {
                return false;
            }
            ++tpos;
            ++ppos;
        }
        return ppos == plen;
    }

    private char nextChar(String string, int pos, int length) {
        return pos + 1 < length ? string.charAt(pos + 1) : (char)'\u0000';
    }
}

