/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension;

import javax.ide.util.Version;

public final class ExtensionDependency {
    private final String _id;
    private final Version _minVersion;
    private final Version _maxVersion;

    public ExtensionDependency(String id) {
        this(id, null, null);
    }

    public ExtensionDependency(String id, Version min, Version max) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        this._id = id;
        this._minVersion = min;
        this._maxVersion = max;
    }

    public String getID() {
        return this._id;
    }

    public Version getMinimumVersion() {
        return this._minVersion;
    }

    public Version getMaximumVersion() {
        return this._maxVersion;
    }

    public String toString() {
        return "ExtensionDependency[ id=" + this._id + ", _minVersion=" + String.valueOf(this._minVersion) + ", _maxVersion=" + String.valueOf(this._maxVersion) + " ]";
    }

    public int hashCode() {
        int result = 42;
        result = 37 * result + this._id.hashCode();
        if (this._minVersion != null) {
            result = 37 * result + this._minVersion.hashCode();
        }
        if (this._maxVersion != null) {
            result = 37 * result + this._maxVersion.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtensionDependency)) {
            return false;
        }
        ExtensionDependency that = (ExtensionDependency)o;
        if (!that.getID().equals(this.getID())) {
            return false;
        }
        if (that.getMinimumVersion() != this.getMinimumVersion() && that.getMinimumVersion() != null && !that.getMinimumVersion().equals(this.getMinimumVersion())) {
            return false;
        }
        return that.getMaximumVersion() == this.getMaximumVersion() || that.getMaximumVersion() == null || that.getMaximumVersion().equals(this.getMaximumVersion());
    }
}

