/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.Compiler;
import oracle.jdevimpl.runner.RunItemActions;

public class RunItemListener
implements BuildSystemListener {
    public void buildWillStart(Context context) {
        this.updateActions();
    }

    public void buildFinished(int errorCount, int warningCount, int infoCount) {
        final Timer timer = new Timer("RunItemListener_WaitBuildFinished");
        TimerTask task = new TimerTask(){
            Context context = new Context();

            @Override
            public void run() {
                if (!Compiler.getCompiler().isBusy(this.context)) {
                    timer.cancel();
                    RunItemListener.this.updateActions();
                }
            }
        };
        timer.schedule(task, 10L, 50L);
    }

    private void updateActions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunItemActions.getInstance().updateRunDebugActions();
            }
        });
    }

    public void cleanWillStart(Context context) {
    }

    public void cleanFinished(Context context) {
    }
}

