/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.tasks;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.pgql.PgqlResources;
import oracle.dbtools.pgql.commands.PgqlScriptRunnerPanel;
import oracle.dbtools.pgql.editor.PGQLEditor;
import oracle.dbtools.pgql.tasks.PgqlRaptorTask;
import oracle.dbtools.pgql.utils.PgqlResultSetUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ir.StatementType;

public class RunStatementTask<V>
extends PgqlRaptorTask<V> {
    private PGQLEditor pgqlEditorClass = null;

    public RunStatementTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        super(string, bl, iRaptorTaskRunMode);
    }

    public PGQLEditor getPgqlEditorClass() {
        return this.pgqlEditorClass;
    }

    public RunStatementTask<V> setPgqlEditorClass(PGQLEditor pGQLEditor) {
        this.pgqlEditorClass = pGQLEditor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected V doWork() throws TaskException {
        if (this.queries.length == 1) {
            String string = this.queries[0];
            long l = -1L;
            boolean bl = false;
            Component component = null;
            int n = this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1;
            PgqlResultSet pgqlResultSet = null;
            this.pgqlResultsPanelContext.getExecuter().setQuery(string);
            StatementType statementType = this.pgqlResultsPanelContext.getExecuter().getQueryType();
            IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater = this.getRaptorTaskProgressUpdater();
            try {
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage(PgqlResources.get("EXECUTING") + string);
                }
                switch (statementType) {
                    case SELECT: {
                        pgqlResultSet = this.pgqlResultsPanelContext.getExecuter().executeSelectQuery();
                        if (pgqlResultSet != null) {
                            component = this.showResultSetOnTable(pgqlResultSet);
                            break;
                        }
                        throw new PgqlException("Unable to load table of results. Please validate your query or try again later.");
                    }
                    case GRAPH_MODIFY: 
                    case CREATE_PROPERTY_GRAPH: 
                    case DROP_PROPERTY_GRAPH: {
                        bl = this.pgqlResultsPanelContext.getExecuter().executeNonSelectQuery();
                        l = this.pgqlResultsPanelContext.getExecuter().getModifyCount();
                        component = this.showQueryResultOnPanel(l, statementType);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(PgqlResources.getString("QUERYTYPE_NOT_AVAILABLE"));
                    }
                }
                if (iRaptorTaskProgressUpdater != null) {
                    iRaptorTaskProgressUpdater.checkCanProceed();
                }
                ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
                arrayList.add(this.closeListener);
                if (this.pgqlResultsPanelContext.getTabCount() == 0) {
                    this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                    if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                        this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                    }
                }
                Object object = PgqlResources.getString("PGQLEditor.ScriptOutput");
                if (statementType == StatementType.SELECT) {
                    Object object2;
                    if (this.pgqlResultsPanelContext.getLastNumberOfQueriesExecuted() == 1 && this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() > 0) {
                        this.pgqlResultsPanelContext.setTabCount(this.pgqlResultsPanelContext.getTabCount() - 1);
                        object2 = this.pgqlResultsPanelContext.getResultsPane().getTabModel();
                        DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)((DefaultListModel)object2).get(n);
                        this.pgqlResultsPanelContext.getResultsPane().removeTab(defaultCustomTabPage);
                    }
                    object2 = this.pgqlResultsPanelContext.getTabCount() > 0 ? " " + String.valueOf(this.pgqlResultsPanelContext.getTabCount()) : "";
                    object = PgqlResources.getString("PGQLEditor.QueryResult") + (String)object2;
                    if (this.pgqlResultsPanelContext.getTabCount() == 0) {
                        this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                        if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                            this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                        }
                    }
                    this.pgqlResultsPanelContext.setTabCount(this.pgqlResultsPanelContext.getTabCount() + 1);
                    this.pgqlResultsPanelContext.getResultsPane().addTab(OracleIcons.getIcon((String)"run.png"), (String)object, component, arrayList);
                    this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                    this.pgqlResultsPanelContext.setWasLastQueryStatement(true);
                } else {
                    if (!this.pgqlResultsPanelContext.getIsScriptResultTabOpen().booleanValue()) {
                        this.pgqlResultsPanelContext.getResultsPane().addTab(OracleIcons.getIcon((String)"run.png"), (String)object, component, arrayList);
                        this.pgqlResultsPanelContext.setIsScriptResultTabOpen(true);
                        this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                    } else {
                        this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getPanelIndex(component));
                    }
                    this.pgqlResultsPanelContext.setWasLastQueryStatement(false);
                }
                this.closeResultSet(pgqlResultSet);
            }
            catch (ExecutionException executionException) {
                this.pgqlResultsPanelContext.getExecuter().cancelQuery();
            }
            catch (IllegalArgumentException | PgqlToSqlException | PgqlException throwable) {
                DefaultCustomTabPage defaultCustomTabPage;
                Serializable serializable;
                if (this.pgqlResultsPanelContext.getLastNumberOfQueriesExecuted() == 1 && this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() > 0) {
                    this.pgqlResultsPanelContext.setTabCount(this.pgqlResultsPanelContext.getTabCount() - 1);
                    serializable = this.pgqlResultsPanelContext.getResultsPane().getTabModel();
                    defaultCustomTabPage = (DefaultCustomTabPage)((DefaultListModel)serializable).get(n);
                    this.pgqlResultsPanelContext.getResultsPane().removeTab(defaultCustomTabPage);
                }
                serializable = this.showErrorOnTab(throwable.toString());
                defaultCustomTabPage = new ArrayList();
                defaultCustomTabPage.add(this.closeListener);
                if (this.pgqlResultsPanelContext.getTabCount() == 0) {
                    this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                    if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                        this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                    }
                }
                String string2 = this.pgqlResultsPanelContext.getTabCount() > 0 ? " " + String.valueOf(this.pgqlResultsPanelContext.getTabCount()) : "";
                this.pgqlResultsPanelContext.setTabCount(this.pgqlResultsPanelContext.getTabCount() + 1);
                String string3 = PgqlResources.getString("PGQLEditor.QueryResult") + string2;
                this.pgqlResultsPanelContext.getResultsPane().addTab(this._problemIcon, string3, (Component)serializable, (List)defaultCustomTabPage);
                this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                this.pgqlResultsPanelContext.setWasLastQueryStatement(true);
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                this.closeResultSet(pgqlResultSet);
            }
            finally {
                this.closeResultSet(pgqlResultSet);
            }
            this.pgqlResultsPanelContext.setLastNumberOfQueriesExecuted(1);
        } else {
            for (String string : this.queries) {
                Object object;
                Object object3;
                PgqlResultSet pgqlResultSet = null;
                this.pgqlResultsPanelContext.getExecuter().setQuery(string);
                StatementType statementType = this.pgqlResultsPanelContext.getExecuter().getQueryType();
                long l = -1L;
                boolean bl = false;
                Component component = null;
                IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater = this.getRaptorTaskProgressUpdater();
                try {
                    if (iRaptorTaskProgressUpdater != null) {
                        iRaptorTaskProgressUpdater.checkCanProceed();
                        iRaptorTaskProgressUpdater.getDescriptor().setMessage(PgqlResources.get("EXECUTING") + string);
                    }
                    switch (statementType) {
                        case SELECT: {
                            pgqlResultSet = this.pgqlResultsPanelContext.getExecuter().executeSelectQuery();
                            if (pgqlResultSet == null) break;
                            component = this.showResultSetOnTable(pgqlResultSet);
                            break;
                        }
                        case GRAPH_MODIFY: 
                        case CREATE_PROPERTY_GRAPH: 
                        case DROP_PROPERTY_GRAPH: {
                            bl = this.pgqlResultsPanelContext.getExecuter().executeNonSelectQuery();
                            l = this.pgqlResultsPanelContext.getExecuter().getModifyCount();
                            component = this.showQueryResultOnPanel(l, statementType);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(PgqlResources.getString("QUERYTYPE_NOT_AVAILABLE"));
                        }
                    }
                    if (iRaptorTaskProgressUpdater != null) {
                        iRaptorTaskProgressUpdater.checkCanProceed();
                    }
                    ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
                    arrayList.add(this.closeListener);
                    if (this.pgqlResultsPanelContext.getTabCount() == 0) {
                        this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                        if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                            this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                        }
                    }
                    object3 = PgqlResources.getString("PGQLEditor.ScriptOutput");
                    if (statementType == StatementType.SELECT) {
                        object = this.pgqlResultsPanelContext.getTabCount() > 0 ? " " + String.valueOf(this.pgqlResultsPanelContext.getTabCount()) : "";
                        this.pgqlResultsPanelContext.setTabCount(this.pgqlResultsPanelContext.getTabCount() + 1);
                        object3 = PgqlResources.getString("PGQLEditor.QueryResult") + (String)object;
                        this.pgqlResultsPanelContext.getResultsPane().addTab(OracleIcons.getIcon((String)"run.png"), (String)object3, component, arrayList);
                        this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                        this.pgqlResultsPanelContext.setWasLastQueryStatement(true);
                    } else {
                        if (!this.pgqlResultsPanelContext.getIsScriptResultTabOpen().booleanValue()) {
                            this.pgqlResultsPanelContext.getResultsPane().addTab(OracleIcons.getIcon((String)"run.png"), (String)object3, component, arrayList);
                            this.pgqlResultsPanelContext.setIsScriptResultTabOpen(true);
                            this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                        } else {
                            this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getPanelIndex(component));
                        }
                        this.pgqlResultsPanelContext.setWasLastQueryStatement(false);
                    }
                    this.closeResultSet(pgqlResultSet);
                }
                catch (ExecutionException executionException) {
                    this.pgqlResultsPanelContext.getExecuter().cancelQuery();
                    break;
                }
                catch (IllegalArgumentException | PgqlToSqlException | PgqlException throwable) {
                    object3 = this.showErrorOnTab(throwable.toString());
                    object = new ArrayList<ITabCloseListner>();
                    object.add(this.closeListener);
                    if (this.pgqlResultsPanelContext.getTabCount() == 0) {
                        this.pgqlResultsPanelContext.getSplitPane().add((Component)this.pgqlResultsPanelContext.getResultsPane(), "bottom");
                        if (this.pgqlResultsPanelContext.getSplitPane().getBottomComponent() == null) {
                            this.pgqlResultsPanelContext.getSplitPane().setBottomComponent((Component)this.pgqlResultsPanelContext.getResultsPane());
                        }
                    }
                    String string4 = this.pgqlResultsPanelContext.getTabCount() > 0 ? " " + String.valueOf(this.pgqlResultsPanelContext.getTabCount()) : "";
                    this.pgqlResultsPanelContext.setTabCount(this.pgqlResultsPanelContext.getTabCount() + 1);
                    String string5 = PgqlResources.getString("PGQLEditor.QueryResult") + string4;
                    this.pgqlResultsPanelContext.getResultsPane().addTab(this._problemIcon, string5, (Component)object3, (List)object);
                    this.focusTab(this.pgqlResultsPanelContext.getResultsPane().getNumberOfTabs() - 1);
                    this.pgqlResultsPanelContext.setWasLastQueryStatement(true);
                    {
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                    this.closeResultSet(pgqlResultSet);
                }
                finally {
                    this.closeResultSet(pgqlResultSet);
                }
            }
            this.pgqlResultsPanelContext.setLastNumberOfQueriesExecuted(this.queries.length);
        }
        return null;
    }

    private Component showResultSetOnTable(PgqlResultSet pgqlResultSet) {
        DefaultTableModel defaultTableModel = PgqlResultSetUtils.resultSetToTableModel(pgqlResultSet);
        ResultSetTable resultSetTable = new ResultSetTable(PgqlResources.get("PGQLEditor.QueryResult"));
        resultSetTable.setColumnSelectorAvailable(true);
        resultSetTable.setModel((TableModel)defaultTableModel);
        JScrollPane jScrollPane = new JScrollPane((Component)resultSetTable, 22, 30);
        resultSetTable.getColumnModel().addColumnModelListener(this.pgqlEditorClass);
        JViewport jViewport = new JViewport();
        JTable jTable = resultSetTable.getRowHeader();
        jViewport.setView((Component)resultSetTable);
        jViewport.setPreferredSize(jTable.getMaximumSize());
        jScrollPane.setRowHeader(jViewport);
        jScrollPane.setViewportView((Component)resultSetTable);
        ColumnAutoSizer.autoResizeTable((JTable)resultSetTable, (String)ColumnAutoSizer.AUTO_FIT_OPTIMUM);
        return jScrollPane;
    }

    private Component showErrorOnTab(String string) {
        PgqlScriptRunnerPanel pgqlScriptRunnerPanel = new PgqlScriptRunnerPanel(PgqlResources.getString("PGQLEditor.QueryResult"), this.pgqlResultsPanelContext.getWorksheetContext());
        BasicEditorPane basicEditorPane = pgqlScriptRunnerPanel.getTextPane();
        basicEditorPane.setEditable(true);
        basicEditorPane.setText(string);
        basicEditorPane.setEditable(false);
        basicEditorPane.setCaretPosition(0);
        basicEditorPane.setEnabled(false);
        basicEditorPane.setDisabledTextColor(Color.BLACK);
        return pgqlScriptRunnerPanel;
    }
}

