/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.editor.insight;

import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.dbtools.pgql.editor.insight.PgqlInsightListDataItem;
import oracle.dbtools.pgql.editor.insight.PgqlInsightPlugin;
import oracle.javatools.editor.insight.ListInsightData;

public class PgqlInsightData
implements ListInsightData {
    private List<PgqlInsightListDataItem> keywords = new ArrayList<PgqlInsightListDataItem>();
    private DefaultListModel<PgqlInsightListDataItem> listModel;
    private PgqlInsightPlugin insight;

    public PgqlInsightData() {
        this.keywords.add(new PgqlInsightListDataItem("PATH"));
        this.keywords.add(new PgqlInsightListDataItem("SELECT"));
        this.keywords.add(new PgqlInsightListDataItem("FROM"));
        this.keywords.add(new PgqlInsightListDataItem("MATCH"));
        this.keywords.add(new PgqlInsightListDataItem("ON"));
        this.keywords.add(new PgqlInsightListDataItem("WHERE"));
        this.keywords.add(new PgqlInsightListDataItem("GROUP"));
        this.keywords.add(new PgqlInsightListDataItem("BY"));
        this.keywords.add(new PgqlInsightListDataItem("HAVING"));
        this.keywords.add(new PgqlInsightListDataItem("ORDER"));
        this.keywords.add(new PgqlInsightListDataItem("ASC"));
        this.keywords.add(new PgqlInsightListDataItem("DESC"));
        this.keywords.add(new PgqlInsightListDataItem("LIMIT"));
        this.keywords.add(new PgqlInsightListDataItem("OFFSET"));
        this.keywords.add(new PgqlInsightListDataItem("AND"));
        this.keywords.add(new PgqlInsightListDataItem("OR"));
        this.keywords.add(new PgqlInsightListDataItem("NOT"));
        this.keywords.add(new PgqlInsightListDataItem("true"));
        this.keywords.add(new PgqlInsightListDataItem("false"));
        this.keywords.add(new PgqlInsightListDataItem("IS"));
        this.keywords.add(new PgqlInsightListDataItem("NULL"));
        this.keywords.add(new PgqlInsightListDataItem("AS"));
        this.keywords.add(new PgqlInsightListDataItem("DATE"));
        this.keywords.add(new PgqlInsightListDataItem("TIME"));
        this.keywords.add(new PgqlInsightListDataItem("TIMESTAMP"));
        this.keywords.add(new PgqlInsightListDataItem("WITH"));
        this.keywords.add(new PgqlInsightListDataItem("ZONE"));
        this.keywords.add(new PgqlInsightListDataItem("DISTINCT"));
        this.keywords.add(new PgqlInsightListDataItem("COUNT"));
        this.keywords.add(new PgqlInsightListDataItem("MIN"));
        this.keywords.add(new PgqlInsightListDataItem("MAX"));
        this.keywords.add(new PgqlInsightListDataItem("AVG"));
        this.keywords.add(new PgqlInsightListDataItem("SUM"));
        this.keywords.add(new PgqlInsightListDataItem("ARRAY_AGG"));
        this.keywords.add(new PgqlInsightListDataItem("LISTAGG"));
        this.keywords.add(new PgqlInsightListDataItem("IN"));
        this.keywords.add(new PgqlInsightListDataItem("EXISTS"));
        this.keywords.add(new PgqlInsightListDataItem("CAST"));
        this.keywords.add(new PgqlInsightListDataItem("CASE"));
        this.keywords.add(new PgqlInsightListDataItem("WHEN"));
        this.keywords.add(new PgqlInsightListDataItem("THEN"));
        this.keywords.add(new PgqlInsightListDataItem("ELSE"));
        this.keywords.add(new PgqlInsightListDataItem("END"));
        this.keywords.add(new PgqlInsightListDataItem("EXTRACT"));
        this.keywords.add(new PgqlInsightListDataItem("YEAR"));
        this.keywords.add(new PgqlInsightListDataItem("MONTH"));
        this.keywords.add(new PgqlInsightListDataItem("DAY"));
        this.keywords.add(new PgqlInsightListDataItem("HOUR"));
        this.keywords.add(new PgqlInsightListDataItem("MINUTE"));
        this.keywords.add(new PgqlInsightListDataItem("SECOND"));
        this.keywords.add(new PgqlInsightListDataItem("TIMEZONE_HOUR"));
        this.keywords.add(new PgqlInsightListDataItem("TIMEZONE_MINUTE"));
        this.keywords.add(new PgqlInsightListDataItem("TOP"));
        this.keywords.add(new PgqlInsightListDataItem("SHORTEST"));
        this.keywords.add(new PgqlInsightListDataItem("CHEAPEST"));
        this.keywords.add(new PgqlInsightListDataItem("COST"));
        this.keywords.add(new PgqlInsightListDataItem("CREATE"));
        this.keywords.add(new PgqlInsightListDataItem("PROPERTY"));
        this.keywords.add(new PgqlInsightListDataItem("GRAPH"));
        this.keywords.add(new PgqlInsightListDataItem("VERTEX"));
        this.keywords.add(new PgqlInsightListDataItem("EDGE"));
        this.keywords.add(new PgqlInsightListDataItem("TABLES"));
        this.keywords.add(new PgqlInsightListDataItem("LABEL"));
        this.keywords.add(new PgqlInsightListDataItem("PROPERTIES"));
        this.keywords.add(new PgqlInsightListDataItem("ARE"));
        this.keywords.add(new PgqlInsightListDataItem("ALL"));
        this.keywords.add(new PgqlInsightListDataItem("COLUMNS"));
        this.keywords.add(new PgqlInsightListDataItem("EXCEPT"));
        this.keywords.add(new PgqlInsightListDataItem("NO"));
        this.keywords.add(new PgqlInsightListDataItem("INSERT"));
        this.keywords.add(new PgqlInsightListDataItem("UPDATE"));
        this.keywords.add(new PgqlInsightListDataItem("DELETE"));
        this.keywords.add(new PgqlInsightListDataItem("INTO"));
        this.keywords.add(new PgqlInsightListDataItem("LABELS"));
        this.keywords.add(new PgqlInsightListDataItem("SET"));
        this.keywords.add(new PgqlInsightListDataItem("BETWEEN"));
        this.listModel = new DefaultListModel();
        for (PgqlInsightListDataItem pgqlInsightListDataItem : this.keywords) {
            this.listModel.addElement(pgqlInsightListDataItem);
        }
    }

    public boolean complete(Object object) {
        int n = this.insight.getCaretPosition();
        PgqlInsightListDataItem pgqlInsightListDataItem = (PgqlInsightListDataItem)((Object)object);
        String string = this.getTypedWord();
        String string2 = pgqlInsightListDataItem.getDisplayText();
        String string3 = string2.substring(string.length());
        try {
            this.insight.getDocument().insertString(n, string3, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return false;
    }

    public Object[] getData() {
        return this.keywords.toArray();
    }

    public Object getDefault() {
        return this.keywords.stream().findFirst();
    }

    public Object[] getMatchingData() {
        String string = this.getTypedWord();
        Object[] objectArray = this.keywords.stream().filter(pgqlInsightListDataItem -> pgqlInsightListDataItem.getName().toUpperCase().startsWith(string)).toArray();
        return objectArray;
    }

    public int getMatchingDataCount() {
        String string = this.getTypedWord();
        Object[] objectArray = this.keywords.stream().filter(pgqlInsightListDataItem -> pgqlInsightListDataItem.getName().toUpperCase().startsWith(string)).toArray();
        return objectArray.length;
    }

    public void partialComplete() {
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setInsight(PgqlInsightPlugin pgqlInsightPlugin) {
        this.insight = pgqlInsightPlugin;
    }

    protected String getTypedWord() {
        int n;
        if (this.insight == null) {
            return "";
        }
        if (this.insight.getEditorPane() == null) {
            return "";
        }
        int n2 = this.insight.getCaretPosition();
        String string = null;
        try {
            string = this.insight.getDocument().getText(0, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        for (n = n2 - 1; n >= 0 && Character.isLetter(string.charAt(n)); --n) {
        }
        String string2 = string.substring(n + 1);
        return string2.toUpperCase();
    }
}

