/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.pgql.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.text.Document;
import oracle.dbtools.pgql.PgqlResources;
import oracle.dbtools.pgql.commands.PgqlScriptRunnerPanel;
import oracle.dbtools.pgql.editor.PGQLEditorNode;
import oracle.dbtools.pgql.editor.insight.PgqlInsightPlugin;
import oracle.dbtools.pgql.tasks.RunScriptTask;
import oracle.dbtools.pgql.tasks.RunStatementTask;
import oracle.dbtools.pgql.utils.PgqlQueryExecuter;
import oracle.dbtools.pgql.utils.PgqlResultsPanelContext;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.oviewer.base.AsynchronousViewerEditor;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageSupport;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.dbtools.worksheet.TextView;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.dbtools.worksheet.extension.WorksheetURLFileSystemHelper;
import oracle.ide.Context;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.view.StatusProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorOverview;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.icons.OracleIcons;

public class PGQLEditor
extends AsynchronousViewerEditor
implements LayoutControl,
StatusProvider,
BasicEditorPaneContainer,
TextView,
IDBEditor,
TableColumnModelListener,
IRaptorTaskListener {
    public String BASIC_QUERY = "SELECT e, v, n FROM MATCH (v)-[e]-(n) ON GRAPH1 LIMIT 100";
    private BasicEditorPane pgqlEditorPane = null;
    private EditorStatusBar statusBar = new EditorStatusBar();
    private BasicEditorOverview overview;
    private PgqlInsightPlugin insightPlugin = new PgqlInsightPlugin();
    private JComponent mainPanel;
    private JSplitPane splitPane;
    private WorksheetTabbedPane tabPanel;
    private WorksheetTabbedPane resultsTabPanel;
    private DBObject dbObject = null;
    private Connection connection;
    protected PgqlQueryExecuter pgqlQueryExecuter = null;
    ExecutorService executorService;
    WorksheetContext ctx;
    PgqlScriptRunnerPanel scriptRunnerPanel;
    BasicEditorPane editor;
    private Integer tabCount = 0;
    private Boolean isScriptResultTabOpen = false;
    private PgqlResultsPanelContext pgqlResultsPanelContext = null;

    public String getConnectionName() {
        return Connections.getInstance().getConnectionName(this.getConn());
    }

    public Database getDatabase() {
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(this.getConnectionName());
        }
        catch (DBException dBException) {
            Logger.severe(this.getClass(), (Throwable)dBException);
        }
        return database;
    }

    private Connection getConn() {
        if (this.getViewerNode() == null) {
            return null;
        }
        if (this.getViewerNode().getDBObject() == null) {
            return null;
        }
        return this.getViewerNode().getDBObject().getConnection();
    }

    public Connection getConnection() {
        return this.getConn();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    WorksheetTabbedPane getWorksheetTabbedPane() {
        return this.tabPanel;
    }

    public void appendText(String string) {
    }

    public void replaceText(String string) {
    }

    public BasicEditorPane getFocusedEditorPane() {
        return this.pgqlEditorPane;
    }

    public JComponent[] getCustomCells() {
        if (this.statusBar != null) {
            return this.statusBar.getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent jComponent) {
        return true;
    }

    protected JComponent createViewerUI() {
        Node node;
        Context context = this.getContext();
        this.dbObject = this.getViewerNode().getDBObject();
        if (!this.dbObject.getObjectName().equals("PG_FOLDER")) {
            if (this.dbObject.getObjectFolderType().equals("PG_VIEW_FOLDER")) {
                this.BASIC_QUERY = "SELECT e, v, n FROM MATCH (v)-[e]-(n) ON " + this.dbObject.getObjectName() + " LIMIT 100";
            }
        } else {
            this.BASIC_QUERY = "CREATE PROPERTY GRAPH MY_GRAPH";
        }
        if ((node = context.getNode()) instanceof PGQLEditorNode) {
            PGQLEditorNode pGQLEditorNode = (PGQLEditorNode)node;
            Connection connection = pGQLEditorNode.getDBObject().getConnection();
            this.setConnection(connection);
            this.pgqlQueryExecuter = new PgqlQueryExecuter(connection);
        } else {
            ViewerNode viewerNode = (ViewerNode)node;
            Connection connection = viewerNode.getDBObject().getConnection();
            this.setConnection(connection);
            this.pgqlQueryExecuter = new PgqlQueryExecuter(connection);
        }
        this.initPGQLEditor();
        SwingUtilities.invokeLater(() -> this.initToolbar());
        this.mainPanel = this.setSplittedPanel();
        return this.mainPanel;
    }

    protected void updateContent(boolean bl) {
    }

    protected void cleanUp() {
        this.mainPanel = null;
    }

    public Object getPrintable() {
        return this.mainPanel;
    }

    public String getTabLabel() {
        return PgqlResources.getString("PGQLEditor.Title");
    }

    private BasicEditorPane getCodeArea() {
        return this.pgqlEditorPane;
    }

    private void setCodeArea(BasicEditorPane basicEditorPane) {
        this.pgqlEditorPane = basicEditorPane;
    }

    private void initPGQLEditor() {
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        this.setCodeArea(basicEditorPane);
        BasicDocument basicDocument = (BasicDocument)this.getCodeArea().getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)"pgql"));
        PLSQLLanguageSupport pLSQLLanguageSupport = new PLSQLLanguageSupport();
        basicDocument.setLanguageSupport((LanguageSupport)pLSQLLanguageSupport);
        basicEditorPane.setDocument((Document)basicDocument);
        basicEditorPane.getDocument().putProperty("__EndOfLine__", "\n");
        basicEditorPane.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        basicEditorPane.installPlugin((EditorPlugin)lineGutterPlugin);
        basicEditorPane.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        this.overview = new BasicEditorOverview(basicEditorPane);
        SwingUtilities.invokeLater(() -> basicEditorPane.installPlugin((EditorPlugin)this.statusBar));
        basicEditorPane.installPlugin((EditorPlugin)this.insightPlugin);
        basicEditorPane.setEditable(true);
        basicEditorPane.setText(this.BASIC_QUERY);
        basicEditorPane.setCaretPosition(0);
    }

    private JComponent setSplittedPanel() {
        this.tabPanel = new WorksheetTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane((Component)this.getCodeArea()), "Center");
        jPanel.add((Component)this.overview.getGUI(), "East");
        this.tabPanel.addTab(null, PgqlResources.getString("PGQL"), (Component)jPanel);
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent((Component)this.tabPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.tabPanel.setPreferredSize(new Dimension(this.splitPane.getWidth(), this.splitPane.getHeight() / 2));
        this.splitPane.setResizeWeight(0.5);
        this.splitPane.setDividerLocation(0.5);
        this.resultsTabPanel = new WorksheetTabbedPane();
        this.splitPane.setAutoscrolls(true);
        this.resultsTabPanel.setPreferredSize(new Dimension(this.splitPane.getWidth(), this.splitPane.getHeight() / 2));
        this.setContentModelLoaded(true);
        return this.splitPane;
    }

    protected void initToolbar() {
        Toolbar toolbar = (Toolbar)UIUtils.findFirstOfType((JComponent)((JComponent)this.getFixedTopMargin()), Toolbar.class);
        ToggleAction toggleAction = new ToggleAction(PgqlResources.getString("RUN_QUERY"), OracleIcons.getIcon((String)"run.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                PGQLEditor.this.executorService = Executors.newSingleThreadExecutor();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        String string;
                        PGQLEditor.this.initRunScriptPanel();
                        if (PGQLEditor.this.pgqlResultsPanelContext == null) {
                            PGQLEditor.this.initResultsPanelContext();
                        }
                        String string2 = (string = PGQLEditor.this.pgqlEditorPane.getSelectedText()) == null ? PGQLEditor.this.pgqlEditorPane.getText() : string;
                        String[] stringArray = string2.split(";");
                        for (String string3 : stringArray) {
                            string3 = string3.trim();
                        }
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                        arrayList.removeAll(Arrays.asList("", "\n", null));
                        String[] stringArray2 = arrayList.toArray(new String[0]);
                        if (string == null) {
                            stringArray2 = new String[]{stringArray2[0]};
                        }
                        RunStatementTask runStatementTask = new RunStatementTask(PgqlResources.getString("PGQLEditor.QueryResult"), false, IRaptorTaskRunMode.MODAL);
                        runStatementTask.setPgqlEditorClass(PGQLEditor.this).setQueries(stringArray2).setPgqlResultsPanelContext(PGQLEditor.this.pgqlResultsPanelContext);
                        RaptorTaskManager.getInstance().addTask(runStatementTask);
                    }
                };
                PGQLEditor.this.executorService.execute(runnable);
                PGQLEditor.this.executorService.shutdown();
            }
        };
        ToggleAction toggleAction2 = new ToggleAction(PgqlResources.getString("RUN_SCRIPT"), WorksheetResources.getIcon((String)"RUN_SCRIPT_ICON")){

            public void actionPerformed(ActionEvent actionEvent) {
                PGQLEditor.this.executorService = Executors.newSingleThreadExecutor();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PGQLEditor.this.initRunScriptPanel();
                        if (PGQLEditor.this.pgqlResultsPanelContext == null) {
                            PGQLEditor.this.initResultsPanelContext();
                        }
                        String[] stringArray = PGQLEditor.this.getCodeArea().getText().split(";");
                        for (String string : stringArray) {
                            string = string.trim();
                        }
                        RunScriptTask runScriptTask = new RunScriptTask(PgqlResources.getString("PGQLEditor.ScriptOutput"), false, IRaptorTaskRunMode.MODAL);
                        runScriptTask.setQueries(stringArray).setPgqlResultsPanelContext(PGQLEditor.this.pgqlResultsPanelContext);
                        RaptorTaskManager.getInstance().addTask((RaptorTask)runScriptTask);
                    }
                };
                PGQLEditor.this.executorService.execute(runnable);
                PGQLEditor.this.executorService.shutdown();
            }
        };
        toggleAction.setName(toggleAction.getValue("Name").toString());
        toolbar.add(toggleAction);
        toggleAction2.setName(toggleAction2.getValue("Name").toString());
        toolbar.add(toggleAction2);
        toolbar.addSeparator();
    }

    private void initRunScriptPanel() {
        if (this.ctx == null) {
            this.ctx = this.getWorksheetContext(null);
        }
        if (this.scriptRunnerPanel == null && this.ctx != null) {
            this.scriptRunnerPanel = new PgqlScriptRunnerPanel(PgqlResources.getString("PGQLEditor.QueryResult"), this.ctx);
        }
        if (this.editor == null && this.ctx != null && this.scriptRunnerPanel != null) {
            this.editor = this.scriptRunnerPanel.getTextPane();
            this.editor.setAutoscrolls(true);
        }
    }

    private void initResultsPanelContext() {
        this.pgqlResultsPanelContext = new PgqlResultsPanelContext();
        this.pgqlResultsPanelContext.setExecuter(this.pgqlQueryExecuter).setEditor(this.editor).setStatementsEditor(this.pgqlEditorPane).setIsScriptResultTabOpen(this.isScriptResultTabOpen).setResultsPane(this.resultsTabPanel).setWorksheetContext(this.ctx).setScriptRunnerPane(this.scriptRunnerPanel).setSplitPane(this.splitPane).setTabCount(this.tabCount);
    }

    private String getConnQualifiedName() {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getViewerNode().getDBObject().getDatabase();
        return oracleDatabaseImpl.getQualifiedName();
    }

    private WorksheetContext getWorksheetContext(BasicEditorPane basicEditorPane) {
        WorksheetContext worksheetContext = new WorksheetContext();
        worksheetContext.setConnectionName(this.getConnQualifiedName());
        worksheetContext.setEditor(basicEditorPane);
        worksheetContext.setStatementRunner(false);
        worksheetContext.setCallback((WorksheetCallback)new Callback());
        URL uRL = this.getContext().getNode().getURL();
        worksheetContext.setFileURL(uRL);
        worksheetContext.setIsTemporaryFile(WorksheetURLFileSystemHelper.isWorksheetURL((URL)uRL));
        if (worksheetContext.isTemporaryFile()) {
            this.getContext().getNode().getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
        }
        return worksheetContext;
    }

    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    void addPanel(WorksheetResultPanel worksheetResultPanel) {
    }

    private class Callback
    implements WorksheetCallback {
        private WaitCursor m_cursor;

        private Callback() {
        }

        public void setEnabled(boolean bl) {
            if (bl && this.m_cursor != null) {
                this.m_cursor.hide();
                this.m_cursor = null;
            } else if (!bl && this.m_cursor == null) {
                this.m_cursor = new WaitCursor((Component)PGQLEditor.this.mainPanel);
                this.m_cursor.show();
            }
        }

        public void showResultPanel(final WorksheetResultPanel worksheetResultPanel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    PGQLEditor.this.addPanel(worksheetResultPanel);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void setStatusMessage(String string, Exception exception) {
        }

        public void focusPanel(WorksheetResultPanel worksheetResultPanel) {
            final WorksheetTabbedPane worksheetTabbedPane = PGQLEditor.this.getWorksheetTabbedPane();
            final int n = worksheetTabbedPane.getPanelIndex((Component)worksheetResultPanel.getGUI());
            if (n != -1) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        worksheetTabbedPane.setSelectedIndex(n);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
    }
}

