/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.resource.PlSqlBundle;
import oracle.javatools.db.token.Token;

@Deprecated
public class PlSqlFragment {
    private Type m_type;
    private AlterSubType m_alterSubType;
    private PlSqlToken m_firstToken;
    private PlSqlToken m_lastToken;
    private ArrayList<PlSqlFragment> m_subFragments;
    private PlSqlFragment m_parent;
    private WeakReference<PlSqlInterrogator> m_plsInt;
    private static final Type m_packageSpec = Type.PACKAGE_SPEC;
    public static final int TYPE_PACKAGE_SPEC = m_packageSpec.ordinal();
    private static final Type m_packageBody = Type.PACKAGE_BODY;
    public static final int TYPE_PACKAGE_BODY = m_packageBody.ordinal();

    PlSqlFragment(PlSqlInterrogator plSqlInterrogator, PlSqlFragment plSqlFragment) {
        this.initialise(plSqlInterrogator, plSqlFragment);
    }

    PlSqlFragment(PlSqlInterrogator plSqlInterrogator) {
        this.initialise(plSqlInterrogator, null);
    }

    private void initialise(PlSqlInterrogator plSqlInterrogator, PlSqlFragment plSqlFragment) {
        this.m_plsInt = new WeakReference<PlSqlInterrogator>(plSqlInterrogator);
        this.m_type = Type.UNKNOWN;
        this.m_firstToken = null;
        this.m_lastToken = null;
        this.m_subFragments = new ArrayList();
        this.m_parent = plSqlFragment;
        if (plSqlFragment != null) {
            plSqlFragment.m_subFragments.add(this);
        }
    }

    public PlSqlFragment getParent() {
        return this.m_parent;
    }

    @Deprecated
    public int getType() {
        return this.m_type.ordinal();
    }

    @Deprecated
    public Type getFramentType() {
        return this.getFragmentType();
    }

    public Type getFragmentType() {
        return this.m_type;
    }

    public void setFragmentType(Type type) {
        this.m_type = type;
    }

    public PlSqlToken getFirstToken() {
        return this.m_firstToken;
    }

    public void setAlterSubType(AlterSubType alterSubType) {
        this.m_alterSubType = alterSubType;
    }

    public AlterSubType getAlterSubType() {
        return this.m_alterSubType;
    }

    public void setFirstToken(PlSqlToken plSqlToken) {
        this.m_firstToken = plSqlToken;
    }

    public PlSqlToken getLastToken() {
        if (this.m_lastToken == null && this.m_firstToken != null) {
            this.m_lastToken = this.m_firstToken;
            while (this.m_lastToken.getNextCodeToken() != null && ((PlSqlToken)this.m_lastToken.getNextCodeToken()).getType() != Token.Type.END_MARKER) {
                this.m_lastToken = (PlSqlToken)this.m_lastToken.getNextCodeToken();
            }
        }
        return this.m_lastToken;
    }

    public void setLastToken(PlSqlToken plSqlToken) {
        this.m_lastToken = plSqlToken;
    }

    @Deprecated
    public final ArrayList getSubFragments() {
        return this.m_subFragments;
    }

    public PlSqlFragment[] getChildren() {
        return this.m_subFragments.toArray(new PlSqlFragment[this.m_subFragments.size()]);
    }

    public String getSource() {
        PlSqlToken plSqlToken = this.m_lastToken;
        if (plSqlToken == null) {
            plSqlToken = this.m_firstToken;
            while (plSqlToken.getType() != Token.Type.END_MARKER) {
                plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
            }
            plSqlToken = (PlSqlToken)plSqlToken.getPrevCodeToken();
        }
        return this.m_firstToken.getSource(false, plSqlToken);
    }

    public String getSourceSnippet(int n) {
        PlSqlToken plSqlToken = this.m_firstToken;
        PlSqlToken plSqlToken2 = this.m_lastToken;
        boolean bl = true;
        if (plSqlToken2 == null) {
            plSqlToken2 = this.m_firstToken;
            while (plSqlToken2.getType() != Token.Type.END_MARKER) {
                plSqlToken2 = (PlSqlToken)plSqlToken2.getNextToken();
            }
            plSqlToken2 = (PlSqlToken)plSqlToken2.getPrevCodeToken();
        }
        Object object = "";
        while (plSqlToken.getType() != Token.Type.END_MARKER && plSqlToken.getStart() <= plSqlToken2.getStart()) {
            if (((String)object).length() + plSqlToken.getSource().length() < n - 4) {
                if (plSqlToken.isCode()) {
                    if (!bl) {
                        object = (String)object + " ";
                    }
                    bl = true;
                    object = (String)object + plSqlToken.getSource();
                } else {
                    bl = false;
                }
            } else {
                object = (String)object + "...";
                break;
            }
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
        }
        return object;
    }

    public int getTreeKind() {
        return this.m_type.ordinal();
    }

    public int getStartOffset() {
        return this.m_firstToken.getStart();
    }

    public int getEndOffset() {
        if (this.m_lastToken == null) {
            PlSqlToken plSqlToken = this.m_firstToken;
            if (plSqlToken.getType() != Token.Type.END_MARKER) {
                while (((PlSqlToken)plSqlToken.getNextToken()).getType() != Token.Type.END_MARKER) {
                    plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
                }
            }
            this.m_lastToken = plSqlToken;
        }
        return this.m_lastToken.getEnd();
    }

    public String getTypeString() {
        return PlSqlFragment.getTypeString(this.m_type);
    }

    public static String getTypeString(Type type) {
        if (type == Type.PROCEDURE_FD) {
            type = Type.PROCEDURE;
        } else if (type == Type.FUNCTION_FD) {
            type = Type.FUNCTION;
        }
        String string = null;
        try {
            string = PlSqlBundle.get(type.toString());
        }
        catch (MissingResourceException missingResourceException) {
            string = PlSqlBundle.get("UNKNOWN");
        }
        return string;
    }

    @Deprecated
    public String getDescriptionString() {
        return this.getDescriptionImpl(true, null);
    }

    public String getDescription(Integer n) {
        return this.getDescriptionImpl(false, n);
    }

    private String getDescriptionImpl(boolean bl, Integer n) {
        Object object = null;
        if (bl) {
            object = PlSqlFragment.getTypeString(this.m_type);
        } else {
            object = this.m_type.toString().toLowerCase();
            int n2 = ((String)object).indexOf("_");
            if (n2 > 0) {
                object = ((String)object).substring(0, n2);
            }
        }
        switch (this.m_type) {
            case PARAMETER: {
                object = this.getFirstToken().getSource();
                break;
            }
            case DECLARATION: {
                if (this.getFirstToken().matches("TYPE") || this.getFirstToken().matches("SUBTYPE")) {
                    object = ((PlSqlToken)this.getFirstToken().getNextCodeToken()).getSource();
                    break;
                }
                if (this.getAlterSubType() != null && this.getFirstToken().matches("(")) {
                    object = ((PlSqlToken)this.getFirstToken().getNextCodeToken()).getSource() + "...";
                    break;
                }
                object = this.getFirstToken().getSource();
                break;
            }
            case CURSOR: {
                object = ((PlSqlToken)this.getFirstToken().getNextCodeToken()).getSource();
                break;
            }
            case TRIGGER_TIMING: 
            case TRIGGER_TABLE: {
                object = (String)object + ": " + this.getSource();
                break;
            }
            case PACKAGE_SPEC: 
            case TYPE_SPEC: 
            case TRIGGER: {
                PlSqlToken plSqlToken = (PlSqlToken)this.getFirstToken().getNextCodeToken();
                object = (String)object + ": " + this.getSourceToWS(plSqlToken);
                break;
            }
            case PACKAGE_BODY: 
            case TYPE_BODY: {
                PlSqlToken plSqlToken = (PlSqlToken)((PlSqlToken)this.getFirstToken().getNextCodeToken()).getNextCodeToken();
                object = (String)object + ": " + this.getSourceToWS(plSqlToken);
                break;
            }
            case PROCEDURE: 
            case PROCEDURE_FD: 
            case FUNCTION: 
            case FUNCTION_FD: {
                try {
                    PlSqlToken plSqlToken = this.getFirstToken();
                    while (!plSqlToken.matches("PROCEDURE") && !plSqlToken.matches("FUNCTION")) {
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    }
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    object = plSqlToken.getSource();
                    if ((plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken()).matches(".")) {
                        object = (String)object + plSqlToken.getSource();
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                        object = (String)object + plSqlToken.getSource();
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    }
                    if (plSqlToken.matches("(")) {
                        object = (String)object + plSqlToken.getSource();
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                        while (!(plSqlToken.matches(")") || plSqlToken.matches("IS") || plSqlToken.matches("AS") || plSqlToken.matches("RETURN") || plSqlToken.matches(";"))) {
                            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                            while (plSqlToken.matches("IN") || plSqlToken.matches("OUT") || plSqlToken.matches("NOCOPY")) {
                                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                            }
                            while (!(plSqlToken.matches(")") || plSqlToken.matches("DEFAULT") || plSqlToken.matches(":=") || plSqlToken.matches(","))) {
                                object = (String)object + plSqlToken.getSource();
                                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                            }
                            while (!plSqlToken.matches(")") && !plSqlToken.matches(",")) {
                                plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                            }
                            object = (String)object + plSqlToken.getSource() + " ";
                            if (plSqlToken.matches(")")) continue;
                            plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                        }
                        plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    } else {
                        object = (String)object + " ";
                    }
                    if (!plSqlToken.matches("RETURN")) break;
                    object = (String)object + ": ";
                    plSqlToken = (PlSqlToken)plSqlToken.getNextCodeToken();
                    while (plSqlToken.isCode() && !plSqlToken.matches(";")) {
                        object = (String)object + plSqlToken.getSource();
                        plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
                    }
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    break;
                }
            }
            case EX_WHEN: {
                PlSqlToken plSqlToken = (PlSqlToken)this.getFirstToken().getNextCodeToken();
                object = (String)object + ": " + this.getSourceToWS(plSqlToken);
                break;
            }
            case LABEL: {
                object = this.getSource();
                break;
            }
            case PLSQL_BLOCK: 
            case IF: 
            case ELSIF: 
            case ELSE: 
            case LOOP: 
            case FOR_LOOP: 
            case WHILE_LOOP: 
            case STATEMENT: 
            case PRAGMA: 
            case CASE: 
            case CASE_ELSE: 
            case CASE_WHEN: 
            case TYPE_ALTER_STATEMENT: {
                if (!bl) break;
                String string = "";
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < this.m_parent.getChildren().length; ++i) {
                    PlSqlFragment plSqlFragment = this.m_parent.getChildren()[i];
                    if (plSqlFragment.getFragmentType() == this.m_type) {
                        ++n3;
                    }
                    if (plSqlFragment != this) continue;
                    n4 = n3;
                }
                if (n3 <= true) break;
                object = (String)object + ": #" + String.valueOf(n4);
            }
        }
        if (n != null && n < 3) {
            n = 3;
        }
        if (n != null && ((String)object).length() > n) {
            object = ((String)object).substring(0, n - 3) + "...";
        }
        return object;
    }

    private String getSourceToWS(PlSqlToken plSqlToken) {
        Object object = "";
        while (plSqlToken.isCode()) {
            object = (String)object + plSqlToken.getSource();
            plSqlToken = (PlSqlToken)plSqlToken.getNextToken();
        }
        return object;
    }

    public PlSqlFragment findChild(Type type, boolean bl) {
        if (this.getFragmentType() == type) {
            return this;
        }
        for (PlSqlFragment plSqlFragment : this.getChildren()) {
            PlSqlFragment plSqlFragment2;
            if (plSqlFragment.getFragmentType() == type) {
                return plSqlFragment;
            }
            if (!bl || (plSqlFragment2 = plSqlFragment.findChild(type, true)) == null) continue;
            return plSqlFragment2;
        }
        return null;
    }

    final void replaceChildWithGrandChildren(PlSqlFragment plSqlFragment) {
        ArrayList<PlSqlFragment> arrayList = plSqlFragment.m_subFragments;
        this.m_subFragments.remove(plSqlFragment);
        this.m_subFragments.addAll(arrayList);
        for (PlSqlFragment plSqlFragment2 : arrayList) {
            plSqlFragment2.m_parent = this;
        }
    }

    List<String> getLocalDeclarations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.getLocalDeclarations(arrayList);
        return arrayList;
    }

    private void getLocalDeclarations(List<String> list) {
        Object object;
        if (this.getFragmentType() == Type.PLSQL_BLOCK) {
            object = this.m_subFragments.iterator();
            while (object.hasNext()) {
                PlSqlFragment plSqlFragment = object.next();
                if (plSqlFragment.getFragmentType() != Type.DECLARE) continue;
                for (PlSqlFragment plSqlFragment2 : plSqlFragment.getChildren()) {
                    if (plSqlFragment2.getFragmentType() != Type.DECLARATION) continue;
                    list.add(plSqlFragment2.getFirstToken().getSource(true));
                }
            }
        } else if (this.getFragmentType() == Type.PACKAGE_SPEC || this.getFragmentType() == Type.PACKAGE_BODY || this.getFragmentType() == Type.TYPE_BODY) {
            object = this.m_subFragments.iterator();
            while (object.hasNext()) {
                PlSqlFragment plSqlFragment = (PlSqlFragment)object.next();
                if (plSqlFragment.getFragmentType() != Type.DECLARATION) continue;
                list.add(plSqlFragment.getFirstToken().getSource(true));
            }
        }
        if ((object = this.getParent()) != null) {
            ((PlSqlFragment)object).getLocalDeclarations(list);
        }
    }

    public static enum AlterSubType {
        ADD_ATTRIBUTE,
        DROP_ATTRIBUTE,
        MODIFY_ATTRIBUTE,
        ADD_METHOD,
        DROP_METHOD;

    }

    public static enum Type {
        UNKNOWN,
        ROOT,
        LABEL,
        DECLARE,
        BEGIN,
        EXCEPTION,
        PACKAGE_SPEC,
        PACKAGE_BODY,
        PRAGMA,
        PROCEDURE,
        FUNCTION,
        TRIGGER,
        PLSQL_BLOCK,
        IF,
        ELSIF,
        ELSE,
        LOOP,
        FOR_LOOP,
        WHILE_LOOP,
        CASE,
        CASE_WHEN,
        CASE_ELSE,
        STATEMENT,
        DECLARATION,
        EX_WHEN,
        PARAMETER_LIST,
        PARAMETER,
        TRIGGER_TIMING,
        TRIGGER_EVENTS,
        TRIGGER_COLUMNS,
        TRIGGER_TABLE,
        TRIGGER_REFERENCING,
        TRIGGER_ROW_LEVEL,
        TRIGGER_WHEN,
        PROCEDURE_FD,
        FUNCTION_FD,
        TYPE_SPEC,
        TYPE_BODY,
        TYPE_ALTER_STATEMENT,
        CURSOR;

    }
}

