/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.swift.connection;

import java.io.IOException;
import javax.swing.SwingUtilities;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.connections.NameExistsException;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.swift.config.AddSwiftCredentialPanel;
import oracle.dbtools.swift.connection.SwiftConnectionException;
import oracle.dbtools.swift.connection.SwiftConnectionInfo;
import oracle.dbtools.swift.connection.SwiftConnectionInfoFactory;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorage;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorageFactory;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorageInfo;
import oracle.dbtools.util.Logger;
import oracle.jdevimpl.db.adapter.StorageWrapper;

public class SwiftConnections
implements OracleSwiftObjectStorageFactory {
    private static SwiftConnections INSTANCE;
    private Boolean response = new Boolean(Boolean.FALSE);

    public static synchronized SwiftConnections getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new SwiftConnections();
        }
        return INSTANCE;
    }

    private SwiftConnections() {
    }

    public String[] listConnections() {
        return this.getStorage().listConnections();
    }

    public SwiftConnectionInfo getConnectionInfo(String string) {
        SwiftConnectionInfo swiftConnectionInfo = null;
        try {
            swiftConnectionInfo = (SwiftConnectionInfo)this.getStorage().getConnection(string, (ConnectionFactory)new SwiftConnectionInfoFactory());
        }
        catch (StorageException storageException) {
            Logger.severe(this.getClass(), (Throwable)storageException);
        }
        return swiftConnectionInfo;
    }

    public void addConnection(String string, SwiftConnectionInfo swiftConnectionInfo) throws SwiftConnectionException {
        try {
            this.getStorage().addConnection(string, (ConnectionReferenceable)swiftConnectionInfo);
        }
        catch (NameExistsException nameExistsException) {
            throw new SwiftConnectionException(new IllegalArgumentException("Duplicate name: " + string));
        }
        catch (StorageException storageException) {
            throw new SwiftConnectionException(storageException);
        }
    }

    public void removeConnection(String string) {
        try {
            this.getStorage().removeConnection(string);
        }
        catch (StorageException storageException) {
            Logger.severe(this.getClass(), (Throwable)storageException);
        }
    }

    public OracleSwiftObjectStorage find(String string) {
        OracleSwiftObjectStorage oracleSwiftObjectStorage = null;
        String string2 = OracleSwiftObjectStorage.getNamespaceUrl((String)string);
        SwiftConnectionInfo swiftConnectionInfo = this.getConnectionInfo(string2);
        if (swiftConnectionInfo != null && swiftConnectionInfo.isEnabled()) {
            oracleSwiftObjectStorage = new OracleSwiftObjectStorage(string2, swiftConnectionInfo.getUserName());
            try {
                oracleSwiftObjectStorage.setPassword(new String(swiftConnectionInfo.getUserData()));
            }
            catch (IOException iOException) {
                Logger.ignore(this.getClass(), (Throwable)iOException);
            }
        }
        return oracleSwiftObjectStorage;
    }

    public boolean canPromptUserForAdd() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean promptUserForAdd(String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            return AddSwiftCredentialPanel.runAsDialog(string);
        }
        Boolean bl = this.response;
        synchronized (bl) {
            this.response = false;
            try {
                SwingUtilities.invokeAndWait(() -> {
                    this.response = AddSwiftCredentialPanel.runAsDialog(string);
                });
            }
            catch (Exception exception) {
                Logger.warn(this.getClass(), (Throwable)exception);
            }
            return this.response;
        }
    }

    public OracleSwiftObjectStorageInfo getInfo(String string) {
        String string2 = OracleSwiftObjectStorage.getNamespaceUrl((String)string);
        final boolean bl = this.canPromptUserForAdd();
        final OracleSwiftObjectStorage oracleSwiftObjectStorage = this.find(string);
        SwiftConnectionInfo swiftConnectionInfo = this.getConnectionInfo(string2);
        final boolean bl2 = null == swiftConnectionInfo ? true : swiftConnectionInfo.isEnabled();
        return new OracleSwiftObjectStorageInfo(){

            public OracleSwiftObjectStorage getStorage() {
                return oracleSwiftObjectStorage;
            }

            public boolean isEnabled() {
                return bl2;
            }

            public boolean canPrompt() {
                return bl;
            }
        };
    }

    private Storage<SwiftConnectionInfo> getStorage() {
        StorageWrapper storageWrapper = StorageWrapper.getDefaultWrapper();
        return storageWrapper.getStorage("OracleSwift");
    }
}

