/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.swift.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.swift.SwiftResources;
import oracle.dbtools.swift.connection.SwiftConnectionException;
import oracle.dbtools.swift.connection.SwiftConnectionInfo;
import oracle.dbtools.swift.connection.SwiftConnections;
import oracle.dbtools.transfer.location.OracleSwiftObjectStorage;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.ui.RichHintLabel;

public class AddSwiftCredentialPanel
extends JPanel
implements LayoutControl {
    private static final Class<?> clazz = AddSwiftCredentialPanel.class;
    private JTextField namespaceUrl = new JTextField();
    private JTextField userName = new JTextField();
    private JPasswordField userData = new JPasswordField();
    private JCheckBox enabled = new JCheckBox();
    private JComponent[] panelComponents = new JComponent[]{this.namespaceUrl, this.userName, this.userData};
    private static String[] DEFAULT_COLUMNS = new String[]{SwiftResources.get("NAMESPACE_URL"), SwiftResources.get("USER_NAME"), SwiftResources.get("PASSWORD")};
    private static String[] DEFAULT_COLUMN_TOOLTIPS = new String[]{SwiftResources.get("NAMESPACE_URL_TOOLTIP"), SwiftResources.get("USER_NAME_TOOLTIP"), SwiftResources.get("PASSWORD_TOOLTIP")};
    private static final String ACTION_ID_DOC = "display-auth-token-doc";
    private static final String ACTION_ID_PREF = "open-preference-page";
    private static final String SWIFT_URL_START = "https://swiftobjectstorage.";

    public AddSwiftCredentialPanel() {
        this.init();
    }

    private void init() {
        JComponent jComponent;
        JComponent jComponent2;
        this.setLayout(new BorderLayout());
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        this.add((Component)AddSwiftCredentialPanel.getDesc("ORACLE_SWIFT_DESC_ADD"), "North");
        for (int i = 0; i < this.panelComponents.length; ++i) {
            jComponent2 = new JLabel(DEFAULT_COLUMNS[i]);
            jComponent = this.panelComponents[i];
            jComponent2.setToolTipText(DEFAULT_COLUMN_TOOLTIPS[i]);
            ((JLabel)jComponent2).setLabelFor(jComponent);
            jPanel.add((Component)jComponent2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)(1 == ++n ? LayoutControl.GBC.Inset.SECTION_LINE_START_COMP : LayoutControl.GBC.Inset.LINE_START_COMP)));
            jPanel.add((Component)jComponent, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)(1 == n ? LayoutControl.GBC.Inset.SECTION_LINE_LABEL2CONTROL_COMP : LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP), (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        }
        JLabel jLabel = new JLabel();
        jLabel.setFocusable(false);
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        LayoutControl.GBC.addSpring((JPanel)jPanel, (int)(++n), (int)2);
        this.add((Component)LayoutControl.GBC.createDialogMainPanel((Component)jPanel), "Center");
        jComponent2 = LayoutControl.GBC.createPanel();
        n = 0;
        jComponent = new JLabel(SwiftResources.get("DO_NOT_SHOW_AGAIN"));
        ((JLabel)jComponent).setLabelFor(this.enabled);
        jComponent2.add((Component)this.enabled, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        jComponent2.add((Component)jComponent, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jComponent2.add((Component)this.getPreferencePageReference(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        LayoutControl.GBC.addSpring((JPanel)jComponent2, (int)(++n), (int)2);
        this.add((Component)jComponent2, "South");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_addswiftcredential_html");
    }

    static JComponent getDesc(String string) {
        RichHintLabel richHintLabel = new RichHintLabel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<a href=\"http:").append(ACTION_ID_DOC).append("\">").append(SwiftResources.getString("AUTH_TOKEN_DOC_URL")).append("</a>");
        String string2 = stringBuilder.toString();
        richHintLabel.setHtmlText(SwiftResources.format(string, string2));
        richHintLabel.registerAction(ACTION_ID_DOC, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = URLFactory.newURL((String)SwiftResources.getString("AUTH_TOKEN_DOC_URL"));
                    if (uRL != null) {
                        BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                        browserRunner.runBrowserOnURL(uRL, null, null);
                    }
                }
                catch (Throwable throwable) {
                    Logger.warn(this.getClass(), (Throwable)throwable);
                }
            }
        });
        return richHintLabel;
    }

    private JComponent getPreferencePageReference() {
        RichHintLabel richHintLabel = new RichHintLabel();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<a href=\"http:").append(ACTION_ID_PREF).append("\">").append(SwiftResources.getString("PREFERENCES")).append("</a>");
        String string = stringBuilder.toString();
        richHintLabel.setHtmlText(SwiftResources.format("PREFERENCES_INFO", string));
        richHintLabel.registerAction(ACTION_ID_PREF, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{SwiftResources.getString("ORACLE_SWIFT_TITLE")});
                }
                catch (Throwable throwable) {
                    Logger.warn(this.getClass(), (Throwable)throwable);
                }
            }
        });
        return richHintLabel;
    }

    public static boolean runAsDialog(String string) {
        Object object;
        boolean bl = false;
        AddSwiftCredentialPanel addSwiftCredentialPanel = new AddSwiftCredentialPanel();
        if (string != null && string.startsWith(SWIFT_URL_START)) {
            object = OracleSwiftObjectStorage.getNamespaceUrl((String)string);
            addSwiftCredentialPanel.namespaceUrl.setText((String)object);
            addSwiftCredentialPanel.namespaceUrl.setEditable(false);
            addSwiftCredentialPanel.enabled.setSelected(true);
            SwiftConnectionInfo swiftConnectionInfo = SwiftConnections.getInstance().getConnectionInfo((String)object);
            if (swiftConnectionInfo != null) {
                addSwiftCredentialPanel.userName.setText(swiftConnectionInfo.getUserName());
                addSwiftCredentialPanel.userData.setText(null == swiftConnectionInfo.getUserData() ? "" : new String(swiftConnectionInfo.getUserData()));
                addSwiftCredentialPanel.enabled.setSelected(!swiftConnectionInfo.isEnabled());
            }
        } else {
            addSwiftCredentialPanel.namespaceUrl.setText(SWIFT_URL_START);
            addSwiftCredentialPanel.enabled.setSelected(true);
        }
        bl = UIUtils.showPanelAsDialog((JPanel)addSwiftCredentialPanel, (String)SwiftResources.get("ORACLE_SWIFT_TITLE"), null, (int)7, (boolean)true);
        if (bl) {
            object = addSwiftCredentialPanel.userData.getPassword();
            boolean bl2 = false;
            if (object != null && ((Object)object).length > 0) {
                bl2 = true;
            }
            try {
                SwiftConnections.getInstance().addConnection(addSwiftCredentialPanel.namespaceUrl.getText(), new SwiftConnectionInfo(addSwiftCredentialPanel.namespaceUrl.getText(), addSwiftCredentialPanel.userName.getText(), addSwiftCredentialPanel.userData.getPassword(), bl2));
            }
            catch (SwiftConnectionException swiftConnectionException) {
                Logger.severe(clazz, (Throwable)swiftConnectionException);
            }
        }
        return bl;
    }
}

