/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class UIComponentStyle {
    private String m_name;
    private int m_fontSize;
    private String m_fontName;
    private int m_fontStyle;
    private Color m_fontColor;
    private Color m_backgroundColor;
    private boolean m_isStrikeThrough;
    private boolean m_isUnderline;
    public static final String ROW_HEADER = "row header";
    public static final String COLUMN_HEADER = "column header";
    public static final String DATA_BODY = "data body";
    public static final String TITLE = "title";
    public static final String SUBTITLE = "subtitle";
    public static final String FOOTNOTE = "footnote";
    public static final String PAGECONTROL = "page control";
    static final String UI_COMPONENT_STYLE = "UICOMPONENTSTYLE";
    static final String a_componentName = "ComponentName";
    static final String a_fontName = "FontName";
    static final String a_fontSize = "FontSize";
    static final String a_fontBold = "FontBold";
    static final String a_fontItalic = "FontItalic";
    static final String a_underline = "Underline";
    static final String a_strikeThrough = "StrikeThrough";
    static final String a_background = "Background";
    static final String a_foreground = "Foreground";

    public UIComponentStyle(String name, int fontSize, String fontName, int fontStyle, Color fontColor, Color backgroundColor, boolean isStrikeThrough, boolean isUnderline) {
        this.m_name = name;
        this.m_fontSize = fontSize;
        this.m_fontName = fontName;
        this.m_fontStyle = fontStyle;
        this.m_fontColor = fontColor;
        this.m_backgroundColor = backgroundColor;
        this.m_isStrikeThrough = isStrikeThrough;
        this.m_isUnderline = isUnderline;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setFontSize(int fontSize) {
        this.m_fontSize = fontSize;
    }

    public int getFontSize() {
        return this.m_fontSize;
    }

    public void setFontName(String fontName) {
        this.m_fontName = fontName;
    }

    public String getFontName() {
        return this.m_fontName;
    }

    public void setFontStyle(int fontStyle) {
        this.m_fontStyle = fontStyle;
    }

    public int getFontStyle() {
        return this.m_fontStyle;
    }

    public void setFontColor(Color fontColor) {
        this.m_fontColor = fontColor;
    }

    public Color getFontColor() {
        return this.m_fontColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.m_backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public void setStrikeThrough(boolean isStrikeThrough) {
        this.m_isStrikeThrough = isStrikeThrough;
    }

    public boolean isStrikeThrough() {
        return this.m_isStrikeThrough;
    }

    public void setUnderline(boolean isUnderline) {
        this.m_isUnderline = isUnderline;
    }

    public boolean isUnderline() {
        return this.m_isUnderline;
    }

    public boolean setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty(a_componentName);
        if (pNode != null) {
            this.setName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_fontName)) != null) {
            this.setFontName(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_fontSize)) != null) {
            this.setFontSize(pNode.getValueAsInteger());
        }
        this.setFontStyle(0);
        pNode = node.getProperty(a_fontBold);
        if (pNode != null && pNode.getValueAsBoolean()) {
            this.setFontStyle(this.getFontStyle() | 1);
        }
        if ((pNode = node.getProperty(a_fontItalic)) != null && pNode.getValueAsBoolean()) {
            this.setFontStyle(this.getFontStyle() | 2);
        }
        if ((pNode = node.getProperty(a_underline)) != null) {
            this.setUnderline(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_strikeThrough)) != null) {
            this.setStrikeThrough(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_foreground)) != null) {
            this.setFontColor(new Color(UIComponentStyle.hexStringToInt(pNode.getValueAsString())));
        }
        if ((pNode = node.getProperty(a_background)) != null) {
            this.setBackgroundColor(new Color(UIComponentStyle.hexStringToInt(pNode.getValueAsString())));
        }
        return true;
    }

    protected static int hexStringToInt(String str) {
        String noPound = str.substring(1);
        return Integer.parseInt(noPound, 16);
    }

    protected static String toHexString(int value) {
        String hexStr = Integer.toHexString(value & 0xFFFFFF);
        String poundStr = "#";
        StringBuffer buff = new StringBuffer(poundStr);
        buff.append(hexStr);
        return buff.toString();
    }

    public ObjectNode getXML(String componentName) {
        ObjectNode node = new ObjectNode(componentName);
        node.addProperty(a_componentName, this.getName());
        node.addProperty(a_fontName, this.getFontName());
        node.addProperty(a_fontSize, this.getFontSize());
        node.addProperty(a_fontBold, (this.getFontStyle() & 1) != 0);
        node.addProperty(a_fontItalic, (this.getFontStyle() & 2) != 0);
        node.addProperty(a_underline, this.isUnderline());
        node.addProperty(a_strikeThrough, this.isStrikeThrough());
        node.addProperty(a_foreground, UIComponentStyle.toHexString(this.getFontColor().getRGB()));
        node.addProperty(a_background, UIComponentStyle.toHexString(this.getBackgroundColor().getRGB()));
        return node;
    }
}

