/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.managers.ViewStyle;

public class FontPanel
extends JPanel
implements PropertyChangeListener,
HelpContext {
    public static final String PROPERTY_FONTPANEL_WRAP_WORDS = "Wrap Words";
    private ResourceBundle rBundle = null;
    protected String m_translatedText;
    protected JCheckBox m_chkWrapWords;
    protected boolean m_wrapWordsState;
    protected String m_fontName;
    protected int m_fontStyle;
    protected ViewStyle m_viewStyle;
    protected JButton m_fontButton;
    protected Font m_font = null;
    protected int m_horizontalAlignment;
    protected int m_verticalAlignment;
    protected FontPane m_fontPane = null;
    protected boolean m_underline = false;
    protected int m_fontsize;
    protected Color m_foreground = Color.black;
    protected Color m_background = null;
    protected int m_visibleStyle = 15;
    protected int m_visibleAlignment = 478;
    protected int m_visibleColor = 3;
    protected Locale m_locale = null;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    private boolean _flag = true;
    public static final String PROPERTY_CANCELLED = "fontDialogCancelled";
    public static final int INIT_USEBIT = 0;
    public static final int INIT_IGNORE_USEBIT = 1;
    private int m_initState = 0;
    private String m_dialogTitle = "";
    private ItemListener m_itemListener;
    private boolean panelShow = false;
    private boolean m_backgroundColorChanged = false;

    public FontPanel(ViewStyle style) {
        this.m_viewStyle = style;
        this.constructPanel();
        this._initFontPane();
    }

    public FontPanel(ViewStyle style, int initState) {
        this.m_viewStyle = style;
        this.m_initState = initState;
        this.constructPanel();
        this._initFontPane();
    }

    private void constructPanel() {
        this.updateResourceBundle(this.m_locale);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.m_fontPane = new TransparentFontPane();
        this.m_fontPane.setStyleButtonMask(this.m_visibleStyle);
        this.m_fontPane.setAlignmentButtonMask(this.m_visibleAlignment);
        this.m_fontPane.setColorComponentMask(this.m_visibleColor);
        this.m_fontPane.setPreviewAreaVisible(false);
        this.m_fontPane.setWidthVisible(false);
        this.m_fontPane.getFontBackgroundColorChoice().setColorPalette(ColorGrid.getColorPalette((int)2));
        this.m_fontPane.getFontBackgroundColorChoice().setTransparentAllowed(true);
        this.m_fontPane.getFontColorChoice().setColorPalette(ColorGrid.getColorPalette((int)2));
        if (this.m_locale != null) {
            this.m_fontPane.setLocale(this.m_locale);
        }
        this.add((Component)this.m_fontPane);
        this.m_fontPane.setAlignmentX(0.0f);
        this.m_fontPane.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_translatedText = this.rBundle.getString("WrapWords");
        this.m_chkWrapWords = new JCheckBox(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.m_chkWrapWords.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FontPanel.this.m_wrapWordsState = true;
                    FontPanel.this.firePropertyChange(FontPanel.PROPERTY_FONTPANEL_WRAP_WORDS, false, true);
                } else {
                    FontPanel.this.m_wrapWordsState = false;
                    FontPanel.this.firePropertyChange(FontPanel.PROPERTY_FONTPANEL_WRAP_WORDS, true, false);
                }
            }
        };
        this.m_chkWrapWords.addItemListener(this.m_itemListener);
        this.m_fontPane.setExtraComponent((Component)this.m_chkWrapWords);
        this.m_chkWrapWords.setAlignmentX(0.0f);
        this.add(Box.createVerticalGlue());
        this.m_backgroundColorChanged = false;
    }

    public void cleanUp() {
        this.m_chkWrapWords.removeItemListener(this.m_itemListener);
        this.m_itemListener = null;
    }

    protected int convertBaliHAlignmentToSwing(int fPane) {
        int alignment = 0;
        switch (fPane) {
            case 2: {
                alignment = 2;
                break;
            }
            case 4: {
                alignment = 4;
                break;
            }
            case 10: {
                alignment = 10;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        return alignment;
    }

    protected int convertBaliVAlignmentToSwing(int fPane) {
        int alignment = 0;
        switch (fPane) {
            case 1: {
                alignment = 1;
                break;
            }
            case 3: {
                alignment = 3;
                break;
            }
            default: {
                alignment = 0;
            }
        }
        return alignment;
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.revalidate();
        Dimension newDimension = new Dimension(500, 500);
        this.resize(newDimension);
    }

    public FontPane getFontPane() {
        return this.m_fontPane;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName == "fontHorizontalAlignment") {
            this.m_horizontalAlignment = this.m_fontPane.getFontHorizontalAlignment();
            int oldAlignment = (Integer)e.getOldValue();
            int newAlignment = (Integer)e.getNewValue();
            this.firePropertyChange(propertyName, oldAlignment, this.convertBaliHAlignmentToSwing(newAlignment));
        } else if (propertyName == "fontVerticalAlignment") {
            this.m_verticalAlignment = this.m_fontPane.getFontVerticalAlignment();
            int oldAlignment = (Integer)e.getOldValue();
            int newAlignment = (Integer)e.getNewValue();
            this.firePropertyChange(propertyName, oldAlignment, this.convertBaliVAlignmentToSwing(newAlignment));
        } else if (e.getPropertyName().equals("BackgroundColor")) {
            this._flag = false;
            this.m_background = (Color)e.getNewValue();
            this.m_fontPane.setFontBackgroundColor(this.m_background);
            this._flag = true;
        } else {
            if (propertyName == "fontName") {
                this.m_fontName = this.m_fontPane.getFontName();
            }
            if (propertyName == "fontSize") {
                this.m_fontsize = this.m_fontPane.getFontSize();
            }
            if (propertyName == "fontStyle") {
                this.m_fontStyle = this.m_fontPane.getFontStyle();
            }
            if (propertyName == "fontColor") {
                this.m_foreground = this.m_fontPane.getFontColor();
            }
            if (propertyName == "fontBackgroundColor") {
                this.m_background = this.m_fontPane.getFontBackgroundColor();
                if (this._flag) {
                    this.firePropertyChange(propertyName, e.getOldValue(), e.getNewValue());
                    if (this.m_background != null) {
                        this.m_backgroundColorChanged = true;
                    }
                }
                return;
            }
            this.firePropertyChange(propertyName, e.getOldValue(), e.getNewValue());
        }
    }

    public void setStyleButtonMask(int style) {
        this.m_visibleStyle = style;
    }

    public void setAlignmentButtonMask(int alignment) {
        this.m_visibleAlignment = alignment;
    }

    public void setColorComponentMask(int buttons) {
        this.m_visibleColor = buttons;
    }

    public Color getComponentForeground() {
        return this.m_foreground;
    }

    public void setComponentForeground(Color c) {
        this.m_foreground = c;
    }

    public Color getComponentBackground() {
        return this.m_background;
    }

    public void setComponentBackground(Color c) {
        this.m_background = c;
    }

    public Font getComponentFont() {
        this.m_font = this.m_fontPane.getCurrentFont();
        return this.m_font;
    }

    public void setComponentFont(Font f) {
        this.m_font = f;
    }

    public boolean isUnderlineStyle() {
        return (this.m_fontStyle & 4) != 0;
    }

    public boolean isStrikeThroughStyle() {
        return (this.m_fontStyle & 8) != 0;
    }

    public boolean isBoldStyle() {
        return (this.m_fontStyle & 1) != 0;
    }

    public boolean isItalicStyle() {
        return (this.m_fontStyle & 2) != 0;
    }

    public int getFontStyle() {
        return this.m_fontPane.getFontStyle();
    }

    public int getHorizontalAlignment() {
        return this.m_horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.m_horizontalAlignment = alignment;
    }

    public int getVerticalAlignment() {
        return this.m_verticalAlignment;
    }

    public boolean getWrapWordsState() {
        return this.m_wrapWordsState;
    }

    public String getFontName() {
        return this.m_fontName;
    }

    public int getFontSize() {
        return this.m_fontsize;
    }

    public void setVerticalAlignment(int alignment) {
        this.m_verticalAlignment = alignment;
    }

    public void apply() {
        int iAlignment;
        int iStyle;
        boolean temp;
        if (this.m_fontPane.getFontName() != null && !this.m_viewStyle.getFontName().equals(this.m_fontPane.getFontName())) {
            this.m_viewStyle.setFontName(this.m_fontPane.getFontName());
        }
        if (this.m_fontPane.getFontSize() != -1 && this.m_viewStyle.getFontSize() != this.m_fontPane.getFontSize()) {
            this.m_viewStyle.setFontSize(this.m_fontPane.getFontSize());
        }
        if (this.m_viewStyle.getForeground().getRGB() != this.m_fontPane.getFontColor().getRGB()) {
            this.m_viewStyle.setForeground(this.m_fontPane.getFontColor());
        }
        if (this.m_backgroundColorChanged) {
            if (this.m_fontPane.getFontBackgroundColor() != null) {
                if (this.m_viewStyle.getBackground().getRGB() != this.m_fontPane.getFontBackgroundColor().getRGB()) {
                    this.m_viewStyle.setBackground(this.m_fontPane.getFontBackgroundColor());
                }
            } else {
                this.m_viewStyle.setBackground(null);
            }
        }
        boolean bl = temp = ((iStyle = this.m_fontPane.getFontStyle()) & 1) != 0;
        if (this.m_viewStyle.isFontBold() != temp) {
            this.m_viewStyle.setFontBold(temp);
        }
        boolean bl2 = temp = (iStyle & 2) != 0;
        if (this.m_viewStyle.isFontItalic() != temp) {
            this.m_viewStyle.setFontItalic(temp);
        }
        boolean bl3 = temp = (iStyle & 4) != 0;
        if (this.m_viewStyle.isUnderline() != temp) {
            this.m_viewStyle.setUnderline(temp);
        }
        boolean bl4 = temp = (iStyle & 8) != 0;
        if (this.m_viewStyle.isStrikeThrough() != temp) {
            this.m_viewStyle.setStrikeThrough(temp);
        }
        if (this.m_fontPane.getFontHorizontalAlignment() != -1) {
            iAlignment = this.convertBaliHAlignmentToSwing(this.m_fontPane.getFontHorizontalAlignment());
            if (this.m_viewStyle.getHorizontalAlignment() != iAlignment) {
                this.m_viewStyle.setHorizontalAlignment(iAlignment);
            }
        }
        if (this.m_fontPane.getFontVerticalAlignment() != -1) {
            iAlignment = this.convertBaliVAlignmentToSwing(this.m_fontPane.getFontVerticalAlignment());
            if (this.m_viewStyle.getVerticalAlignment() != iAlignment) {
                this.m_viewStyle.setVerticalAlignment(iAlignment);
            }
        }
        if (this.m_viewStyle.isWordWrapEnabled() != this.m_chkWrapWords.isSelected()) {
            this.m_viewStyle.setWordWrapEnabled(this.m_chkWrapWords.isSelected());
        }
    }

    public ViewStyle getViewStyle() {
        return this.m_viewStyle;
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.m_locale = loc;
        this.updateResourceBundle(loc);
        if (this.m_fontPane != null) {
            this.m_fontPane.setLocale(loc);
        }
        if (this.m_chkWrapWords != null) {
            this.m_chkWrapWords.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("WrapWords")));
        }
        this.revalidate();
    }

    public void setCustomColorsEnabled(boolean enabled) {
        ((TransparentFontPane)this.m_fontPane).setCustomColorsEnabled(enabled);
    }

    private void _initFontPane() {
        int alignment;
        if (this.m_initState != 0 || this.m_viewStyle.isFontNameUsed()) {
            this.m_fontName = this.m_viewStyle.getFontName();
            this.m_fontPane.setFontName(this.m_fontName);
        } else {
            this.m_fontName = null;
            this.m_fontPane.setFontName(null);
        }
        if (this.m_initState != 0 || this.m_viewStyle.isFontSizeUsed()) {
            this.m_fontsize = this.m_viewStyle.getFontSize();
            this.m_fontPane.setFontSize(this.m_fontsize);
        } else {
            this.m_fontsize = -1;
            this.m_fontPane.setFontSize(-1);
        }
        int iStyle = 0;
        int iBoldItalic = 0;
        iBoldItalic = this.m_viewStyle.getFontStyle();
        if ((iBoldItalic & 9) != 0) {
            iStyle |= 1;
        }
        if ((iBoldItalic & 0xA) != 0) {
            iStyle |= 2;
        }
        if (this.m_viewStyle.isUnderline()) {
            iStyle |= 4;
        }
        if (this.m_viewStyle.isStrikeThrough()) {
            iStyle |= 8;
        }
        this.m_fontPane.setFontStyle(iStyle);
        this.m_fontStyle = iStyle;
        this.m_foreground = this.m_viewStyle.getForeground();
        this.m_fontPane.setFontColor(this.m_foreground);
        if (this.m_initState != 0 || this.m_viewStyle.isBackgroundUsed()) {
            this.m_background = this.m_viewStyle.getBackground();
            this.m_fontPane.setFontBackgroundColor(this.m_background);
        } else {
            this.m_background = null;
            this.m_fontPane.setFontBackgroundColor(null);
        }
        if (this.m_initState != 0 || this.m_viewStyle.isHorizontalAlignmentUsed()) {
            this.m_horizontalAlignment = this.m_viewStyle.getHorizontalAlignment();
            switch (this.m_horizontalAlignment) {
                case 2: {
                    alignment = 2;
                    break;
                }
                case 4: {
                    alignment = 4;
                    break;
                }
                case 10: {
                    alignment = 10;
                    break;
                }
                default: {
                    alignment = 0;
                }
            }
            this.m_fontPane.setFontHorizontalAlignment(alignment);
            this.m_horizontalAlignment = alignment;
        } else {
            this.m_horizontalAlignment = -1;
            this.m_fontPane.setFontHorizontalAlignment(-1);
        }
        if (this.m_initState != 0 || this.m_viewStyle.isVerticalAlignmentUsed()) {
            this.m_verticalAlignment = this.m_viewStyle.getVerticalAlignment();
            switch (this.m_verticalAlignment) {
                case 1: {
                    alignment = 1;
                    break;
                }
                case 3: {
                    alignment = 3;
                    break;
                }
                default: {
                    alignment = 0;
                }
            }
            this.m_fontPane.setFontVerticalAlignment(alignment);
            this.m_verticalAlignment = alignment;
        } else {
            this.m_verticalAlignment = -1;
            this.m_fontPane.setFontVerticalAlignment(-1);
        }
        if (this.m_viewStyle.isWordWrapEnabled()) {
            this.m_chkWrapWords.setSelected(true);
            this.m_wrapWordsState = true;
        } else {
            this.m_chkWrapWords.setSelected(false);
            this.m_wrapWordsState = false;
        }
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    class TransparentFontPane
    extends FontPane {
        TransparentFontPane() {
        }

        public void addNotify() {
            boolean m_transparent = this.getFontBackgroundColor() == null;
            super.addNotify();
            if (m_transparent) {
                this.getFontBackgroundColorChoice().setSelectedColor(null);
            }
        }

        public void setCustomColorsEnabled(boolean enabled) {
            if (enabled) {
                this.getFontBackgroundColorChoice().setEditAllowed(true);
                this.getFontBackgroundColorChoice().setCustomColorPalette(this._createCustomPalette(this.getFontBackgroundColorChoice()));
                this.getFontBackgroundColorChoice().getColorPalettePane().setCustomColorsVisible(true);
                this.getFontBackgroundColorChoice().getColorPalettePane().setEditVisible(true);
                this.getFontColorChoice().setEditAllowed(true);
                this.getFontColorChoice().setCustomColorPalette(this._createCustomPalette(this.getFontColorChoice()));
                this.getFontColorChoice().getColorPalettePane().setCustomColorsVisible(true);
                this.getFontColorChoice().getColorPalettePane().setEditVisible(true);
            } else {
                this.getFontBackgroundColorChoice().setEditAllowed(false);
                this.getFontBackgroundColorChoice().setCustomColorPalette(null);
                this.getFontBackgroundColorChoice().getColorPalettePane().setCustomColorsVisible(false);
                this.getFontBackgroundColorChoice().getColorPalettePane().setEditVisible(false);
                this.getFontColorChoice().setEditAllowed(false);
                this.getFontColorChoice().setCustomColorPalette(null);
                this.getFontColorChoice().getColorPalettePane().setCustomColorsVisible(false);
                this.getFontColorChoice().getColorPalettePane().setEditVisible(false);
            }
        }

        private TwoDModel _createCustomPalette(ColorChoice color) {
            TwoDModel regularModel = color.getColorPalette();
            ArrayTwoDModel customModel = new ArrayTwoDModel(regularModel.getColumnCount(), 2);
            return customModel;
        }
    }
}

